package software.amazon.awscdk.services.servicecatalogappregistry;

/**
 * (experimental) A Service Catalog AppRegistry Attribute Group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * AttributeGroup attributeGroup = AttributeGroup.Builder.create(this, "MyFirstAttributeGroup")
 *         .attributeGroupName("MyFirstAttributeGroupName")
 *         .description("description for my attribute group") // the description is optional,
 *         .attributes(Map.of(
 *                 "project", "foo",
 *                 "team", List.of("member1", "member2", "member3"),
 *                 "public", false,
 *                 "stages", Map.of(
 *                         "alpha", "complete",
 *                         "beta", "incomplete",
 *                         "release", "not started")))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:09.988Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_servicecatalogappregistry.AttributeGroup")
public class AttributeGroup extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.servicecatalogappregistry.IAttributeGroup {

    protected AttributeGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AttributeGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public AttributeGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalogappregistry.AttributeGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Imports an attribute group construct that represents an external attribute group.
     * <p>
     * @param scope The parent creating construct (usually `this`). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param attributeGroupArn the Amazon Resource Name of the existing AppRegistry attribute group. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalogappregistry.IAttributeGroup fromAttributeGroupArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String attributeGroupArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.servicecatalogappregistry.AttributeGroup.class, "fromAttributeGroupArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalogappregistry.IAttributeGroup.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attributeGroupArn, "attributeGroupArn is required") });
    }

    /**
     * (experimental) The ARN of the attribute group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttributeGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "attributeGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The ID of the attribute group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttributeGroupId() {
        return software.amazon.jsii.Kernel.get(this, "attributeGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.servicecatalogappregistry.AttributeGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.servicecatalogappregistry.AttributeGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.servicecatalogappregistry.AttributeGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.servicecatalogappregistry.AttributeGroupProps.Builder();
        }

        /**
         * (experimental) Enforces a particular physical attribute group name.
         * <p>
         * @return {@code this}
         * @param attributeGroupName Enforces a particular physical attribute group name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder attributeGroupName(final java.lang.String attributeGroupName) {
            this.props.attributeGroupName(attributeGroupName);
            return this;
        }

        /**
         * (experimental) A JSON of nested key-value pairs that represent the attributes in the group.
         * <p>
         * Attributes maybe an empty JSON '{}', but must be explicitly stated.
         * <p>
         * @return {@code this}
         * @param attributes A JSON of nested key-value pairs that represent the attributes in the group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder attributes(final java.util.Map<java.lang.String, ? extends java.lang.Object> attributes) {
            this.props.attributes(attributes);
            return this;
        }

        /**
         * (experimental) Description for attribute group.
         * <p>
         * Default: - No description provided
         * <p>
         * @return {@code this}
         * @param description Description for attribute group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.servicecatalogappregistry.AttributeGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.servicecatalogappregistry.AttributeGroup build() {
            return new software.amazon.awscdk.services.servicecatalogappregistry.AttributeGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
