package software.amazon.awscdk.services.servicediscovery;

/**
 * A CloudFormation `AWS::ServiceDiscovery::Service`.
 * <p>
 * A complex type that contains information about a service, which defines the configuration of the following entities:
 * <p>
 * <ul>
 * <li>For public and private DNS namespaces, one of the following combinations of DNS records in Amazon Route 53:</li>
 * <li>A</li>
 * <li>AAAA</li>
 * <li>A and AAAA</li>
 * <li>SRV</li>
 * <li>CNAME</li>
 * <li>Optionally, a health check</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.servicediscovery.*;
 * CfnService cfnService = CfnService.Builder.create(this, "MyCfnService")
 *         .description("description")
 *         .dnsConfig(DnsConfigProperty.builder()
 *                 .dnsRecords(List.of(DnsRecordProperty.builder()
 *                         .ttl(123)
 *                         .type("type")
 *                         .build()))
 *                 // the properties below are optional
 *                 .namespaceId("namespaceId")
 *                 .routingPolicy("routingPolicy")
 *                 .build())
 *         .healthCheckConfig(HealthCheckConfigProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .failureThreshold(123)
 *                 .resourcePath("resourcePath")
 *                 .build())
 *         .healthCheckCustomConfig(HealthCheckCustomConfigProperty.builder()
 *                 .failureThreshold(123)
 *                 .build())
 *         .name("name")
 *         .namespaceId("namespaceId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .type("type")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:10.049Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_servicediscovery.CfnService")
public class CfnService extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnService(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnService(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.servicediscovery.CfnService.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ServiceDiscovery::Service`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnService(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.CfnServiceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::ServiceDiscovery::Service`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnService(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name that you assigned to the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags for the service.
     * <p>
     * Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The description of the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * A complex type that contains information about the Route 53 DNS records that you want AWS Cloud Map to create when you register an instance.
     * <p>
     * <blockquote>
     * <p>
     * The record types of a service can only be changed by deleting the service and recreating it with a new <code>Dnsconfig</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDnsConfig() {
        return software.amazon.jsii.Kernel.get(this, "dnsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A complex type that contains information about the Route 53 DNS records that you want AWS Cloud Map to create when you register an instance.
     * <p>
     * <blockquote>
     * <p>
     * The record types of a service can only be changed by deleting the service and recreating it with a new <code>Dnsconfig</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDnsConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.CfnService.DnsConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "dnsConfig", value);
    }

    /**
     * A complex type that contains information about the Route 53 DNS records that you want AWS Cloud Map to create when you register an instance.
     * <p>
     * <blockquote>
     * <p>
     * The record types of a service can only be changed by deleting the service and recreating it with a new <code>Dnsconfig</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDnsConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dnsConfig", value);
    }

    /**
     * *Public DNS and HTTP namespaces only.* A complex type that contains settings for an optional health check. If you specify settings for a health check, AWS Cloud Map associates the health check with the records that you specify in `DnsConfig` .
     * <p>
     * For information about the charges for health checks, see <a href="https://docs.aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHealthCheckConfig() {
        return software.amazon.jsii.Kernel.get(this, "healthCheckConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * *Public DNS and HTTP namespaces only.* A complex type that contains settings for an optional health check. If you specify settings for a health check, AWS Cloud Map associates the health check with the records that you specify in `DnsConfig` .
     * <p>
     * For information about the charges for health checks, see <a href="https://docs.aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.CfnService.HealthCheckConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "healthCheckConfig", value);
    }

    /**
     * *Public DNS and HTTP namespaces only.* A complex type that contains settings for an optional health check. If you specify settings for a health check, AWS Cloud Map associates the health check with the records that you specify in `DnsConfig` .
     * <p>
     * For information about the charges for health checks, see <a href="https://docs.aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "healthCheckConfig", value);
    }

    /**
     * A complex type that contains information about an optional custom health check.
     * <p>
     * <blockquote>
     * <p>
     * If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or <code>HealthCheckConfig</code> but not both.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHealthCheckCustomConfig() {
        return software.amazon.jsii.Kernel.get(this, "healthCheckCustomConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A complex type that contains information about an optional custom health check.
     * <p>
     * <blockquote>
     * <p>
     * If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or <code>HealthCheckConfig</code> but not both.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckCustomConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.CfnService.HealthCheckCustomConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "healthCheckCustomConfig", value);
    }

    /**
     * A complex type that contains information about an optional custom health check.
     * <p>
     * <blockquote>
     * <p>
     * If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or <code>HealthCheckConfig</code> but not both.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckCustomConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "healthCheckCustomConfig", value);
    }

    /**
     * The name of the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The ID of the namespace that was used to create the service.
     * <p>
     * <blockquote>
     * <p>
     * You must specify a value for <code>NamespaceId</code> either for the service properties or for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicediscovery-service-dnsconfig.html">DnsConfig</a> . Don't specify a value in both places.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNamespaceId() {
        return software.amazon.jsii.Kernel.get(this, "namespaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the namespace that was used to create the service.
     * <p>
     * <blockquote>
     * <p>
     * You must specify a value for <code>NamespaceId</code> either for the service properties or for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicediscovery-service-dnsconfig.html">DnsConfig</a> . Don't specify a value in both places.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNamespaceId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "namespaceId", value);
    }

    /**
     * If present, specifies that the service instances are only discoverable using the `DiscoverInstances` API operation.
     * <p>
     * No DNS records is registered for the service instances. The only valid value is <code>HTTP</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * If present, specifies that the service instances are only discoverable using the `DiscoverInstances` API operation.
     * <p>
     * No DNS records is registered for the service instances. The only valid value is <code>HTTP</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", value);
    }
    /**
     * A complex type that contains information about the Amazon Route 53 DNS records that you want AWS Cloud Map to create when you register an instance.
     * <p>
     * <blockquote>
     * <p>
     * The record types of a service can only be changed by deleting the service and recreating it with a new <code>Dnsconfig</code> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.servicediscovery.*;
     * DnsConfigProperty dnsConfigProperty = DnsConfigProperty.builder()
     *         .dnsRecords(List.of(DnsRecordProperty.builder()
     *                 .ttl(123)
     *                 .type("type")
     *                 .build()))
     *         // the properties below are optional
     *         .namespaceId("namespaceId")
     *         .routingPolicy("routingPolicy")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_servicediscovery.CfnService.DnsConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DnsConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DnsConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array that contains one `DnsRecord` object for each Route 53 DNS record that you want AWS Cloud Map to create when you register an instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDnsRecords();

        /**
         * The ID of the namespace to use for DNS configuration.
         * <p>
         * <blockquote>
         * <p>
         * You must specify a value for <code>NamespaceId</code> either for <code>DnsConfig</code> or for the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-service.html">service properties</a> . Don't specify a value in both places.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespaceId() {
            return null;
        }

        /**
         * The routing policy that you want to apply to all Route 53 DNS records that AWS Cloud Map creates when you register an instance and specify this service.
         * <p>
         * <blockquote>
         * <p>
         * If you want to use this service to register instances that create alias records, specify <code>WEIGHTED</code> for the routing policy.
         * <p>
         * </blockquote>
         * <p>
         * You can specify the following values:
         * <p>
         * <ul>
         * <li><strong>MULTIVALUE</strong> - If you define a health check for the service and the health check is healthy, Route 53 returns the applicable value for up to eight instances.</li>
         * </ul>
         * <p>
         * For example, suppose that the service includes configurations for one <code>A</code> record and a health check. You use the service to register 10 instances. Route 53 responds to DNS queries with IP addresses for up to eight healthy instances. If fewer than eight instances are healthy, Route 53 responds to every DNS query with the IP addresses for all of the healthy instances.
         * <p>
         * If you don't define a health check for the service, Route 53 assumes that all instances are healthy and returns the values for up to eight instances.
         * <p>
         * For more information about the multivalue routing policy, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-multivalue">Multivalue Answer Routing</a> in the <em>Route 53 Developer Guide</em> .
         * <p>
         * <ul>
         * <li><strong>WEIGHTED</strong> - Route 53 returns the applicable value from one randomly selected instance from among the instances that you registered using the same service. Currently, all records have the same weight, so you can't route more or less traffic to any instances.</li>
         * </ul>
         * <p>
         * For example, suppose that the service includes configurations for one <code>A</code> record and a health check. You use the service to register 10 instances. Route 53 responds to DNS queries with the IP address for one randomly selected instance from among the healthy instances. If no instances are healthy, Route 53 responds to DNS queries as if all of the instances were healthy.
         * <p>
         * If you don't define a health check for the service, Route 53 assumes that all instances are healthy and returns the applicable value for one randomly selected instance.
         * <p>
         * For more information about the weighted routing policy, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-weighted">Weighted Routing</a> in the <em>Route 53 Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoutingPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DnsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DnsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DnsConfigProperty> {
            java.lang.Object dnsRecords;
            java.lang.String namespaceId;
            java.lang.String routingPolicy;

            /**
             * Sets the value of {@link DnsConfigProperty#getDnsRecords}
             * @param dnsRecords An array that contains one `DnsRecord` object for each Route 53 DNS record that you want AWS Cloud Map to create when you register an instance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsRecords(software.amazon.awscdk.core.IResolvable dnsRecords) {
                this.dnsRecords = dnsRecords;
                return this;
            }

            /**
             * Sets the value of {@link DnsConfigProperty#getDnsRecords}
             * @param dnsRecords An array that contains one `DnsRecord` object for each Route 53 DNS record that you want AWS Cloud Map to create when you register an instance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsRecords(java.util.List<? extends java.lang.Object> dnsRecords) {
                this.dnsRecords = dnsRecords;
                return this;
            }

            /**
             * Sets the value of {@link DnsConfigProperty#getNamespaceId}
             * @param namespaceId The ID of the namespace to use for DNS configuration.
             *                    <blockquote>
             *                    <p>
             *                    You must specify a value for <code>NamespaceId</code> either for <code>DnsConfig</code> or for the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicediscovery-service.html">service properties</a> . Don't specify a value in both places.
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespaceId(java.lang.String namespaceId) {
                this.namespaceId = namespaceId;
                return this;
            }

            /**
             * Sets the value of {@link DnsConfigProperty#getRoutingPolicy}
             * @param routingPolicy The routing policy that you want to apply to all Route 53 DNS records that AWS Cloud Map creates when you register an instance and specify this service.
             *                      <blockquote>
             *                      <p>
             *                      If you want to use this service to register instances that create alias records, specify <code>WEIGHTED</code> for the routing policy.
             *                      <p>
             *                      </blockquote>
             *                      <p>
             *                      You can specify the following values:
             *                      <p>
             *                      <ul>
             *                      <li><strong>MULTIVALUE</strong> - If you define a health check for the service and the health check is healthy, Route 53 returns the applicable value for up to eight instances.</li>
             *                      </ul>
             *                      <p>
             *                      For example, suppose that the service includes configurations for one <code>A</code> record and a health check. You use the service to register 10 instances. Route 53 responds to DNS queries with IP addresses for up to eight healthy instances. If fewer than eight instances are healthy, Route 53 responds to every DNS query with the IP addresses for all of the healthy instances.
             *                      <p>
             *                      If you don't define a health check for the service, Route 53 assumes that all instances are healthy and returns the values for up to eight instances.
             *                      <p>
             *                      For more information about the multivalue routing policy, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-multivalue">Multivalue Answer Routing</a> in the <em>Route 53 Developer Guide</em> .
             *                      <p>
             *                      <ul>
             *                      <li><strong>WEIGHTED</strong> - Route 53 returns the applicable value from one randomly selected instance from among the instances that you registered using the same service. Currently, all records have the same weight, so you can't route more or less traffic to any instances.</li>
             *                      </ul>
             *                      <p>
             *                      For example, suppose that the service includes configurations for one <code>A</code> record and a health check. You use the service to register 10 instances. Route 53 responds to DNS queries with the IP address for one randomly selected instance from among the healthy instances. If no instances are healthy, Route 53 responds to DNS queries as if all of the instances were healthy.
             *                      <p>
             *                      If you don't define a health check for the service, Route 53 assumes that all instances are healthy and returns the applicable value for one randomly selected instance.
             *                      <p>
             *                      For more information about the weighted routing policy, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-weighted">Weighted Routing</a> in the <em>Route 53 Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routingPolicy(java.lang.String routingPolicy) {
                this.routingPolicy = routingPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DnsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DnsConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DnsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DnsConfigProperty {
            private final java.lang.Object dnsRecords;
            private final java.lang.String namespaceId;
            private final java.lang.String routingPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dnsRecords = software.amazon.jsii.Kernel.get(this, "dnsRecords", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.namespaceId = software.amazon.jsii.Kernel.get(this, "namespaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.routingPolicy = software.amazon.jsii.Kernel.get(this, "routingPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dnsRecords = java.util.Objects.requireNonNull(builder.dnsRecords, "dnsRecords is required");
                this.namespaceId = builder.namespaceId;
                this.routingPolicy = builder.routingPolicy;
            }

            @Override
            public final java.lang.Object getDnsRecords() {
                return this.dnsRecords;
            }

            @Override
            public final java.lang.String getNamespaceId() {
                return this.namespaceId;
            }

            @Override
            public final java.lang.String getRoutingPolicy() {
                return this.routingPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dnsRecords", om.valueToTree(this.getDnsRecords()));
                if (this.getNamespaceId() != null) {
                    data.set("namespaceId", om.valueToTree(this.getNamespaceId()));
                }
                if (this.getRoutingPolicy() != null) {
                    data.set("routingPolicy", om.valueToTree(this.getRoutingPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_servicediscovery.CfnService.DnsConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DnsConfigProperty.Jsii$Proxy that = (DnsConfigProperty.Jsii$Proxy) o;

                if (!dnsRecords.equals(that.dnsRecords)) return false;
                if (this.namespaceId != null ? !this.namespaceId.equals(that.namespaceId) : that.namespaceId != null) return false;
                return this.routingPolicy != null ? this.routingPolicy.equals(that.routingPolicy) : that.routingPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dnsRecords.hashCode();
                result = 31 * result + (this.namespaceId != null ? this.namespaceId.hashCode() : 0);
                result = 31 * result + (this.routingPolicy != null ? this.routingPolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A complex type that contains information about the Route 53 DNS records that you want AWS Cloud Map to create when you register an instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.servicediscovery.*;
     * DnsRecordProperty dnsRecordProperty = DnsRecordProperty.builder()
     *         .ttl(123)
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_servicediscovery.CfnService.DnsRecordProperty")
    @software.amazon.jsii.Jsii.Proxy(DnsRecordProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DnsRecordProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The amount of time, in seconds, that you want DNS resolvers to cache the settings for this record.
         * <p>
         * <blockquote>
         * <p>
         * Alias records don't include a TTL because Route 53 uses the TTL for the AWS resource that an alias record routes traffic to. If you include the <code>AWS_ALIAS_DNS_NAME</code> attribute when you submit a <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a> request, the <code>TTL</code> value is ignored. Always specify a TTL for the service; you can use a service to register instances that create either alias or non-alias records.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTtl();

        /**
         * The type of the resource, which indicates the type of value that Route 53 returns in response to DNS queries.
         * <p>
         * You can specify values for <code>Type</code> in the following combinations:
         * <p>
         * <ul>
         * <li><code>A</code></li>
         * <li><code>AAAA</code></li>
         * <li><code>A</code> and <code>AAAA</code></li>
         * <li><code>SRV</code></li>
         * <li><code>CNAME</code></li>
         * </ul>
         * <p>
         * If you want AWS Cloud Map to create a Route 53 alias record when you register an instance, specify <code>A</code> or <code>AAAA</code> for <code>Type</code> .
         * <p>
         * You specify other settings, such as the IP address for <code>A</code> and <code>AAAA</code> records, when you register an instance. For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a> .
         * <p>
         * The following values are supported:
         * <p>
         * <ul>
         * <li><strong>A</strong> - Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.</li>
         * <li><strong>AAAA</strong> - Route 53 returns the IP address of the resource in IPv6 format, such as 2001:0db8:85a3:0000:0000:abcd:0001:2345.</li>
         * <li><strong>CNAME</strong> - Route 53 returns the domain name of the resource, such as www.example.com. Note the following:</li>
         * <li>You specify the domain name that you want to route traffic to when you register an instance. For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html#cloudmap-RegisterInstance-request-Attributes">Attributes</a> in the topic <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a> .</li>
         * <li>You must specify <code>WEIGHTED</code> for the value of <code>RoutingPolicy</code> .</li>
         * <li>You can't specify both <code>CNAME</code> for <code>Type</code> and settings for <code>HealthCheckConfig</code> . If you do, the request will fail with an <code>InvalidInput</code> error.</li>
         * <li><strong>SRV</strong> - Route 53 returns the value for an <code>SRV</code> record. The value for an <code>SRV</code> record uses the following values:</li>
         * </ul>
         * <p>
         * <code>priority weight port service-hostname</code>
         * <p>
         * Note the following about the values:
         * <p>
         * <ul>
         * <li>The values of <code>priority</code> and <code>weight</code> are both set to <code>1</code> and can't be changed.</li>
         * <li>The value of <code>port</code> comes from the value that you specify for the <code>AWS_INSTANCE_PORT</code> attribute when you submit a <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a> request.</li>
         * <li>The value of <code>service-hostname</code> is a concatenation of the following values:</li>
         * <li>The value that you specify for <code>InstanceId</code> when you register an instance.</li>
         * <li>The name of the service.</li>
         * <li>The name of the namespace.</li>
         * </ul>
         * <p>
         * For example, if the value of <code>InstanceId</code> is <code>test</code> , the name of the service is <code>backend</code> , and the name of the namespace is <code>example.com</code> , the value of <code>service-hostname</code> is:
         * <p>
         * <code>test.backend.example.com</code>
         * <p>
         * If you specify settings for an <code>SRV</code> record and if you specify values for <code>AWS_INSTANCE_IPV4</code> , <code>AWS_INSTANCE_IPV6</code> , or both in the <code>RegisterInstance</code> request, AWS Cloud Map automatically creates <code>A</code> and/or <code>AAAA</code> records that have the same name as the value of <code>service-hostname</code> in the <code>SRV</code> record. You can ignore these records.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link DnsRecordProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DnsRecordProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DnsRecordProperty> {
            java.lang.Number ttl;
            java.lang.String type;

            /**
             * Sets the value of {@link DnsRecordProperty#getTtl}
             * @param ttl The amount of time, in seconds, that you want DNS resolvers to cache the settings for this record. This parameter is required.
             *            <blockquote>
             *            <p>
             *            Alias records don't include a TTL because Route 53 uses the TTL for the AWS resource that an alias record routes traffic to. If you include the <code>AWS_ALIAS_DNS_NAME</code> attribute when you submit a <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a> request, the <code>TTL</code> value is ignored. Always specify a TTL for the service; you can use a service to register instances that create either alias or non-alias records.
             *            <p>
             *            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ttl(java.lang.Number ttl) {
                this.ttl = ttl;
                return this;
            }

            /**
             * Sets the value of {@link DnsRecordProperty#getType}
             * @param type The type of the resource, which indicates the type of value that Route 53 returns in response to DNS queries. This parameter is required.
             *             You can specify values for <code>Type</code> in the following combinations:
             *             <p>
             *             <ul>
             *             <li><code>A</code></li>
             *             <li><code>AAAA</code></li>
             *             <li><code>A</code> and <code>AAAA</code></li>
             *             <li><code>SRV</code></li>
             *             <li><code>CNAME</code></li>
             *             </ul>
             *             <p>
             *             If you want AWS Cloud Map to create a Route 53 alias record when you register an instance, specify <code>A</code> or <code>AAAA</code> for <code>Type</code> .
             *             <p>
             *             You specify other settings, such as the IP address for <code>A</code> and <code>AAAA</code> records, when you register an instance. For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a> .
             *             <p>
             *             The following values are supported:
             *             <p>
             *             <ul>
             *             <li><strong>A</strong> - Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.</li>
             *             <li><strong>AAAA</strong> - Route 53 returns the IP address of the resource in IPv6 format, such as 2001:0db8:85a3:0000:0000:abcd:0001:2345.</li>
             *             <li><strong>CNAME</strong> - Route 53 returns the domain name of the resource, such as www.example.com. Note the following:</li>
             *             <li>You specify the domain name that you want to route traffic to when you register an instance. For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html#cloudmap-RegisterInstance-request-Attributes">Attributes</a> in the topic <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a> .</li>
             *             <li>You must specify <code>WEIGHTED</code> for the value of <code>RoutingPolicy</code> .</li>
             *             <li>You can't specify both <code>CNAME</code> for <code>Type</code> and settings for <code>HealthCheckConfig</code> . If you do, the request will fail with an <code>InvalidInput</code> error.</li>
             *             <li><strong>SRV</strong> - Route 53 returns the value for an <code>SRV</code> record. The value for an <code>SRV</code> record uses the following values:</li>
             *             </ul>
             *             <p>
             *             <code>priority weight port service-hostname</code>
             *             <p>
             *             Note the following about the values:
             *             <p>
             *             <ul>
             *             <li>The values of <code>priority</code> and <code>weight</code> are both set to <code>1</code> and can't be changed.</li>
             *             <li>The value of <code>port</code> comes from the value that you specify for the <code>AWS_INSTANCE_PORT</code> attribute when you submit a <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html">RegisterInstance</a> request.</li>
             *             <li>The value of <code>service-hostname</code> is a concatenation of the following values:</li>
             *             <li>The value that you specify for <code>InstanceId</code> when you register an instance.</li>
             *             <li>The name of the service.</li>
             *             <li>The name of the namespace.</li>
             *             </ul>
             *             <p>
             *             For example, if the value of <code>InstanceId</code> is <code>test</code> , the name of the service is <code>backend</code> , and the name of the namespace is <code>example.com</code> , the value of <code>service-hostname</code> is:
             *             <p>
             *             <code>test.backend.example.com</code>
             *             <p>
             *             If you specify settings for an <code>SRV</code> record and if you specify values for <code>AWS_INSTANCE_IPV4</code> , <code>AWS_INSTANCE_IPV6</code> , or both in the <code>RegisterInstance</code> request, AWS Cloud Map automatically creates <code>A</code> and/or <code>AAAA</code> records that have the same name as the value of <code>service-hostname</code> in the <code>SRV</code> record. You can ignore these records.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DnsRecordProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DnsRecordProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DnsRecordProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DnsRecordProperty {
            private final java.lang.Number ttl;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ttl = software.amazon.jsii.Kernel.get(this, "ttl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ttl = java.util.Objects.requireNonNull(builder.ttl, "ttl is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.Number getTtl() {
                return this.ttl;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ttl", om.valueToTree(this.getTtl()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_servicediscovery.CfnService.DnsRecordProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DnsRecordProperty.Jsii$Proxy that = (DnsRecordProperty.Jsii$Proxy) o;

                if (!ttl.equals(that.ttl)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.ttl.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * *Public DNS and HTTP namespaces only.* A complex type that contains settings for an optional health check. If you specify settings for a health check, AWS Cloud Map associates the health check with the records that you specify in `DnsConfig` .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or <code>HealthCheckConfig</code> but not both.
     * <p>
     * </blockquote>
     * <p>
     * Health checks are basic Route 53 health checks that monitor an AWS endpoint. For information about pricing for health checks, see <a href="https://docs.aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a> .
     * <p>
     * Note the following about configuring health checks.
     * <p>
     * <ul>
     * <li><strong>A and AAAA records</strong> - If <code>DnsConfig</code> includes configurations for both <code>A</code> and <code>AAAA</code> records, AWS Cloud Map creates a health check that uses the IPv4 address to check the health of the resource. If the endpoint tthat's specified by the IPv4 address is unhealthy, Route 53 considers both the <code>A</code> and <code>AAAA</code> records to be unhealthy.</li>
     * <li><strong>CNAME records</strong> - You can't specify settings for <code>HealthCheckConfig</code> when the <code>DNSConfig</code> includes <code>CNAME</code> for the value of <code>Type</code> . If you do, the <code>CreateService</code> request will fail with an <code>InvalidInput</code> error.</li>
     * <li><strong>Request interval</strong> - A Route 53 health checker in each health-checking AWS Region sends a health check request to an endpoint every 30 seconds. On average, your endpoint receives a health check request about every two seconds. However, health checkers don't coordinate with one another. Therefore, you might sometimes see several requests in one second that's followed by a few seconds with no health checks at all.</li>
     * <li><strong>Health checking regions</strong> - Health checkers perform checks from all Route 53 health-checking Regions. For a list of the current Regions, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-Regions">Regions</a> .</li>
     * <li><strong>Alias records</strong> - When you register an instance, if you include the <code>AWS_ALIAS_DNS_NAME</code> attribute, AWS Cloud Map creates a Route 53 alias record. Note the following:</li>
     * <li>Route 53 automatically sets <code>EvaluateTargetHealth</code> to true for alias records. When <code>EvaluateTargetHealth</code> is true, the alias record inherits the health of the referenced AWS resource. such as an ELB load balancer. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html#Route53-Type-AliasTarget-EvaluateTargetHealth">EvaluateTargetHealth</a> .</li>
     * <li>If you include <code>HealthCheckConfig</code> and then use the service to register an instance that creates an alias record, Route 53 doesn't create the health check.</li>
     * <li><strong>Charges for health checks</strong> - Health checks are basic Route 53 health checks that monitor an AWS endpoint. For information about pricing for health checks, see <a href="https://docs.aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a> .</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.servicediscovery.*;
     * HealthCheckConfigProperty healthCheckConfigProperty = HealthCheckConfigProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .failureThreshold(123)
     *         .resourcePath("resourcePath")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_servicediscovery.CfnService.HealthCheckConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(HealthCheckConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HealthCheckConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is healthy.
         * <p>
         * <blockquote>
         * <p>
         * You can't change the value of <code>Type</code> after you create a health check.
         * <p>
         * </blockquote>
         * <p>
         * You can create the following types of health checks:
         * <p>
         * <ul>
         * <li><em>HTTP</em> : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP request and waits for an HTTP status code of 200 or greater and less than 400.</li>
         * <li><em>HTTPS</em> : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTPS request and waits for an HTTP status code of 200 or greater and less than 400.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you specify HTTPS for the value of <code>Type</code> , the endpoint must support TLS v1.0 or later.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><em>TCP</em> : Route 53 tries to establish a TCP connection.</li>
         * </ul>
         * <p>
         * If you specify <code>TCP</code> for <code>Type</code> , don't specify a value for <code>ResourcePath</code> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Route 53 Determines Whether an Endpoint Is Healthy</a> in the <em>Route 53 Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The number of consecutive health checks that an endpoint must pass or fail for Route 53 to change the current status of the endpoint from unhealthy to healthy or the other way around.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Route 53 Determines Whether an Endpoint Is Healthy</a> in the <em>Route 53 Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFailureThreshold() {
            return null;
        }

        /**
         * The path that you want Route 53 to request when performing health checks.
         * <p>
         * The path can be any value that your endpoint returns an HTTP status code of a 2xx or 3xx format for when the endpoint is healthy. An example file is <code>/docs/route53-health-check.html</code> . Route 53 automatically adds the DNS name for the service. If you don't specify a value for <code>ResourcePath</code> , the default value is <code>/</code> .
         * <p>
         * If you specify <code>TCP</code> for <code>Type</code> , you must <em>not</em> specify a value for <code>ResourcePath</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourcePath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HealthCheckConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HealthCheckConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HealthCheckConfigProperty> {
            java.lang.String type;
            java.lang.Number failureThreshold;
            java.lang.String resourcePath;

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getType}
             * @param type The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is healthy. This parameter is required.
             *             <blockquote>
             *             <p>
             *             You can't change the value of <code>Type</code> after you create a health check.
             *             <p>
             *             </blockquote>
             *             <p>
             *             You can create the following types of health checks:
             *             <p>
             *             <ul>
             *             <li><em>HTTP</em> : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP request and waits for an HTTP status code of 200 or greater and less than 400.</li>
             *             <li><em>HTTPS</em> : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTPS request and waits for an HTTP status code of 200 or greater and less than 400.</li>
             *             </ul>
             *             <p>
             *             <blockquote>
             *             <p>
             *             If you specify HTTPS for the value of <code>Type</code> , the endpoint must support TLS v1.0 or later.
             *             <p>
             *             </blockquote>
             *             <p>
             *             <ul>
             *             <li><em>TCP</em> : Route 53 tries to establish a TCP connection.</li>
             *             </ul>
             *             <p>
             *             If you specify <code>TCP</code> for <code>Type</code> , don't specify a value for <code>ResourcePath</code> .
             *             <p>
             *             For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Route 53 Determines Whether an Endpoint Is Healthy</a> in the <em>Route 53 Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getFailureThreshold}
             * @param failureThreshold The number of consecutive health checks that an endpoint must pass or fail for Route 53 to change the current status of the endpoint from unhealthy to healthy or the other way around.
             *                         For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Route 53 Determines Whether an Endpoint Is Healthy</a> in the <em>Route 53 Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureThreshold(java.lang.Number failureThreshold) {
                this.failureThreshold = failureThreshold;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckConfigProperty#getResourcePath}
             * @param resourcePath The path that you want Route 53 to request when performing health checks.
             *                     The path can be any value that your endpoint returns an HTTP status code of a 2xx or 3xx format for when the endpoint is healthy. An example file is <code>/docs/route53-health-check.html</code> . Route 53 automatically adds the DNS name for the service. If you don't specify a value for <code>ResourcePath</code> , the default value is <code>/</code> .
             *                     <p>
             *                     If you specify <code>TCP</code> for <code>Type</code> , you must <em>not</em> specify a value for <code>ResourcePath</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourcePath(java.lang.String resourcePath) {
                this.resourcePath = resourcePath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HealthCheckConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HealthCheckConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HealthCheckConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HealthCheckConfigProperty {
            private final java.lang.String type;
            private final java.lang.Number failureThreshold;
            private final java.lang.String resourcePath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.failureThreshold = software.amazon.jsii.Kernel.get(this, "failureThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.resourcePath = software.amazon.jsii.Kernel.get(this, "resourcePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.failureThreshold = builder.failureThreshold;
                this.resourcePath = builder.resourcePath;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Number getFailureThreshold() {
                return this.failureThreshold;
            }

            @Override
            public final java.lang.String getResourcePath() {
                return this.resourcePath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getFailureThreshold() != null) {
                    data.set("failureThreshold", om.valueToTree(this.getFailureThreshold()));
                }
                if (this.getResourcePath() != null) {
                    data.set("resourcePath", om.valueToTree(this.getResourcePath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_servicediscovery.CfnService.HealthCheckConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HealthCheckConfigProperty.Jsii$Proxy that = (HealthCheckConfigProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.failureThreshold != null ? !this.failureThreshold.equals(that.failureThreshold) : that.failureThreshold != null) return false;
                return this.resourcePath != null ? this.resourcePath.equals(that.resourcePath) : that.resourcePath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.failureThreshold != null ? this.failureThreshold.hashCode() : 0);
                result = 31 * result + (this.resourcePath != null ? this.resourcePath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A complex type that contains information about an optional custom health check.
     * <p>
     * A custom health check, which requires that you use a third-party health checker to evaluate the health of your resources, is useful in the following circumstances:
     * <p>
     * <ul>
     * <li>You can't use a health check that's defined by <code>HealthCheckConfig</code> because the resource isn't available over the internet. For example, you can use a custom health check when the instance is in an Amazon VPC. (To check the health of resources in a VPC, the health checker must also be in the VPC.)</li>
     * <li>You want to use a third-party health checker regardless of where your resources are located.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or <code>HealthCheckConfig</code> but not both.
     * <p>
     * </blockquote>
     * <p>
     * To change the status of a custom health check, submit an <code>UpdateInstanceCustomHealthStatus</code> request. AWS Cloud Map doesn't monitor the status of the resource, it just keeps a record of the status specified in the most recent <code>UpdateInstanceCustomHealthStatus</code> request.
     * <p>
     * Here's how custom health checks work:
     * <p>
     * <ul>
     * <li>You create a service.</li>
     * <li>You register an instance.</li>
     * <li>You configure a third-party health checker to monitor the resource that's associated with the new instance.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * AWS Cloud Map doesn't check the health of the resource directly.
     * <p>
     * </blockquote>
     * <p>
     * <ul>
     * <li>The third-party health-checker determines that the resource is unhealthy and notifies your application.</li>
     * <li>Your application submits an <code>UpdateInstanceCustomHealthStatus</code> request.</li>
     * <li>AWS Cloud Map waits for 30 seconds.</li>
     * <li>If another <code>UpdateInstanceCustomHealthStatus</code> request doesn't arrive during that time to change the status back to healthy, AWS Cloud Map stops routing traffic to the resource.</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.servicediscovery.*;
     * HealthCheckCustomConfigProperty healthCheckCustomConfigProperty = HealthCheckCustomConfigProperty.builder()
     *         .failureThreshold(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_servicediscovery.CfnService.HealthCheckCustomConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(HealthCheckCustomConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HealthCheckCustomConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * > This parameter is no longer supported and is always set to 1.
         * <p>
         * AWS Cloud Map waits for approximately 30 seconds after receiving an <code>UpdateInstanceCustomHealthStatus</code> request before changing the status of the service instance.
         * <p>
         * The number of 30-second intervals that you want AWS Cloud Map to wait after receiving an <code>UpdateInstanceCustomHealthStatus</code> request before it changes the health status of a service instance.
         * <p>
         * Sending a second or subsequent <code>UpdateInstanceCustomHealthStatus</code> request with the same value before 30 seconds has passed doesn't accelerate the change. AWS Cloud Map still waits <code>30</code> seconds after the first request to make the change.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFailureThreshold() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HealthCheckCustomConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HealthCheckCustomConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HealthCheckCustomConfigProperty> {
            java.lang.Number failureThreshold;

            /**
             * Sets the value of {@link HealthCheckCustomConfigProperty#getFailureThreshold}
             * @param failureThreshold > This parameter is no longer supported and is always set to 1.
             *                         AWS Cloud Map waits for approximately 30 seconds after receiving an <code>UpdateInstanceCustomHealthStatus</code> request before changing the status of the service instance.
             *                         <p>
             *                         The number of 30-second intervals that you want AWS Cloud Map to wait after receiving an <code>UpdateInstanceCustomHealthStatus</code> request before it changes the health status of a service instance.
             *                         <p>
             *                         Sending a second or subsequent <code>UpdateInstanceCustomHealthStatus</code> request with the same value before 30 seconds has passed doesn't accelerate the change. AWS Cloud Map still waits <code>30</code> seconds after the first request to make the change.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureThreshold(java.lang.Number failureThreshold) {
                this.failureThreshold = failureThreshold;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HealthCheckCustomConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HealthCheckCustomConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HealthCheckCustomConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HealthCheckCustomConfigProperty {
            private final java.lang.Number failureThreshold;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.failureThreshold = software.amazon.jsii.Kernel.get(this, "failureThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.failureThreshold = builder.failureThreshold;
            }

            @Override
            public final java.lang.Number getFailureThreshold() {
                return this.failureThreshold;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFailureThreshold() != null) {
                    data.set("failureThreshold", om.valueToTree(this.getFailureThreshold()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_servicediscovery.CfnService.HealthCheckCustomConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HealthCheckCustomConfigProperty.Jsii$Proxy that = (HealthCheckCustomConfigProperty.Jsii$Proxy) o;

                return this.failureThreshold != null ? this.failureThreshold.equals(that.failureThreshold) : that.failureThreshold == null;
            }

            @Override
            public final int hashCode() {
                int result = this.failureThreshold != null ? this.failureThreshold.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.servicediscovery.CfnService}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.servicediscovery.CfnService> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.servicediscovery.CfnServiceProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The description of the service.
         * <p>
         * @return {@code this}
         * @param description The description of the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * A complex type that contains information about the Route 53 DNS records that you want AWS Cloud Map to create when you register an instance.
         * <p>
         * <blockquote>
         * <p>
         * The record types of a service can only be changed by deleting the service and recreating it with a new <code>Dnsconfig</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param dnsConfig A complex type that contains information about the Route 53 DNS records that you want AWS Cloud Map to create when you register an instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsConfig(final software.amazon.awscdk.services.servicediscovery.CfnService.DnsConfigProperty dnsConfig) {
            this.props().dnsConfig(dnsConfig);
            return this;
        }
        /**
         * A complex type that contains information about the Route 53 DNS records that you want AWS Cloud Map to create when you register an instance.
         * <p>
         * <blockquote>
         * <p>
         * The record types of a service can only be changed by deleting the service and recreating it with a new <code>Dnsconfig</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param dnsConfig A complex type that contains information about the Route 53 DNS records that you want AWS Cloud Map to create when you register an instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsConfig(final software.amazon.awscdk.core.IResolvable dnsConfig) {
            this.props().dnsConfig(dnsConfig);
            return this;
        }

        /**
         * *Public DNS and HTTP namespaces only.* A complex type that contains settings for an optional health check. If you specify settings for a health check, AWS Cloud Map associates the health check with the records that you specify in `DnsConfig` .
         * <p>
         * For information about the charges for health checks, see <a href="https://docs.aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a> .
         * <p>
         * @return {@code this}
         * @param healthCheckConfig *Public DNS and HTTP namespaces only.* A complex type that contains settings for an optional health check. If you specify settings for a health check, AWS Cloud Map associates the health check with the records that you specify in `DnsConfig` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckConfig(final software.amazon.awscdk.services.servicediscovery.CfnService.HealthCheckConfigProperty healthCheckConfig) {
            this.props().healthCheckConfig(healthCheckConfig);
            return this;
        }
        /**
         * *Public DNS and HTTP namespaces only.* A complex type that contains settings for an optional health check. If you specify settings for a health check, AWS Cloud Map associates the health check with the records that you specify in `DnsConfig` .
         * <p>
         * For information about the charges for health checks, see <a href="https://docs.aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a> .
         * <p>
         * @return {@code this}
         * @param healthCheckConfig *Public DNS and HTTP namespaces only.* A complex type that contains settings for an optional health check. If you specify settings for a health check, AWS Cloud Map associates the health check with the records that you specify in `DnsConfig` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckConfig(final software.amazon.awscdk.core.IResolvable healthCheckConfig) {
            this.props().healthCheckConfig(healthCheckConfig);
            return this;
        }

        /**
         * A complex type that contains information about an optional custom health check.
         * <p>
         * <blockquote>
         * <p>
         * If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or <code>HealthCheckConfig</code> but not both.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param healthCheckCustomConfig A complex type that contains information about an optional custom health check. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckCustomConfig(final software.amazon.awscdk.services.servicediscovery.CfnService.HealthCheckCustomConfigProperty healthCheckCustomConfig) {
            this.props().healthCheckCustomConfig(healthCheckCustomConfig);
            return this;
        }
        /**
         * A complex type that contains information about an optional custom health check.
         * <p>
         * <blockquote>
         * <p>
         * If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or <code>HealthCheckConfig</code> but not both.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param healthCheckCustomConfig A complex type that contains information about an optional custom health check. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckCustomConfig(final software.amazon.awscdk.core.IResolvable healthCheckCustomConfig) {
            this.props().healthCheckCustomConfig(healthCheckCustomConfig);
            return this;
        }

        /**
         * The name of the service.
         * <p>
         * @return {@code this}
         * @param name The name of the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * The ID of the namespace that was used to create the service.
         * <p>
         * <blockquote>
         * <p>
         * You must specify a value for <code>NamespaceId</code> either for the service properties or for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicediscovery-service-dnsconfig.html">DnsConfig</a> . Don't specify a value in both places.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param namespaceId The ID of the namespace that was used to create the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespaceId(final java.lang.String namespaceId) {
            this.props().namespaceId(namespaceId);
            return this;
        }

        /**
         * The tags for the service.
         * <p>
         * Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * <p>
         * @return {@code this}
         * @param tags The tags for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * If present, specifies that the service instances are only discoverable using the `DiscoverInstances` API operation.
         * <p>
         * No DNS records is registered for the service instances. The only valid value is <code>HTTP</code> .
         * <p>
         * @return {@code this}
         * @param type If present, specifies that the service instances are only discoverable using the `DiscoverInstances` API operation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props().type(type);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.servicediscovery.CfnService}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.servicediscovery.CfnService build() {
            return new software.amazon.awscdk.services.servicediscovery.CfnService(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.servicediscovery.CfnServiceProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.servicediscovery.CfnServiceProps.Builder();
            }
            return this.props;
        }
    }
}
