package software.amazon.awscdk.services.servicediscovery;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * App app = new App();
 * Stack stack = new Stack(app, "aws-servicediscovery-integ");
 * PublicDnsNamespace namespace = PublicDnsNamespace.Builder.create(stack, "Namespace")
 *         .name("foobar.com")
 *         .build();
 * Service service = namespace.createService("Service", DnsServiceProps.builder()
 *         .name("foo")
 *         .dnsRecordType(DnsRecordType.CNAME)
 *         .dnsTtl(Duration.seconds(30))
 *         .build());
 * service.registerCnameInstance("CnameInstance", CnameInstanceBaseProps.builder()
 *         .instanceCname("service.pizza")
 *         .build());
 * app.synth();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:10.078Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_servicediscovery.DnsRecordType")
public enum DnsRecordType {
    /**
     * (experimental) An A record.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    A,
    /**
     * (experimental) An AAAA record.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    AAAA,
    /**
     * (experimental) Both an A and AAAA record.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    A_AAAA,
    /**
     * (experimental) A Srv record.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SRV,
    /**
     * (experimental) A CNAME record.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    CNAME,
}
