package software.amazon.awscdk.services.ses;

/**
 * (experimental) A new receipt rule set.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ReceiptRuleSet ruleSet = new ReceiptRuleSet(this, "RuleSet");
 * ReceiptRule awsRule = ruleSet.addRule("Aws", ReceiptRuleOptions.builder()
 *         .recipients(List.of("aws.com"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:10.216Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ses.ReceiptRuleSet")
public class ReceiptRuleSet extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.ses.IReceiptRuleSet {

    protected ReceiptRuleSet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ReceiptRuleSet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ReceiptRuleSet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.ReceiptRuleSetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ReceiptRuleSet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Import an exported receipt rule set.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param receiptRuleSetName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.IReceiptRuleSet fromReceiptRuleSetName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String receiptRuleSetName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ses.ReceiptRuleSet.class, "fromReceiptRuleSetName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.IReceiptRuleSet.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(receiptRuleSetName, "receiptRuleSetName is required") });
    }

    /**
     * (experimental) Adds a drop spam rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void addDropSpamRule() {
        software.amazon.jsii.Kernel.call(this, "addDropSpamRule", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * (experimental) Adds a new receipt rule in this rule set.
     * <p>
     * The new rule is added after
     * the last added rule unless <code>after</code> is specified.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.ReceiptRule addRule(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.ReceiptRuleOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addRule", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.ReceiptRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * (experimental) Adds a new receipt rule in this rule set.
     * <p>
     * The new rule is added after
     * the last added rule unless <code>after</code> is specified.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.ReceiptRule addRule(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "addRule", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.ReceiptRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) The receipt rule set name.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getReceiptRuleSetName() {
        return software.amazon.jsii.Kernel.get(this, "receiptRuleSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.ses.ReceiptRuleSet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.ReceiptRuleSet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ses.ReceiptRuleSetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * (experimental) Whether to add a first rule to stop processing messages that have at least one spam indicator.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param dropSpam Whether to add a first rule to stop processing messages that have at least one spam indicator. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dropSpam(final java.lang.Boolean dropSpam) {
            this.props().dropSpam(dropSpam);
            return this;
        }

        /**
         * (experimental) The name for the receipt rule set.
         * <p>
         * Default: - A CloudFormation generated name.
         * <p>
         * @return {@code this}
         * @param receiptRuleSetName The name for the receipt rule set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder receiptRuleSetName(final java.lang.String receiptRuleSetName) {
            this.props().receiptRuleSetName(receiptRuleSetName);
            return this;
        }

        /**
         * (experimental) The list of rules to add to this rule set.
         * <p>
         * Rules are added in the same
         * order as they appear in the list.
         * <p>
         * Default: - No rules are added to the rule set.
         * <p>
         * @return {@code this}
         * @param rules The list of rules to add to this rule set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder rules(final java.util.List<? extends software.amazon.awscdk.services.ses.ReceiptRuleOptions> rules) {
            this.props().rules(rules);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ses.ReceiptRuleSet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.ses.ReceiptRuleSet build() {
            return new software.amazon.awscdk.services.ses.ReceiptRuleSet(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ses.ReceiptRuleSetProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ses.ReceiptRuleSetProps.Builder();
            }
            return this.props;
        }
    }
}
