package software.amazon.awscdk.services.signer;

/**
 * (experimental) Construction properties for a Signing Profile object.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * SigningProfile signingProfile = SigningProfile.Builder.create(this, "SigningProfile")
 *         .platform(Platform.AWS_LAMBDA_SHA384_ECDSA)
 *         .build();
 * CodeSigningConfig codeSigningConfig = CodeSigningConfig.Builder.create(this, "CodeSigningConfig")
 *         .signingProfiles(List.of(signingProfile))
 *         .build();
 * Function.Builder.create(this, "Function")
 *         .codeSigningConfig(codeSigningConfig)
 *         .runtime(Runtime.NODEJS_16_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:10.270Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_signer.SigningProfileProps")
@software.amazon.jsii.Jsii.Proxy(SigningProfileProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface SigningProfileProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The Signing Platform available for signing profile.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/signer/latest/developerguide/gs-platform.html">https://docs.aws.amazon.com/signer/latest/developerguide/gs-platform.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.signer.Platform getPlatform();

    /**
     * (experimental) The validity period for signatures generated using this signing profile.
     * <p>
     * Default: - 135 months
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getSignatureValidity() {
        return null;
    }

    /**
     * (experimental) Physical name of this Signing Profile.
     * <p>
     * Default: - Assigned by CloudFormation (recommended).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getSigningProfileName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SigningProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SigningProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<SigningProfileProps> {
        software.amazon.awscdk.services.signer.Platform platform;
        software.amazon.awscdk.core.Duration signatureValidity;
        java.lang.String signingProfileName;

        /**
         * Sets the value of {@link SigningProfileProps#getPlatform}
         * @param platform The Signing Platform available for signing profile. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder platform(software.amazon.awscdk.services.signer.Platform platform) {
            this.platform = platform;
            return this;
        }

        /**
         * Sets the value of {@link SigningProfileProps#getSignatureValidity}
         * @param signatureValidity The validity period for signatures generated using this signing profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder signatureValidity(software.amazon.awscdk.core.Duration signatureValidity) {
            this.signatureValidity = signatureValidity;
            return this;
        }

        /**
         * Sets the value of {@link SigningProfileProps#getSigningProfileName}
         * @param signingProfileName Physical name of this Signing Profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder signingProfileName(java.lang.String signingProfileName) {
            this.signingProfileName = signingProfileName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SigningProfileProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public SigningProfileProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SigningProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SigningProfileProps {
        private final software.amazon.awscdk.services.signer.Platform platform;
        private final software.amazon.awscdk.core.Duration signatureValidity;
        private final java.lang.String signingProfileName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.platform = software.amazon.jsii.Kernel.get(this, "platform", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.signer.Platform.class));
            this.signatureValidity = software.amazon.jsii.Kernel.get(this, "signatureValidity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.signingProfileName = software.amazon.jsii.Kernel.get(this, "signingProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.platform = java.util.Objects.requireNonNull(builder.platform, "platform is required");
            this.signatureValidity = builder.signatureValidity;
            this.signingProfileName = builder.signingProfileName;
        }

        @Override
        public final software.amazon.awscdk.services.signer.Platform getPlatform() {
            return this.platform;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getSignatureValidity() {
            return this.signatureValidity;
        }

        @Override
        public final java.lang.String getSigningProfileName() {
            return this.signingProfileName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("platform", om.valueToTree(this.getPlatform()));
            if (this.getSignatureValidity() != null) {
                data.set("signatureValidity", om.valueToTree(this.getSignatureValidity()));
            }
            if (this.getSigningProfileName() != null) {
                data.set("signingProfileName", om.valueToTree(this.getSigningProfileName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_signer.SigningProfileProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SigningProfileProps.Jsii$Proxy that = (SigningProfileProps.Jsii$Proxy) o;

            if (!platform.equals(that.platform)) return false;
            if (this.signatureValidity != null ? !this.signatureValidity.equals(that.signatureValidity) : that.signatureValidity != null) return false;
            return this.signingProfileName != null ? this.signingProfileName.equals(that.signingProfileName) : that.signingProfileName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.platform.hashCode();
            result = 31 * result + (this.signatureValidity != null ? this.signatureValidity.hashCode() : 0);
            result = 31 * result + (this.signingProfileName != null ? this.signingProfileName.hashCode() : 0);
            return result;
        }
    }
}
