package software.amazon.awscdk.services.sns.subscriptions;

/**
 * (experimental) Use an SQS queue as a subscription target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Queue queue;
 * Topic myTopic = new Topic(this, "MyTopic");
 * myTopic.addSubscription(new SqsSubscription(queue));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:10.343Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_sns_subscriptions.SqsSubscription")
public class SqsSubscription extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sns.ITopicSubscription {

    protected SqsSubscription(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SqsSubscription(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param queue This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SqsSubscription(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue queue, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.subscriptions.SqsSubscriptionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(queue, "queue is required"), props });
    }

    /**
     * @param queue This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SqsSubscription(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue queue) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(queue, "queue is required") });
    }

    /**
     * (experimental) Returns a configuration for an SQS queue to subscribe to an SNS topic.
     * <p>
     * @param topic This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.TopicSubscriptionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic topic) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.TopicSubscriptionConfig.class), new Object[] { java.util.Objects.requireNonNull(topic, "topic is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.sns.subscriptions.SqsSubscription}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sns.subscriptions.SqsSubscription> {
        /**
         * @return a new instance of {@link Builder}.
         * @param queue This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.services.sqs.IQueue queue) {
            return new Builder(queue);
        }

        private final software.amazon.awscdk.services.sqs.IQueue queue;
        private software.amazon.awscdk.services.sns.subscriptions.SqsSubscriptionProps.Builder props;

        private Builder(final software.amazon.awscdk.services.sqs.IQueue queue) {
            this.queue = queue;
        }

        /**
         * (experimental) Queue to be used as dead letter queue.
         * <p>
         * If not passed no dead letter queue is enabled.
         * <p>
         * Default: - No dead letter queue enabled.
         * <p>
         * @return {@code this}
         * @param deadLetterQueue Queue to be used as dead letter queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * (experimental) The filter policy.
         * <p>
         * Default: - all messages are delivered
         * <p>
         * @return {@code this}
         * @param filterPolicy The filter policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder filterPolicy(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy) {
            this.props().filterPolicy(filterPolicy);
            return this;
        }

        /**
         * (experimental) The message to the queue is the same as it was sent to the topic.
         * <p>
         * If false, the message will be wrapped in an SNS envelope.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param rawMessageDelivery The message to the queue is the same as it was sent to the topic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder rawMessageDelivery(final java.lang.Boolean rawMessageDelivery) {
            this.props().rawMessageDelivery(rawMessageDelivery);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.sns.subscriptions.SqsSubscription}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.sns.subscriptions.SqsSubscription build() {
            return new software.amazon.awscdk.services.sns.subscriptions.SqsSubscription(
                this.queue,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.sns.subscriptions.SqsSubscriptionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.sns.subscriptions.SqsSubscriptionProps.Builder();
            }
            return this.props;
        }
    }
}
