package software.amazon.awscdk.services.sqs;

/**
 * (experimental) Properties for creating a new Queue.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Use managed key
 * // Use managed key
 * Queue.Builder.create(this, "Queue")
 *         .encryption(QueueEncryption.KMS_MANAGED)
 *         .build();
 * // Use custom key
 * Key myKey = new Key(this, "Key");
 * Queue.Builder.create(this, "Queue")
 *         .encryption(QueueEncryption.KMS)
 *         .encryptionMasterKey(myKey)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:10.387Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_sqs.QueueProps")
@software.amazon.jsii.Jsii.Proxy(QueueProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface QueueProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Specifies whether to enable content-based deduplication.
     * <p>
     * During the deduplication interval (5 minutes), Amazon SQS treats
     * messages that are sent with identical content (excluding attributes) as
     * duplicates and delivers only one copy of the message.
     * <p>
     * If you don't enable content-based deduplication and you want to deduplicate
     * messages, provide an explicit deduplication ID in your SendMessage() call.
     * <p>
     * (Only applies to FIFO queues.)
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getContentBasedDeduplication() {
        return null;
    }

    /**
     * (experimental) The length of time that Amazon SQS reuses a data key before calling KMS again.
     * <p>
     * The value must be an integer between 60 (1 minute) and 86,400 (24
     * hours). The default is 300 (5 minutes).
     * <p>
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getDataKeyReuse() {
        return null;
    }

    /**
     * (experimental) Send messages to this queue if they were unsuccessfully dequeued a number of times.
     * <p>
     * Default: no dead-letter queue
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sqs.DeadLetterQueue getDeadLetterQueue() {
        return null;
    }

    /**
     * (experimental) For high throughput for FIFO queues, specifies whether message deduplication occurs at the message group or queue level.
     * <p>
     * (Only applies to FIFO queues.)
     * <p>
     * Default: DeduplicationScope.QUEUE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sqs.DeduplicationScope getDeduplicationScope() {
        return null;
    }

    /**
     * (experimental) The time in seconds that the delivery of all messages in the queue is delayed.
     * <p>
     * You can specify an integer value of 0 to 900 (15 minutes). The default
     * value is 0.
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getDeliveryDelay() {
        return null;
    }

    /**
     * (experimental) Whether the contents of the queue are encrypted, and by what type of key.
     * <p>
     * Be aware that encryption is not available in all regions, please see the docs
     * for current availability details.
     * <p>
     * Default: Unencrypted
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sqs.QueueEncryption getEncryption() {
        return null;
    }

    /**
     * (experimental) External KMS master key to use for queue encryption.
     * <p>
     * Individual messages will be encrypted using data keys. The data keys in
     * turn will be encrypted using this key, and reused for a maximum of
     * <code>dataKeyReuseSecs</code> seconds.
     * <p>
     * If the 'encryptionMasterKey' property is set, 'encryption' type will be
     * implicitly set to "KMS".
     * <p>
     * Default: If encryption is set to KMS and not specified, a key will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionMasterKey() {
        return null;
    }

    /**
     * (experimental) Whether this a first-in-first-out (FIFO) queue.
     * <p>
     * Default: false, unless queueName ends in '.fifo' or 'contentBasedDeduplication' is true.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getFifo() {
        return null;
    }

    /**
     * (experimental) For high throughput for FIFO queues, specifies whether the FIFO queue throughput quota applies to the entire queue or per message group.
     * <p>
     * (Only applies to FIFO queues.)
     * <p>
     * Default: FifoThroughputLimit.PER_QUEUE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sqs.FifoThroughputLimit getFifoThroughputLimit() {
        return null;
    }

    /**
     * (experimental) The limit of how many bytes that a message can contain before Amazon SQS rejects it.
     * <p>
     * You can specify an integer value from 1024 bytes (1 KiB) to 262144 bytes
     * (256 KiB). The default value is 262144 (256 KiB).
     * <p>
     * Default: 256KiB
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxMessageSizeBytes() {
        return null;
    }

    /**
     * (experimental) A name for the queue.
     * <p>
     * If specified and this is a FIFO queue, must end in the string '.fifo'.
     * <p>
     * Default: CloudFormation-generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getQueueName() {
        return null;
    }

    /**
     * (experimental) Default wait time for ReceiveMessage calls.
     * <p>
     * Does not wait if set to 0, otherwise waits this amount of seconds
     * by default for messages to arrive.
     * <p>
     * For more information, see Amazon SQS Long Poll.
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getReceiveMessageWaitTime() {
        return null;
    }

    /**
     * (experimental) Policy to apply when the queue is removed from the stack.
     * <p>
     * Even though queues are technically stateful, their contents are transient and it
     * is common to add and remove Queues while rearchitecting your application. The
     * default is therefore <code>DESTROY</code>. Change it to <code>RETAIN</code> if the messages are so
     * valuable that accidentally losing them would be unacceptable.
     * <p>
     * Default: RemovalPolicy.DESTROY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * (experimental) The number of seconds that Amazon SQS retains a message.
     * <p>
     * You can specify an integer value from 60 seconds (1 minute) to 1209600
     * seconds (14 days). The default value is 345600 seconds (4 days).
     * <p>
     * Default: Duration.days(4)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getRetentionPeriod() {
        return null;
    }

    /**
     * (experimental) Timeout of processing a single message.
     * <p>
     * After dequeuing, the processor has this much time to handle the message
     * and delete it from the queue before it becomes visible again for dequeueing
     * by another processor.
     * <p>
     * Values must be from 0 to 43200 seconds (12 hours). If you don't specify
     * a value, AWS CloudFormation uses the default value of 30 seconds.
     * <p>
     * Default: Duration.seconds(30)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getVisibilityTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link QueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link QueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<QueueProps> {
        java.lang.Boolean contentBasedDeduplication;
        software.amazon.awscdk.core.Duration dataKeyReuse;
        software.amazon.awscdk.services.sqs.DeadLetterQueue deadLetterQueue;
        software.amazon.awscdk.services.sqs.DeduplicationScope deduplicationScope;
        software.amazon.awscdk.core.Duration deliveryDelay;
        software.amazon.awscdk.services.sqs.QueueEncryption encryption;
        software.amazon.awscdk.services.kms.IKey encryptionMasterKey;
        java.lang.Boolean fifo;
        software.amazon.awscdk.services.sqs.FifoThroughputLimit fifoThroughputLimit;
        java.lang.Number maxMessageSizeBytes;
        java.lang.String queueName;
        software.amazon.awscdk.core.Duration receiveMessageWaitTime;
        software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        software.amazon.awscdk.core.Duration retentionPeriod;
        software.amazon.awscdk.core.Duration visibilityTimeout;

        /**
         * Sets the value of {@link QueueProps#getContentBasedDeduplication}
         * @param contentBasedDeduplication Specifies whether to enable content-based deduplication.
         *                                  During the deduplication interval (5 minutes), Amazon SQS treats
         *                                  messages that are sent with identical content (excluding attributes) as
         *                                  duplicates and delivers only one copy of the message.
         *                                  <p>
         *                                  If you don't enable content-based deduplication and you want to deduplicate
         *                                  messages, provide an explicit deduplication ID in your SendMessage() call.
         *                                  <p>
         *                                  (Only applies to FIFO queues.)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder contentBasedDeduplication(java.lang.Boolean contentBasedDeduplication) {
            this.contentBasedDeduplication = contentBasedDeduplication;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getDataKeyReuse}
         * @param dataKeyReuse The length of time that Amazon SQS reuses a data key before calling KMS again.
         *                     The value must be an integer between 60 (1 minute) and 86,400 (24
         *                     hours). The default is 300 (5 minutes).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dataKeyReuse(software.amazon.awscdk.core.Duration dataKeyReuse) {
            this.dataKeyReuse = dataKeyReuse;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getDeadLetterQueue}
         * @param deadLetterQueue Send messages to this queue if they were unsuccessfully dequeued a number of times.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deadLetterQueue(software.amazon.awscdk.services.sqs.DeadLetterQueue deadLetterQueue) {
            this.deadLetterQueue = deadLetterQueue;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getDeduplicationScope}
         * @param deduplicationScope For high throughput for FIFO queues, specifies whether message deduplication occurs at the message group or queue level.
         *                           (Only applies to FIFO queues.)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deduplicationScope(software.amazon.awscdk.services.sqs.DeduplicationScope deduplicationScope) {
            this.deduplicationScope = deduplicationScope;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getDeliveryDelay}
         * @param deliveryDelay The time in seconds that the delivery of all messages in the queue is delayed.
         *                      You can specify an integer value of 0 to 900 (15 minutes). The default
         *                      value is 0.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deliveryDelay(software.amazon.awscdk.core.Duration deliveryDelay) {
            this.deliveryDelay = deliveryDelay;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getEncryption}
         * @param encryption Whether the contents of the queue are encrypted, and by what type of key.
         *                   Be aware that encryption is not available in all regions, please see the docs
         *                   for current availability details.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryption(software.amazon.awscdk.services.sqs.QueueEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getEncryptionMasterKey}
         * @param encryptionMasterKey External KMS master key to use for queue encryption.
         *                            Individual messages will be encrypted using data keys. The data keys in
         *                            turn will be encrypted using this key, and reused for a maximum of
         *                            <code>dataKeyReuseSecs</code> seconds.
         *                            <p>
         *                            If the 'encryptionMasterKey' property is set, 'encryption' type will be
         *                            implicitly set to "KMS".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionMasterKey(software.amazon.awscdk.services.kms.IKey encryptionMasterKey) {
            this.encryptionMasterKey = encryptionMasterKey;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getFifo}
         * @param fifo Whether this a first-in-first-out (FIFO) queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder fifo(java.lang.Boolean fifo) {
            this.fifo = fifo;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getFifoThroughputLimit}
         * @param fifoThroughputLimit For high throughput for FIFO queues, specifies whether the FIFO queue throughput quota applies to the entire queue or per message group.
         *                            (Only applies to FIFO queues.)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder fifoThroughputLimit(software.amazon.awscdk.services.sqs.FifoThroughputLimit fifoThroughputLimit) {
            this.fifoThroughputLimit = fifoThroughputLimit;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getMaxMessageSizeBytes}
         * @param maxMessageSizeBytes The limit of how many bytes that a message can contain before Amazon SQS rejects it.
         *                            You can specify an integer value from 1024 bytes (1 KiB) to 262144 bytes
         *                            (256 KiB). The default value is 262144 (256 KiB).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxMessageSizeBytes(java.lang.Number maxMessageSizeBytes) {
            this.maxMessageSizeBytes = maxMessageSizeBytes;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getQueueName}
         * @param queueName A name for the queue.
         *                  If specified and this is a FIFO queue, must end in the string '.fifo'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder queueName(java.lang.String queueName) {
            this.queueName = queueName;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getReceiveMessageWaitTime}
         * @param receiveMessageWaitTime Default wait time for ReceiveMessage calls.
         *                               Does not wait if set to 0, otherwise waits this amount of seconds
         *                               by default for messages to arrive.
         *                               <p>
         *                               For more information, see Amazon SQS Long Poll.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder receiveMessageWaitTime(software.amazon.awscdk.core.Duration receiveMessageWaitTime) {
            this.receiveMessageWaitTime = receiveMessageWaitTime;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getRemovalPolicy}
         * @param removalPolicy Policy to apply when the queue is removed from the stack.
         *                      Even though queues are technically stateful, their contents are transient and it
         *                      is common to add and remove Queues while rearchitecting your application. The
         *                      default is therefore <code>DESTROY</code>. Change it to <code>RETAIN</code> if the messages are so
         *                      valuable that accidentally losing them would be unacceptable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getRetentionPeriod}
         * @param retentionPeriod The number of seconds that Amazon SQS retains a message.
         *                        You can specify an integer value from 60 seconds (1 minute) to 1209600
         *                        seconds (14 days). The default value is 345600 seconds (4 days).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder retentionPeriod(software.amazon.awscdk.core.Duration retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link QueueProps#getVisibilityTimeout}
         * @param visibilityTimeout Timeout of processing a single message.
         *                          After dequeuing, the processor has this much time to handle the message
         *                          and delete it from the queue before it becomes visible again for dequeueing
         *                          by another processor.
         *                          <p>
         *                          Values must be from 0 to 43200 seconds (12 hours). If you don't specify
         *                          a value, AWS CloudFormation uses the default value of 30 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder visibilityTimeout(software.amazon.awscdk.core.Duration visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link QueueProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public QueueProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link QueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueueProps {
        private final java.lang.Boolean contentBasedDeduplication;
        private final software.amazon.awscdk.core.Duration dataKeyReuse;
        private final software.amazon.awscdk.services.sqs.DeadLetterQueue deadLetterQueue;
        private final software.amazon.awscdk.services.sqs.DeduplicationScope deduplicationScope;
        private final software.amazon.awscdk.core.Duration deliveryDelay;
        private final software.amazon.awscdk.services.sqs.QueueEncryption encryption;
        private final software.amazon.awscdk.services.kms.IKey encryptionMasterKey;
        private final java.lang.Boolean fifo;
        private final software.amazon.awscdk.services.sqs.FifoThroughputLimit fifoThroughputLimit;
        private final java.lang.Number maxMessageSizeBytes;
        private final java.lang.String queueName;
        private final software.amazon.awscdk.core.Duration receiveMessageWaitTime;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final software.amazon.awscdk.core.Duration retentionPeriod;
        private final software.amazon.awscdk.core.Duration visibilityTimeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.contentBasedDeduplication = software.amazon.jsii.Kernel.get(this, "contentBasedDeduplication", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.dataKeyReuse = software.amazon.jsii.Kernel.get(this, "dataKeyReuse", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.deadLetterQueue = software.amazon.jsii.Kernel.get(this, "deadLetterQueue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.DeadLetterQueue.class));
            this.deduplicationScope = software.amazon.jsii.Kernel.get(this, "deduplicationScope", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.DeduplicationScope.class));
            this.deliveryDelay = software.amazon.jsii.Kernel.get(this, "deliveryDelay", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.QueueEncryption.class));
            this.encryptionMasterKey = software.amazon.jsii.Kernel.get(this, "encryptionMasterKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.fifo = software.amazon.jsii.Kernel.get(this, "fifo", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.fifoThroughputLimit = software.amazon.jsii.Kernel.get(this, "fifoThroughputLimit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.FifoThroughputLimit.class));
            this.maxMessageSizeBytes = software.amazon.jsii.Kernel.get(this, "maxMessageSizeBytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.queueName = software.amazon.jsii.Kernel.get(this, "queueName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.receiveMessageWaitTime = software.amazon.jsii.Kernel.get(this, "receiveMessageWaitTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.RemovalPolicy.class));
            this.retentionPeriod = software.amazon.jsii.Kernel.get(this, "retentionPeriod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.visibilityTimeout = software.amazon.jsii.Kernel.get(this, "visibilityTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.contentBasedDeduplication = builder.contentBasedDeduplication;
            this.dataKeyReuse = builder.dataKeyReuse;
            this.deadLetterQueue = builder.deadLetterQueue;
            this.deduplicationScope = builder.deduplicationScope;
            this.deliveryDelay = builder.deliveryDelay;
            this.encryption = builder.encryption;
            this.encryptionMasterKey = builder.encryptionMasterKey;
            this.fifo = builder.fifo;
            this.fifoThroughputLimit = builder.fifoThroughputLimit;
            this.maxMessageSizeBytes = builder.maxMessageSizeBytes;
            this.queueName = builder.queueName;
            this.receiveMessageWaitTime = builder.receiveMessageWaitTime;
            this.removalPolicy = builder.removalPolicy;
            this.retentionPeriod = builder.retentionPeriod;
            this.visibilityTimeout = builder.visibilityTimeout;
        }

        @Override
        public final java.lang.Boolean getContentBasedDeduplication() {
            return this.contentBasedDeduplication;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getDataKeyReuse() {
            return this.dataKeyReuse;
        }

        @Override
        public final software.amazon.awscdk.services.sqs.DeadLetterQueue getDeadLetterQueue() {
            return this.deadLetterQueue;
        }

        @Override
        public final software.amazon.awscdk.services.sqs.DeduplicationScope getDeduplicationScope() {
            return this.deduplicationScope;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getDeliveryDelay() {
            return this.deliveryDelay;
        }

        @Override
        public final software.amazon.awscdk.services.sqs.QueueEncryption getEncryption() {
            return this.encryption;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionMasterKey() {
            return this.encryptionMasterKey;
        }

        @Override
        public final java.lang.Boolean getFifo() {
            return this.fifo;
        }

        @Override
        public final software.amazon.awscdk.services.sqs.FifoThroughputLimit getFifoThroughputLimit() {
            return this.fifoThroughputLimit;
        }

        @Override
        public final java.lang.Number getMaxMessageSizeBytes() {
            return this.maxMessageSizeBytes;
        }

        @Override
        public final java.lang.String getQueueName() {
            return this.queueName;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getReceiveMessageWaitTime() {
            return this.receiveMessageWaitTime;
        }

        @Override
        public final software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getRetentionPeriod() {
            return this.retentionPeriod;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getVisibilityTimeout() {
            return this.visibilityTimeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getContentBasedDeduplication() != null) {
                data.set("contentBasedDeduplication", om.valueToTree(this.getContentBasedDeduplication()));
            }
            if (this.getDataKeyReuse() != null) {
                data.set("dataKeyReuse", om.valueToTree(this.getDataKeyReuse()));
            }
            if (this.getDeadLetterQueue() != null) {
                data.set("deadLetterQueue", om.valueToTree(this.getDeadLetterQueue()));
            }
            if (this.getDeduplicationScope() != null) {
                data.set("deduplicationScope", om.valueToTree(this.getDeduplicationScope()));
            }
            if (this.getDeliveryDelay() != null) {
                data.set("deliveryDelay", om.valueToTree(this.getDeliveryDelay()));
            }
            if (this.getEncryption() != null) {
                data.set("encryption", om.valueToTree(this.getEncryption()));
            }
            if (this.getEncryptionMasterKey() != null) {
                data.set("encryptionMasterKey", om.valueToTree(this.getEncryptionMasterKey()));
            }
            if (this.getFifo() != null) {
                data.set("fifo", om.valueToTree(this.getFifo()));
            }
            if (this.getFifoThroughputLimit() != null) {
                data.set("fifoThroughputLimit", om.valueToTree(this.getFifoThroughputLimit()));
            }
            if (this.getMaxMessageSizeBytes() != null) {
                data.set("maxMessageSizeBytes", om.valueToTree(this.getMaxMessageSizeBytes()));
            }
            if (this.getQueueName() != null) {
                data.set("queueName", om.valueToTree(this.getQueueName()));
            }
            if (this.getReceiveMessageWaitTime() != null) {
                data.set("receiveMessageWaitTime", om.valueToTree(this.getReceiveMessageWaitTime()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getRetentionPeriod() != null) {
                data.set("retentionPeriod", om.valueToTree(this.getRetentionPeriod()));
            }
            if (this.getVisibilityTimeout() != null) {
                data.set("visibilityTimeout", om.valueToTree(this.getVisibilityTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_sqs.QueueProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            QueueProps.Jsii$Proxy that = (QueueProps.Jsii$Proxy) o;

            if (this.contentBasedDeduplication != null ? !this.contentBasedDeduplication.equals(that.contentBasedDeduplication) : that.contentBasedDeduplication != null) return false;
            if (this.dataKeyReuse != null ? !this.dataKeyReuse.equals(that.dataKeyReuse) : that.dataKeyReuse != null) return false;
            if (this.deadLetterQueue != null ? !this.deadLetterQueue.equals(that.deadLetterQueue) : that.deadLetterQueue != null) return false;
            if (this.deduplicationScope != null ? !this.deduplicationScope.equals(that.deduplicationScope) : that.deduplicationScope != null) return false;
            if (this.deliveryDelay != null ? !this.deliveryDelay.equals(that.deliveryDelay) : that.deliveryDelay != null) return false;
            if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
            if (this.encryptionMasterKey != null ? !this.encryptionMasterKey.equals(that.encryptionMasterKey) : that.encryptionMasterKey != null) return false;
            if (this.fifo != null ? !this.fifo.equals(that.fifo) : that.fifo != null) return false;
            if (this.fifoThroughputLimit != null ? !this.fifoThroughputLimit.equals(that.fifoThroughputLimit) : that.fifoThroughputLimit != null) return false;
            if (this.maxMessageSizeBytes != null ? !this.maxMessageSizeBytes.equals(that.maxMessageSizeBytes) : that.maxMessageSizeBytes != null) return false;
            if (this.queueName != null ? !this.queueName.equals(that.queueName) : that.queueName != null) return false;
            if (this.receiveMessageWaitTime != null ? !this.receiveMessageWaitTime.equals(that.receiveMessageWaitTime) : that.receiveMessageWaitTime != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.retentionPeriod != null ? !this.retentionPeriod.equals(that.retentionPeriod) : that.retentionPeriod != null) return false;
            return this.visibilityTimeout != null ? this.visibilityTimeout.equals(that.visibilityTimeout) : that.visibilityTimeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.contentBasedDeduplication != null ? this.contentBasedDeduplication.hashCode() : 0;
            result = 31 * result + (this.dataKeyReuse != null ? this.dataKeyReuse.hashCode() : 0);
            result = 31 * result + (this.deadLetterQueue != null ? this.deadLetterQueue.hashCode() : 0);
            result = 31 * result + (this.deduplicationScope != null ? this.deduplicationScope.hashCode() : 0);
            result = 31 * result + (this.deliveryDelay != null ? this.deliveryDelay.hashCode() : 0);
            result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
            result = 31 * result + (this.encryptionMasterKey != null ? this.encryptionMasterKey.hashCode() : 0);
            result = 31 * result + (this.fifo != null ? this.fifo.hashCode() : 0);
            result = 31 * result + (this.fifoThroughputLimit != null ? this.fifoThroughputLimit.hashCode() : 0);
            result = 31 * result + (this.maxMessageSizeBytes != null ? this.maxMessageSizeBytes.hashCode() : 0);
            result = 31 * result + (this.queueName != null ? this.queueName.hashCode() : 0);
            result = 31 * result + (this.receiveMessageWaitTime != null ? this.receiveMessageWaitTime.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.retentionPeriod != null ? this.retentionPeriod.hashCode() : 0);
            result = 31 * result + (this.visibilityTimeout != null ? this.visibilityTimeout.hashCode() : 0);
            return result;
        }
    }
}
