package software.amazon.awscdk.services.stepfunctions;

/**
 * (experimental) Defines which category of execution history events are logged.
 * <p>
 * Default: ERROR
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * LogGroup logGroup = new LogGroup(this, "MyLogGroup");
 * StateMachine.Builder.create(this, "MyStateMachine")
 *         .definition(Chain.start(new Pass(this, "Pass")))
 *         .logs(LogOptions.builder()
 *                 .destination(logGroup)
 *                 .level(LogLevel.ALL)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html">https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:10.655Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions.LogLevel")
public enum LogLevel {
    /**
     * (experimental) No Logging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    OFF,
    /**
     * (experimental) Log everything.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ALL,
    /**
     * (experimental) Log all errors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ERROR,
    /**
     * (experimental) Log fatal errors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    FATAL,
}
