package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * (experimental) The size of the Elastic Inference (EI) instance to use for the production variant.
 * <p>
 * EI instances provide on-demand GPU computing for inference
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.tasks.*;
 * AcceleratorType acceleratorType = new AcceleratorType("instanceTypeIdentifier");
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:10.775Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.AcceleratorType")
public class AcceleratorType extends software.amazon.jsii.JsiiObject {

    protected AcceleratorType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AcceleratorType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param instanceTypeIdentifier This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public AcceleratorType(final @org.jetbrains.annotations.NotNull java.lang.String instanceTypeIdentifier) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(instanceTypeIdentifier, "instanceTypeIdentifier is required") });
    }

    /**
     * (experimental) AcceleratorType.
     * <p>
     * This class takes a combination of a class and size.
     * <p>
     * @param acceleratorClass This parameter is required.
     * @param instanceSize This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorType of(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorClass acceleratorClass, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceSize instanceSize) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorType.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorType.class), new Object[] { java.util.Objects.requireNonNull(acceleratorClass, "acceleratorClass is required"), java.util.Objects.requireNonNull(instanceSize, "instanceSize is required") });
    }

    /**
     * (experimental) Return the accelerator type as a dotted string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
