package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * (experimental) A Step Functions Task to create an EMR Cluster.
 * <p>
 * The ClusterConfiguration is defined as Parameters in the state machine definition.
 * <p>
 * OUTPUT: the ClusterId.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Role clusterRole = Role.Builder.create(this, "ClusterRole")
 *         .assumedBy(new ServicePrincipal("ec2.amazonaws.com"))
 *         .build();
 * Role serviceRole = Role.Builder.create(this, "ServiceRole")
 *         .assumedBy(new ServicePrincipal("elasticmapreduce.amazonaws.com"))
 *         .build();
 * Role autoScalingRole = Role.Builder.create(this, "AutoScalingRole")
 *         .assumedBy(new ServicePrincipal("elasticmapreduce.amazonaws.com"))
 *         .build();
 * autoScalingRole.assumeRolePolicy.addStatements(
 * PolicyStatement.Builder.create()
 *         .effect(Effect.ALLOW)
 *         .principals(List.of(
 *             new ServicePrincipal("application-autoscaling.amazonaws.com")))
 *         .actions(List.of("sts:AssumeRole"))
 *         .build());
 * EmrCreateCluster.Builder.create(this, "Create Cluster")
 *         .instances(InstancesConfigProperty.builder().build())
 *         .clusterRole(clusterRole)
 *         .name(TaskInput.fromJsonPathAt("$.ClusterName").getValue())
 *         .serviceRole(serviceRole)
 *         .autoScalingRole(autoScalingRole)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:10.903Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster")
public class EmrCreateCluster extends software.amazon.awscdk.services.stepfunctions.TaskStateBase {

    protected EmrCreateCluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EmrCreateCluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public EmrCreateCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) The autoscaling role for the EMR Cluster.
     * <p>
     * Only available after task has been added to a state machine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getAutoScalingRole() {
        return software.amazon.jsii.Kernel.get(this, "autoScalingRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * (experimental) The instance role for the EMR Cluster.
     * <p>
     * Only available after task has been added to a state machine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getClusterRole() {
        return software.amazon.jsii.Kernel.get(this, "clusterRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * (experimental) The service role for the EMR Cluster.
     * <p>
     * Only available after task has been added to a state machine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getServiceRole() {
        return software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig getTaskMetrics() {
        return software.amazon.jsii.Kernel.get(this, "taskMetrics", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getTaskPolicies() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)(software.amazon.jsii.Kernel.get(this, "taskPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }
    /**
     * (experimental) Properties for the EMR Cluster Applications.
     * <p>
     * Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of applications for Amazon EMR to install and configure when launching
     * the cluster.
     * <p>
     * See the RunJobFlow API for complete documentation on input parameters
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * ApplicationConfigProperty applicationConfigProperty = ApplicationConfigProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .additionalInfo(Map.of(
     *                 "additionalInfoKey", "additionalInfo"))
     *         .args(List.of("args"))
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_Application.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_Application.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.ApplicationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ApplicationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface ApplicationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (experimental) The name of the application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * (experimental) This option is for advanced users only.
         * <p>
         * This is meta information about third-party applications that third-party vendors use
         * for testing purposes.
         * <p>
         * Default: No additionalInfo
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getAdditionalInfo() {
            return null;
        }

        /**
         * (experimental) Arguments for Amazon EMR to pass to the application.
         * <p>
         * Default: No args
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArgs() {
            return null;
        }

        /**
         * (experimental) The version of the application.
         * <p>
         * Default: No version
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ApplicationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApplicationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<ApplicationConfigProperty> {
            java.lang.String name;
            java.util.Map<java.lang.String, java.lang.String> additionalInfo;
            java.util.List<java.lang.String> args;
            java.lang.String version;

            /**
             * Sets the value of {@link ApplicationConfigProperty#getName}
             * @param name The name of the application. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationConfigProperty#getAdditionalInfo}
             * @param additionalInfo This option is for advanced users only.
             *                       This is meta information about third-party applications that third-party vendors use
             *                       for testing purposes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder additionalInfo(java.util.Map<java.lang.String, java.lang.String> additionalInfo) {
                this.additionalInfo = additionalInfo;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationConfigProperty#getArgs}
             * @param args Arguments for Amazon EMR to pass to the application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder args(java.util.List<java.lang.String> args) {
                this.args = args;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationConfigProperty#getVersion}
             * @param version The version of the application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public ApplicationConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApplicationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationConfigProperty {
            private final java.lang.String name;
            private final java.util.Map<java.lang.String, java.lang.String> additionalInfo;
            private final java.util.List<java.lang.String> args;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.additionalInfo = software.amazon.jsii.Kernel.get(this, "additionalInfo", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.args = software.amazon.jsii.Kernel.get(this, "args", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.additionalInfo = builder.additionalInfo;
                this.args = builder.args;
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.util.Map<java.lang.String, java.lang.String> getAdditionalInfo() {
                return this.additionalInfo;
            }

            @Override
            public final java.util.List<java.lang.String> getArgs() {
                return this.args;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getAdditionalInfo() != null) {
                    data.set("additionalInfo", om.valueToTree(this.getAdditionalInfo()));
                }
                if (this.getArgs() != null) {
                    data.set("args", om.valueToTree(this.getArgs()));
                }
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.EmrCreateCluster.ApplicationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApplicationConfigProperty.Jsii$Proxy that = (ApplicationConfigProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.additionalInfo != null ? !this.additionalInfo.equals(that.additionalInfo) : that.additionalInfo != null) return false;
                if (this.args != null ? !this.args.equals(that.args) : that.args != null) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.additionalInfo != null ? this.additionalInfo.hashCode() : 0);
                result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * (experimental) An automatic scaling policy for a core instance group or task instance group in an Amazon EMR cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.core.*;
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * Duration duration;
     * AutoScalingPolicyProperty autoScalingPolicyProperty = AutoScalingPolicyProperty.builder()
     *         .constraints(ScalingConstraintsProperty.builder()
     *                 .maxCapacity(123)
     *                 .minCapacity(123)
     *                 .build())
     *         .rules(List.of(ScalingRuleProperty.builder()
     *                 .action(ScalingActionProperty.builder()
     *                         .simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty.builder()
     *                                 .scalingAdjustment(123)
     *                                 // the properties below are optional
     *                                 .adjustmentType(EmrCreateCluster.getScalingAdjustmentType().CHANGE_IN_CAPACITY)
     *                                 .coolDown(123)
     *                                 .build())
     *                         // the properties below are optional
     *                         .market(EmrCreateCluster.getInstanceMarket().ON_DEMAND)
     *                         .build())
     *                 .name("name")
     *                 .trigger(ScalingTriggerProperty.builder()
     *                         .cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty.builder()
     *                                 .comparisonOperator(EmrCreateCluster.getCloudWatchAlarmComparisonOperator().GREATER_THAN_OR_EQUAL)
     *                                 .metricName("metricName")
     *                                 .period(duration)
     *                                 // the properties below are optional
     *                                 .dimensions(List.of(MetricDimensionProperty.builder()
     *                                         .key("key")
     *                                         .value("value")
     *                                         .build()))
     *                                 .evaluationPeriods(123)
     *                                 .namespace("namespace")
     *                                 .statistic(EmrCreateCluster.getCloudWatchAlarmStatistic().SAMPLE_COUNT)
     *                                 .threshold(123)
     *                                 .unit(EmrCreateCluster.getCloudWatchAlarmUnit().NONE)
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .description("description")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_AutoScalingPolicy.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_AutoScalingPolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.AutoScalingPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoScalingPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface AutoScalingPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (experimental) The upper and lower EC2 instance limits for an automatic scaling policy.
         * <p>
         * Automatic scaling activity will not cause an instance
         * group to grow above or below these limits.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingConstraintsProperty getConstraints();

        /**
         * (experimental) The scale-in and scale-out rules that comprise the automatic scaling policy.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingRuleProperty> getRules();

        /**
         * @return a {@link Builder} of {@link AutoScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<AutoScalingPolicyProperty> {
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingConstraintsProperty constraints;
            java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingRuleProperty> rules;

            /**
             * Sets the value of {@link AutoScalingPolicyProperty#getConstraints}
             * @param constraints The upper and lower EC2 instance limits for an automatic scaling policy. This parameter is required.
             *                    Automatic scaling activity will not cause an instance
             *                    group to grow above or below these limits.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder constraints(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingConstraintsProperty constraints) {
                this.constraints = constraints;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingPolicyProperty#getRules}
             * @param rules The scale-in and scale-out rules that comprise the automatic scaling policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @SuppressWarnings("unchecked")
            public Builder rules(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingRuleProperty> rules) {
                this.rules = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingRuleProperty>)rules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoScalingPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public AutoScalingPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoScalingPolicyProperty {
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingConstraintsProperty constraints;
            private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingRuleProperty> rules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.constraints = software.amazon.jsii.Kernel.get(this, "constraints", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingConstraintsProperty.class));
                this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingRuleProperty.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.constraints = java.util.Objects.requireNonNull(builder.constraints, "constraints is required");
                this.rules = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingRuleProperty>)java.util.Objects.requireNonNull(builder.rules, "rules is required");
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingConstraintsProperty getConstraints() {
                return this.constraints;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingRuleProperty> getRules() {
                return this.rules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("constraints", om.valueToTree(this.getConstraints()));
                data.set("rules", om.valueToTree(this.getRules()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.EmrCreateCluster.AutoScalingPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoScalingPolicyProperty.Jsii$Proxy that = (AutoScalingPolicyProperty.Jsii$Proxy) o;

                if (!constraints.equals(that.constraints)) return false;
                return this.rules.equals(that.rules);
            }

            @Override
            public final int hashCode() {
                int result = this.constraints.hashCode();
                result = 31 * result + (this.rules.hashCode());
                return result;
            }
        }
    }
    /**
     * (experimental) Configuration of a bootstrap action.
     * <p>
     * See the RunJobFlow API for complete documentation on input parameters
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * BootstrapActionConfigProperty bootstrapActionConfigProperty = BootstrapActionConfigProperty.builder()
     *         .name("name")
     *         .scriptBootstrapAction(ScriptBootstrapActionConfigProperty.builder()
     *                 .path("path")
     *                 // the properties below are optional
     *                 .args(List.of("args"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_BootstrapActionConfig.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_BootstrapActionConfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.BootstrapActionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(BootstrapActionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface BootstrapActionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (experimental) The name of the bootstrap action.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * (experimental) The script run by the bootstrap action.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScriptBootstrapActionConfigProperty getScriptBootstrapAction();

        /**
         * @return a {@link Builder} of {@link BootstrapActionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BootstrapActionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<BootstrapActionConfigProperty> {
            java.lang.String name;
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScriptBootstrapActionConfigProperty scriptBootstrapAction;

            /**
             * Sets the value of {@link BootstrapActionConfigProperty#getName}
             * @param name The name of the bootstrap action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link BootstrapActionConfigProperty#getScriptBootstrapAction}
             * @param scriptBootstrapAction The script run by the bootstrap action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder scriptBootstrapAction(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScriptBootstrapActionConfigProperty scriptBootstrapAction) {
                this.scriptBootstrapAction = scriptBootstrapAction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BootstrapActionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public BootstrapActionConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BootstrapActionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BootstrapActionConfigProperty {
            private final java.lang.String name;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScriptBootstrapActionConfigProperty scriptBootstrapAction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scriptBootstrapAction = software.amazon.jsii.Kernel.get(this, "scriptBootstrapAction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScriptBootstrapActionConfigProperty.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.scriptBootstrapAction = java.util.Objects.requireNonNull(builder.scriptBootstrapAction, "scriptBootstrapAction is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScriptBootstrapActionConfigProperty getScriptBootstrapAction() {
                return this.scriptBootstrapAction;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("scriptBootstrapAction", om.valueToTree(this.getScriptBootstrapAction()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.EmrCreateCluster.BootstrapActionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BootstrapActionConfigProperty.Jsii$Proxy that = (BootstrapActionConfigProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.scriptBootstrapAction.equals(that.scriptBootstrapAction);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.scriptBootstrapAction.hashCode());
                return result;
            }
        }
    }
    /**
     * (experimental) CloudWatch Alarm Comparison Operators.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.CloudWatchAlarmComparisonOperator")
    public enum CloudWatchAlarmComparisonOperator {
        /**
         * (experimental) GREATER_THAN_OR_EQUAL.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        GREATER_THAN_OR_EQUAL,
        /**
         * (experimental) GREATER_THAN.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        GREATER_THAN,
        /**
         * (experimental) LESS_THAN.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        LESS_THAN,
        /**
         * (experimental) LESS_THAN_OR_EQUAL.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        LESS_THAN_OR_EQUAL,
    }
    /**
     * (experimental) The definition of a CloudWatch metric alarm, which determines when an automatic scaling activity is triggered.
     * <p>
     * When the defined alarm conditions
     * are satisfied, scaling activity begins.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.core.*;
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * Duration duration;
     * CloudWatchAlarmDefinitionProperty cloudWatchAlarmDefinitionProperty = CloudWatchAlarmDefinitionProperty.builder()
     *         .comparisonOperator(EmrCreateCluster.getCloudWatchAlarmComparisonOperator().GREATER_THAN_OR_EQUAL)
     *         .metricName("metricName")
     *         .period(duration)
     *         // the properties below are optional
     *         .dimensions(List.of(MetricDimensionProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .evaluationPeriods(123)
     *         .namespace("namespace")
     *         .statistic(EmrCreateCluster.getCloudWatchAlarmStatistic().SAMPLE_COUNT)
     *         .threshold(123)
     *         .unit(EmrCreateCluster.getCloudWatchAlarmUnit().NONE)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_CloudWatchAlarmDefinition.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_CloudWatchAlarmDefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.CloudWatchAlarmDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchAlarmDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface CloudWatchAlarmDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (experimental) Determines how the metric specified by MetricName is compared to the value specified by Threshold.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmComparisonOperator getComparisonOperator();

        /**
         * (experimental) The name of the CloudWatch metric that is watched to determine an alarm condition.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

        /**
         * (experimental) The period, in seconds, over which the statistic is applied.
         * <p>
         * EMR CloudWatch metrics are emitted every five minutes (300 seconds), so if
         * an EMR CloudWatch metric is specified, specify 300.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration getPeriod();

        /**
         * (experimental) A CloudWatch metric dimension.
         * <p>
         * Default: - No dimensions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.MetricDimensionProperty> getDimensions() {
            return null;
        }

        /**
         * (experimental) The number of periods, in five-minute increments, during which the alarm condition must exist before the alarm triggers automatic scaling activity.
         * <p>
         * Default: 1
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEvaluationPeriods() {
            return null;
        }

        /**
         * (experimental) The namespace for the CloudWatch metric.
         * <p>
         * Default: 'AWS/ElasticMapReduce'
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
            return null;
        }

        /**
         * (experimental) The statistic to apply to the metric associated with the alarm.
         * <p>
         * Default: CloudWatchAlarmStatistic.AVERAGE
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmStatistic getStatistic() {
            return null;
        }

        /**
         * (experimental) The value against which the specified statistic is compared.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThreshold() {
            return null;
        }

        /**
         * (experimental) The unit of measure associated with the CloudWatch metric being watched.
         * <p>
         * The value specified for Unit must correspond to the units
         * specified in the CloudWatch metric.
         * <p>
         * Default: CloudWatchAlarmUnit.NONE
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmUnit getUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudWatchAlarmDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchAlarmDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchAlarmDefinitionProperty> {
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmComparisonOperator comparisonOperator;
            java.lang.String metricName;
            software.amazon.awscdk.core.Duration period;
            java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.MetricDimensionProperty> dimensions;
            java.lang.Number evaluationPeriods;
            java.lang.String namespace;
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmStatistic statistic;
            java.lang.Number threshold;
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmUnit unit;

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getComparisonOperator}
             * @param comparisonOperator Determines how the metric specified by MetricName is compared to the value specified by Threshold. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder comparisonOperator(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmComparisonOperator comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getMetricName}
             * @param metricName The name of the CloudWatch metric that is watched to determine an alarm condition. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getPeriod}
             * @param period The period, in seconds, over which the statistic is applied. This parameter is required.
             *               EMR CloudWatch metrics are emitted every five minutes (300 seconds), so if
             *               an EMR CloudWatch metric is specified, specify 300.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder period(software.amazon.awscdk.core.Duration period) {
                this.period = period;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getDimensions}
             * @param dimensions A CloudWatch metric dimension.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @SuppressWarnings("unchecked")
            public Builder dimensions(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.MetricDimensionProperty> dimensions) {
                this.dimensions = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.MetricDimensionProperty>)dimensions;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getEvaluationPeriods}
             * @param evaluationPeriods The number of periods, in five-minute increments, during which the alarm condition must exist before the alarm triggers automatic scaling activity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder evaluationPeriods(java.lang.Number evaluationPeriods) {
                this.evaluationPeriods = evaluationPeriods;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getNamespace}
             * @param namespace The namespace for the CloudWatch metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getStatistic}
             * @param statistic The statistic to apply to the metric associated with the alarm.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder statistic(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmStatistic statistic) {
                this.statistic = statistic;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getThreshold}
             * @param threshold The value against which the specified statistic is compared.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder threshold(java.lang.Number threshold) {
                this.threshold = threshold;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getUnit}
             * @param unit The unit of measure associated with the CloudWatch metric being watched.
             *             The value specified for Unit must correspond to the units
             *             specified in the CloudWatch metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder unit(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmUnit unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchAlarmDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public CloudWatchAlarmDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchAlarmDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchAlarmDefinitionProperty {
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmComparisonOperator comparisonOperator;
            private final java.lang.String metricName;
            private final software.amazon.awscdk.core.Duration period;
            private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.MetricDimensionProperty> dimensions;
            private final java.lang.Number evaluationPeriods;
            private final java.lang.String namespace;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmStatistic statistic;
            private final java.lang.Number threshold;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmUnit unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comparisonOperator = software.amazon.jsii.Kernel.get(this, "comparisonOperator", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmComparisonOperator.class));
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
                this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.MetricDimensionProperty.class)));
                this.evaluationPeriods = software.amazon.jsii.Kernel.get(this, "evaluationPeriods", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmStatistic.class));
                this.threshold = software.amazon.jsii.Kernel.get(this, "threshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmUnit.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comparisonOperator = java.util.Objects.requireNonNull(builder.comparisonOperator, "comparisonOperator is required");
                this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
                this.period = java.util.Objects.requireNonNull(builder.period, "period is required");
                this.dimensions = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.MetricDimensionProperty>)builder.dimensions;
                this.evaluationPeriods = builder.evaluationPeriods;
                this.namespace = builder.namespace;
                this.statistic = builder.statistic;
                this.threshold = builder.threshold;
                this.unit = builder.unit;
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmComparisonOperator getComparisonOperator() {
                return this.comparisonOperator;
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final software.amazon.awscdk.core.Duration getPeriod() {
                return this.period;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.MetricDimensionProperty> getDimensions() {
                return this.dimensions;
            }

            @Override
            public final java.lang.Number getEvaluationPeriods() {
                return this.evaluationPeriods;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmStatistic getStatistic() {
                return this.statistic;
            }

            @Override
            public final java.lang.Number getThreshold() {
                return this.threshold;
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmUnit getUnit() {
                return this.unit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("comparisonOperator", om.valueToTree(this.getComparisonOperator()));
                data.set("metricName", om.valueToTree(this.getMetricName()));
                data.set("period", om.valueToTree(this.getPeriod()));
                if (this.getDimensions() != null) {
                    data.set("dimensions", om.valueToTree(this.getDimensions()));
                }
                if (this.getEvaluationPeriods() != null) {
                    data.set("evaluationPeriods", om.valueToTree(this.getEvaluationPeriods()));
                }
                if (this.getNamespace() != null) {
                    data.set("namespace", om.valueToTree(this.getNamespace()));
                }
                if (this.getStatistic() != null) {
                    data.set("statistic", om.valueToTree(this.getStatistic()));
                }
                if (this.getThreshold() != null) {
                    data.set("threshold", om.valueToTree(this.getThreshold()));
                }
                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.EmrCreateCluster.CloudWatchAlarmDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchAlarmDefinitionProperty.Jsii$Proxy that = (CloudWatchAlarmDefinitionProperty.Jsii$Proxy) o;

                if (!comparisonOperator.equals(that.comparisonOperator)) return false;
                if (!metricName.equals(that.metricName)) return false;
                if (!period.equals(that.period)) return false;
                if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
                if (this.evaluationPeriods != null ? !this.evaluationPeriods.equals(that.evaluationPeriods) : that.evaluationPeriods != null) return false;
                if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) return false;
                if (this.statistic != null ? !this.statistic.equals(that.statistic) : that.statistic != null) return false;
                if (this.threshold != null ? !this.threshold.equals(that.threshold) : that.threshold != null) return false;
                return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.comparisonOperator.hashCode();
                result = 31 * result + (this.metricName.hashCode());
                result = 31 * result + (this.period.hashCode());
                result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
                result = 31 * result + (this.evaluationPeriods != null ? this.evaluationPeriods.hashCode() : 0);
                result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
                result = 31 * result + (this.statistic != null ? this.statistic.hashCode() : 0);
                result = 31 * result + (this.threshold != null ? this.threshold.hashCode() : 0);
                result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * (experimental) CloudWatch Alarm Statistics.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.CloudWatchAlarmStatistic")
    public enum CloudWatchAlarmStatistic {
        /**
         * (experimental) SAMPLE_COUNT.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        SAMPLE_COUNT,
        /**
         * (experimental) AVERAGE.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        AVERAGE,
        /**
         * (experimental) SUM.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        SUM,
        /**
         * (experimental) MINIMUM.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        MINIMUM,
        /**
         * (experimental) MAXIMUM.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        MAXIMUM,
    }
    /**
     * (experimental) CloudWatch Alarm Units.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.CloudWatchAlarmUnit")
    public enum CloudWatchAlarmUnit {
        /**
         * (experimental) NONE.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        NONE,
        /**
         * (experimental) SECONDS.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        SECONDS,
        /**
         * (experimental) MICRO_SECONDS.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        MICRO_SECONDS,
        /**
         * (experimental) MILLI_SECONDS.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        MILLI_SECONDS,
        /**
         * (experimental) BYTES.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        BYTES,
        /**
         * (experimental) KILO_BYTES.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        KILO_BYTES,
        /**
         * (experimental) MEGA_BYTES.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        MEGA_BYTES,
        /**
         * (experimental) GIGA_BYTES.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        GIGA_BYTES,
        /**
         * (experimental) TERA_BYTES.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        TERA_BYTES,
        /**
         * (experimental) BITS.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        BITS,
        /**
         * (experimental) KILO_BITS.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        KILO_BITS,
        /**
         * (experimental) MEGA_BITS.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        MEGA_BITS,
        /**
         * (experimental) GIGA_BITS.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        GIGA_BITS,
        /**
         * (experimental) TERA_BITS.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        TERA_BITS,
        /**
         * (experimental) PERCENT.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        PERCENT,
        /**
         * (experimental) COUNT.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        COUNT,
        /**
         * (experimental) BYTES_PER_SECOND.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        BYTES_PER_SECOND,
        /**
         * (experimental) KILO_BYTES_PER_SECOND.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        KILO_BYTES_PER_SECOND,
        /**
         * (experimental) MEGA_BYTES_PER_SECOND.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        MEGA_BYTES_PER_SECOND,
        /**
         * (experimental) GIGA_BYTES_PER_SECOND.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        GIGA_BYTES_PER_SECOND,
        /**
         * (experimental) TERA_BYTES_PER_SECOND.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        TERA_BYTES_PER_SECOND,
        /**
         * (experimental) BITS_PER_SECOND.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        BITS_PER_SECOND,
        /**
         * (experimental) KILO_BITS_PER_SECOND.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        KILO_BITS_PER_SECOND,
        /**
         * (experimental) MEGA_BITS_PER_SECOND.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        MEGA_BITS_PER_SECOND,
        /**
         * (experimental) GIGA_BITS_PER_SECOND.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        GIGA_BITS_PER_SECOND,
        /**
         * (experimental) TERA_BITS_PER_SECOND.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        TERA_BITS_PER_SECOND,
        /**
         * (experimental) COUNT_PER_SECOND.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        COUNT_PER_SECOND,
    }
    /**
     * (experimental) An optional configuration specification to be used when provisioning cluster instances, which can include configurations for applications and software bundled with Amazon EMR.
     * <p>
     * See the RunJobFlow API for complete documentation on input parameters
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * ConfigurationProperty configurationProperty_;
     * ConfigurationProperty configurationProperty = ConfigurationProperty.builder()
     *         .classification("classification")
     *         .configurations(List.of(ConfigurationProperty.builder()
     *                 .classification("classification")
     *                 .configurations(List.of(configurationProperty_))
     *                 .properties(Map.of(
     *                         "propertiesKey", "properties"))
     *                 .build()))
     *         .properties(Map.of(
     *                 "propertiesKey", "properties"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_Configuration.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_Configuration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.ConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface ConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (experimental) The classification within a configuration.
         * <p>
         * Default: No classification
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getClassification() {
            return null;
        }

        /**
         * (experimental) A list of additional configurations to apply within a configuration object.
         * <p>
         * Default: No configurations
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> getConfigurations() {
            return null;
        }

        /**
         * (experimental) A set of properties specified within a configuration classification.
         * <p>
         * Default: No properties
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<ConfigurationProperty> {
            java.lang.String classification;
            java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations;
            java.util.Map<java.lang.String, java.lang.String> properties;

            /**
             * Sets the value of {@link ConfigurationProperty#getClassification}
             * @param classification The classification within a configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder classification(java.lang.String classification) {
                this.classification = classification;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationProperty#getConfigurations}
             * @param configurations A list of additional configurations to apply within a configuration object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @SuppressWarnings("unchecked")
            public Builder configurations(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations) {
                this.configurations = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty>)configurations;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationProperty#getProperties}
             * @param properties A set of properties specified within a configuration classification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder properties(java.util.Map<java.lang.String, java.lang.String> properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public ConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationProperty {
            private final java.lang.String classification;
            private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations;
            private final java.util.Map<java.lang.String, java.lang.String> properties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.classification = software.amazon.jsii.Kernel.get(this, "classification", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.configurations = software.amazon.jsii.Kernel.get(this, "configurations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty.class)));
                this.properties = software.amazon.jsii.Kernel.get(this, "properties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.classification = builder.classification;
                this.configurations = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty>)builder.configurations;
                this.properties = builder.properties;
            }

            @Override
            public final java.lang.String getClassification() {
                return this.classification;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> getConfigurations() {
                return this.configurations;
            }

            @Override
            public final java.util.Map<java.lang.String, java.lang.String> getProperties() {
                return this.properties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClassification() != null) {
                    data.set("classification", om.valueToTree(this.getClassification()));
                }
                if (this.getConfigurations() != null) {
                    data.set("configurations", om.valueToTree(this.getConfigurations()));
                }
                if (this.getProperties() != null) {
                    data.set("properties", om.valueToTree(this.getProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.EmrCreateCluster.ConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfigurationProperty.Jsii$Proxy that = (ConfigurationProperty.Jsii$Proxy) o;

                if (this.classification != null ? !this.classification.equals(that.classification) : that.classification != null) return false;
                if (this.configurations != null ? !this.configurations.equals(that.configurations) : that.configurations != null) return false;
                return this.properties != null ? this.properties.equals(that.properties) : that.properties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.classification != null ? this.classification.hashCode() : 0;
                result = 31 * result + (this.configurations != null ? this.configurations.hashCode() : 0);
                result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * (experimental) Configuration of requested EBS block device associated with the instance group with count of volumes that will be associated to every instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.core.*;
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * Size size;
     * EbsBlockDeviceConfigProperty ebsBlockDeviceConfigProperty = EbsBlockDeviceConfigProperty.builder()
     *         .volumeSpecification(VolumeSpecificationProperty.builder()
     *                 .volumeSize(size)
     *                 .volumeType(EmrCreateCluster.getEbsBlockDeviceVolumeType().GP2)
     *                 // the properties below are optional
     *                 .iops(123)
     *                 .build())
     *         // the properties below are optional
     *         .volumesPerInstance(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_EbsBlockDeviceConfig.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_EbsBlockDeviceConfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.EbsBlockDeviceConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(EbsBlockDeviceConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface EbsBlockDeviceConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (experimental) EBS volume specifications such as volume type, IOPS, and size (GiB) that will be requested for the EBS volume attached to an EC2 instance in the cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.VolumeSpecificationProperty getVolumeSpecification();

        /**
         * (experimental) Number of EBS volumes with a specific volume configuration that will be associated with every instance in the instance group.
         * <p>
         * Default: EMR selected default
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVolumesPerInstance() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EbsBlockDeviceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EbsBlockDeviceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<EbsBlockDeviceConfigProperty> {
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.VolumeSpecificationProperty volumeSpecification;
            java.lang.Number volumesPerInstance;

            /**
             * Sets the value of {@link EbsBlockDeviceConfigProperty#getVolumeSpecification}
             * @param volumeSpecification EBS volume specifications such as volume type, IOPS, and size (GiB) that will be requested for the EBS volume attached to an EC2 instance in the cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder volumeSpecification(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.VolumeSpecificationProperty volumeSpecification) {
                this.volumeSpecification = volumeSpecification;
                return this;
            }

            /**
             * Sets the value of {@link EbsBlockDeviceConfigProperty#getVolumesPerInstance}
             * @param volumesPerInstance Number of EBS volumes with a specific volume configuration that will be associated with every instance in the instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder volumesPerInstance(java.lang.Number volumesPerInstance) {
                this.volumesPerInstance = volumesPerInstance;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsBlockDeviceConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public EbsBlockDeviceConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EbsBlockDeviceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EbsBlockDeviceConfigProperty {
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.VolumeSpecificationProperty volumeSpecification;
            private final java.lang.Number volumesPerInstance;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.volumeSpecification = software.amazon.jsii.Kernel.get(this, "volumeSpecification", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.VolumeSpecificationProperty.class));
                this.volumesPerInstance = software.amazon.jsii.Kernel.get(this, "volumesPerInstance", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.volumeSpecification = java.util.Objects.requireNonNull(builder.volumeSpecification, "volumeSpecification is required");
                this.volumesPerInstance = builder.volumesPerInstance;
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.VolumeSpecificationProperty getVolumeSpecification() {
                return this.volumeSpecification;
            }

            @Override
            public final java.lang.Number getVolumesPerInstance() {
                return this.volumesPerInstance;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("volumeSpecification", om.valueToTree(this.getVolumeSpecification()));
                if (this.getVolumesPerInstance() != null) {
                    data.set("volumesPerInstance", om.valueToTree(this.getVolumesPerInstance()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.EmrCreateCluster.EbsBlockDeviceConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EbsBlockDeviceConfigProperty.Jsii$Proxy that = (EbsBlockDeviceConfigProperty.Jsii$Proxy) o;

                if (!volumeSpecification.equals(that.volumeSpecification)) return false;
                return this.volumesPerInstance != null ? this.volumesPerInstance.equals(that.volumesPerInstance) : that.volumesPerInstance == null;
            }

            @Override
            public final int hashCode() {
                int result = this.volumeSpecification.hashCode();
                result = 31 * result + (this.volumesPerInstance != null ? this.volumesPerInstance.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * (experimental) EBS Volume Types.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.EbsBlockDeviceVolumeType")
    public enum EbsBlockDeviceVolumeType {
        /**
         * (experimental) gp2 Volume Type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        GP2,
        /**
         * (experimental) io1 Volume Type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        IO1,
        /**
         * (experimental) Standard Volume Type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        STANDARD,
    }
    /**
     * (experimental) The Amazon EBS configuration of a cluster instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.core.*;
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * Size size;
     * EbsConfigurationProperty ebsConfigurationProperty = EbsConfigurationProperty.builder()
     *         .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
     *                 .volumeSpecification(VolumeSpecificationProperty.builder()
     *                         .volumeSize(size)
     *                         .volumeType(EmrCreateCluster.getEbsBlockDeviceVolumeType().GP2)
     *                         // the properties below are optional
     *                         .iops(123)
     *                         .build())
     *                 // the properties below are optional
     *                 .volumesPerInstance(123)
     *                 .build()))
     *         .ebsOptimized(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_EbsConfiguration.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_EbsConfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.EbsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EbsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface EbsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (experimental) An array of Amazon EBS volume specifications attached to a cluster instance.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceConfigProperty> getEbsBlockDeviceConfigs() {
            return null;
        }

        /**
         * (experimental) Indicates whether an Amazon EBS volume is EBS-optimized.
         * <p>
         * Default: - EMR selected default
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Boolean getEbsOptimized() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EbsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EbsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<EbsConfigurationProperty> {
            java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceConfigProperty> ebsBlockDeviceConfigs;
            java.lang.Boolean ebsOptimized;

            /**
             * Sets the value of {@link EbsConfigurationProperty#getEbsBlockDeviceConfigs}
             * @param ebsBlockDeviceConfigs An array of Amazon EBS volume specifications attached to a cluster instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @SuppressWarnings("unchecked")
            public Builder ebsBlockDeviceConfigs(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceConfigProperty> ebsBlockDeviceConfigs) {
                this.ebsBlockDeviceConfigs = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceConfigProperty>)ebsBlockDeviceConfigs;
                return this;
            }

            /**
             * Sets the value of {@link EbsConfigurationProperty#getEbsOptimized}
             * @param ebsOptimized Indicates whether an Amazon EBS volume is EBS-optimized.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder ebsOptimized(java.lang.Boolean ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public EbsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EbsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EbsConfigurationProperty {
            private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceConfigProperty> ebsBlockDeviceConfigs;
            private final java.lang.Boolean ebsOptimized;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ebsBlockDeviceConfigs = software.amazon.jsii.Kernel.get(this, "ebsBlockDeviceConfigs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceConfigProperty.class)));
                this.ebsOptimized = software.amazon.jsii.Kernel.get(this, "ebsOptimized", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ebsBlockDeviceConfigs = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceConfigProperty>)builder.ebsBlockDeviceConfigs;
                this.ebsOptimized = builder.ebsOptimized;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceConfigProperty> getEbsBlockDeviceConfigs() {
                return this.ebsBlockDeviceConfigs;
            }

            @Override
            public final java.lang.Boolean getEbsOptimized() {
                return this.ebsOptimized;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEbsBlockDeviceConfigs() != null) {
                    data.set("ebsBlockDeviceConfigs", om.valueToTree(this.getEbsBlockDeviceConfigs()));
                }
                if (this.getEbsOptimized() != null) {
                    data.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.EmrCreateCluster.EbsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EbsConfigurationProperty.Jsii$Proxy that = (EbsConfigurationProperty.Jsii$Proxy) o;

                if (this.ebsBlockDeviceConfigs != null ? !this.ebsBlockDeviceConfigs.equals(that.ebsBlockDeviceConfigs) : that.ebsBlockDeviceConfigs != null) return false;
                return this.ebsOptimized != null ? this.ebsOptimized.equals(that.ebsOptimized) : that.ebsOptimized == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ebsBlockDeviceConfigs != null ? this.ebsBlockDeviceConfigs.hashCode() : 0;
                result = 31 * result + (this.ebsOptimized != null ? this.ebsOptimized.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * (experimental) The Cluster ScaleDownBehavior specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_RunJobFlow.html#EMR-RunJobFlow-request-ScaleDownBehavior">https://docs.aws.amazon.com/emr/latest/APIReference/API_RunJobFlow.html#EMR-RunJobFlow-request-ScaleDownBehavior</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.EmrClusterScaleDownBehavior")
    public enum EmrClusterScaleDownBehavior {
        /**
         * (experimental) Indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of when the request to terminate the instance was submitted.
         * <p>
         * This option is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that version
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        TERMINATE_AT_INSTANCE_HOUR,
        /**
         * (experimental) Indicates that Amazon EMR adds nodes to a deny list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour boundary.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        TERMINATE_AT_TASK_COMPLETION,
    }
    /**
     * (experimental) The configuration that defines an instance fleet.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.core.*;
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * ConfigurationProperty configurationProperty_;
     * Size size;
     * InstanceFleetConfigProperty instanceFleetConfigProperty = InstanceFleetConfigProperty.builder()
     *         .instanceFleetType(EmrCreateCluster.getInstanceRoleType().MASTER)
     *         // the properties below are optional
     *         .instanceTypeConfigs(List.of(InstanceTypeConfigProperty.builder()
     *                 .instanceType("instanceType")
     *                 // the properties below are optional
     *                 .bidPrice("bidPrice")
     *                 .bidPriceAsPercentageOfOnDemandPrice(123)
     *                 .configurations(List.of(ConfigurationProperty.builder()
     *                         .classification("classification")
     *                         .configurations(List.of(configurationProperty_))
     *                         .properties(Map.of(
     *                                 "propertiesKey", "properties"))
     *                         .build()))
     *                 .ebsConfiguration(EbsConfigurationProperty.builder()
     *                         .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
     *                                 .volumeSpecification(VolumeSpecificationProperty.builder()
     *                                         .volumeSize(size)
     *                                         .volumeType(EmrCreateCluster.getEbsBlockDeviceVolumeType().GP2)
     *                                         // the properties below are optional
     *                                         .iops(123)
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .volumesPerInstance(123)
     *                                 .build()))
     *                         .ebsOptimized(false)
     *                         .build())
     *                 .weightedCapacity(123)
     *                 .build()))
     *         .launchSpecifications(InstanceFleetProvisioningSpecificationsProperty.builder()
     *                 .spotSpecification(SpotProvisioningSpecificationProperty.builder()
     *                         .timeoutAction(EmrCreateCluster.getSpotTimeoutAction().SWITCH_TO_ON_DEMAND)
     *                         .timeoutDurationMinutes(123)
     *                         // the properties below are optional
     *                         .allocationStrategy(EmrCreateCluster.getSpotAllocationStrategy().CAPACITY_OPTIMIZED)
     *                         .blockDurationMinutes(123)
     *                         .build())
     *                 .build())
     *         .name("name")
     *         .targetOnDemandCapacity(123)
     *         .targetSpotCapacity(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceFleetConfig.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceFleetConfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.InstanceFleetConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceFleetConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface InstanceFleetConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (experimental) The node type that the instance fleet hosts.
         * <p>
         * Valid values are MASTER,CORE,and TASK.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType getInstanceFleetType();

        /**
         * (experimental) The instance type configurations that define the EC2 instances in the instance fleet.
         * <p>
         * Default: No instanceTpeConfigs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceTypeConfigProperty> getInstanceTypeConfigs() {
            return null;
        }

        /**
         * (experimental) The launch specification for the instance fleet.
         * <p>
         * Default: No launchSpecifications
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetProvisioningSpecificationsProperty getLaunchSpecifications() {
            return null;
        }

        /**
         * (experimental) The friendly name of the instance fleet.
         * <p>
         * Default: No name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * (experimental) The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
         * <p>
         * Default: No targetOnDemandCapacity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTargetOnDemandCapacity() {
            return null;
        }

        /**
         * (experimental) The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
         * <p>
         * Default: No targetSpotCapacity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTargetSpotCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceFleetConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceFleetConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceFleetConfigProperty> {
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType instanceFleetType;
            java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceTypeConfigProperty> instanceTypeConfigs;
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetProvisioningSpecificationsProperty launchSpecifications;
            java.lang.String name;
            java.lang.Number targetOnDemandCapacity;
            java.lang.Number targetSpotCapacity;

            /**
             * Sets the value of {@link InstanceFleetConfigProperty#getInstanceFleetType}
             * @param instanceFleetType The node type that the instance fleet hosts. This parameter is required.
             *                          Valid values are MASTER,CORE,and TASK.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder instanceFleetType(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType instanceFleetType) {
                this.instanceFleetType = instanceFleetType;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetConfigProperty#getInstanceTypeConfigs}
             * @param instanceTypeConfigs The instance type configurations that define the EC2 instances in the instance fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @SuppressWarnings("unchecked")
            public Builder instanceTypeConfigs(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceTypeConfigProperty> instanceTypeConfigs) {
                this.instanceTypeConfigs = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceTypeConfigProperty>)instanceTypeConfigs;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetConfigProperty#getLaunchSpecifications}
             * @param launchSpecifications The launch specification for the instance fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder launchSpecifications(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetProvisioningSpecificationsProperty launchSpecifications) {
                this.launchSpecifications = launchSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetConfigProperty#getName}
             * @param name The friendly name of the instance fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetConfigProperty#getTargetOnDemandCapacity}
             * @param targetOnDemandCapacity The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder targetOnDemandCapacity(java.lang.Number targetOnDemandCapacity) {
                this.targetOnDemandCapacity = targetOnDemandCapacity;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetConfigProperty#getTargetSpotCapacity}
             * @param targetSpotCapacity The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder targetSpotCapacity(java.lang.Number targetSpotCapacity) {
                this.targetSpotCapacity = targetSpotCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceFleetConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public InstanceFleetConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceFleetConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceFleetConfigProperty {
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType instanceFleetType;
            private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceTypeConfigProperty> instanceTypeConfigs;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetProvisioningSpecificationsProperty launchSpecifications;
            private final java.lang.String name;
            private final java.lang.Number targetOnDemandCapacity;
            private final java.lang.Number targetSpotCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceFleetType = software.amazon.jsii.Kernel.get(this, "instanceFleetType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType.class));
                this.instanceTypeConfigs = software.amazon.jsii.Kernel.get(this, "instanceTypeConfigs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceTypeConfigProperty.class)));
                this.launchSpecifications = software.amazon.jsii.Kernel.get(this, "launchSpecifications", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetProvisioningSpecificationsProperty.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetOnDemandCapacity = software.amazon.jsii.Kernel.get(this, "targetOnDemandCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.targetSpotCapacity = software.amazon.jsii.Kernel.get(this, "targetSpotCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceFleetType = java.util.Objects.requireNonNull(builder.instanceFleetType, "instanceFleetType is required");
                this.instanceTypeConfigs = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceTypeConfigProperty>)builder.instanceTypeConfigs;
                this.launchSpecifications = builder.launchSpecifications;
                this.name = builder.name;
                this.targetOnDemandCapacity = builder.targetOnDemandCapacity;
                this.targetSpotCapacity = builder.targetSpotCapacity;
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType getInstanceFleetType() {
                return this.instanceFleetType;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceTypeConfigProperty> getInstanceTypeConfigs() {
                return this.instanceTypeConfigs;
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetProvisioningSpecificationsProperty getLaunchSpecifications() {
                return this.launchSpecifications;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Number getTargetOnDemandCapacity() {
                return this.targetOnDemandCapacity;
            }

            @Override
            public final java.lang.Number getTargetSpotCapacity() {
                return this.targetSpotCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceFleetType", om.valueToTree(this.getInstanceFleetType()));
                if (this.getInstanceTypeConfigs() != null) {
                    data.set("instanceTypeConfigs", om.valueToTree(this.getInstanceTypeConfigs()));
                }
                if (this.getLaunchSpecifications() != null) {
                    data.set("launchSpecifications", om.valueToTree(this.getLaunchSpecifications()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getTargetOnDemandCapacity() != null) {
                    data.set("targetOnDemandCapacity", om.valueToTree(this.getTargetOnDemandCapacity()));
                }
                if (this.getTargetSpotCapacity() != null) {
                    data.set("targetSpotCapacity", om.valueToTree(this.getTargetSpotCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.EmrCreateCluster.InstanceFleetConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceFleetConfigProperty.Jsii$Proxy that = (InstanceFleetConfigProperty.Jsii$Proxy) o;

                if (!instanceFleetType.equals(that.instanceFleetType)) return false;
                if (this.instanceTypeConfigs != null ? !this.instanceTypeConfigs.equals(that.instanceTypeConfigs) : that.instanceTypeConfigs != null) return false;
                if (this.launchSpecifications != null ? !this.launchSpecifications.equals(that.launchSpecifications) : that.launchSpecifications != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.targetOnDemandCapacity != null ? !this.targetOnDemandCapacity.equals(that.targetOnDemandCapacity) : that.targetOnDemandCapacity != null) return false;
                return this.targetSpotCapacity != null ? this.targetSpotCapacity.equals(that.targetSpotCapacity) : that.targetSpotCapacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instanceFleetType.hashCode();
                result = 31 * result + (this.instanceTypeConfigs != null ? this.instanceTypeConfigs.hashCode() : 0);
                result = 31 * result + (this.launchSpecifications != null ? this.launchSpecifications.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.targetOnDemandCapacity != null ? this.targetOnDemandCapacity.hashCode() : 0);
                result = 31 * result + (this.targetSpotCapacity != null ? this.targetSpotCapacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * (experimental) The launch specification for Spot instances in the fleet, which determines the defined duration and provisioning timeout behavior.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * InstanceFleetProvisioningSpecificationsProperty instanceFleetProvisioningSpecificationsProperty = InstanceFleetProvisioningSpecificationsProperty.builder()
     *         .spotSpecification(SpotProvisioningSpecificationProperty.builder()
     *                 .timeoutAction(EmrCreateCluster.getSpotTimeoutAction().SWITCH_TO_ON_DEMAND)
     *                 .timeoutDurationMinutes(123)
     *                 // the properties below are optional
     *                 .allocationStrategy(EmrCreateCluster.getSpotAllocationStrategy().CAPACITY_OPTIMIZED)
     *                 .blockDurationMinutes(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceFleetProvisioningSpecifications.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceFleetProvisioningSpecifications.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.InstanceFleetProvisioningSpecificationsProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceFleetProvisioningSpecificationsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface InstanceFleetProvisioningSpecificationsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (experimental) The launch specification for Spot instances in the fleet, which determines the defined duration and provisioning timeout behavior.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotProvisioningSpecificationProperty getSpotSpecification();

        /**
         * @return a {@link Builder} of {@link InstanceFleetProvisioningSpecificationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceFleetProvisioningSpecificationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceFleetProvisioningSpecificationsProperty> {
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotProvisioningSpecificationProperty spotSpecification;

            /**
             * Sets the value of {@link InstanceFleetProvisioningSpecificationsProperty#getSpotSpecification}
             * @param spotSpecification The launch specification for Spot instances in the fleet, which determines the defined duration and provisioning timeout behavior. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder spotSpecification(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotProvisioningSpecificationProperty spotSpecification) {
                this.spotSpecification = spotSpecification;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceFleetProvisioningSpecificationsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public InstanceFleetProvisioningSpecificationsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceFleetProvisioningSpecificationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceFleetProvisioningSpecificationsProperty {
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotProvisioningSpecificationProperty spotSpecification;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.spotSpecification = software.amazon.jsii.Kernel.get(this, "spotSpecification", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotProvisioningSpecificationProperty.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.spotSpecification = java.util.Objects.requireNonNull(builder.spotSpecification, "spotSpecification is required");
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotProvisioningSpecificationProperty getSpotSpecification() {
                return this.spotSpecification;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("spotSpecification", om.valueToTree(this.getSpotSpecification()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.EmrCreateCluster.InstanceFleetProvisioningSpecificationsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceFleetProvisioningSpecificationsProperty.Jsii$Proxy that = (InstanceFleetProvisioningSpecificationsProperty.Jsii$Proxy) o;

                return this.spotSpecification.equals(that.spotSpecification);
            }

            @Override
            public final int hashCode() {
                int result = this.spotSpecification.hashCode();
                return result;
            }
        }
    }
    /**
     * (experimental) Configuration defining a new instance group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.core.*;
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * ConfigurationProperty configurationProperty_;
     * Duration duration;
     * Size size;
     * InstanceGroupConfigProperty instanceGroupConfigProperty = InstanceGroupConfigProperty.builder()
     *         .instanceCount(123)
     *         .instanceRole(EmrCreateCluster.getInstanceRoleType().MASTER)
     *         .instanceType("instanceType")
     *         // the properties below are optional
     *         .autoScalingPolicy(AutoScalingPolicyProperty.builder()
     *                 .constraints(ScalingConstraintsProperty.builder()
     *                         .maxCapacity(123)
     *                         .minCapacity(123)
     *                         .build())
     *                 .rules(List.of(ScalingRuleProperty.builder()
     *                         .action(ScalingActionProperty.builder()
     *                                 .simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty.builder()
     *                                         .scalingAdjustment(123)
     *                                         // the properties below are optional
     *                                         .adjustmentType(EmrCreateCluster.getScalingAdjustmentType().CHANGE_IN_CAPACITY)
     *                                         .coolDown(123)
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .market(EmrCreateCluster.getInstanceMarket().ON_DEMAND)
     *                                 .build())
     *                         .name("name")
     *                         .trigger(ScalingTriggerProperty.builder()
     *                                 .cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty.builder()
     *                                         .comparisonOperator(EmrCreateCluster.getCloudWatchAlarmComparisonOperator().GREATER_THAN_OR_EQUAL)
     *                                         .metricName("metricName")
     *                                         .period(duration)
     *                                         // the properties below are optional
     *                                         .dimensions(List.of(MetricDimensionProperty.builder()
     *                                                 .key("key")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .evaluationPeriods(123)
     *                                         .namespace("namespace")
     *                                         .statistic(EmrCreateCluster.getCloudWatchAlarmStatistic().SAMPLE_COUNT)
     *                                         .threshold(123)
     *                                         .unit(EmrCreateCluster.getCloudWatchAlarmUnit().NONE)
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .description("description")
     *                         .build()))
     *                 .build())
     *         .bidPrice("bidPrice")
     *         .configurations(List.of(ConfigurationProperty.builder()
     *                 .classification("classification")
     *                 .configurations(List.of(configurationProperty_))
     *                 .properties(Map.of(
     *                         "propertiesKey", "properties"))
     *                 .build()))
     *         .ebsConfiguration(EbsConfigurationProperty.builder()
     *                 .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
     *                         .volumeSpecification(VolumeSpecificationProperty.builder()
     *                                 .volumeSize(size)
     *                                 .volumeType(EmrCreateCluster.getEbsBlockDeviceVolumeType().GP2)
     *                                 // the properties below are optional
     *                                 .iops(123)
     *                                 .build())
     *                         // the properties below are optional
     *                         .volumesPerInstance(123)
     *                         .build()))
     *                 .ebsOptimized(false)
     *                 .build())
     *         .market(EmrCreateCluster.getInstanceMarket().ON_DEMAND)
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceGroupConfig.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceGroupConfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.InstanceGroupConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceGroupConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface InstanceGroupConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (experimental) Target number of instances for the instance group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.Number getInstanceCount();

        /**
         * (experimental) The role of the instance group in the cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType getInstanceRole();

        /**
         * (experimental) The EC2 instance type for all instances in the instance group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

        /**
         * (experimental) An automatic scaling policy for a core instance group or task instance group in an Amazon EMR cluster.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.AutoScalingPolicyProperty getAutoScalingPolicy() {
            return null;
        }

        /**
         * (experimental) The bid price for each EC2 Spot instance type as defined by InstanceType.
         * <p>
         * Expressed in USD.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getBidPrice() {
            return null;
        }

        /**
         * (experimental) The list of configurations supplied for an EMR cluster instance group.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> getConfigurations() {
            return null;
        }

        /**
         * (experimental) EBS configurations that will be attached to each EC2 instance in the instance group.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty getEbsConfiguration() {
            return null;
        }

        /**
         * (experimental) Market type of the EC2 instances used to create a cluster node.
         * <p>
         * Default: - EMR selected default
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket getMarket() {
            return null;
        }

        /**
         * (experimental) Friendly name given to the instance group.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceGroupConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceGroupConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceGroupConfigProperty> {
            java.lang.Number instanceCount;
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType instanceRole;
            java.lang.String instanceType;
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.AutoScalingPolicyProperty autoScalingPolicy;
            java.lang.String bidPrice;
            java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations;
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty ebsConfiguration;
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket market;
            java.lang.String name;

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getInstanceCount}
             * @param instanceCount Target number of instances for the instance group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder instanceCount(java.lang.Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getInstanceRole}
             * @param instanceRole The role of the instance group in the cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder instanceRole(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType instanceRole) {
                this.instanceRole = instanceRole;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getInstanceType}
             * @param instanceType The EC2 instance type for all instances in the instance group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getAutoScalingPolicy}
             * @param autoScalingPolicy An automatic scaling policy for a core instance group or task instance group in an Amazon EMR cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder autoScalingPolicy(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.AutoScalingPolicyProperty autoScalingPolicy) {
                this.autoScalingPolicy = autoScalingPolicy;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getBidPrice}
             * @param bidPrice The bid price for each EC2 Spot instance type as defined by InstanceType.
             *                 Expressed in USD.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder bidPrice(java.lang.String bidPrice) {
                this.bidPrice = bidPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getConfigurations}
             * @param configurations The list of configurations supplied for an EMR cluster instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @SuppressWarnings("unchecked")
            public Builder configurations(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations) {
                this.configurations = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty>)configurations;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getEbsConfiguration}
             * @param ebsConfiguration EBS configurations that will be attached to each EC2 instance in the instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder ebsConfiguration(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty ebsConfiguration) {
                this.ebsConfiguration = ebsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getMarket}
             * @param market Market type of the EC2 instances used to create a cluster node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder market(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket market) {
                this.market = market;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getName}
             * @param name Friendly name given to the instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceGroupConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public InstanceGroupConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceGroupConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceGroupConfigProperty {
            private final java.lang.Number instanceCount;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType instanceRole;
            private final java.lang.String instanceType;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.AutoScalingPolicyProperty autoScalingPolicy;
            private final java.lang.String bidPrice;
            private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty ebsConfiguration;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket market;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceCount = software.amazon.jsii.Kernel.get(this, "instanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.instanceRole = software.amazon.jsii.Kernel.get(this, "instanceRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.autoScalingPolicy = software.amazon.jsii.Kernel.get(this, "autoScalingPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.AutoScalingPolicyProperty.class));
                this.bidPrice = software.amazon.jsii.Kernel.get(this, "bidPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.configurations = software.amazon.jsii.Kernel.get(this, "configurations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty.class)));
                this.ebsConfiguration = software.amazon.jsii.Kernel.get(this, "ebsConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty.class));
                this.market = software.amazon.jsii.Kernel.get(this, "market", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceCount = java.util.Objects.requireNonNull(builder.instanceCount, "instanceCount is required");
                this.instanceRole = java.util.Objects.requireNonNull(builder.instanceRole, "instanceRole is required");
                this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
                this.autoScalingPolicy = builder.autoScalingPolicy;
                this.bidPrice = builder.bidPrice;
                this.configurations = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty>)builder.configurations;
                this.ebsConfiguration = builder.ebsConfiguration;
                this.market = builder.market;
                this.name = builder.name;
            }

            @Override
            public final java.lang.Number getInstanceCount() {
                return this.instanceCount;
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType getInstanceRole() {
                return this.instanceRole;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.AutoScalingPolicyProperty getAutoScalingPolicy() {
                return this.autoScalingPolicy;
            }

            @Override
            public final java.lang.String getBidPrice() {
                return this.bidPrice;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> getConfigurations() {
                return this.configurations;
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty getEbsConfiguration() {
                return this.ebsConfiguration;
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket getMarket() {
                return this.market;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
                data.set("instanceRole", om.valueToTree(this.getInstanceRole()));
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
                if (this.getAutoScalingPolicy() != null) {
                    data.set("autoScalingPolicy", om.valueToTree(this.getAutoScalingPolicy()));
                }
                if (this.getBidPrice() != null) {
                    data.set("bidPrice", om.valueToTree(this.getBidPrice()));
                }
                if (this.getConfigurations() != null) {
                    data.set("configurations", om.valueToTree(this.getConfigurations()));
                }
                if (this.getEbsConfiguration() != null) {
                    data.set("ebsConfiguration", om.valueToTree(this.getEbsConfiguration()));
                }
                if (this.getMarket() != null) {
                    data.set("market", om.valueToTree(this.getMarket()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.EmrCreateCluster.InstanceGroupConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceGroupConfigProperty.Jsii$Proxy that = (InstanceGroupConfigProperty.Jsii$Proxy) o;

                if (!instanceCount.equals(that.instanceCount)) return false;
                if (!instanceRole.equals(that.instanceRole)) return false;
                if (!instanceType.equals(that.instanceType)) return false;
                if (this.autoScalingPolicy != null ? !this.autoScalingPolicy.equals(that.autoScalingPolicy) : that.autoScalingPolicy != null) return false;
                if (this.bidPrice != null ? !this.bidPrice.equals(that.bidPrice) : that.bidPrice != null) return false;
                if (this.configurations != null ? !this.configurations.equals(that.configurations) : that.configurations != null) return false;
                if (this.ebsConfiguration != null ? !this.ebsConfiguration.equals(that.ebsConfiguration) : that.ebsConfiguration != null) return false;
                if (this.market != null ? !this.market.equals(that.market) : that.market != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instanceCount.hashCode();
                result = 31 * result + (this.instanceRole.hashCode());
                result = 31 * result + (this.instanceType.hashCode());
                result = 31 * result + (this.autoScalingPolicy != null ? this.autoScalingPolicy.hashCode() : 0);
                result = 31 * result + (this.bidPrice != null ? this.bidPrice.hashCode() : 0);
                result = 31 * result + (this.configurations != null ? this.configurations.hashCode() : 0);
                result = 31 * result + (this.ebsConfiguration != null ? this.ebsConfiguration.hashCode() : 0);
                result = 31 * result + (this.market != null ? this.market.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * (experimental) EC2 Instance Market.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.InstanceMarket")
    public enum InstanceMarket {
        /**
         * (experimental) On Demand Instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        ON_DEMAND,
        /**
         * (experimental) Spot Instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        SPOT,
    }
    /**
     * (experimental) Instance Role Types.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.InstanceRoleType")
    public enum InstanceRoleType {
        /**
         * (experimental) Master Node.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        MASTER,
        /**
         * (experimental) Core Node.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        CORE,
        /**
         * (experimental) Task Node.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        TASK,
    }
    /**
     * (experimental) An instance type configuration for each instance type in an instance fleet, which determines the EC2 instances Amazon EMR attempts to provision to fulfill On-Demand and Spot target capacities.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.core.*;
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * ConfigurationProperty configurationProperty_;
     * Size size;
     * InstanceTypeConfigProperty instanceTypeConfigProperty = InstanceTypeConfigProperty.builder()
     *         .instanceType("instanceType")
     *         // the properties below are optional
     *         .bidPrice("bidPrice")
     *         .bidPriceAsPercentageOfOnDemandPrice(123)
     *         .configurations(List.of(ConfigurationProperty.builder()
     *                 .classification("classification")
     *                 .configurations(List.of(configurationProperty_))
     *                 .properties(Map.of(
     *                         "propertiesKey", "properties"))
     *                 .build()))
     *         .ebsConfiguration(EbsConfigurationProperty.builder()
     *                 .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
     *                         .volumeSpecification(VolumeSpecificationProperty.builder()
     *                                 .volumeSize(size)
     *                                 .volumeType(EmrCreateCluster.getEbsBlockDeviceVolumeType().GP2)
     *                                 // the properties below are optional
     *                                 .iops(123)
     *                                 .build())
     *                         // the properties below are optional
     *                         .volumesPerInstance(123)
     *                         .build()))
     *                 .ebsOptimized(false)
     *                 .build())
     *         .weightedCapacity(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceTypeConfig.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceTypeConfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.InstanceTypeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceTypeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface InstanceTypeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (experimental) An EC2 instance type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

        /**
         * (experimental) The bid price for each EC2 Spot instance type as defined by InstanceType.
         * <p>
         * Expressed in USD.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getBidPrice() {
            return null;
        }

        /**
         * (experimental) The bid price, as a percentage of On-Demand price.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBidPriceAsPercentageOfOnDemandPrice() {
            return null;
        }

        /**
         * (experimental) A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> getConfigurations() {
            return null;
        }

        /**
         * (experimental) The configuration of Amazon Elastic Block Storage (EBS) attached to each instance as defined by InstanceType.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty getEbsConfiguration() {
            return null;
        }

        /**
         * (experimental) The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in the InstanceFleetConfig.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeightedCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceTypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceTypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceTypeConfigProperty> {
            java.lang.String instanceType;
            java.lang.String bidPrice;
            java.lang.Number bidPriceAsPercentageOfOnDemandPrice;
            java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations;
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty ebsConfiguration;
            java.lang.Number weightedCapacity;

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getInstanceType}
             * @param instanceType An EC2 instance type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getBidPrice}
             * @param bidPrice The bid price for each EC2 Spot instance type as defined by InstanceType.
             *                 Expressed in USD.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder bidPrice(java.lang.String bidPrice) {
                this.bidPrice = bidPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getBidPriceAsPercentageOfOnDemandPrice}
             * @param bidPriceAsPercentageOfOnDemandPrice The bid price, as a percentage of On-Demand price.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder bidPriceAsPercentageOfOnDemandPrice(java.lang.Number bidPriceAsPercentageOfOnDemandPrice) {
                this.bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getConfigurations}
             * @param configurations A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @SuppressWarnings("unchecked")
            public Builder configurations(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations) {
                this.configurations = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty>)configurations;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getEbsConfiguration}
             * @param ebsConfiguration The configuration of Amazon Elastic Block Storage (EBS) attached to each instance as defined by InstanceType.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder ebsConfiguration(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty ebsConfiguration) {
                this.ebsConfiguration = ebsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getWeightedCapacity}
             * @param weightedCapacity The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in the InstanceFleetConfig.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder weightedCapacity(java.lang.Number weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceTypeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public InstanceTypeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceTypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceTypeConfigProperty {
            private final java.lang.String instanceType;
            private final java.lang.String bidPrice;
            private final java.lang.Number bidPriceAsPercentageOfOnDemandPrice;
            private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty ebsConfiguration;
            private final java.lang.Number weightedCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bidPrice = software.amazon.jsii.Kernel.get(this, "bidPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bidPriceAsPercentageOfOnDemandPrice = software.amazon.jsii.Kernel.get(this, "bidPriceAsPercentageOfOnDemandPrice", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.configurations = software.amazon.jsii.Kernel.get(this, "configurations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty.class)));
                this.ebsConfiguration = software.amazon.jsii.Kernel.get(this, "ebsConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty.class));
                this.weightedCapacity = software.amazon.jsii.Kernel.get(this, "weightedCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
                this.bidPrice = builder.bidPrice;
                this.bidPriceAsPercentageOfOnDemandPrice = builder.bidPriceAsPercentageOfOnDemandPrice;
                this.configurations = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty>)builder.configurations;
                this.ebsConfiguration = builder.ebsConfiguration;
                this.weightedCapacity = builder.weightedCapacity;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.String getBidPrice() {
                return this.bidPrice;
            }

            @Override
            public final java.lang.Number getBidPriceAsPercentageOfOnDemandPrice() {
                return this.bidPriceAsPercentageOfOnDemandPrice;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> getConfigurations() {
                return this.configurations;
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty getEbsConfiguration() {
                return this.ebsConfiguration;
            }

            @Override
            public final java.lang.Number getWeightedCapacity() {
                return this.weightedCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceType", om.valueToTree(this.getInstanceType()));
                if (this.getBidPrice() != null) {
                    data.set("bidPrice", om.valueToTree(this.getBidPrice()));
                }
                if (this.getBidPriceAsPercentageOfOnDemandPrice() != null) {
                    data.set("bidPriceAsPercentageOfOnDemandPrice", om.valueToTree(this.getBidPriceAsPercentageOfOnDemandPrice()));
                }
                if (this.getConfigurations() != null) {
                    data.set("configurations", om.valueToTree(this.getConfigurations()));
                }
                if (this.getEbsConfiguration() != null) {
                    data.set("ebsConfiguration", om.valueToTree(this.getEbsConfiguration()));
                }
                if (this.getWeightedCapacity() != null) {
                    data.set("weightedCapacity", om.valueToTree(this.getWeightedCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.EmrCreateCluster.InstanceTypeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceTypeConfigProperty.Jsii$Proxy that = (InstanceTypeConfigProperty.Jsii$Proxy) o;

                if (!instanceType.equals(that.instanceType)) return false;
                if (this.bidPrice != null ? !this.bidPrice.equals(that.bidPrice) : that.bidPrice != null) return false;
                if (this.bidPriceAsPercentageOfOnDemandPrice != null ? !this.bidPriceAsPercentageOfOnDemandPrice.equals(that.bidPriceAsPercentageOfOnDemandPrice) : that.bidPriceAsPercentageOfOnDemandPrice != null) return false;
                if (this.configurations != null ? !this.configurations.equals(that.configurations) : that.configurations != null) return false;
                if (this.ebsConfiguration != null ? !this.ebsConfiguration.equals(that.ebsConfiguration) : that.ebsConfiguration != null) return false;
                return this.weightedCapacity != null ? this.weightedCapacity.equals(that.weightedCapacity) : that.weightedCapacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instanceType.hashCode();
                result = 31 * result + (this.bidPrice != null ? this.bidPrice.hashCode() : 0);
                result = 31 * result + (this.bidPriceAsPercentageOfOnDemandPrice != null ? this.bidPriceAsPercentageOfOnDemandPrice.hashCode() : 0);
                result = 31 * result + (this.configurations != null ? this.configurations.hashCode() : 0);
                result = 31 * result + (this.ebsConfiguration != null ? this.ebsConfiguration.hashCode() : 0);
                result = 31 * result + (this.weightedCapacity != null ? this.weightedCapacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * (experimental) A specification of the number and type of Amazon EC2 instances.
     * <p>
     * See the RunJobFlow API for complete documentation on input parameters
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * Role clusterRole = Role.Builder.create(this, "ClusterRole")
     *         .assumedBy(new ServicePrincipal("ec2.amazonaws.com"))
     *         .build();
     * Role serviceRole = Role.Builder.create(this, "ServiceRole")
     *         .assumedBy(new ServicePrincipal("elasticmapreduce.amazonaws.com"))
     *         .build();
     * Role autoScalingRole = Role.Builder.create(this, "AutoScalingRole")
     *         .assumedBy(new ServicePrincipal("elasticmapreduce.amazonaws.com"))
     *         .build();
     * autoScalingRole.assumeRolePolicy.addStatements(
     * PolicyStatement.Builder.create()
     *         .effect(Effect.ALLOW)
     *         .principals(List.of(
     *             new ServicePrincipal("application-autoscaling.amazonaws.com")))
     *         .actions(List.of("sts:AssumeRole"))
     *         .build());
     * EmrCreateCluster.Builder.create(this, "Create Cluster")
     *         .instances(InstancesConfigProperty.builder().build())
     *         .clusterRole(clusterRole)
     *         .name(TaskInput.fromJsonPathAt("$.ClusterName").getValue())
     *         .serviceRole(serviceRole)
     *         .autoScalingRole(autoScalingRole)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_JobFlowInstancesConfig.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_JobFlowInstancesConfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.InstancesConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(InstancesConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface InstancesConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (experimental) A list of additional Amazon EC2 security group IDs for the master node.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdditionalMasterSecurityGroups() {
            return null;
        }

        /**
         * (experimental) A list of additional Amazon EC2 security group IDs for the core and task nodes.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdditionalSlaveSecurityGroups() {
            return null;
        }

        /**
         * (experimental) The name of the EC2 key pair that can be used to ssh to the master node as the user called "hadoop.".
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getEc2KeyName() {
            return null;
        }

        /**
         * (experimental) Applies to clusters that use the uniform instance group configuration.
         * <p>
         * To launch the cluster in Amazon Virtual Private Cloud (Amazon VPC),
         * set this parameter to the identifier of the Amazon VPC subnet where you want the cluster to launch.
         * <p>
         * Default: EMR selected default
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getEc2SubnetId() {
            return null;
        }

        /**
         * (experimental) Applies to clusters that use the instance fleet configuration.
         * <p>
         * When multiple EC2 subnet IDs are specified, Amazon EMR evaluates them and
         * launches instances in the optimal subnet.
         * <p>
         * Default: EMR selected default
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEc2SubnetIds() {
            return null;
        }

        /**
         * (experimental) The identifier of the Amazon EC2 security group for the master node.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getEmrManagedMasterSecurityGroup() {
            return null;
        }

        /**
         * (experimental) The identifier of the Amazon EC2 security group for the core and task nodes.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getEmrManagedSlaveSecurityGroup() {
            return null;
        }

        /**
         * (experimental) Applies only to Amazon EMR release versions earlier than 4.0. The Hadoop version for the cluster.
         * <p>
         * Default: - 0.18 if the AmiVersion parameter is not set. If AmiVersion is set, the version of Hadoop for that AMI version is used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getHadoopVersion() {
            return null;
        }

        /**
         * (experimental) The number of EC2 instances in the cluster.
         * <p>
         * Default: 0
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInstanceCount() {
            return null;
        }

        /**
         * (experimental) Describes the EC2 instances and instance configurations for clusters that use the instance fleet configuration.
         * <p>
         * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetConfigProperty> getInstanceFleets() {
            return null;
        }

        /**
         * (experimental) Configuration for the instance groups in a cluster.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceGroupConfigProperty> getInstanceGroups() {
            return null;
        }

        /**
         * (experimental) The EC2 instance type of the master node.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getMasterInstanceType() {
            return null;
        }

        /**
         * (experimental) The Availability Zone in which the cluster runs.
         * <p>
         * Default: - EMR selected default
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.PlacementTypeProperty getPlacement() {
            return null;
        }

        /**
         * (experimental) The identifier of the Amazon EC2 security group for the Amazon EMR service to access clusters in VPC private subnets.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccessSecurityGroup() {
            return null;
        }

        /**
         * (experimental) The EC2 instance type of the core and task nodes.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getSlaveInstanceType() {
            return null;
        }

        /**
         * (experimental) Specifies whether to lock the cluster to prevent the Amazon EC2 instances from being terminated by API call, user intervention, or in the event of a job-flow error.
         * <p>
         * Default: false
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Boolean getTerminationProtected() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstancesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstancesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<InstancesConfigProperty> {
            java.util.List<java.lang.String> additionalMasterSecurityGroups;
            java.util.List<java.lang.String> additionalSlaveSecurityGroups;
            java.lang.String ec2KeyName;
            java.lang.String ec2SubnetId;
            java.util.List<java.lang.String> ec2SubnetIds;
            java.lang.String emrManagedMasterSecurityGroup;
            java.lang.String emrManagedSlaveSecurityGroup;
            java.lang.String hadoopVersion;
            java.lang.Number instanceCount;
            java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetConfigProperty> instanceFleets;
            java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceGroupConfigProperty> instanceGroups;
            java.lang.String masterInstanceType;
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.PlacementTypeProperty placement;
            java.lang.String serviceAccessSecurityGroup;
            java.lang.String slaveInstanceType;
            java.lang.Boolean terminationProtected;

            /**
             * Sets the value of {@link InstancesConfigProperty#getAdditionalMasterSecurityGroups}
             * @param additionalMasterSecurityGroups A list of additional Amazon EC2 security group IDs for the master node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder additionalMasterSecurityGroups(java.util.List<java.lang.String> additionalMasterSecurityGroups) {
                this.additionalMasterSecurityGroups = additionalMasterSecurityGroups;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getAdditionalSlaveSecurityGroups}
             * @param additionalSlaveSecurityGroups A list of additional Amazon EC2 security group IDs for the core and task nodes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder additionalSlaveSecurityGroups(java.util.List<java.lang.String> additionalSlaveSecurityGroups) {
                this.additionalSlaveSecurityGroups = additionalSlaveSecurityGroups;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getEc2KeyName}
             * @param ec2KeyName The name of the EC2 key pair that can be used to ssh to the master node as the user called "hadoop.".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder ec2KeyName(java.lang.String ec2KeyName) {
                this.ec2KeyName = ec2KeyName;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getEc2SubnetId}
             * @param ec2SubnetId Applies to clusters that use the uniform instance group configuration.
             *                    To launch the cluster in Amazon Virtual Private Cloud (Amazon VPC),
             *                    set this parameter to the identifier of the Amazon VPC subnet where you want the cluster to launch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder ec2SubnetId(java.lang.String ec2SubnetId) {
                this.ec2SubnetId = ec2SubnetId;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getEc2SubnetIds}
             * @param ec2SubnetIds Applies to clusters that use the instance fleet configuration.
             *                     When multiple EC2 subnet IDs are specified, Amazon EMR evaluates them and
             *                     launches instances in the optimal subnet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder ec2SubnetIds(java.util.List<java.lang.String> ec2SubnetIds) {
                this.ec2SubnetIds = ec2SubnetIds;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getEmrManagedMasterSecurityGroup}
             * @param emrManagedMasterSecurityGroup The identifier of the Amazon EC2 security group for the master node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder emrManagedMasterSecurityGroup(java.lang.String emrManagedMasterSecurityGroup) {
                this.emrManagedMasterSecurityGroup = emrManagedMasterSecurityGroup;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getEmrManagedSlaveSecurityGroup}
             * @param emrManagedSlaveSecurityGroup The identifier of the Amazon EC2 security group for the core and task nodes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder emrManagedSlaveSecurityGroup(java.lang.String emrManagedSlaveSecurityGroup) {
                this.emrManagedSlaveSecurityGroup = emrManagedSlaveSecurityGroup;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getHadoopVersion}
             * @param hadoopVersion Applies only to Amazon EMR release versions earlier than 4.0. The Hadoop version for the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder hadoopVersion(java.lang.String hadoopVersion) {
                this.hadoopVersion = hadoopVersion;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getInstanceCount}
             * @param instanceCount The number of EC2 instances in the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder instanceCount(java.lang.Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getInstanceFleets}
             * @param instanceFleets Describes the EC2 instances and instance configurations for clusters that use the instance fleet configuration.
             *                       The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @SuppressWarnings("unchecked")
            public Builder instanceFleets(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetConfigProperty> instanceFleets) {
                this.instanceFleets = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetConfigProperty>)instanceFleets;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getInstanceGroups}
             * @param instanceGroups Configuration for the instance groups in a cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @SuppressWarnings("unchecked")
            public Builder instanceGroups(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceGroupConfigProperty> instanceGroups) {
                this.instanceGroups = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceGroupConfigProperty>)instanceGroups;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getMasterInstanceType}
             * @param masterInstanceType The EC2 instance type of the master node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder masterInstanceType(java.lang.String masterInstanceType) {
                this.masterInstanceType = masterInstanceType;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getPlacement}
             * @param placement The Availability Zone in which the cluster runs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder placement(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.PlacementTypeProperty placement) {
                this.placement = placement;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getServiceAccessSecurityGroup}
             * @param serviceAccessSecurityGroup The identifier of the Amazon EC2 security group for the Amazon EMR service to access clusters in VPC private subnets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder serviceAccessSecurityGroup(java.lang.String serviceAccessSecurityGroup) {
                this.serviceAccessSecurityGroup = serviceAccessSecurityGroup;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getSlaveInstanceType}
             * @param slaveInstanceType The EC2 instance type of the core and task nodes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder slaveInstanceType(java.lang.String slaveInstanceType) {
                this.slaveInstanceType = slaveInstanceType;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getTerminationProtected}
             * @param terminationProtected Specifies whether to lock the cluster to prevent the Amazon EC2 instances from being terminated by API call, user intervention, or in the event of a job-flow error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder terminationProtected(java.lang.Boolean terminationProtected) {
                this.terminationProtected = terminationProtected;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstancesConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public InstancesConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstancesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstancesConfigProperty {
            private final java.util.List<java.lang.String> additionalMasterSecurityGroups;
            private final java.util.List<java.lang.String> additionalSlaveSecurityGroups;
            private final java.lang.String ec2KeyName;
            private final java.lang.String ec2SubnetId;
            private final java.util.List<java.lang.String> ec2SubnetIds;
            private final java.lang.String emrManagedMasterSecurityGroup;
            private final java.lang.String emrManagedSlaveSecurityGroup;
            private final java.lang.String hadoopVersion;
            private final java.lang.Number instanceCount;
            private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetConfigProperty> instanceFleets;
            private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceGroupConfigProperty> instanceGroups;
            private final java.lang.String masterInstanceType;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.PlacementTypeProperty placement;
            private final java.lang.String serviceAccessSecurityGroup;
            private final java.lang.String slaveInstanceType;
            private final java.lang.Boolean terminationProtected;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.additionalMasterSecurityGroups = software.amazon.jsii.Kernel.get(this, "additionalMasterSecurityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.additionalSlaveSecurityGroups = software.amazon.jsii.Kernel.get(this, "additionalSlaveSecurityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.ec2KeyName = software.amazon.jsii.Kernel.get(this, "ec2KeyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ec2SubnetId = software.amazon.jsii.Kernel.get(this, "ec2SubnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ec2SubnetIds = software.amazon.jsii.Kernel.get(this, "ec2SubnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.emrManagedMasterSecurityGroup = software.amazon.jsii.Kernel.get(this, "emrManagedMasterSecurityGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.emrManagedSlaveSecurityGroup = software.amazon.jsii.Kernel.get(this, "emrManagedSlaveSecurityGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hadoopVersion = software.amazon.jsii.Kernel.get(this, "hadoopVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceCount = software.amazon.jsii.Kernel.get(this, "instanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.instanceFleets = software.amazon.jsii.Kernel.get(this, "instanceFleets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetConfigProperty.class)));
                this.instanceGroups = software.amazon.jsii.Kernel.get(this, "instanceGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceGroupConfigProperty.class)));
                this.masterInstanceType = software.amazon.jsii.Kernel.get(this, "masterInstanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.placement = software.amazon.jsii.Kernel.get(this, "placement", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.PlacementTypeProperty.class));
                this.serviceAccessSecurityGroup = software.amazon.jsii.Kernel.get(this, "serviceAccessSecurityGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.slaveInstanceType = software.amazon.jsii.Kernel.get(this, "slaveInstanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.terminationProtected = software.amazon.jsii.Kernel.get(this, "terminationProtected", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.additionalMasterSecurityGroups = builder.additionalMasterSecurityGroups;
                this.additionalSlaveSecurityGroups = builder.additionalSlaveSecurityGroups;
                this.ec2KeyName = builder.ec2KeyName;
                this.ec2SubnetId = builder.ec2SubnetId;
                this.ec2SubnetIds = builder.ec2SubnetIds;
                this.emrManagedMasterSecurityGroup = builder.emrManagedMasterSecurityGroup;
                this.emrManagedSlaveSecurityGroup = builder.emrManagedSlaveSecurityGroup;
                this.hadoopVersion = builder.hadoopVersion;
                this.instanceCount = builder.instanceCount;
                this.instanceFleets = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetConfigProperty>)builder.instanceFleets;
                this.instanceGroups = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceGroupConfigProperty>)builder.instanceGroups;
                this.masterInstanceType = builder.masterInstanceType;
                this.placement = builder.placement;
                this.serviceAccessSecurityGroup = builder.serviceAccessSecurityGroup;
                this.slaveInstanceType = builder.slaveInstanceType;
                this.terminationProtected = builder.terminationProtected;
            }

            @Override
            public final java.util.List<java.lang.String> getAdditionalMasterSecurityGroups() {
                return this.additionalMasterSecurityGroups;
            }

            @Override
            public final java.util.List<java.lang.String> getAdditionalSlaveSecurityGroups() {
                return this.additionalSlaveSecurityGroups;
            }

            @Override
            public final java.lang.String getEc2KeyName() {
                return this.ec2KeyName;
            }

            @Override
            public final java.lang.String getEc2SubnetId() {
                return this.ec2SubnetId;
            }

            @Override
            public final java.util.List<java.lang.String> getEc2SubnetIds() {
                return this.ec2SubnetIds;
            }

            @Override
            public final java.lang.String getEmrManagedMasterSecurityGroup() {
                return this.emrManagedMasterSecurityGroup;
            }

            @Override
            public final java.lang.String getEmrManagedSlaveSecurityGroup() {
                return this.emrManagedSlaveSecurityGroup;
            }

            @Override
            public final java.lang.String getHadoopVersion() {
                return this.hadoopVersion;
            }

            @Override
            public final java.lang.Number getInstanceCount() {
                return this.instanceCount;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetConfigProperty> getInstanceFleets() {
                return this.instanceFleets;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceGroupConfigProperty> getInstanceGroups() {
                return this.instanceGroups;
            }

            @Override
            public final java.lang.String getMasterInstanceType() {
                return this.masterInstanceType;
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.PlacementTypeProperty getPlacement() {
                return this.placement;
            }

            @Override
            public final java.lang.String getServiceAccessSecurityGroup() {
                return this.serviceAccessSecurityGroup;
            }

            @Override
            public final java.lang.String getSlaveInstanceType() {
                return this.slaveInstanceType;
            }

            @Override
            public final java.lang.Boolean getTerminationProtected() {
                return this.terminationProtected;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdditionalMasterSecurityGroups() != null) {
                    data.set("additionalMasterSecurityGroups", om.valueToTree(this.getAdditionalMasterSecurityGroups()));
                }
                if (this.getAdditionalSlaveSecurityGroups() != null) {
                    data.set("additionalSlaveSecurityGroups", om.valueToTree(this.getAdditionalSlaveSecurityGroups()));
                }
                if (this.getEc2KeyName() != null) {
                    data.set("ec2KeyName", om.valueToTree(this.getEc2KeyName()));
                }
                if (this.getEc2SubnetId() != null) {
                    data.set("ec2SubnetId", om.valueToTree(this.getEc2SubnetId()));
                }
                if (this.getEc2SubnetIds() != null) {
                    data.set("ec2SubnetIds", om.valueToTree(this.getEc2SubnetIds()));
                }
                if (this.getEmrManagedMasterSecurityGroup() != null) {
                    data.set("emrManagedMasterSecurityGroup", om.valueToTree(this.getEmrManagedMasterSecurityGroup()));
                }
                if (this.getEmrManagedSlaveSecurityGroup() != null) {
                    data.set("emrManagedSlaveSecurityGroup", om.valueToTree(this.getEmrManagedSlaveSecurityGroup()));
                }
                if (this.getHadoopVersion() != null) {
                    data.set("hadoopVersion", om.valueToTree(this.getHadoopVersion()));
                }
                if (this.getInstanceCount() != null) {
                    data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
                }
                if (this.getInstanceFleets() != null) {
                    data.set("instanceFleets", om.valueToTree(this.getInstanceFleets()));
                }
                if (this.getInstanceGroups() != null) {
                    data.set("instanceGroups", om.valueToTree(this.getInstanceGroups()));
                }
                if (this.getMasterInstanceType() != null) {
                    data.set("masterInstanceType", om.valueToTree(this.getMasterInstanceType()));
                }
                if (this.getPlacement() != null) {
                    data.set("placement", om.valueToTree(this.getPlacement()));
                }
                if (this.getServiceAccessSecurityGroup() != null) {
                    data.set("serviceAccessSecurityGroup", om.valueToTree(this.getServiceAccessSecurityGroup()));
                }
                if (this.getSlaveInstanceType() != null) {
                    data.set("slaveInstanceType", om.valueToTree(this.getSlaveInstanceType()));
                }
                if (this.getTerminationProtected() != null) {
                    data.set("terminationProtected", om.valueToTree(this.getTerminationProtected()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.EmrCreateCluster.InstancesConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstancesConfigProperty.Jsii$Proxy that = (InstancesConfigProperty.Jsii$Proxy) o;

                if (this.additionalMasterSecurityGroups != null ? !this.additionalMasterSecurityGroups.equals(that.additionalMasterSecurityGroups) : that.additionalMasterSecurityGroups != null) return false;
                if (this.additionalSlaveSecurityGroups != null ? !this.additionalSlaveSecurityGroups.equals(that.additionalSlaveSecurityGroups) : that.additionalSlaveSecurityGroups != null) return false;
                if (this.ec2KeyName != null ? !this.ec2KeyName.equals(that.ec2KeyName) : that.ec2KeyName != null) return false;
                if (this.ec2SubnetId != null ? !this.ec2SubnetId.equals(that.ec2SubnetId) : that.ec2SubnetId != null) return false;
                if (this.ec2SubnetIds != null ? !this.ec2SubnetIds.equals(that.ec2SubnetIds) : that.ec2SubnetIds != null) return false;
                if (this.emrManagedMasterSecurityGroup != null ? !this.emrManagedMasterSecurityGroup.equals(that.emrManagedMasterSecurityGroup) : that.emrManagedMasterSecurityGroup != null) return false;
                if (this.emrManagedSlaveSecurityGroup != null ? !this.emrManagedSlaveSecurityGroup.equals(that.emrManagedSlaveSecurityGroup) : that.emrManagedSlaveSecurityGroup != null) return false;
                if (this.hadoopVersion != null ? !this.hadoopVersion.equals(that.hadoopVersion) : that.hadoopVersion != null) return false;
                if (this.instanceCount != null ? !this.instanceCount.equals(that.instanceCount) : that.instanceCount != null) return false;
                if (this.instanceFleets != null ? !this.instanceFleets.equals(that.instanceFleets) : that.instanceFleets != null) return false;
                if (this.instanceGroups != null ? !this.instanceGroups.equals(that.instanceGroups) : that.instanceGroups != null) return false;
                if (this.masterInstanceType != null ? !this.masterInstanceType.equals(that.masterInstanceType) : that.masterInstanceType != null) return false;
                if (this.placement != null ? !this.placement.equals(that.placement) : that.placement != null) return false;
                if (this.serviceAccessSecurityGroup != null ? !this.serviceAccessSecurityGroup.equals(that.serviceAccessSecurityGroup) : that.serviceAccessSecurityGroup != null) return false;
                if (this.slaveInstanceType != null ? !this.slaveInstanceType.equals(that.slaveInstanceType) : that.slaveInstanceType != null) return false;
                return this.terminationProtected != null ? this.terminationProtected.equals(that.terminationProtected) : that.terminationProtected == null;
            }

            @Override
            public final int hashCode() {
                int result = this.additionalMasterSecurityGroups != null ? this.additionalMasterSecurityGroups.hashCode() : 0;
                result = 31 * result + (this.additionalSlaveSecurityGroups != null ? this.additionalSlaveSecurityGroups.hashCode() : 0);
                result = 31 * result + (this.ec2KeyName != null ? this.ec2KeyName.hashCode() : 0);
                result = 31 * result + (this.ec2SubnetId != null ? this.ec2SubnetId.hashCode() : 0);
                result = 31 * result + (this.ec2SubnetIds != null ? this.ec2SubnetIds.hashCode() : 0);
                result = 31 * result + (this.emrManagedMasterSecurityGroup != null ? this.emrManagedMasterSecurityGroup.hashCode() : 0);
                result = 31 * result + (this.emrManagedSlaveSecurityGroup != null ? this.emrManagedSlaveSecurityGroup.hashCode() : 0);
                result = 31 * result + (this.hadoopVersion != null ? this.hadoopVersion.hashCode() : 0);
                result = 31 * result + (this.instanceCount != null ? this.instanceCount.hashCode() : 0);
                result = 31 * result + (this.instanceFleets != null ? this.instanceFleets.hashCode() : 0);
                result = 31 * result + (this.instanceGroups != null ? this.instanceGroups.hashCode() : 0);
                result = 31 * result + (this.masterInstanceType != null ? this.masterInstanceType.hashCode() : 0);
                result = 31 * result + (this.placement != null ? this.placement.hashCode() : 0);
                result = 31 * result + (this.serviceAccessSecurityGroup != null ? this.serviceAccessSecurityGroup.hashCode() : 0);
                result = 31 * result + (this.slaveInstanceType != null ? this.slaveInstanceType.hashCode() : 0);
                result = 31 * result + (this.terminationProtected != null ? this.terminationProtected.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * (experimental) Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
     * <p>
     * See the RunJobFlow API for complete documentation on input parameters
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * KerberosAttributesProperty kerberosAttributesProperty = KerberosAttributesProperty.builder()
     *         .realm("realm")
     *         // the properties below are optional
     *         .adDomainJoinPassword("adDomainJoinPassword")
     *         .adDomainJoinUser("adDomainJoinUser")
     *         .crossRealmTrustPrincipalPassword("crossRealmTrustPrincipalPassword")
     *         .kdcAdminPassword("kdcAdminPassword")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_KerberosAttributes.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_KerberosAttributes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.KerberosAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(KerberosAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface KerberosAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (experimental) The name of the Kerberos realm to which all nodes in a cluster belong.
         * <p>
         * For example, EC2.INTERNAL.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.String getRealm();

        /**
         * (experimental) The Active Directory password for ADDomainJoinUser.
         * <p>
         * Default: No adDomainJoinPassword
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdDomainJoinPassword() {
            return null;
        }

        /**
         * (experimental) Required only when establishing a cross-realm trust with an Active Directory domain.
         * <p>
         * A user with sufficient privileges to join
         * resources to the domain.
         * <p>
         * Default: No adDomainJoinUser
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdDomainJoinUser() {
            return null;
        }

        /**
         * (experimental) Required only when establishing a cross-realm trust with a KDC in a different realm.
         * <p>
         * The cross-realm principal password, which
         * must be identical across realms.
         * <p>
         * Default: No crossRealmTrustPrincipalPassword
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getCrossRealmTrustPrincipalPassword() {
            return null;
        }

        /**
         * (experimental) The password used within the cluster for the kadmin service on the cluster-dedicated KDC, which maintains Kerberos principals, password policies, and keytabs for the cluster.
         * <p>
         * Default: No kdcAdminPassword
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getKdcAdminPassword() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KerberosAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KerberosAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<KerberosAttributesProperty> {
            java.lang.String realm;
            java.lang.String adDomainJoinPassword;
            java.lang.String adDomainJoinUser;
            java.lang.String crossRealmTrustPrincipalPassword;
            java.lang.String kdcAdminPassword;

            /**
             * Sets the value of {@link KerberosAttributesProperty#getRealm}
             * @param realm The name of the Kerberos realm to which all nodes in a cluster belong. This parameter is required.
             *              For example, EC2.INTERNAL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder realm(java.lang.String realm) {
                this.realm = realm;
                return this;
            }

            /**
             * Sets the value of {@link KerberosAttributesProperty#getAdDomainJoinPassword}
             * @param adDomainJoinPassword The Active Directory password for ADDomainJoinUser.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder adDomainJoinPassword(java.lang.String adDomainJoinPassword) {
                this.adDomainJoinPassword = adDomainJoinPassword;
                return this;
            }

            /**
             * Sets the value of {@link KerberosAttributesProperty#getAdDomainJoinUser}
             * @param adDomainJoinUser Required only when establishing a cross-realm trust with an Active Directory domain.
             *                         A user with sufficient privileges to join
             *                         resources to the domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder adDomainJoinUser(java.lang.String adDomainJoinUser) {
                this.adDomainJoinUser = adDomainJoinUser;
                return this;
            }

            /**
             * Sets the value of {@link KerberosAttributesProperty#getCrossRealmTrustPrincipalPassword}
             * @param crossRealmTrustPrincipalPassword Required only when establishing a cross-realm trust with a KDC in a different realm.
             *                                         The cross-realm principal password, which
             *                                         must be identical across realms.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder crossRealmTrustPrincipalPassword(java.lang.String crossRealmTrustPrincipalPassword) {
                this.crossRealmTrustPrincipalPassword = crossRealmTrustPrincipalPassword;
                return this;
            }

            /**
             * Sets the value of {@link KerberosAttributesProperty#getKdcAdminPassword}
             * @param kdcAdminPassword The password used within the cluster for the kadmin service on the cluster-dedicated KDC, which maintains Kerberos principals, password policies, and keytabs for the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder kdcAdminPassword(java.lang.String kdcAdminPassword) {
                this.kdcAdminPassword = kdcAdminPassword;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KerberosAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public KerberosAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KerberosAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KerberosAttributesProperty {
            private final java.lang.String realm;
            private final java.lang.String adDomainJoinPassword;
            private final java.lang.String adDomainJoinUser;
            private final java.lang.String crossRealmTrustPrincipalPassword;
            private final java.lang.String kdcAdminPassword;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.realm = software.amazon.jsii.Kernel.get(this, "realm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.adDomainJoinPassword = software.amazon.jsii.Kernel.get(this, "adDomainJoinPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.adDomainJoinUser = software.amazon.jsii.Kernel.get(this, "adDomainJoinUser", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.crossRealmTrustPrincipalPassword = software.amazon.jsii.Kernel.get(this, "crossRealmTrustPrincipalPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kdcAdminPassword = software.amazon.jsii.Kernel.get(this, "kdcAdminPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.realm = java.util.Objects.requireNonNull(builder.realm, "realm is required");
                this.adDomainJoinPassword = builder.adDomainJoinPassword;
                this.adDomainJoinUser = builder.adDomainJoinUser;
                this.crossRealmTrustPrincipalPassword = builder.crossRealmTrustPrincipalPassword;
                this.kdcAdminPassword = builder.kdcAdminPassword;
            }

            @Override
            public final java.lang.String getRealm() {
                return this.realm;
            }

            @Override
            public final java.lang.String getAdDomainJoinPassword() {
                return this.adDomainJoinPassword;
            }

            @Override
            public final java.lang.String getAdDomainJoinUser() {
                return this.adDomainJoinUser;
            }

            @Override
            public final java.lang.String getCrossRealmTrustPrincipalPassword() {
                return this.crossRealmTrustPrincipalPassword;
            }

            @Override
            public final java.lang.String getKdcAdminPassword() {
                return this.kdcAdminPassword;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("realm", om.valueToTree(this.getRealm()));
                if (this.getAdDomainJoinPassword() != null) {
                    data.set("adDomainJoinPassword", om.valueToTree(this.getAdDomainJoinPassword()));
                }
                if (this.getAdDomainJoinUser() != null) {
                    data.set("adDomainJoinUser", om.valueToTree(this.getAdDomainJoinUser()));
                }
                if (this.getCrossRealmTrustPrincipalPassword() != null) {
                    data.set("crossRealmTrustPrincipalPassword", om.valueToTree(this.getCrossRealmTrustPrincipalPassword()));
                }
                if (this.getKdcAdminPassword() != null) {
                    data.set("kdcAdminPassword", om.valueToTree(this.getKdcAdminPassword()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.EmrCreateCluster.KerberosAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KerberosAttributesProperty.Jsii$Proxy that = (KerberosAttributesProperty.Jsii$Proxy) o;

                if (!realm.equals(that.realm)) return false;
                if (this.adDomainJoinPassword != null ? !this.adDomainJoinPassword.equals(that.adDomainJoinPassword) : that.adDomainJoinPassword != null) return false;
                if (this.adDomainJoinUser != null ? !this.adDomainJoinUser.equals(that.adDomainJoinUser) : that.adDomainJoinUser != null) return false;
                if (this.crossRealmTrustPrincipalPassword != null ? !this.crossRealmTrustPrincipalPassword.equals(that.crossRealmTrustPrincipalPassword) : that.crossRealmTrustPrincipalPassword != null) return false;
                return this.kdcAdminPassword != null ? this.kdcAdminPassword.equals(that.kdcAdminPassword) : that.kdcAdminPassword == null;
            }

            @Override
            public final int hashCode() {
                int result = this.realm.hashCode();
                result = 31 * result + (this.adDomainJoinPassword != null ? this.adDomainJoinPassword.hashCode() : 0);
                result = 31 * result + (this.adDomainJoinUser != null ? this.adDomainJoinUser.hashCode() : 0);
                result = 31 * result + (this.crossRealmTrustPrincipalPassword != null ? this.crossRealmTrustPrincipalPassword.hashCode() : 0);
                result = 31 * result + (this.kdcAdminPassword != null ? this.kdcAdminPassword.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * (experimental) A CloudWatch dimension, which is specified using a Key (known as a Name in CloudWatch), Value pair.
     * <p>
     * By default, Amazon EMR uses
     * one dimension whose Key is JobFlowID and Value is a variable representing the cluster ID, which is ${emr.clusterId}. This enables
     * the rule to bootstrap when the cluster ID becomes available
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * MetricDimensionProperty metricDimensionProperty = MetricDimensionProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_MetricDimension.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_MetricDimension.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.MetricDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface MetricDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (experimental) The dimension name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * (experimental) The dimension value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<MetricDimensionProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link MetricDimensionProperty#getKey}
             * @param key The dimension name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link MetricDimensionProperty#getValue}
             * @param value The dimension value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public MetricDimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricDimensionProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.EmrCreateCluster.MetricDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricDimensionProperty.Jsii$Proxy that = (MetricDimensionProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * (experimental) The Amazon EC2 Availability Zone configuration of the cluster (job flow).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * PlacementTypeProperty placementTypeProperty = PlacementTypeProperty.builder()
     *         .availabilityZone("availabilityZone")
     *         .availabilityZones(List.of("availabilityZones"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_PlacementType.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_PlacementType.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.PlacementTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(PlacementTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface PlacementTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (experimental) The Amazon EC2 Availability Zone for the cluster.
         * <p>
         * AvailabilityZone is used for uniform instance groups, while AvailabilityZones
         * (plural) is used for instance fleets.
         * <p>
         * Default: - EMR selected default
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * (experimental) When multiple Availability Zones are specified, Amazon EMR evaluates them and launches instances in the optimal Availability Zone.
         * <p>
         * AvailabilityZones is used for instance fleets, while AvailabilityZone (singular) is used for uniform instance groups.
         * <p>
         * Default: - EMR selected default
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAvailabilityZones() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PlacementTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PlacementTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<PlacementTypeProperty> {
            java.lang.String availabilityZone;
            java.util.List<java.lang.String> availabilityZones;

            /**
             * Sets the value of {@link PlacementTypeProperty#getAvailabilityZone}
             * @param availabilityZone The Amazon EC2 Availability Zone for the cluster.
             *                         AvailabilityZone is used for uniform instance groups, while AvailabilityZones
             *                         (plural) is used for instance fleets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link PlacementTypeProperty#getAvailabilityZones}
             * @param availabilityZones When multiple Availability Zones are specified, Amazon EMR evaluates them and launches instances in the optimal Availability Zone.
             *                          AvailabilityZones is used for instance fleets, while AvailabilityZone (singular) is used for uniform instance groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder availabilityZones(java.util.List<java.lang.String> availabilityZones) {
                this.availabilityZones = availabilityZones;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlacementTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public PlacementTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PlacementTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlacementTypeProperty {
            private final java.lang.String availabilityZone;
            private final java.util.List<java.lang.String> availabilityZones;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.availabilityZones = software.amazon.jsii.Kernel.get(this, "availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZone = builder.availabilityZone;
                this.availabilityZones = builder.availabilityZones;
            }

            @Override
            public final java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public final java.util.List<java.lang.String> getAvailabilityZones() {
                return this.availabilityZones;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getAvailabilityZones() != null) {
                    data.set("availabilityZones", om.valueToTree(this.getAvailabilityZones()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.EmrCreateCluster.PlacementTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PlacementTypeProperty.Jsii$Proxy that = (PlacementTypeProperty.Jsii$Proxy) o;

                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                return this.availabilityZones != null ? this.availabilityZones.equals(that.availabilityZones) : that.availabilityZones == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availabilityZone != null ? this.availabilityZone.hashCode() : 0;
                result = 31 * result + (this.availabilityZones != null ? this.availabilityZones.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * (experimental) The type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the adjustment.
     * <p>
     * And an automatic scaling configuration, which describes how the policy adds or removes instances, the cooldown period,
     * and the number of EC2 instances that will be added each time the CloudWatch metric alarm condition is satisfied.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * ScalingActionProperty scalingActionProperty = ScalingActionProperty.builder()
     *         .simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty.builder()
     *                 .scalingAdjustment(123)
     *                 // the properties below are optional
     *                 .adjustmentType(EmrCreateCluster.getScalingAdjustmentType().CHANGE_IN_CAPACITY)
     *                 .coolDown(123)
     *                 .build())
     *         // the properties below are optional
     *         .market(EmrCreateCluster.getInstanceMarket().ON_DEMAND)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_ScalingAction.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_ScalingAction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.ScalingActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface ScalingActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (experimental) The type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the adjustment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SimpleScalingPolicyConfigurationProperty getSimpleScalingPolicyConfiguration();

        /**
         * (experimental) Not available for instance groups.
         * <p>
         * Instance groups use the market type specified for the group.
         * <p>
         * Default: - EMR selected default
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket getMarket() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScalingActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingActionProperty> {
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SimpleScalingPolicyConfigurationProperty simpleScalingPolicyConfiguration;
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket market;

            /**
             * Sets the value of {@link ScalingActionProperty#getSimpleScalingPolicyConfiguration}
             * @param simpleScalingPolicyConfiguration The type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the adjustment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder simpleScalingPolicyConfiguration(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SimpleScalingPolicyConfigurationProperty simpleScalingPolicyConfiguration) {
                this.simpleScalingPolicyConfiguration = simpleScalingPolicyConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ScalingActionProperty#getMarket}
             * @param market Not available for instance groups.
             *               Instance groups use the market type specified for the group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder market(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket market) {
                this.market = market;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public ScalingActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScalingActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingActionProperty {
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SimpleScalingPolicyConfigurationProperty simpleScalingPolicyConfiguration;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket market;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.simpleScalingPolicyConfiguration = software.amazon.jsii.Kernel.get(this, "simpleScalingPolicyConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SimpleScalingPolicyConfigurationProperty.class));
                this.market = software.amazon.jsii.Kernel.get(this, "market", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.simpleScalingPolicyConfiguration = java.util.Objects.requireNonNull(builder.simpleScalingPolicyConfiguration, "simpleScalingPolicyConfiguration is required");
                this.market = builder.market;
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SimpleScalingPolicyConfigurationProperty getSimpleScalingPolicyConfiguration() {
                return this.simpleScalingPolicyConfiguration;
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket getMarket() {
                return this.market;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("simpleScalingPolicyConfiguration", om.valueToTree(this.getSimpleScalingPolicyConfiguration()));
                if (this.getMarket() != null) {
                    data.set("market", om.valueToTree(this.getMarket()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.EmrCreateCluster.ScalingActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingActionProperty.Jsii$Proxy that = (ScalingActionProperty.Jsii$Proxy) o;

                if (!simpleScalingPolicyConfiguration.equals(that.simpleScalingPolicyConfiguration)) return false;
                return this.market != null ? this.market.equals(that.market) : that.market == null;
            }

            @Override
            public final int hashCode() {
                int result = this.simpleScalingPolicyConfiguration.hashCode();
                result = 31 * result + (this.market != null ? this.market.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * (experimental) AutoScaling Adjustment Type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.ScalingAdjustmentType")
    public enum ScalingAdjustmentType {
        /**
         * (experimental) CHANGE_IN_CAPACITY.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        CHANGE_IN_CAPACITY,
        /**
         * (experimental) PERCENT_CHANGE_IN_CAPACITY.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        PERCENT_CHANGE_IN_CAPACITY,
        /**
         * (experimental) EXACT_CAPACITY.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        EXACT_CAPACITY,
    }
    /**
     * (experimental) The upper and lower EC2 instance limits for an automatic scaling policy.
     * <p>
     * Automatic scaling activities triggered by automatic scaling
     * rules will not cause an instance group to grow above or below these limits.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * ScalingConstraintsProperty scalingConstraintsProperty = ScalingConstraintsProperty.builder()
     *         .maxCapacity(123)
     *         .minCapacity(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_ScalingConstraints.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_ScalingConstraints.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.ScalingConstraintsProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingConstraintsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface ScalingConstraintsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (experimental) The upper boundary of EC2 instances in an instance group beyond which scaling activities are not allowed to grow.
         * <p>
         * Scale-out
         * activities will not add instances beyond this boundary.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxCapacity();

        /**
         * (experimental) The lower boundary of EC2 instances in an instance group below which scaling activities are not allowed to shrink.
         * <p>
         * Scale-in
         * activities will not terminate instances below this boundary.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinCapacity();

        /**
         * @return a {@link Builder} of {@link ScalingConstraintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingConstraintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingConstraintsProperty> {
            java.lang.Number maxCapacity;
            java.lang.Number minCapacity;

            /**
             * Sets the value of {@link ScalingConstraintsProperty#getMaxCapacity}
             * @param maxCapacity The upper boundary of EC2 instances in an instance group beyond which scaling activities are not allowed to grow. This parameter is required.
             *                    Scale-out
             *                    activities will not add instances beyond this boundary.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder maxCapacity(java.lang.Number maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this;
            }

            /**
             * Sets the value of {@link ScalingConstraintsProperty#getMinCapacity}
             * @param minCapacity The lower boundary of EC2 instances in an instance group below which scaling activities are not allowed to shrink. This parameter is required.
             *                    Scale-in
             *                    activities will not terminate instances below this boundary.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder minCapacity(java.lang.Number minCapacity) {
                this.minCapacity = minCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingConstraintsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public ScalingConstraintsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScalingConstraintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingConstraintsProperty {
            private final java.lang.Number maxCapacity;
            private final java.lang.Number minCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minCapacity = software.amazon.jsii.Kernel.get(this, "minCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxCapacity = java.util.Objects.requireNonNull(builder.maxCapacity, "maxCapacity is required");
                this.minCapacity = java.util.Objects.requireNonNull(builder.minCapacity, "minCapacity is required");
            }

            @Override
            public final java.lang.Number getMaxCapacity() {
                return this.maxCapacity;
            }

            @Override
            public final java.lang.Number getMinCapacity() {
                return this.minCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
                data.set("minCapacity", om.valueToTree(this.getMinCapacity()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.EmrCreateCluster.ScalingConstraintsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingConstraintsProperty.Jsii$Proxy that = (ScalingConstraintsProperty.Jsii$Proxy) o;

                if (!maxCapacity.equals(that.maxCapacity)) return false;
                return this.minCapacity.equals(that.minCapacity);
            }

            @Override
            public final int hashCode() {
                int result = this.maxCapacity.hashCode();
                result = 31 * result + (this.minCapacity.hashCode());
                return result;
            }
        }
    }
    /**
     * (experimental) A scale-in or scale-out rule that defines scaling activity, including the CloudWatch metric alarm that triggers activity, how EC2 instances are added or removed, and the periodicity of adjustments.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.core.*;
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * Duration duration;
     * ScalingRuleProperty scalingRuleProperty = ScalingRuleProperty.builder()
     *         .action(ScalingActionProperty.builder()
     *                 .simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty.builder()
     *                         .scalingAdjustment(123)
     *                         // the properties below are optional
     *                         .adjustmentType(EmrCreateCluster.getScalingAdjustmentType().CHANGE_IN_CAPACITY)
     *                         .coolDown(123)
     *                         .build())
     *                 // the properties below are optional
     *                 .market(EmrCreateCluster.getInstanceMarket().ON_DEMAND)
     *                 .build())
     *         .name("name")
     *         .trigger(ScalingTriggerProperty.builder()
     *                 .cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty.builder()
     *                         .comparisonOperator(EmrCreateCluster.getCloudWatchAlarmComparisonOperator().GREATER_THAN_OR_EQUAL)
     *                         .metricName("metricName")
     *                         .period(duration)
     *                         // the properties below are optional
     *                         .dimensions(List.of(MetricDimensionProperty.builder()
     *                                 .key("key")
     *                                 .value("value")
     *                                 .build()))
     *                         .evaluationPeriods(123)
     *                         .namespace("namespace")
     *                         .statistic(EmrCreateCluster.getCloudWatchAlarmStatistic().SAMPLE_COUNT)
     *                         .threshold(123)
     *                         .unit(EmrCreateCluster.getCloudWatchAlarmUnit().NONE)
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .description("description")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_ScalingRule.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_ScalingRule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.ScalingRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface ScalingRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (experimental) The conditions that trigger an automatic scaling activity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingActionProperty getAction();

        /**
         * (experimental) The name used to identify an automatic scaling rule.
         * <p>
         * Rule names must be unique within a scaling policy.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * (experimental) The CloudWatch alarm definition that determines when automatic scaling activity is triggered.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingTriggerProperty getTrigger();

        /**
         * (experimental) A friendly, more verbose description of the automatic scaling rule.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScalingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingRuleProperty> {
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingActionProperty action;
            java.lang.String name;
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingTriggerProperty trigger;
            java.lang.String description;

            /**
             * Sets the value of {@link ScalingRuleProperty#getAction}
             * @param action The conditions that trigger an automatic scaling activity. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder action(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingActionProperty action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link ScalingRuleProperty#getName}
             * @param name The name used to identify an automatic scaling rule. This parameter is required.
             *             Rule names must be unique within a scaling policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ScalingRuleProperty#getTrigger}
             * @param trigger The CloudWatch alarm definition that determines when automatic scaling activity is triggered. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder trigger(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingTriggerProperty trigger) {
                this.trigger = trigger;
                return this;
            }

            /**
             * Sets the value of {@link ScalingRuleProperty#getDescription}
             * @param description A friendly, more verbose description of the automatic scaling rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public ScalingRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScalingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingRuleProperty {
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingActionProperty action;
            private final java.lang.String name;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingTriggerProperty trigger;
            private final java.lang.String description;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingActionProperty.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.trigger = software.amazon.jsii.Kernel.get(this, "trigger", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingTriggerProperty.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.trigger = java.util.Objects.requireNonNull(builder.trigger, "trigger is required");
                this.description = builder.description;
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingActionProperty getAction() {
                return this.action;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingTriggerProperty getTrigger() {
                return this.trigger;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("trigger", om.valueToTree(this.getTrigger()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.EmrCreateCluster.ScalingRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingRuleProperty.Jsii$Proxy that = (ScalingRuleProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                if (!name.equals(that.name)) return false;
                if (!trigger.equals(that.trigger)) return false;
                return this.description != null ? this.description.equals(that.description) : that.description == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.trigger.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * (experimental) The conditions that trigger an automatic scaling activity and the definition of a CloudWatch metric alarm.
     * <p>
     * When the defined alarm conditions are met along with other trigger parameters, scaling activity begins.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.core.*;
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * Duration duration;
     * ScalingTriggerProperty scalingTriggerProperty = ScalingTriggerProperty.builder()
     *         .cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty.builder()
     *                 .comparisonOperator(EmrCreateCluster.getCloudWatchAlarmComparisonOperator().GREATER_THAN_OR_EQUAL)
     *                 .metricName("metricName")
     *                 .period(duration)
     *                 // the properties below are optional
     *                 .dimensions(List.of(MetricDimensionProperty.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .evaluationPeriods(123)
     *                 .namespace("namespace")
     *                 .statistic(EmrCreateCluster.getCloudWatchAlarmStatistic().SAMPLE_COUNT)
     *                 .threshold(123)
     *                 .unit(EmrCreateCluster.getCloudWatchAlarmUnit().NONE)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_ScalingTrigger.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_ScalingTrigger.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.ScalingTriggerProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingTriggerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface ScalingTriggerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (experimental) The definition of a CloudWatch metric alarm.
         * <p>
         * When the defined alarm conditions are met along with other trigger parameters,
         * scaling activity begins.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmDefinitionProperty getCloudWatchAlarmDefinition();

        /**
         * @return a {@link Builder} of {@link ScalingTriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingTriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingTriggerProperty> {
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmDefinitionProperty cloudWatchAlarmDefinition;

            /**
             * Sets the value of {@link ScalingTriggerProperty#getCloudWatchAlarmDefinition}
             * @param cloudWatchAlarmDefinition The definition of a CloudWatch metric alarm. This parameter is required.
             *                                  When the defined alarm conditions are met along with other trigger parameters,
             *                                  scaling activity begins.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder cloudWatchAlarmDefinition(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmDefinitionProperty cloudWatchAlarmDefinition) {
                this.cloudWatchAlarmDefinition = cloudWatchAlarmDefinition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingTriggerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public ScalingTriggerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScalingTriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingTriggerProperty {
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmDefinitionProperty cloudWatchAlarmDefinition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchAlarmDefinition = software.amazon.jsii.Kernel.get(this, "cloudWatchAlarmDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmDefinitionProperty.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchAlarmDefinition = java.util.Objects.requireNonNull(builder.cloudWatchAlarmDefinition, "cloudWatchAlarmDefinition is required");
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmDefinitionProperty getCloudWatchAlarmDefinition() {
                return this.cloudWatchAlarmDefinition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cloudWatchAlarmDefinition", om.valueToTree(this.getCloudWatchAlarmDefinition()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.EmrCreateCluster.ScalingTriggerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingTriggerProperty.Jsii$Proxy that = (ScalingTriggerProperty.Jsii$Proxy) o;

                return this.cloudWatchAlarmDefinition.equals(that.cloudWatchAlarmDefinition);
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchAlarmDefinition.hashCode();
                return result;
            }
        }
    }
    /**
     * (experimental) Configuration of the script to run during a bootstrap action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * ScriptBootstrapActionConfigProperty scriptBootstrapActionConfigProperty = ScriptBootstrapActionConfigProperty.builder()
     *         .path("path")
     *         // the properties below are optional
     *         .args(List.of("args"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_ScriptBootstrapActionConfig.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_ScriptBootstrapActionConfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.ScriptBootstrapActionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ScriptBootstrapActionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface ScriptBootstrapActionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (experimental) Location of the script to run during a bootstrap action.
         * <p>
         * Can be either a location in Amazon S3 or on a local file system.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.String getPath();

        /**
         * (experimental) A list of command line arguments to pass to the bootstrap action script.
         * <p>
         * Default: No args
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArgs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScriptBootstrapActionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScriptBootstrapActionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<ScriptBootstrapActionConfigProperty> {
            java.lang.String path;
            java.util.List<java.lang.String> args;

            /**
             * Sets the value of {@link ScriptBootstrapActionConfigProperty#getPath}
             * @param path Location of the script to run during a bootstrap action. This parameter is required.
             *             Can be either a location in Amazon S3 or on a local file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link ScriptBootstrapActionConfigProperty#getArgs}
             * @param args A list of command line arguments to pass to the bootstrap action script.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder args(java.util.List<java.lang.String> args) {
                this.args = args;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScriptBootstrapActionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public ScriptBootstrapActionConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScriptBootstrapActionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScriptBootstrapActionConfigProperty {
            private final java.lang.String path;
            private final java.util.List<java.lang.String> args;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.args = software.amazon.jsii.Kernel.get(this, "args", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.path = java.util.Objects.requireNonNull(builder.path, "path is required");
                this.args = builder.args;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            public final java.util.List<java.lang.String> getArgs() {
                return this.args;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("path", om.valueToTree(this.getPath()));
                if (this.getArgs() != null) {
                    data.set("args", om.valueToTree(this.getArgs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.EmrCreateCluster.ScriptBootstrapActionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScriptBootstrapActionConfigProperty.Jsii$Proxy that = (ScriptBootstrapActionConfigProperty.Jsii$Proxy) o;

                if (!path.equals(that.path)) return false;
                return this.args != null ? this.args.equals(that.args) : that.args == null;
            }

            @Override
            public final int hashCode() {
                int result = this.path.hashCode();
                result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * (experimental) An automatic scaling configuration, which describes how the policy adds or removes instances, the cooldown period, and the number of EC2 instances that will be added each time the CloudWatch metric alarm condition is satisfied.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * SimpleScalingPolicyConfigurationProperty simpleScalingPolicyConfigurationProperty = SimpleScalingPolicyConfigurationProperty.builder()
     *         .scalingAdjustment(123)
     *         // the properties below are optional
     *         .adjustmentType(EmrCreateCluster.getScalingAdjustmentType().CHANGE_IN_CAPACITY)
     *         .coolDown(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_SimpleScalingPolicyConfiguration.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_SimpleScalingPolicyConfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.SimpleScalingPolicyConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SimpleScalingPolicyConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface SimpleScalingPolicyConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (experimental) The amount by which to scale in or scale out, based on the specified AdjustmentType.
         * <p>
         * A positive value adds to the instance group's
         * EC2 instance count while a negative number removes instances. If AdjustmentType is set to EXACT_CAPACITY, the number should only be
         * a positive integer.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.Number getScalingAdjustment();

        /**
         * (experimental) The way in which EC2 instances are added (if ScalingAdjustment is a positive number) or terminated (if ScalingAdjustment is a negative number) each time the scaling activity is triggered.
         * <p>
         * Default: - None
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingAdjustmentType getAdjustmentType() {
            return null;
        }

        /**
         * (experimental) The amount of time, in seconds, after a scaling activity completes before any further trigger-related scaling activities can start.
         * <p>
         * Default: 0
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCoolDown() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SimpleScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SimpleScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<SimpleScalingPolicyConfigurationProperty> {
            java.lang.Number scalingAdjustment;
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingAdjustmentType adjustmentType;
            java.lang.Number coolDown;

            /**
             * Sets the value of {@link SimpleScalingPolicyConfigurationProperty#getScalingAdjustment}
             * @param scalingAdjustment The amount by which to scale in or scale out, based on the specified AdjustmentType. This parameter is required.
             *                          A positive value adds to the instance group's
             *                          EC2 instance count while a negative number removes instances. If AdjustmentType is set to EXACT_CAPACITY, the number should only be
             *                          a positive integer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder scalingAdjustment(java.lang.Number scalingAdjustment) {
                this.scalingAdjustment = scalingAdjustment;
                return this;
            }

            /**
             * Sets the value of {@link SimpleScalingPolicyConfigurationProperty#getAdjustmentType}
             * @param adjustmentType The way in which EC2 instances are added (if ScalingAdjustment is a positive number) or terminated (if ScalingAdjustment is a negative number) each time the scaling activity is triggered.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder adjustmentType(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingAdjustmentType adjustmentType) {
                this.adjustmentType = adjustmentType;
                return this;
            }

            /**
             * Sets the value of {@link SimpleScalingPolicyConfigurationProperty#getCoolDown}
             * @param coolDown The amount of time, in seconds, after a scaling activity completes before any further trigger-related scaling activities can start.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder coolDown(java.lang.Number coolDown) {
                this.coolDown = coolDown;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SimpleScalingPolicyConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public SimpleScalingPolicyConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SimpleScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SimpleScalingPolicyConfigurationProperty {
            private final java.lang.Number scalingAdjustment;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingAdjustmentType adjustmentType;
            private final java.lang.Number coolDown;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scalingAdjustment = software.amazon.jsii.Kernel.get(this, "scalingAdjustment", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.adjustmentType = software.amazon.jsii.Kernel.get(this, "adjustmentType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingAdjustmentType.class));
                this.coolDown = software.amazon.jsii.Kernel.get(this, "coolDown", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scalingAdjustment = java.util.Objects.requireNonNull(builder.scalingAdjustment, "scalingAdjustment is required");
                this.adjustmentType = builder.adjustmentType;
                this.coolDown = builder.coolDown;
            }

            @Override
            public final java.lang.Number getScalingAdjustment() {
                return this.scalingAdjustment;
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingAdjustmentType getAdjustmentType() {
                return this.adjustmentType;
            }

            @Override
            public final java.lang.Number getCoolDown() {
                return this.coolDown;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("scalingAdjustment", om.valueToTree(this.getScalingAdjustment()));
                if (this.getAdjustmentType() != null) {
                    data.set("adjustmentType", om.valueToTree(this.getAdjustmentType()));
                }
                if (this.getCoolDown() != null) {
                    data.set("coolDown", om.valueToTree(this.getCoolDown()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.EmrCreateCluster.SimpleScalingPolicyConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SimpleScalingPolicyConfigurationProperty.Jsii$Proxy that = (SimpleScalingPolicyConfigurationProperty.Jsii$Proxy) o;

                if (!scalingAdjustment.equals(that.scalingAdjustment)) return false;
                if (this.adjustmentType != null ? !this.adjustmentType.equals(that.adjustmentType) : that.adjustmentType != null) return false;
                return this.coolDown != null ? this.coolDown.equals(that.coolDown) : that.coolDown == null;
            }

            @Override
            public final int hashCode() {
                int result = this.scalingAdjustment.hashCode();
                result = 31 * result + (this.adjustmentType != null ? this.adjustmentType.hashCode() : 0);
                result = 31 * result + (this.coolDown != null ? this.coolDown.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * (experimental) Spot Allocation Strategies.
     * <p>
     * Specifies the strategy to use in launching Spot Instance fleets. For example, "capacity-optimized" launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_SpotProvisioningSpecification.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_SpotProvisioningSpecification.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.SpotAllocationStrategy")
    public enum SpotAllocationStrategy {
        /**
         * (experimental) Capacity-optimized, which launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        CAPACITY_OPTIMIZED,
    }
    /**
     * (experimental) The launch specification for Spot instances in the instance fleet, which determines the defined duration and provisioning timeout behavior.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * SpotProvisioningSpecificationProperty spotProvisioningSpecificationProperty = SpotProvisioningSpecificationProperty.builder()
     *         .timeoutAction(EmrCreateCluster.getSpotTimeoutAction().SWITCH_TO_ON_DEMAND)
     *         .timeoutDurationMinutes(123)
     *         // the properties below are optional
     *         .allocationStrategy(EmrCreateCluster.getSpotAllocationStrategy().CAPACITY_OPTIMIZED)
     *         .blockDurationMinutes(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_SpotProvisioningSpecification.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_SpotProvisioningSpecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.SpotProvisioningSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(SpotProvisioningSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface SpotProvisioningSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (experimental) The action to take when TargetSpotCapacity has not been fulfilled when the TimeoutDurationMinutes has expired.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotTimeoutAction getTimeoutAction();

        /**
         * (experimental) The spot provisioning timeout period in minutes.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.Number getTimeoutDurationMinutes();

        /**
         * (experimental) Specifies the strategy to use in launching Spot Instance fleets.
         * <p>
         * Default: - No allocation strategy, i.e. spot instance type will be chosen based on current price only
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotAllocationStrategy getAllocationStrategy() {
            return null;
        }

        /**
         * (experimental) The defined duration for Spot instances (also known as Spot blocks) in minutes.
         * <p>
         * Default: - No blockDurationMinutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBlockDurationMinutes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpotProvisioningSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpotProvisioningSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<SpotProvisioningSpecificationProperty> {
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotTimeoutAction timeoutAction;
            java.lang.Number timeoutDurationMinutes;
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotAllocationStrategy allocationStrategy;
            java.lang.Number blockDurationMinutes;

            /**
             * Sets the value of {@link SpotProvisioningSpecificationProperty#getTimeoutAction}
             * @param timeoutAction The action to take when TargetSpotCapacity has not been fulfilled when the TimeoutDurationMinutes has expired. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder timeoutAction(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotTimeoutAction timeoutAction) {
                this.timeoutAction = timeoutAction;
                return this;
            }

            /**
             * Sets the value of {@link SpotProvisioningSpecificationProperty#getTimeoutDurationMinutes}
             * @param timeoutDurationMinutes The spot provisioning timeout period in minutes. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder timeoutDurationMinutes(java.lang.Number timeoutDurationMinutes) {
                this.timeoutDurationMinutes = timeoutDurationMinutes;
                return this;
            }

            /**
             * Sets the value of {@link SpotProvisioningSpecificationProperty#getAllocationStrategy}
             * @param allocationStrategy Specifies the strategy to use in launching Spot Instance fleets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder allocationStrategy(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotAllocationStrategy allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            /**
             * Sets the value of {@link SpotProvisioningSpecificationProperty#getBlockDurationMinutes}
             * @param blockDurationMinutes The defined duration for Spot instances (also known as Spot blocks) in minutes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder blockDurationMinutes(java.lang.Number blockDurationMinutes) {
                this.blockDurationMinutes = blockDurationMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotProvisioningSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public SpotProvisioningSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpotProvisioningSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotProvisioningSpecificationProperty {
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotTimeoutAction timeoutAction;
            private final java.lang.Number timeoutDurationMinutes;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotAllocationStrategy allocationStrategy;
            private final java.lang.Number blockDurationMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.timeoutAction = software.amazon.jsii.Kernel.get(this, "timeoutAction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotTimeoutAction.class));
                this.timeoutDurationMinutes = software.amazon.jsii.Kernel.get(this, "timeoutDurationMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.allocationStrategy = software.amazon.jsii.Kernel.get(this, "allocationStrategy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotAllocationStrategy.class));
                this.blockDurationMinutes = software.amazon.jsii.Kernel.get(this, "blockDurationMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.timeoutAction = java.util.Objects.requireNonNull(builder.timeoutAction, "timeoutAction is required");
                this.timeoutDurationMinutes = java.util.Objects.requireNonNull(builder.timeoutDurationMinutes, "timeoutDurationMinutes is required");
                this.allocationStrategy = builder.allocationStrategy;
                this.blockDurationMinutes = builder.blockDurationMinutes;
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotTimeoutAction getTimeoutAction() {
                return this.timeoutAction;
            }

            @Override
            public final java.lang.Number getTimeoutDurationMinutes() {
                return this.timeoutDurationMinutes;
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotAllocationStrategy getAllocationStrategy() {
                return this.allocationStrategy;
            }

            @Override
            public final java.lang.Number getBlockDurationMinutes() {
                return this.blockDurationMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("timeoutAction", om.valueToTree(this.getTimeoutAction()));
                data.set("timeoutDurationMinutes", om.valueToTree(this.getTimeoutDurationMinutes()));
                if (this.getAllocationStrategy() != null) {
                    data.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
                }
                if (this.getBlockDurationMinutes() != null) {
                    data.set("blockDurationMinutes", om.valueToTree(this.getBlockDurationMinutes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.EmrCreateCluster.SpotProvisioningSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotProvisioningSpecificationProperty.Jsii$Proxy that = (SpotProvisioningSpecificationProperty.Jsii$Proxy) o;

                if (!timeoutAction.equals(that.timeoutAction)) return false;
                if (!timeoutDurationMinutes.equals(that.timeoutDurationMinutes)) return false;
                if (this.allocationStrategy != null ? !this.allocationStrategy.equals(that.allocationStrategy) : that.allocationStrategy != null) return false;
                return this.blockDurationMinutes != null ? this.blockDurationMinutes.equals(that.blockDurationMinutes) : that.blockDurationMinutes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.timeoutAction.hashCode();
                result = 31 * result + (this.timeoutDurationMinutes.hashCode());
                result = 31 * result + (this.allocationStrategy != null ? this.allocationStrategy.hashCode() : 0);
                result = 31 * result + (this.blockDurationMinutes != null ? this.blockDurationMinutes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * (experimental) Spot Timeout Actions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.SpotTimeoutAction")
    public enum SpotTimeoutAction {
        /**
         * (experimental) SWITCH_TO_ON_DEMAND.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        SWITCH_TO_ON_DEMAND,
        /**
         * (experimental) TERMINATE_CLUSTER.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        TERMINATE_CLUSTER,
    }
    /**
     * (experimental) EBS volume specifications such as volume type, IOPS, and size (GiB) that will be requested for the EBS volume attached to an EC2 instance in the cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.core.*;
     * import software.amazon.awscdk.services.stepfunctions.tasks.*;
     * Size size;
     * VolumeSpecificationProperty volumeSpecificationProperty = VolumeSpecificationProperty.builder()
     *         .volumeSize(size)
     *         .volumeType(EmrCreateCluster.getEbsBlockDeviceVolumeType().GP2)
     *         // the properties below are optional
     *         .iops(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr/latest/APIReference/API_VolumeSpecification.html">https://docs.aws.amazon.com/emr/latest/APIReference/API_VolumeSpecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_stepfunctions_tasks.EmrCreateCluster.VolumeSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(VolumeSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface VolumeSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (experimental) The volume size.
         * <p>
         * If the volume type is EBS-optimized, the minimum value is 10GiB.
         * Maximum size is 1TiB
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Size getVolumeSize();

        /**
         * (experimental) The volume type.
         * <p>
         * Volume types supported are gp2, io1, standard.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceVolumeType getVolumeType();

        /**
         * (experimental) The number of I/O operations per second (IOPS) that the volume supports.
         * <p>
         * Default: - EMR selected default
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VolumeSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VolumeSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<VolumeSpecificationProperty> {
            software.amazon.awscdk.core.Size volumeSize;
            software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceVolumeType volumeType;
            java.lang.Number iops;

            /**
             * Sets the value of {@link VolumeSpecificationProperty#getVolumeSize}
             * @param volumeSize The volume size. This parameter is required.
             *                   If the volume type is EBS-optimized, the minimum value is 10GiB.
             *                   Maximum size is 1TiB
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder volumeSize(software.amazon.awscdk.core.Size volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            /**
             * Sets the value of {@link VolumeSpecificationProperty#getVolumeType}
             * @param volumeType The volume type. This parameter is required.
             *                   Volume types supported are gp2, io1, standard.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder volumeType(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceVolumeType volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            /**
             * Sets the value of {@link VolumeSpecificationProperty#getIops}
             * @param iops The number of I/O operations per second (IOPS) that the volume supports.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VolumeSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public VolumeSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VolumeSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VolumeSpecificationProperty {
            private final software.amazon.awscdk.core.Size volumeSize;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceVolumeType volumeType;
            private final java.lang.Number iops;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.volumeSize = software.amazon.jsii.Kernel.get(this, "volumeSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Size.class));
                this.volumeType = software.amazon.jsii.Kernel.get(this, "volumeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceVolumeType.class));
                this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.volumeSize = java.util.Objects.requireNonNull(builder.volumeSize, "volumeSize is required");
                this.volumeType = java.util.Objects.requireNonNull(builder.volumeType, "volumeType is required");
                this.iops = builder.iops;
            }

            @Override
            public final software.amazon.awscdk.core.Size getVolumeSize() {
                return this.volumeSize;
            }

            @Override
            public final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceVolumeType getVolumeType() {
                return this.volumeType;
            }

            @Override
            public final java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("volumeSize", om.valueToTree(this.getVolumeSize()));
                data.set("volumeType", om.valueToTree(this.getVolumeType()));
                if (this.getIops() != null) {
                    data.set("iops", om.valueToTree(this.getIops()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_stepfunctions_tasks.EmrCreateCluster.VolumeSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VolumeSpecificationProperty.Jsii$Proxy that = (VolumeSpecificationProperty.Jsii$Proxy) o;

                if (!volumeSize.equals(that.volumeSize)) return false;
                if (!volumeType.equals(that.volumeType)) return false;
                return this.iops != null ? this.iops.equals(that.iops) : that.iops == null;
            }

            @Override
            public final int hashCode() {
                int result = this.volumeSize.hashCode();
                result = 31 * result + (this.volumeType.hashCode());
                result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateClusterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateClusterProps.Builder();
        }

        /**
         * (experimental) An optional description for this state.
         * <p>
         * Default: - No comment
         * <p>
         * @return {@code this}
         * @param comment An optional description for this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * (experimental) Timeout for the heartbeat.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param heartbeat Timeout for the heartbeat. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder heartbeat(final software.amazon.awscdk.core.Duration heartbeat) {
            this.props.heartbeat(heartbeat);
            return this;
        }

        /**
         * (experimental) JSONPath expression to select part of the state to be the input to this state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * input to be the empty object {}.
         * <p>
         * Default: - The entire task input (JSON path '$')
         * <p>
         * @return {@code this}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder inputPath(final java.lang.String inputPath) {
            this.props.inputPath(inputPath);
            return this;
        }

        /**
         * (experimental) AWS Step Functions integrates with services directly in the Amazon States Language.
         * <p>
         * You can control these AWS services using service integration patterns
         * <p>
         * Default: - `IntegrationPattern.REQUEST_RESPONSE` for most tasks.
         * `IntegrationPattern.RUN_JOB` for the following exceptions:
         * `BatchSubmitJob`, `EmrAddStep`, `EmrCreateCluster`, `EmrTerminationCluster`, and `EmrContainersStartJobRun`.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token</a>
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integrationPattern(final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        /**
         * (experimental) JSONPath expression to select select a portion of the state output to pass to the next state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * output to be the empty object {}.
         * <p>
         * Default: - The entire JSON node determined by the state input, the task result,
         * and resultPath is passed to the next state (JSON path '$')
         * <p>
         * @return {@code this}
         * @param outputPath JSONPath expression to select select a portion of the state output to pass to the next state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputPath(final java.lang.String outputPath) {
            this.props.outputPath(outputPath);
            return this;
        }

        /**
         * (experimental) JSONPath expression to indicate where to inject the state's output.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the state's
         * input to become its output.
         * <p>
         * Default: - Replaces the entire input with the result (JSON path '$')
         * <p>
         * @return {@code this}
         * @param resultPath JSONPath expression to indicate where to inject the state's output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder resultPath(final java.lang.String resultPath) {
            this.props.resultPath(resultPath);
            return this;
        }

        /**
         * (experimental) The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         * <p>
         * You can use ResultSelector to create a payload with values that are static
         * or selected from the state's raw result.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector">https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector</a>
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder resultSelector(final java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.props.resultSelector(resultSelector);
            return this;
        }

        /**
         * (experimental) Timeout for the state machine.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param timeout Timeout for the state machine. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder timeout(final software.amazon.awscdk.core.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * (experimental) A specification of the number and type of Amazon EC2 instances.
         * <p>
         * @return {@code this}
         * @param instances A specification of the number and type of Amazon EC2 instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instances(final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstancesConfigProperty instances) {
            this.props.instances(instances);
            return this;
        }

        /**
         * (experimental) The Name of the Cluster.
         * <p>
         * @return {@code this}
         * @param name The Name of the Cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * (experimental) A JSON string for selecting additional features.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param additionalInfo A JSON string for selecting additional features. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder additionalInfo(final java.lang.String additionalInfo) {
            this.props.additionalInfo(additionalInfo);
            return this;
        }

        /**
         * (experimental) A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster.
         * <p>
         * Default: - EMR selected default
         * <p>
         * @return {@code this}
         * @param applications A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder applications(final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty> applications) {
            this.props.applications(applications);
            return this;
        }

        /**
         * (experimental) An IAM role for automatic scaling policies.
         * <p>
         * Default: - A role will be created.
         * <p>
         * @return {@code this}
         * @param autoScalingRole An IAM role for automatic scaling policies. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoScalingRole(final software.amazon.awscdk.services.iam.IRole autoScalingRole) {
            this.props.autoScalingRole(autoScalingRole);
            return this;
        }

        /**
         * (experimental) A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param bootstrapActions A list of bootstrap actions to run before Hadoop starts on the cluster nodes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bootstrapActions(final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty> bootstrapActions) {
            this.props.bootstrapActions(bootstrapActions);
            return this;
        }

        /**
         * (experimental) Also called instance profile and EC2 role.
         * <p>
         * An IAM role for an EMR cluster. The EC2 instances of the cluster assume this role.
         * <p>
         * This attribute has been renamed from jobFlowRole to clusterRole to align with other ERM/StepFunction integration parameters.
         * <p>
         * Default: - * A Role will be created
         * <p>
         * @return {@code this}
         * @param clusterRole Also called instance profile and EC2 role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterRole(final software.amazon.awscdk.services.iam.IRole clusterRole) {
            this.props.clusterRole(clusterRole);
            return this;
        }

        /**
         * (experimental) The list of configurations supplied for the EMR cluster you are creating.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param configurations The list of configurations supplied for the EMR cluster you are creating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder configurations(final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations) {
            this.props.configurations(configurations);
            return this;
        }

        /**
         * (experimental) The ID of a custom Amazon EBS-backed Linux AMI.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param customAmiId The ID of a custom Amazon EBS-backed Linux AMI. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder customAmiId(final java.lang.String customAmiId) {
            this.props.customAmiId(customAmiId);
            return this;
        }

        /**
         * (experimental) The size of the EBS root device volume of the Linux AMI that is used for each EC2 instance.
         * <p>
         * Default: - EMR selected default
         * <p>
         * @return {@code this}
         * @param ebsRootVolumeSize The size of the EBS root device volume of the Linux AMI that is used for each EC2 instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ebsRootVolumeSize(final software.amazon.awscdk.core.Size ebsRootVolumeSize) {
            this.props.ebsRootVolumeSize(ebsRootVolumeSize);
            return this;
        }

        /**
         * (experimental) Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param kerberosAttributes Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kerberosAttributes(final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.KerberosAttributesProperty kerberosAttributes) {
            this.props.kerberosAttributes(kerberosAttributes);
            return this;
        }

        /**
         * (experimental) The location in Amazon S3 to write the log files of the job flow.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param logUri The location in Amazon S3 to write the log files of the job flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logUri(final java.lang.String logUri) {
            this.props.logUri(logUri);
            return this;
        }

        /**
         * (experimental) The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster.
         * <p>
         * Default: - EMR selected default
         * <p>
         * @return {@code this}
         * @param releaseLabel The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseLabel(final java.lang.String releaseLabel) {
            this.props.releaseLabel(releaseLabel);
            return this;
        }

        /**
         * (experimental) Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized.
         * <p>
         * Default: - EMR selected default
         * <p>
         * @return {@code this}
         * @param scaleDownBehavior Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder scaleDownBehavior(final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EmrClusterScaleDownBehavior scaleDownBehavior) {
            this.props.scaleDownBehavior(scaleDownBehavior);
            return this;
        }

        /**
         * (experimental) The name of a security configuration to apply to the cluster.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param securityConfiguration The name of a security configuration to apply to the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityConfiguration(final java.lang.String securityConfiguration) {
            this.props.securityConfiguration(securityConfiguration);
            return this;
        }

        /**
         * (experimental) The IAM role that will be assumed by the Amazon EMR service to access AWS resources on your behalf.
         * <p>
         * Default: - A role will be created that Amazon EMR service can assume.
         * <p>
         * @return {@code this}
         * @param serviceRole The IAM role that will be assumed by the Amazon EMR service to access AWS resources on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serviceRole(final software.amazon.awscdk.services.iam.IRole serviceRole) {
            this.props.serviceRole(serviceRole);
            return this;
        }

        /**
         * (experimental) Specifies the step concurrency level to allow multiple steps to run in parallel.
         * <p>
         * Requires EMR release label 5.28.0 or above.
         * Must be in range [1, 256].
         * <p>
         * Default: 1 - no step concurrency allowed
         * <p>
         * @return {@code this}
         * @param stepConcurrencyLevel Specifies the step concurrency level to allow multiple steps to run in parallel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stepConcurrencyLevel(final java.lang.Number stepConcurrencyLevel) {
            this.props.stepConcurrencyLevel(stepConcurrencyLevel);
            return this;
        }

        /**
         * (experimental) A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param tags A list of tags to associate with a cluster and propagate to Amazon EC2 instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * (experimental) A value of true indicates that all IAM users in the AWS account can perform cluster actions if they have the proper IAM policy permissions.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param visibleToAllUsers A value of true indicates that all IAM users in the AWS account can perform cluster actions if they have the proper IAM policy permissions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder visibleToAllUsers(final java.lang.Boolean visibleToAllUsers) {
            this.props.visibleToAllUsers(visibleToAllUsers);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
