package software.amazon.awscdk.services.synthetics;

/**
 * A CloudFormation `AWS::Synthetics::Canary`.
 * <p>
 * Creates or updates a canary. Canaries are scripts that monitor your endpoints and APIs from the outside-in. Canaries help you check the availability and latency of your web services and troubleshoot anomalies by investigating load time data, screenshots of the UI, logs, and metrics. You can set up a canary to run continuously or just once.
 * <p>
 * To create canaries, you must have the <code>CloudWatchSyntheticsFullAccess</code> policy. If you are creating a new IAM role for the canary, you also need the the <code>iam:CreateRole</code> , <code>iam:CreatePolicy</code> and <code>iam:AttachRolePolicy</code> permissions. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Roles">Necessary Roles and Permissions</a> .
 * <p>
 * Do not include secrets or proprietary information in your canary names. The canary name makes up part of the Amazon Resource Name (ARN) for the canary, and the ARN is included in outbound calls over the internet. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html">Security Considerations for Synthetics Canaries</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.synthetics.*;
 * CfnCanary cfnCanary = CfnCanary.Builder.create(this, "MyCfnCanary")
 *         .artifactS3Location("artifactS3Location")
 *         .code(CodeProperty.builder()
 *                 .handler("handler")
 *                 // the properties below are optional
 *                 .s3Bucket("s3Bucket")
 *                 .s3Key("s3Key")
 *                 .s3ObjectVersion("s3ObjectVersion")
 *                 .script("script")
 *                 .build())
 *         .executionRoleArn("executionRoleArn")
 *         .name("name")
 *         .runtimeVersion("runtimeVersion")
 *         .schedule(ScheduleProperty.builder()
 *                 .expression("expression")
 *                 // the properties below are optional
 *                 .durationInSeconds("durationInSeconds")
 *                 .build())
 *         .startCanaryAfterCreation(false)
 *         // the properties below are optional
 *         .artifactConfig(ArtifactConfigProperty.builder()
 *                 .s3Encryption(S3EncryptionProperty.builder()
 *                         .encryptionMode("encryptionMode")
 *                         .kmsKeyArn("kmsKeyArn")
 *                         .build())
 *                 .build())
 *         .deleteLambdaResourcesOnCanaryDeletion(false)
 *         .failureRetentionPeriod(123)
 *         .runConfig(RunConfigProperty.builder()
 *                 .activeTracing(false)
 *                 .environmentVariables(Map.of(
 *                         "environmentVariablesKey", "environmentVariables"))
 *                 .memoryInMb(123)
 *                 .timeoutInSeconds(123)
 *                 .build())
 *         .successRetentionPeriod(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .visualReference(VisualReferenceProperty.builder()
 *                 .baseCanaryRunId("baseCanaryRunId")
 *                 // the properties below are optional
 *                 .baseScreenshots(List.of(BaseScreenshotProperty.builder()
 *                         .screenshotName("screenshotName")
 *                         // the properties below are optional
 *                         .ignoreCoordinates(List.of("ignoreCoordinates"))
 *                         .build()))
 *                 .build())
 *         .vpcConfig(VPCConfigProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 // the properties below are optional
 *                 .vpcId("vpcId")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:11.157Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_synthetics.CfnCanary")
public class CfnCanary extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnCanary(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCanary(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.CfnCanary.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Synthetics::Canary`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCanary(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.CfnCanaryProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The state of the canary.
     * <p>
     * For example, <code>RUNNING</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrState() {
        return software.amazon.jsii.Kernel.get(this, "attrState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The list of key-value pairs that are associated with the canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The location in Amazon S3 where Synthetics stores artifacts from the runs of this canary.
     * <p>
     * Artifacts include the log file, screenshots, and HAR files. Specify the full location path, including <code>s3://</code> at the beginning of the path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getArtifactS3Location() {
        return software.amazon.jsii.Kernel.get(this, "artifactS3Location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The location in Amazon S3 where Synthetics stores artifacts from the runs of this canary.
     * <p>
     * Artifacts include the log file, screenshots, and HAR files. Specify the full location path, including <code>s3://</code> at the beginning of the path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArtifactS3Location(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "artifactS3Location", java.util.Objects.requireNonNull(value, "artifactS3Location is required"));
    }

    /**
     * Use this structure to input your script code for the canary.
     * <p>
     * This structure contains the Lambda handler with the location where the canary should start running the script. If the script is stored in an S3 bucket, the bucket name, key, and version are also included. If the script is passed into the canary directly, the script code is contained in the value of <code>Script</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getCode() {
        return software.amazon.jsii.Kernel.get(this, "code", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Use this structure to input your script code for the canary.
     * <p>
     * This structure contains the Lambda handler with the location where the canary should start running the script. If the script is stored in an S3 bucket, the bucket name, key, and version are also included. If the script is passed into the canary directly, the script code is contained in the value of <code>Script</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCode(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.CfnCanary.CodeProperty value) {
        software.amazon.jsii.Kernel.set(this, "code", java.util.Objects.requireNonNull(value, "code is required"));
    }

    /**
     * Use this structure to input your script code for the canary.
     * <p>
     * This structure contains the Lambda handler with the location where the canary should start running the script. If the script is stored in an S3 bucket, the bucket name, key, and version are also included. If the script is passed into the canary directly, the script code is contained in the value of <code>Script</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCode(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "code", java.util.Objects.requireNonNull(value, "code is required"));
    }

    /**
     * The ARN of the IAM role to be used to run the canary.
     * <p>
     * This role must already exist, and must include <code>lambda.amazonaws.com</code> as a principal in the trust policy. The role must also have the following permissions:
     * <p>
     * <ul>
     * <li><code>s3:PutObject</code></li>
     * <li><code>s3:GetBucketLocation</code></li>
     * <li><code>s3:ListAllMyBuckets</code></li>
     * <li><code>cloudwatch:PutMetricData</code></li>
     * <li><code>logs:CreateLogGroup</code></li>
     * <li><code>logs:CreateLogStream</code></li>
     * <li><code>logs:PutLogEvents</code></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getExecutionRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the IAM role to be used to run the canary.
     * <p>
     * This role must already exist, and must include <code>lambda.amazonaws.com</code> as a principal in the trust policy. The role must also have the following permissions:
     * <p>
     * <ul>
     * <li><code>s3:PutObject</code></li>
     * <li><code>s3:GetBucketLocation</code></li>
     * <li><code>s3:ListAllMyBuckets</code></li>
     * <li><code>cloudwatch:PutMetricData</code></li>
     * <li><code>logs:CreateLogGroup</code></li>
     * <li><code>logs:CreateLogStream</code></li>
     * <li><code>logs:PutLogEvents</code></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExecutionRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "executionRoleArn", java.util.Objects.requireNonNull(value, "executionRoleArn is required"));
    }

    /**
     * The name for this canary.
     * <p>
     * Be sure to give it a descriptive name that distinguishes it from other canaries in your account.
     * <p>
     * Do not include secrets or proprietary information in your canary names. The canary name makes up part of the canary ARN, and the ARN is included in outbound calls over the internet. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html">Security Considerations for Synthetics Canaries</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name for this canary.
     * <p>
     * Be sure to give it a descriptive name that distinguishes it from other canaries in your account.
     * <p>
     * Do not include secrets or proprietary information in your canary names. The canary name makes up part of the canary ARN, and the ARN is included in outbound calls over the internet. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html">Security Considerations for Synthetics Canaries</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * Specifies the runtime version to use for the canary.
     * <p>
     * For more information about runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">Canary Runtime Versions</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRuntimeVersion() {
        return software.amazon.jsii.Kernel.get(this, "runtimeVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the runtime version to use for the canary.
     * <p>
     * For more information about runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">Canary Runtime Versions</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuntimeVersion(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "runtimeVersion", java.util.Objects.requireNonNull(value, "runtimeVersion is required"));
    }

    /**
     * A structure that contains information about how often the canary is to run, and when these runs are to stop.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSchedule() {
        return software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure that contains information about how often the canary is to run, and when these runs are to stop.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.CfnCanary.ScheduleProperty value) {
        software.amazon.jsii.Kernel.set(this, "schedule", java.util.Objects.requireNonNull(value, "schedule is required"));
    }

    /**
     * A structure that contains information about how often the canary is to run, and when these runs are to stop.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "schedule", java.util.Objects.requireNonNull(value, "schedule is required"));
    }

    /**
     * Specify TRUE to have the canary start making runs immediately after it is created.
     * <p>
     * A canary that you create using CloudFormation can't be used to monitor the CloudFormation stack that creates the canary or to roll back that stack if there is a failure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getStartCanaryAfterCreation() {
        return software.amazon.jsii.Kernel.get(this, "startCanaryAfterCreation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specify TRUE to have the canary start making runs immediately after it is created.
     * <p>
     * A canary that you create using CloudFormation can't be used to monitor the CloudFormation stack that creates the canary or to roll back that stack if there is a failure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStartCanaryAfterCreation(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "startCanaryAfterCreation", java.util.Objects.requireNonNull(value, "startCanaryAfterCreation is required"));
    }

    /**
     * Specify TRUE to have the canary start making runs immediately after it is created.
     * <p>
     * A canary that you create using CloudFormation can't be used to monitor the CloudFormation stack that creates the canary or to roll back that stack if there is a failure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStartCanaryAfterCreation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "startCanaryAfterCreation", java.util.Objects.requireNonNull(value, "startCanaryAfterCreation is required"));
    }

    /**
     * A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getArtifactConfig() {
        return software.amazon.jsii.Kernel.get(this, "artifactConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArtifactConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.synthetics.CfnCanary.ArtifactConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "artifactConfig", value);
    }

    /**
     * A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArtifactConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "artifactConfig", value);
    }

    /**
     * Specifies whether AWS CloudFormation is to also delete the Lambda functions and layers used by this canary, when the canary is deleted.
     * <p>
     * The default is false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeleteLambdaResourcesOnCanaryDeletion() {
        return software.amazon.jsii.Kernel.get(this, "deleteLambdaResourcesOnCanaryDeletion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether AWS CloudFormation is to also delete the Lambda functions and layers used by this canary, when the canary is deleted.
     * <p>
     * The default is false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeleteLambdaResourcesOnCanaryDeletion(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "deleteLambdaResourcesOnCanaryDeletion", value);
    }

    /**
     * Specifies whether AWS CloudFormation is to also delete the Lambda functions and layers used by this canary, when the canary is deleted.
     * <p>
     * The default is false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeleteLambdaResourcesOnCanaryDeletion(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deleteLambdaResourcesOnCanaryDeletion", value);
    }

    /**
     * The number of days to retain data about failed runs of this canary.
     * <p>
     * If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getFailureRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "failureRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of days to retain data about failed runs of this canary.
     * <p>
     * If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFailureRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "failureRetentionPeriod", value);
    }

    /**
     * A structure that contains input information for a canary run.
     * <p>
     * If you omit this structure, the frequency of the canary is used as canary's timeout value, up to a maximum of 900 seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRunConfig() {
        return software.amazon.jsii.Kernel.get(this, "runConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure that contains input information for a canary run.
     * <p>
     * If you omit this structure, the frequency of the canary is used as canary's timeout value, up to a maximum of 900 seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRunConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.synthetics.CfnCanary.RunConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "runConfig", value);
    }

    /**
     * A structure that contains input information for a canary run.
     * <p>
     * If you omit this structure, the frequency of the canary is used as canary's timeout value, up to a maximum of 900 seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRunConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "runConfig", value);
    }

    /**
     * The number of days to retain data about successful runs of this canary.
     * <p>
     * If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getSuccessRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "successRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of days to retain data about successful runs of this canary.
     * <p>
     * If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSuccessRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "successRetentionPeriod", value);
    }

    /**
     * If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of the canary run to use as the baseline for screenshots, and the coordinates of any parts of the screen to ignore during the visual monitoring comparison.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVisualReference() {
        return software.amazon.jsii.Kernel.get(this, "visualReference", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of the canary run to use as the baseline for screenshots, and the coordinates of any parts of the screen to ignore during the visual monitoring comparison.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVisualReference(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.synthetics.CfnCanary.VisualReferenceProperty value) {
        software.amazon.jsii.Kernel.set(this, "visualReference", value);
    }

    /**
     * If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of the canary run to use as the baseline for screenshots, and the coordinates of any parts of the screen to ignore during the visual monitoring comparison.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVisualReference(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "visualReference", value);
    }

    /**
     * If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security groups of the VPC endpoint.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">Running a Canary in a VPC</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfig() {
        return software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security groups of the VPC endpoint.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">Running a Canary in a VPC</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.synthetics.CfnCanary.VPCConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfig", value);
    }

    /**
     * If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security groups of the VPC endpoint.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">Running a Canary in a VPC</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfig", value);
    }
    /**
     * A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3 .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.synthetics.*;
     * ArtifactConfigProperty artifactConfigProperty = ArtifactConfigProperty.builder()
     *         .s3Encryption(S3EncryptionProperty.builder()
     *                 .encryptionMode("encryptionMode")
     *                 .kmsKeyArn("kmsKeyArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_synthetics.CfnCanary.ArtifactConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ArtifactConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArtifactConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A structure that contains the configuration of the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3 .
         * <p>
         * Artifact encryption functionality is available only for canaries that use Synthetics runtime version syn-nodejs-puppeteer-3.3 or later. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_artifact_encryption.html">Encrypting canary artifacts</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Encryption() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ArtifactConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArtifactConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArtifactConfigProperty> {
            java.lang.Object s3Encryption;

            /**
             * Sets the value of {@link ArtifactConfigProperty#getS3Encryption}
             * @param s3Encryption A structure that contains the configuration of the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3 .
             *                     Artifact encryption functionality is available only for canaries that use Synthetics runtime version syn-nodejs-puppeteer-3.3 or later. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_artifact_encryption.html">Encrypting canary artifacts</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Encryption(software.amazon.awscdk.services.synthetics.CfnCanary.S3EncryptionProperty s3Encryption) {
                this.s3Encryption = s3Encryption;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactConfigProperty#getS3Encryption}
             * @param s3Encryption A structure that contains the configuration of the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3 .
             *                     Artifact encryption functionality is available only for canaries that use Synthetics runtime version syn-nodejs-puppeteer-3.3 or later. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_artifact_encryption.html">Encrypting canary artifacts</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Encryption(software.amazon.awscdk.core.IResolvable s3Encryption) {
                this.s3Encryption = s3Encryption;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArtifactConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArtifactConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArtifactConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArtifactConfigProperty {
            private final java.lang.Object s3Encryption;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Encryption = software.amazon.jsii.Kernel.get(this, "s3Encryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Encryption = builder.s3Encryption;
            }

            @Override
            public final java.lang.Object getS3Encryption() {
                return this.s3Encryption;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3Encryption() != null) {
                    data.set("s3Encryption", om.valueToTree(this.getS3Encryption()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_synthetics.CfnCanary.ArtifactConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArtifactConfigProperty.Jsii$Proxy that = (ArtifactConfigProperty.Jsii$Proxy) o;

                return this.s3Encryption != null ? this.s3Encryption.equals(that.s3Encryption) : that.s3Encryption == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3Encryption != null ? this.s3Encryption.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A structure representing a screenshot that is used as a baseline during visual monitoring comparisons made by the canary.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.synthetics.*;
     * BaseScreenshotProperty baseScreenshotProperty = BaseScreenshotProperty.builder()
     *         .screenshotName("screenshotName")
     *         // the properties below are optional
     *         .ignoreCoordinates(List.of("ignoreCoordinates"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_synthetics.CfnCanary.BaseScreenshotProperty")
    @software.amazon.jsii.Jsii.Proxy(BaseScreenshotProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BaseScreenshotProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the screenshot.
         * <p>
         * This is generated the first time the canary is run after the <code>UpdateCanary</code> operation that specified for this canary to perform visual monitoring.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScreenshotName();

        /**
         * Coordinates that define the part of a screen to ignore during screenshot comparisons.
         * <p>
         * To obtain the coordinates to use here, use the CloudWatch Logs console to draw the boundaries on the screen. For more information, see {LINK}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIgnoreCoordinates() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BaseScreenshotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BaseScreenshotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BaseScreenshotProperty> {
            java.lang.String screenshotName;
            java.util.List<java.lang.String> ignoreCoordinates;

            /**
             * Sets the value of {@link BaseScreenshotProperty#getScreenshotName}
             * @param screenshotName The name of the screenshot. This parameter is required.
             *                       This is generated the first time the canary is run after the <code>UpdateCanary</code> operation that specified for this canary to perform visual monitoring.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder screenshotName(java.lang.String screenshotName) {
                this.screenshotName = screenshotName;
                return this;
            }

            /**
             * Sets the value of {@link BaseScreenshotProperty#getIgnoreCoordinates}
             * @param ignoreCoordinates Coordinates that define the part of a screen to ignore during screenshot comparisons.
             *                          To obtain the coordinates to use here, use the CloudWatch Logs console to draw the boundaries on the screen. For more information, see {LINK}
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ignoreCoordinates(java.util.List<java.lang.String> ignoreCoordinates) {
                this.ignoreCoordinates = ignoreCoordinates;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BaseScreenshotProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BaseScreenshotProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BaseScreenshotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaseScreenshotProperty {
            private final java.lang.String screenshotName;
            private final java.util.List<java.lang.String> ignoreCoordinates;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.screenshotName = software.amazon.jsii.Kernel.get(this, "screenshotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ignoreCoordinates = software.amazon.jsii.Kernel.get(this, "ignoreCoordinates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.screenshotName = java.util.Objects.requireNonNull(builder.screenshotName, "screenshotName is required");
                this.ignoreCoordinates = builder.ignoreCoordinates;
            }

            @Override
            public final java.lang.String getScreenshotName() {
                return this.screenshotName;
            }

            @Override
            public final java.util.List<java.lang.String> getIgnoreCoordinates() {
                return this.ignoreCoordinates;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("screenshotName", om.valueToTree(this.getScreenshotName()));
                if (this.getIgnoreCoordinates() != null) {
                    data.set("ignoreCoordinates", om.valueToTree(this.getIgnoreCoordinates()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_synthetics.CfnCanary.BaseScreenshotProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BaseScreenshotProperty.Jsii$Proxy that = (BaseScreenshotProperty.Jsii$Proxy) o;

                if (!screenshotName.equals(that.screenshotName)) return false;
                return this.ignoreCoordinates != null ? this.ignoreCoordinates.equals(that.ignoreCoordinates) : that.ignoreCoordinates == null;
            }

            @Override
            public final int hashCode() {
                int result = this.screenshotName.hashCode();
                result = 31 * result + (this.ignoreCoordinates != null ? this.ignoreCoordinates.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Use this structure to input your script code for the canary.
     * <p>
     * This structure contains the Lambda handler with the location where the canary should start running the script. If the script is stored in an S3 bucket, the bucket name, key, and version are also included. If the script is passed into the canary directly, the script code is contained in the value of <code>Script</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.synthetics.*;
     * CodeProperty codeProperty = CodeProperty.builder()
     *         .handler("handler")
     *         // the properties below are optional
     *         .s3Bucket("s3Bucket")
     *         .s3Key("s3Key")
     *         .s3ObjectVersion("s3ObjectVersion")
     *         .script("script")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_synthetics.CfnCanary.CodeProperty")
    @software.amazon.jsii.Jsii.Proxy(CodeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CodeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The entry point to use for the source code when running the canary.
         * <p>
         * For canaries that use the <code>syn-python-selenium-1.0</code> runtime or a <code>syn-nodejs.puppeteer</code> runtime earlier than <code>syn-nodejs.puppeteer-3.4</code> , the handler must be specified as <code>*fileName* .handler</code> . For <code>syn-python-selenium-1.1</code> , <code>syn-nodejs.puppeteer-3.4</code> , and later runtimes, the handler can be specified as <code>*fileName* . *functionName*</code> , or you can specify a folder where canary scripts reside as <code>*folder* / *fileName* . *functionName*</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHandler();

        /**
         * If your canary script is located in S3, specify the bucket name here.
         * <p>
         * The bucket must already exist.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3Bucket() {
            return null;
        }

        /**
         * The S3 key of your script.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingObjects.html">Working with Amazon S3 Objects</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3Key() {
            return null;
        }

        /**
         * The S3 version ID of your script.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3ObjectVersion() {
            return null;
        }

        /**
         * If you input your canary script directly into the canary instead of referring to an S3 location, the value of this parameter is the script in plain text.
         * <p>
         * It can be up to 5 MB.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScript() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CodeProperty> {
            java.lang.String handler;
            java.lang.String s3Bucket;
            java.lang.String s3Key;
            java.lang.String s3ObjectVersion;
            java.lang.String script;

            /**
             * Sets the value of {@link CodeProperty#getHandler}
             * @param handler The entry point to use for the source code when running the canary. This parameter is required.
             *                For canaries that use the <code>syn-python-selenium-1.0</code> runtime or a <code>syn-nodejs.puppeteer</code> runtime earlier than <code>syn-nodejs.puppeteer-3.4</code> , the handler must be specified as <code>*fileName* .handler</code> . For <code>syn-python-selenium-1.1</code> , <code>syn-nodejs.puppeteer-3.4</code> , and later runtimes, the handler can be specified as <code>*fileName* . *functionName*</code> , or you can specify a folder where canary scripts reside as <code>*folder* / *fileName* . *functionName*</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder handler(java.lang.String handler) {
                this.handler = handler;
                return this;
            }

            /**
             * Sets the value of {@link CodeProperty#getS3Bucket}
             * @param s3Bucket If your canary script is located in S3, specify the bucket name here.
             *                 The bucket must already exist.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Bucket(java.lang.String s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            /**
             * Sets the value of {@link CodeProperty#getS3Key}
             * @param s3Key The S3 key of your script.
             *              For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingObjects.html">Working with Amazon S3 Objects</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Key(java.lang.String s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            /**
             * Sets the value of {@link CodeProperty#getS3ObjectVersion}
             * @param s3ObjectVersion The S3 version ID of your script.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ObjectVersion(java.lang.String s3ObjectVersion) {
                this.s3ObjectVersion = s3ObjectVersion;
                return this;
            }

            /**
             * Sets the value of {@link CodeProperty#getScript}
             * @param script If you input your canary script directly into the canary instead of referring to an S3 location, the value of this parameter is the script in plain text.
             *               It can be up to 5 MB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder script(java.lang.String script) {
                this.script = script;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CodeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CodeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeProperty {
            private final java.lang.String handler;
            private final java.lang.String s3Bucket;
            private final java.lang.String s3Key;
            private final java.lang.String s3ObjectVersion;
            private final java.lang.String script;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.handler = software.amazon.jsii.Kernel.get(this, "handler", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Bucket = software.amazon.jsii.Kernel.get(this, "s3Bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Key = software.amazon.jsii.Kernel.get(this, "s3Key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3ObjectVersion = software.amazon.jsii.Kernel.get(this, "s3ObjectVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.script = software.amazon.jsii.Kernel.get(this, "script", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.handler = java.util.Objects.requireNonNull(builder.handler, "handler is required");
                this.s3Bucket = builder.s3Bucket;
                this.s3Key = builder.s3Key;
                this.s3ObjectVersion = builder.s3ObjectVersion;
                this.script = builder.script;
            }

            @Override
            public final java.lang.String getHandler() {
                return this.handler;
            }

            @Override
            public final java.lang.String getS3Bucket() {
                return this.s3Bucket;
            }

            @Override
            public final java.lang.String getS3Key() {
                return this.s3Key;
            }

            @Override
            public final java.lang.String getS3ObjectVersion() {
                return this.s3ObjectVersion;
            }

            @Override
            public final java.lang.String getScript() {
                return this.script;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("handler", om.valueToTree(this.getHandler()));
                if (this.getS3Bucket() != null) {
                    data.set("s3Bucket", om.valueToTree(this.getS3Bucket()));
                }
                if (this.getS3Key() != null) {
                    data.set("s3Key", om.valueToTree(this.getS3Key()));
                }
                if (this.getS3ObjectVersion() != null) {
                    data.set("s3ObjectVersion", om.valueToTree(this.getS3ObjectVersion()));
                }
                if (this.getScript() != null) {
                    data.set("script", om.valueToTree(this.getScript()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_synthetics.CfnCanary.CodeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CodeProperty.Jsii$Proxy that = (CodeProperty.Jsii$Proxy) o;

                if (!handler.equals(that.handler)) return false;
                if (this.s3Bucket != null ? !this.s3Bucket.equals(that.s3Bucket) : that.s3Bucket != null) return false;
                if (this.s3Key != null ? !this.s3Key.equals(that.s3Key) : that.s3Key != null) return false;
                if (this.s3ObjectVersion != null ? !this.s3ObjectVersion.equals(that.s3ObjectVersion) : that.s3ObjectVersion != null) return false;
                return this.script != null ? this.script.equals(that.script) : that.script == null;
            }

            @Override
            public final int hashCode() {
                int result = this.handler.hashCode();
                result = 31 * result + (this.s3Bucket != null ? this.s3Bucket.hashCode() : 0);
                result = 31 * result + (this.s3Key != null ? this.s3Key.hashCode() : 0);
                result = 31 * result + (this.s3ObjectVersion != null ? this.s3ObjectVersion.hashCode() : 0);
                result = 31 * result + (this.script != null ? this.script.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that contains input information for a canary run.
     * <p>
     * This structure is required.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.synthetics.*;
     * RunConfigProperty runConfigProperty = RunConfigProperty.builder()
     *         .activeTracing(false)
     *         .environmentVariables(Map.of(
     *                 "environmentVariablesKey", "environmentVariables"))
     *         .memoryInMb(123)
     *         .timeoutInSeconds(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_synthetics.CfnCanary.RunConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(RunConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RunConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether this canary is to use active AWS X-Ray tracing when it runs.
         * <p>
         * Active tracing enables this canary run to be displayed in the ServiceLens and X-Ray service maps even if the canary does not hit an endpoint that has X-Ray tracing enabled. Using X-Ray tracing incurs charges. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_tracing.html">Canaries and X-Ray tracing</a> .
         * <p>
         * You can enable active tracing only for canaries that use version <code>syn-nodejs-2.0</code> or later for their canary runtime.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getActiveTracing() {
            return null;
        }

        /**
         * Specifies the keys and values to use for any environment variables used in the canary script.
         * <p>
         * Use the following format:
         * <p>
         * { "key1" : "value1", "key2" : "value2", ...}
         * <p>
         * Keys must start with a letter and be at least two characters. The total size of your environment variables cannot exceed 4 KB. You can't specify any Lambda reserved environment variables as the keys for your environment variables. For more information about reserved keys, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime">Runtime environment variables</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironmentVariables() {
            return null;
        }

        /**
         * The maximum amount of memory that the canary can use while running.
         * <p>
         * This value must be a multiple of 64. The range is 960 to 3008.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMemoryInMb() {
            return null;
        }

        /**
         * How long the canary is allowed to run before it must stop.
         * <p>
         * You can't set this time to be longer than the frequency of the runs of this canary.
         * <p>
         * If you omit this field, the frequency of the canary is used as this value, up to a maximum of 900 seconds.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RunConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RunConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RunConfigProperty> {
            java.lang.Object activeTracing;
            java.lang.Object environmentVariables;
            java.lang.Number memoryInMb;
            java.lang.Number timeoutInSeconds;

            /**
             * Sets the value of {@link RunConfigProperty#getActiveTracing}
             * @param activeTracing Specifies whether this canary is to use active AWS X-Ray tracing when it runs.
             *                      Active tracing enables this canary run to be displayed in the ServiceLens and X-Ray service maps even if the canary does not hit an endpoint that has X-Ray tracing enabled. Using X-Ray tracing incurs charges. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_tracing.html">Canaries and X-Ray tracing</a> .
             *                      <p>
             *                      You can enable active tracing only for canaries that use version <code>syn-nodejs-2.0</code> or later for their canary runtime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder activeTracing(java.lang.Boolean activeTracing) {
                this.activeTracing = activeTracing;
                return this;
            }

            /**
             * Sets the value of {@link RunConfigProperty#getActiveTracing}
             * @param activeTracing Specifies whether this canary is to use active AWS X-Ray tracing when it runs.
             *                      Active tracing enables this canary run to be displayed in the ServiceLens and X-Ray service maps even if the canary does not hit an endpoint that has X-Ray tracing enabled. Using X-Ray tracing incurs charges. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_tracing.html">Canaries and X-Ray tracing</a> .
             *                      <p>
             *                      You can enable active tracing only for canaries that use version <code>syn-nodejs-2.0</code> or later for their canary runtime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder activeTracing(software.amazon.awscdk.core.IResolvable activeTracing) {
                this.activeTracing = activeTracing;
                return this;
            }

            /**
             * Sets the value of {@link RunConfigProperty#getEnvironmentVariables}
             * @param environmentVariables Specifies the keys and values to use for any environment variables used in the canary script.
             *                             Use the following format:
             *                             <p>
             *                             { "key1" : "value1", "key2" : "value2", ...}
             *                             <p>
             *                             Keys must start with a letter and be at least two characters. The total size of your environment variables cannot exceed 4 KB. You can't specify any Lambda reserved environment variables as the keys for your environment variables. For more information about reserved keys, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime">Runtime environment variables</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentVariables(software.amazon.awscdk.core.IResolvable environmentVariables) {
                this.environmentVariables = environmentVariables;
                return this;
            }

            /**
             * Sets the value of {@link RunConfigProperty#getEnvironmentVariables}
             * @param environmentVariables Specifies the keys and values to use for any environment variables used in the canary script.
             *                             Use the following format:
             *                             <p>
             *                             { "key1" : "value1", "key2" : "value2", ...}
             *                             <p>
             *                             Keys must start with a letter and be at least two characters. The total size of your environment variables cannot exceed 4 KB. You can't specify any Lambda reserved environment variables as the keys for your environment variables. For more information about reserved keys, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime">Runtime environment variables</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentVariables(java.util.Map<java.lang.String, java.lang.String> environmentVariables) {
                this.environmentVariables = environmentVariables;
                return this;
            }

            /**
             * Sets the value of {@link RunConfigProperty#getMemoryInMb}
             * @param memoryInMb The maximum amount of memory that the canary can use while running.
             *                   This value must be a multiple of 64. The range is 960 to 3008.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryInMb(java.lang.Number memoryInMb) {
                this.memoryInMb = memoryInMb;
                return this;
            }

            /**
             * Sets the value of {@link RunConfigProperty#getTimeoutInSeconds}
             * @param timeoutInSeconds How long the canary is allowed to run before it must stop.
             *                         You can't set this time to be longer than the frequency of the runs of this canary.
             *                         <p>
             *                         If you omit this field, the frequency of the canary is used as this value, up to a maximum of 900 seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutInSeconds(java.lang.Number timeoutInSeconds) {
                this.timeoutInSeconds = timeoutInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RunConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RunConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RunConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RunConfigProperty {
            private final java.lang.Object activeTracing;
            private final java.lang.Object environmentVariables;
            private final java.lang.Number memoryInMb;
            private final java.lang.Number timeoutInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.activeTracing = software.amazon.jsii.Kernel.get(this, "activeTracing", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.environmentVariables = software.amazon.jsii.Kernel.get(this, "environmentVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.memoryInMb = software.amazon.jsii.Kernel.get(this, "memoryInMb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.timeoutInSeconds = software.amazon.jsii.Kernel.get(this, "timeoutInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.activeTracing = builder.activeTracing;
                this.environmentVariables = builder.environmentVariables;
                this.memoryInMb = builder.memoryInMb;
                this.timeoutInSeconds = builder.timeoutInSeconds;
            }

            @Override
            public final java.lang.Object getActiveTracing() {
                return this.activeTracing;
            }

            @Override
            public final java.lang.Object getEnvironmentVariables() {
                return this.environmentVariables;
            }

            @Override
            public final java.lang.Number getMemoryInMb() {
                return this.memoryInMb;
            }

            @Override
            public final java.lang.Number getTimeoutInSeconds() {
                return this.timeoutInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getActiveTracing() != null) {
                    data.set("activeTracing", om.valueToTree(this.getActiveTracing()));
                }
                if (this.getEnvironmentVariables() != null) {
                    data.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
                }
                if (this.getMemoryInMb() != null) {
                    data.set("memoryInMb", om.valueToTree(this.getMemoryInMb()));
                }
                if (this.getTimeoutInSeconds() != null) {
                    data.set("timeoutInSeconds", om.valueToTree(this.getTimeoutInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_synthetics.CfnCanary.RunConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RunConfigProperty.Jsii$Proxy that = (RunConfigProperty.Jsii$Proxy) o;

                if (this.activeTracing != null ? !this.activeTracing.equals(that.activeTracing) : that.activeTracing != null) return false;
                if (this.environmentVariables != null ? !this.environmentVariables.equals(that.environmentVariables) : that.environmentVariables != null) return false;
                if (this.memoryInMb != null ? !this.memoryInMb.equals(that.memoryInMb) : that.memoryInMb != null) return false;
                return this.timeoutInSeconds != null ? this.timeoutInSeconds.equals(that.timeoutInSeconds) : that.timeoutInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.activeTracing != null ? this.activeTracing.hashCode() : 0;
                result = 31 * result + (this.environmentVariables != null ? this.environmentVariables.hashCode() : 0);
                result = 31 * result + (this.memoryInMb != null ? this.memoryInMb.hashCode() : 0);
                result = 31 * result + (this.timeoutInSeconds != null ? this.timeoutInSeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that contains the configuration of the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3 .
     * <p>
     * Artifact encryption functionality is available only for canaries that use Synthetics runtime version syn-nodejs-puppeteer-3.3 or later. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_artifact_encryption.html">Encrypting canary artifacts</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.synthetics.*;
     * S3EncryptionProperty s3EncryptionProperty = S3EncryptionProperty.builder()
     *         .encryptionMode("encryptionMode")
     *         .kmsKeyArn("kmsKeyArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_synthetics.CfnCanary.S3EncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(S3EncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3EncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The encryption method to use for artifacts created by this canary.
         * <p>
         * Specify <code>SSE_S3</code> to use server-side encryption (SSE) with an Amazon S3-managed key. Specify <code>SSE-KMS</code> to use server-side encryption with a customer-managed AWS KMS key.
         * <p>
         * If you omit this parameter, an AWS -managed AWS KMS key is used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionMode() {
            return null;
        }

        /**
         * The ARN of the customer-managed AWS KMS key to use, if you specify `SSE-KMS` for `EncryptionMode`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3EncryptionProperty> {
            java.lang.String encryptionMode;
            java.lang.String kmsKeyArn;

            /**
             * Sets the value of {@link S3EncryptionProperty#getEncryptionMode}
             * @param encryptionMode The encryption method to use for artifacts created by this canary.
             *                       Specify <code>SSE_S3</code> to use server-side encryption (SSE) with an Amazon S3-managed key. Specify <code>SSE-KMS</code> to use server-side encryption with a customer-managed AWS KMS key.
             *                       <p>
             *                       If you omit this parameter, an AWS -managed AWS KMS key is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionMode(java.lang.String encryptionMode) {
                this.encryptionMode = encryptionMode;
                return this;
            }

            /**
             * Sets the value of {@link S3EncryptionProperty#getKmsKeyArn}
             * @param kmsKeyArn The ARN of the customer-managed AWS KMS key to use, if you specify `SSE-KMS` for `EncryptionMode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3EncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3EncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3EncryptionProperty {
            private final java.lang.String encryptionMode;
            private final java.lang.String kmsKeyArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionMode = software.amazon.jsii.Kernel.get(this, "encryptionMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionMode = builder.encryptionMode;
                this.kmsKeyArn = builder.kmsKeyArn;
            }

            @Override
            public final java.lang.String getEncryptionMode() {
                return this.encryptionMode;
            }

            @Override
            public final java.lang.String getKmsKeyArn() {
                return this.kmsKeyArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEncryptionMode() != null) {
                    data.set("encryptionMode", om.valueToTree(this.getEncryptionMode()));
                }
                if (this.getKmsKeyArn() != null) {
                    data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_synthetics.CfnCanary.S3EncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3EncryptionProperty.Jsii$Proxy that = (S3EncryptionProperty.Jsii$Proxy) o;

                if (this.encryptionMode != null ? !this.encryptionMode.equals(that.encryptionMode) : that.encryptionMode != null) return false;
                return this.kmsKeyArn != null ? this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encryptionMode != null ? this.encryptionMode.hashCode() : 0;
                result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This structure specifies how often a canary is to make runs and the date and time when it should stop making runs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.synthetics.*;
     * ScheduleProperty scheduleProperty = ScheduleProperty.builder()
     *         .expression("expression")
     *         // the properties below are optional
     *         .durationInSeconds("durationInSeconds")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_synthetics.CfnCanary.ScheduleProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A `rate` expression or a `cron` expression that defines how often the canary is to run.
         * <p>
         * For a rate expression, The syntax is <code>rate( *number unit* )</code> . <em>unit</em> can be <code>minute</code> , <code>minutes</code> , or <code>hour</code> .
         * <p>
         * For example, <code>rate(1 minute)</code> runs the canary once a minute, <code>rate(10 minutes)</code> runs it once every 10 minutes, and <code>rate(1 hour)</code> runs it once every hour. You can specify a frequency between <code>rate(1 minute)</code> and <code>rate(1 hour)</code> .
         * <p>
         * Specifying <code>rate(0 minute)</code> or <code>rate(0 hour)</code> is a special value that causes the canary to run only once when it is started.
         * <p>
         * Use <code>cron( *expression* )</code> to specify a cron expression. You can't schedule a canary to wait for more than a year before running. For information about the syntax for cron expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html">Scheduling canary runs using cron</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExpression();

        /**
         * How long, in seconds, for the canary to continue making regular runs according to the schedule in the `Expression` value.
         * <p>
         * If you specify 0, the canary continues making runs until you stop it. If you omit this field, the default of 0 is used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDurationInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduleProperty> {
            java.lang.String expression;
            java.lang.String durationInSeconds;

            /**
             * Sets the value of {@link ScheduleProperty#getExpression}
             * @param expression A `rate` expression or a `cron` expression that defines how often the canary is to run. This parameter is required.
             *                   For a rate expression, The syntax is <code>rate( *number unit* )</code> . <em>unit</em> can be <code>minute</code> , <code>minutes</code> , or <code>hour</code> .
             *                   <p>
             *                   For example, <code>rate(1 minute)</code> runs the canary once a minute, <code>rate(10 minutes)</code> runs it once every 10 minutes, and <code>rate(1 hour)</code> runs it once every hour. You can specify a frequency between <code>rate(1 minute)</code> and <code>rate(1 hour)</code> .
             *                   <p>
             *                   Specifying <code>rate(0 minute)</code> or <code>rate(0 hour)</code> is a special value that causes the canary to run only once when it is started.
             *                   <p>
             *                   Use <code>cron( *expression* )</code> to specify a cron expression. You can't schedule a canary to wait for more than a year before running. For information about the syntax for cron expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html">Scheduling canary runs using cron</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getDurationInSeconds}
             * @param durationInSeconds How long, in seconds, for the canary to continue making regular runs according to the schedule in the `Expression` value.
             *                          If you specify 0, the canary continues making runs until you stop it. If you omit this field, the default of 0 is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationInSeconds(java.lang.String durationInSeconds) {
                this.durationInSeconds = durationInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleProperty {
            private final java.lang.String expression;
            private final java.lang.String durationInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.durationInSeconds = software.amazon.jsii.Kernel.get(this, "durationInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.expression = java.util.Objects.requireNonNull(builder.expression, "expression is required");
                this.durationInSeconds = builder.durationInSeconds;
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            public final java.lang.String getDurationInSeconds() {
                return this.durationInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("expression", om.valueToTree(this.getExpression()));
                if (this.getDurationInSeconds() != null) {
                    data.set("durationInSeconds", om.valueToTree(this.getDurationInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_synthetics.CfnCanary.ScheduleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduleProperty.Jsii$Proxy that = (ScheduleProperty.Jsii$Proxy) o;

                if (!expression.equals(that.expression)) return false;
                return this.durationInSeconds != null ? this.durationInSeconds.equals(that.durationInSeconds) : that.durationInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.expression.hashCode();
                result = 31 * result + (this.durationInSeconds != null ? this.durationInSeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security groups of the VPC endpoint.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">Running a Canary in a VPC</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.synthetics.*;
     * VPCConfigProperty vPCConfigProperty = VPCConfigProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnetIds(List.of("subnetIds"))
     *         // the properties below are optional
     *         .vpcId("vpcId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_synthetics.CfnCanary.VPCConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(VPCConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VPCConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IDs of the security groups for this canary.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupIds();

        /**
         * The IDs of the subnets where this canary is to run.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds();

        /**
         * The ID of the VPC where this canary is to run.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VPCConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VPCConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VPCConfigProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnetIds;
            java.lang.String vpcId;

            /**
             * Sets the value of {@link VPCConfigProperty#getSecurityGroupIds}
             * @param securityGroupIds The IDs of the security groups for this canary. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VPCConfigProperty#getSubnetIds}
             * @param subnetIds The IDs of the subnets where this canary is to run. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            /**
             * Sets the value of {@link VPCConfigProperty#getVpcId}
             * @param vpcId The ID of the VPC where this canary is to run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcId(java.lang.String vpcId) {
                this.vpcId = vpcId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VPCConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VPCConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VPCConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VPCConfigProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnetIds;
            private final java.lang.String vpcId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = java.util.Objects.requireNonNull(builder.securityGroupIds, "securityGroupIds is required");
                this.subnetIds = java.util.Objects.requireNonNull(builder.subnetIds, "subnetIds is required");
                this.vpcId = builder.vpcId;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnetIds() {
                return this.subnetIds;
            }

            @Override
            public final java.lang.String getVpcId() {
                return this.vpcId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                if (this.getVpcId() != null) {
                    data.set("vpcId", om.valueToTree(this.getVpcId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_synthetics.CfnCanary.VPCConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VPCConfigProperty.Jsii$Proxy that = (VPCConfigProperty.Jsii$Proxy) o;

                if (!securityGroupIds.equals(that.securityGroupIds)) return false;
                if (!subnetIds.equals(that.subnetIds)) return false;
                return this.vpcId != null ? this.vpcId.equals(that.vpcId) : that.vpcId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds.hashCode();
                result = 31 * result + (this.subnetIds.hashCode());
                result = 31 * result + (this.vpcId != null ? this.vpcId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the screenshots to use as the baseline for comparisons during visual monitoring comparisons during future runs of this canary.
     * <p>
     * If you omit this parameter, no changes are made to any baseline screenshots that the canary might be using already.
     * <p>
     * Visual monitoring is supported only on canaries running the <em>syn-puppeteer-node-3.2</em> runtime or later. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_SyntheticsLogger_VisualTesting.html">Visual monitoring</a> and <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Blueprints_VisualTesting.html">Visual monitoring blueprint</a>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.synthetics.*;
     * VisualReferenceProperty visualReferenceProperty = VisualReferenceProperty.builder()
     *         .baseCanaryRunId("baseCanaryRunId")
     *         // the properties below are optional
     *         .baseScreenshots(List.of(BaseScreenshotProperty.builder()
     *                 .screenshotName("screenshotName")
     *                 // the properties below are optional
     *                 .ignoreCoordinates(List.of("ignoreCoordinates"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_synthetics.CfnCanary.VisualReferenceProperty")
    @software.amazon.jsii.Jsii.Proxy(VisualReferenceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VisualReferenceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies which canary run to use the screenshots from as the baseline for future visual monitoring with this canary.
         * <p>
         * Valid values are <code>nextrun</code> to use the screenshots from the next run after this update is made, <code>lastrun</code> to use the screenshots from the most recent run before this update was made, or the value of <code>Id</code> in the <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CanaryRun.html">CanaryRun</a> from any past run of this canary.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBaseCanaryRunId();

        /**
         * An array of screenshots that are used as the baseline for comparisons during visual monitoring.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBaseScreenshots() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VisualReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VisualReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VisualReferenceProperty> {
            java.lang.String baseCanaryRunId;
            java.lang.Object baseScreenshots;

            /**
             * Sets the value of {@link VisualReferenceProperty#getBaseCanaryRunId}
             * @param baseCanaryRunId Specifies which canary run to use the screenshots from as the baseline for future visual monitoring with this canary. This parameter is required.
             *                        Valid values are <code>nextrun</code> to use the screenshots from the next run after this update is made, <code>lastrun</code> to use the screenshots from the most recent run before this update was made, or the value of <code>Id</code> in the <a href="https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CanaryRun.html">CanaryRun</a> from any past run of this canary.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baseCanaryRunId(java.lang.String baseCanaryRunId) {
                this.baseCanaryRunId = baseCanaryRunId;
                return this;
            }

            /**
             * Sets the value of {@link VisualReferenceProperty#getBaseScreenshots}
             * @param baseScreenshots An array of screenshots that are used as the baseline for comparisons during visual monitoring.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baseScreenshots(software.amazon.awscdk.core.IResolvable baseScreenshots) {
                this.baseScreenshots = baseScreenshots;
                return this;
            }

            /**
             * Sets the value of {@link VisualReferenceProperty#getBaseScreenshots}
             * @param baseScreenshots An array of screenshots that are used as the baseline for comparisons during visual monitoring.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baseScreenshots(java.util.List<? extends java.lang.Object> baseScreenshots) {
                this.baseScreenshots = baseScreenshots;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VisualReferenceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VisualReferenceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VisualReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VisualReferenceProperty {
            private final java.lang.String baseCanaryRunId;
            private final java.lang.Object baseScreenshots;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.baseCanaryRunId = software.amazon.jsii.Kernel.get(this, "baseCanaryRunId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.baseScreenshots = software.amazon.jsii.Kernel.get(this, "baseScreenshots", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.baseCanaryRunId = java.util.Objects.requireNonNull(builder.baseCanaryRunId, "baseCanaryRunId is required");
                this.baseScreenshots = builder.baseScreenshots;
            }

            @Override
            public final java.lang.String getBaseCanaryRunId() {
                return this.baseCanaryRunId;
            }

            @Override
            public final java.lang.Object getBaseScreenshots() {
                return this.baseScreenshots;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("baseCanaryRunId", om.valueToTree(this.getBaseCanaryRunId()));
                if (this.getBaseScreenshots() != null) {
                    data.set("baseScreenshots", om.valueToTree(this.getBaseScreenshots()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_synthetics.CfnCanary.VisualReferenceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VisualReferenceProperty.Jsii$Proxy that = (VisualReferenceProperty.Jsii$Proxy) o;

                if (!baseCanaryRunId.equals(that.baseCanaryRunId)) return false;
                return this.baseScreenshots != null ? this.baseScreenshots.equals(that.baseScreenshots) : that.baseScreenshots == null;
            }

            @Override
            public final int hashCode() {
                int result = this.baseCanaryRunId.hashCode();
                result = 31 * result + (this.baseScreenshots != null ? this.baseScreenshots.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.synthetics.CfnCanary}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.synthetics.CfnCanary> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.synthetics.CfnCanaryProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.synthetics.CfnCanaryProps.Builder();
        }

        /**
         * The location in Amazon S3 where Synthetics stores artifacts from the runs of this canary.
         * <p>
         * Artifacts include the log file, screenshots, and HAR files. Specify the full location path, including <code>s3://</code> at the beginning of the path.
         * <p>
         * @return {@code this}
         * @param artifactS3Location The location in Amazon S3 where Synthetics stores artifacts from the runs of this canary. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactS3Location(final java.lang.String artifactS3Location) {
            this.props.artifactS3Location(artifactS3Location);
            return this;
        }

        /**
         * Use this structure to input your script code for the canary.
         * <p>
         * This structure contains the Lambda handler with the location where the canary should start running the script. If the script is stored in an S3 bucket, the bucket name, key, and version are also included. If the script is passed into the canary directly, the script code is contained in the value of <code>Script</code> .
         * <p>
         * @return {@code this}
         * @param code Use this structure to input your script code for the canary. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(final software.amazon.awscdk.services.synthetics.CfnCanary.CodeProperty code) {
            this.props.code(code);
            return this;
        }
        /**
         * Use this structure to input your script code for the canary.
         * <p>
         * This structure contains the Lambda handler with the location where the canary should start running the script. If the script is stored in an S3 bucket, the bucket name, key, and version are also included. If the script is passed into the canary directly, the script code is contained in the value of <code>Script</code> .
         * <p>
         * @return {@code this}
         * @param code Use this structure to input your script code for the canary. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(final software.amazon.awscdk.core.IResolvable code) {
            this.props.code(code);
            return this;
        }

        /**
         * The ARN of the IAM role to be used to run the canary.
         * <p>
         * This role must already exist, and must include <code>lambda.amazonaws.com</code> as a principal in the trust policy. The role must also have the following permissions:
         * <p>
         * <ul>
         * <li><code>s3:PutObject</code></li>
         * <li><code>s3:GetBucketLocation</code></li>
         * <li><code>s3:ListAllMyBuckets</code></li>
         * <li><code>cloudwatch:PutMetricData</code></li>
         * <li><code>logs:CreateLogGroup</code></li>
         * <li><code>logs:CreateLogStream</code></li>
         * <li><code>logs:PutLogEvents</code></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param executionRoleArn The ARN of the IAM role to be used to run the canary. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleArn(final java.lang.String executionRoleArn) {
            this.props.executionRoleArn(executionRoleArn);
            return this;
        }

        /**
         * The name for this canary.
         * <p>
         * Be sure to give it a descriptive name that distinguishes it from other canaries in your account.
         * <p>
         * Do not include secrets or proprietary information in your canary names. The canary name makes up part of the canary ARN, and the ARN is included in outbound calls over the internet. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html">Security Considerations for Synthetics Canaries</a> .
         * <p>
         * @return {@code this}
         * @param name The name for this canary. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Specifies the runtime version to use for the canary.
         * <p>
         * For more information about runtime versions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html">Canary Runtime Versions</a> .
         * <p>
         * @return {@code this}
         * @param runtimeVersion Specifies the runtime version to use for the canary. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeVersion(final java.lang.String runtimeVersion) {
            this.props.runtimeVersion(runtimeVersion);
            return this;
        }

        /**
         * A structure that contains information about how often the canary is to run, and when these runs are to stop.
         * <p>
         * @return {@code this}
         * @param schedule A structure that contains information about how often the canary is to run, and when these runs are to stop. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.services.synthetics.CfnCanary.ScheduleProperty schedule) {
            this.props.schedule(schedule);
            return this;
        }
        /**
         * A structure that contains information about how often the canary is to run, and when these runs are to stop.
         * <p>
         * @return {@code this}
         * @param schedule A structure that contains information about how often the canary is to run, and when these runs are to stop. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.core.IResolvable schedule) {
            this.props.schedule(schedule);
            return this;
        }

        /**
         * Specify TRUE to have the canary start making runs immediately after it is created.
         * <p>
         * A canary that you create using CloudFormation can't be used to monitor the CloudFormation stack that creates the canary or to roll back that stack if there is a failure.
         * <p>
         * @return {@code this}
         * @param startCanaryAfterCreation Specify TRUE to have the canary start making runs immediately after it is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startCanaryAfterCreation(final java.lang.Boolean startCanaryAfterCreation) {
            this.props.startCanaryAfterCreation(startCanaryAfterCreation);
            return this;
        }
        /**
         * Specify TRUE to have the canary start making runs immediately after it is created.
         * <p>
         * A canary that you create using CloudFormation can't be used to monitor the CloudFormation stack that creates the canary or to roll back that stack if there is a failure.
         * <p>
         * @return {@code this}
         * @param startCanaryAfterCreation Specify TRUE to have the canary start making runs immediately after it is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startCanaryAfterCreation(final software.amazon.awscdk.core.IResolvable startCanaryAfterCreation) {
            this.props.startCanaryAfterCreation(startCanaryAfterCreation);
            return this;
        }

        /**
         * A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.
         * <p>
         * @return {@code this}
         * @param artifactConfig A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactConfig(final software.amazon.awscdk.services.synthetics.CfnCanary.ArtifactConfigProperty artifactConfig) {
            this.props.artifactConfig(artifactConfig);
            return this;
        }
        /**
         * A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.
         * <p>
         * @return {@code this}
         * @param artifactConfig A structure that contains the configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactConfig(final software.amazon.awscdk.core.IResolvable artifactConfig) {
            this.props.artifactConfig(artifactConfig);
            return this;
        }

        /**
         * Specifies whether AWS CloudFormation is to also delete the Lambda functions and layers used by this canary, when the canary is deleted.
         * <p>
         * The default is false.
         * <p>
         * @return {@code this}
         * @param deleteLambdaResourcesOnCanaryDeletion Specifies whether AWS CloudFormation is to also delete the Lambda functions and layers used by this canary, when the canary is deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteLambdaResourcesOnCanaryDeletion(final java.lang.Boolean deleteLambdaResourcesOnCanaryDeletion) {
            this.props.deleteLambdaResourcesOnCanaryDeletion(deleteLambdaResourcesOnCanaryDeletion);
            return this;
        }
        /**
         * Specifies whether AWS CloudFormation is to also delete the Lambda functions and layers used by this canary, when the canary is deleted.
         * <p>
         * The default is false.
         * <p>
         * @return {@code this}
         * @param deleteLambdaResourcesOnCanaryDeletion Specifies whether AWS CloudFormation is to also delete the Lambda functions and layers used by this canary, when the canary is deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteLambdaResourcesOnCanaryDeletion(final software.amazon.awscdk.core.IResolvable deleteLambdaResourcesOnCanaryDeletion) {
            this.props.deleteLambdaResourcesOnCanaryDeletion(deleteLambdaResourcesOnCanaryDeletion);
            return this;
        }

        /**
         * The number of days to retain data about failed runs of this canary.
         * <p>
         * If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
         * <p>
         * @return {@code this}
         * @param failureRetentionPeriod The number of days to retain data about failed runs of this canary. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failureRetentionPeriod(final java.lang.Number failureRetentionPeriod) {
            this.props.failureRetentionPeriod(failureRetentionPeriod);
            return this;
        }

        /**
         * A structure that contains input information for a canary run.
         * <p>
         * If you omit this structure, the frequency of the canary is used as canary's timeout value, up to a maximum of 900 seconds.
         * <p>
         * @return {@code this}
         * @param runConfig A structure that contains input information for a canary run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runConfig(final software.amazon.awscdk.services.synthetics.CfnCanary.RunConfigProperty runConfig) {
            this.props.runConfig(runConfig);
            return this;
        }
        /**
         * A structure that contains input information for a canary run.
         * <p>
         * If you omit this structure, the frequency of the canary is used as canary's timeout value, up to a maximum of 900 seconds.
         * <p>
         * @return {@code this}
         * @param runConfig A structure that contains input information for a canary run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runConfig(final software.amazon.awscdk.core.IResolvable runConfig) {
            this.props.runConfig(runConfig);
            return this;
        }

        /**
         * The number of days to retain data about successful runs of this canary.
         * <p>
         * If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
         * <p>
         * @return {@code this}
         * @param successRetentionPeriod The number of days to retain data about successful runs of this canary. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder successRetentionPeriod(final java.lang.Number successRetentionPeriod) {
            this.props.successRetentionPeriod(successRetentionPeriod);
            return this;
        }

        /**
         * The list of key-value pairs that are associated with the canary.
         * <p>
         * @return {@code this}
         * @param tags The list of key-value pairs that are associated with the canary. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of the canary run to use as the baseline for screenshots, and the coordinates of any parts of the screen to ignore during the visual monitoring comparison.
         * <p>
         * @return {@code this}
         * @param visualReference If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of the canary run to use as the baseline for screenshots, and the coordinates of any parts of the screen to ignore during the visual monitoring comparison. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visualReference(final software.amazon.awscdk.services.synthetics.CfnCanary.VisualReferenceProperty visualReference) {
            this.props.visualReference(visualReference);
            return this;
        }
        /**
         * If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of the canary run to use as the baseline for screenshots, and the coordinates of any parts of the screen to ignore during the visual monitoring comparison.
         * <p>
         * @return {@code this}
         * @param visualReference If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of the canary run to use as the baseline for screenshots, and the coordinates of any parts of the screen to ignore during the visual monitoring comparison. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visualReference(final software.amazon.awscdk.core.IResolvable visualReference) {
            this.props.visualReference(visualReference);
            return this;
        }

        /**
         * If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security groups of the VPC endpoint.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">Running a Canary in a VPC</a> .
         * <p>
         * @return {@code this}
         * @param vpcConfig If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security groups of the VPC endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(final software.amazon.awscdk.services.synthetics.CfnCanary.VPCConfigProperty vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }
        /**
         * If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security groups of the VPC endpoint.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html">Running a Canary in a VPC</a> .
         * <p>
         * @return {@code this}
         * @param vpcConfig If this canary is to test an endpoint in a VPC, this structure contains information about the subnet and security groups of the VPC endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(final software.amazon.awscdk.core.IResolvable vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.synthetics.CfnCanary}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.synthetics.CfnCanary build() {
            return new software.amazon.awscdk.services.synthetics.CfnCanary(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
