package software.amazon.awscdk.services.synthetics;

/**
 * (experimental) Runtime options for a canary.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Canary canary = Canary.Builder.create(this, "MyCanary")
 *         .schedule(Schedule.rate(Duration.minutes(5)))
 *         .test(Test.custom(CustomTestOptions.builder()
 *                 .code(Code.fromAsset(join(__dirname, "canary")))
 *                 .handler("index.handler")
 *                 .build()))
 *         .runtime(Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_1)
 *         .environmentVariables(Map.of(
 *                 "stage", "prod"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:11.180Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_synthetics.Runtime")
public class Runtime extends software.amazon.jsii.JsiiObject {

    protected Runtime(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Runtime(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        SYNTHETICS_1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_2_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_2_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_2_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_2_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_2_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_2_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_3_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_3_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_3_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_3_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_3_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_3_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_3_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_3_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_3_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_3_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_NODEJS_PUPPETEER_3_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_NODEJS_PUPPETEER_3_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
        SYNTHETICS_PYTHON_SELENIUM_1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.synthetics.Runtime.class, "SYNTHETICS_PYTHON_SELENIUM_1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Runtime.class));
    }

    /**
     * @param name The name of the runtime version. This parameter is required.
     * @param family The Lambda runtime family. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Runtime(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.RuntimeFamily family) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(family, "family is required") });
    }

    /**
     * (experimental) **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**.
     * <p>
     * <code>syn-1.0</code> includes the following:
     * <p>
     * <ul>
     * <li>Synthetics library 1.0</li>
     * <li>Synthetics handler code 1.0</li>
     * <li>Lambda runtime Node.js 10.x</li>
     * <li>Puppeteer-core version 1.14.0</li>
     * <li>The Chromium version that matches Puppeteer-core 1.14.0</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-1.0">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-1.0</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_1_0;

    /**
     * (experimental) **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**.
     * <p>
     * <code>syn-nodejs-2.0</code> includes the following:
     * <p>
     * <ul>
     * <li>Lambda runtime Node.js 10.x</li>
     * <li>Puppeteer-core version 3.3.0</li>
     * <li>Chromium version 83.0.4103.0</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.0">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.0</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_2_0;

    /**
     * (experimental) **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**.
     * <p>
     * <code>syn-nodejs-2.1</code> includes the following:
     * <p>
     * <ul>
     * <li>Lambda runtime Node.js 10.x</li>
     * <li>Puppeteer-core version 3.3.0</li>
     * <li>Chromium version 83.0.4103.0</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.1">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.1</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_2_1;

    /**
     * (experimental) **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**.
     * <p>
     * <code>syn-nodejs-2.2</code> includes the following:
     * <p>
     * <ul>
     * <li>Lambda runtime Node.js 10.x</li>
     * <li>Puppeteer-core version 3.3.0</li>
     * <li>Chromium version 83.0.4103.0</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.2">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.2</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_2_2;

    /**
     * (experimental) `syn-nodejs-puppeteer-3.0` includes the following: - Lambda runtime Node.js 12.x - Puppeteer-core version 5.5.0 - Chromium version 88.0.4298.0.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.0">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.0</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_PUPPETEER_3_0;

    /**
     * (experimental) `syn-nodejs-puppeteer-3.1` includes the following: - Lambda runtime Node.js 12.x - Puppeteer-core version 5.5.0 - Chromium version 88.0.4298.0.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.1">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.1</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_PUPPETEER_3_1;

    /**
     * (experimental) `syn-nodejs-puppeteer-3.2` includes the following: - Lambda runtime Node.js 12.x - Puppeteer-core version 5.5.0 - Chromium version 88.0.4298.0.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.2">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.2</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_PUPPETEER_3_2;

    /**
     * (experimental) `syn-nodejs-puppeteer-3.3` includes the following: - Lambda runtime Node.js 12.x - Puppeteer-core version 5.5.0 - Chromium version 88.0.4298.0.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.3">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.3</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_PUPPETEER_3_3;

    /**
     * (experimental) `syn-nodejs-puppeteer-3.4` includes the following: - Lambda runtime Node.js 12.x - Puppeteer-core version 5.5.0 - Chromium version 88.0.4298.0.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.4">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.4</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_PUPPETEER_3_4;

    /**
     * (experimental) `syn-nodejs-puppeteer-3.5` includes the following: - Lambda runtime Node.js 14.x - Puppeteer-core version 10.1.0 - Chromium version 92.0.4512.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.5">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.5</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_NODEJS_PUPPETEER_3_5;

    /**
     * (experimental) `syn-python-selenium-1.0` includes the following: - Lambda runtime Python 3.8 - Selenium version 3.141.0 - Chromium version 83.0.4103.0.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.synthetics.Runtime SYNTHETICS_PYTHON_SELENIUM_1_0;

    /**
     * (experimental) The Lambda runtime family.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.RuntimeFamily getFamily() {
        return software.amazon.jsii.Kernel.get(this, "family", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.RuntimeFamily.class));
    }

    /**
     * (experimental) The name of the runtime version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
