package software.amazon.awscdk.services.timestream;

/**
 * A CloudFormation `AWS::Timestream::Table`.
 * <p>
 * The CreateTable operation adds a new table to an existing database in your account. In an AWS account, table names must be at least unique within each Region if they are in the same database. You may have identical table names in the same Region if the tables are in separate databases. While creating the table, you must specify the table name, database name, and the retention properties. <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a> . See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-table.html">code sample</a> for details.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.timestream.*;
 * CfnTable cfnTable = CfnTable.Builder.create(this, "MyCfnTable")
 *         .databaseName("databaseName")
 *         // the properties below are optional
 *         .magneticStoreWriteProperties(MagneticStoreWritePropertiesProperty.builder()
 *                 .enableMagneticStoreWrites(false)
 *                 // the properties below are optional
 *                 .magneticStoreRejectedDataLocation(MagneticStoreRejectedDataLocationProperty.builder()
 *                         .s3Configuration(S3ConfigurationProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 .encryptionOption("encryptionOption")
 *                                 // the properties below are optional
 *                                 .kmsKeyId("kmsKeyId")
 *                                 .objectKeyPrefix("objectKeyPrefix")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .retentionProperties(RetentionPropertiesProperty.builder()
 *                 .magneticStoreRetentionPeriodInDays("magneticStoreRetentionPeriodInDays")
 *                 .memoryStoreRetentionPeriodInHours("memoryStoreRetentionPeriodInHours")
 *                 .build())
 *         .tableName("tableName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:11.225Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_timestream.CfnTable")
public class CfnTable extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnTable(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTable(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.timestream.CfnTable.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Timestream::Table`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTable(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.timestream.CfnTableProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The `arn` of the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags to add to the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The name of the Timestream database that contains this table.
     * <p>
     * <em>Length Constraints</em> : Minimum length of 3 bytes. Maximum length of 256 bytes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName() {
        return software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Timestream database that contains this table.
     * <p>
     * <em>Length Constraints</em> : Minimum length of 3 bytes. Maximum length of 256 bytes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "databaseName", java.util.Objects.requireNonNull(value, "databaseName is required"));
    }

    /**
     * Contains properties to set on the table when enabling magnetic store writes.
     * <p>
     * This object has the following attributes:
     * <p>
     * <ul>
     * <li><em>EnableMagneticStoreWrites</em> : A <code>boolean</code> flag to enable magnetic store writes.</li>
     * <li><em>MagneticStoreRejectedDataLocation</em> : The location to write error reports for records rejected, asynchronously, during magnetic store writes. Only <code>S3Configuration</code> objects are allowed. The <code>S3Configuration</code> object has the following attributes:</li>
     * <li><em>BucketName</em> : The name of the S3 bucket.</li>
     * <li><em>EncryptionOption</em> : The encryption option for the S3 location. Valid values are S3 server-side encryption with an S3 managed key ( <code>SSE_S3</code> ) or AWS managed key ( <code>SSE_KMS</code> ).</li>
     * <li><em>KmsKeyId</em> : The AWS KMS key ID to use when encrypting with an AWS managed key.</li>
     * <li><em>ObjectKeyPrefix</em> : The prefix to use option for the objects stored in S3.</li>
     * </ul>
     * <p>
     * Both <code>BucketName</code> and <code>EncryptionOption</code> are <em>required</em> when <code>S3Configuration</code> is specified. If you specify <code>SSE_KMS</code> as your <code>EncryptionOption</code> then <code>KmsKeyId</code> is <em>required</em> .
     * <p>
     * <code>EnableMagneticStoreWrites</code> attribute is <em>required</em> when <code>MagneticStoreWriteProperties</code> is specified. <code>MagneticStoreRejectedDataLocation</code> attribute is <em>required</em> when <code>EnableMagneticStoreWrites</code> is set to <code>true</code> .
     * <p>
     * See the following examples:
     * <p>
     * <em>JSON</em>
     * <p>
     * <blockquote><pre>
     * { "Type" : AWS::Timestream::Table", "Properties":{ "DatabaseName":"TestDatabase", "TableName":"TestTable", "MagneticStoreWriteProperties":{ "EnableMagneticStoreWrites":true, "MagneticStoreRejectedDataLocation":{ "S3Configuration":{ "BucketName":"testbucket", "EncryptionOption":"SSE_KMS", "KmsKeyId":"1234abcd-12ab-34cd-56ef-1234567890ab", "ObjectKeyPrefix":"prefix" } } } }
     * }
     * </pre></blockquote>
     * <p>
     * <em>YAML</em>
     * <p>
     * <blockquote><pre>
     * Type: AWS::Timestream::Table
     * DependsOn: TestDatabase
     * Properties: TableName: "TestTable" DatabaseName: "TestDatabase" MagneticStoreWriteProperties: EnableMagneticStoreWrites: true MagneticStoreRejectedDataLocation: S3Configuration: BucketName: "testbucket" EncryptionOption: "SSE_KMS" KmsKeyId: "1234abcd-12ab-34cd-56ef-1234567890ab" ObjectKeyPrefix: "prefix"
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMagneticStoreWriteProperties() {
        return software.amazon.jsii.Kernel.get(this, "magneticStoreWriteProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains properties to set on the table when enabling magnetic store writes.
     * <p>
     * This object has the following attributes:
     * <p>
     * <ul>
     * <li><em>EnableMagneticStoreWrites</em> : A <code>boolean</code> flag to enable magnetic store writes.</li>
     * <li><em>MagneticStoreRejectedDataLocation</em> : The location to write error reports for records rejected, asynchronously, during magnetic store writes. Only <code>S3Configuration</code> objects are allowed. The <code>S3Configuration</code> object has the following attributes:</li>
     * <li><em>BucketName</em> : The name of the S3 bucket.</li>
     * <li><em>EncryptionOption</em> : The encryption option for the S3 location. Valid values are S3 server-side encryption with an S3 managed key ( <code>SSE_S3</code> ) or AWS managed key ( <code>SSE_KMS</code> ).</li>
     * <li><em>KmsKeyId</em> : The AWS KMS key ID to use when encrypting with an AWS managed key.</li>
     * <li><em>ObjectKeyPrefix</em> : The prefix to use option for the objects stored in S3.</li>
     * </ul>
     * <p>
     * Both <code>BucketName</code> and <code>EncryptionOption</code> are <em>required</em> when <code>S3Configuration</code> is specified. If you specify <code>SSE_KMS</code> as your <code>EncryptionOption</code> then <code>KmsKeyId</code> is <em>required</em> .
     * <p>
     * <code>EnableMagneticStoreWrites</code> attribute is <em>required</em> when <code>MagneticStoreWriteProperties</code> is specified. <code>MagneticStoreRejectedDataLocation</code> attribute is <em>required</em> when <code>EnableMagneticStoreWrites</code> is set to <code>true</code> .
     * <p>
     * See the following examples:
     * <p>
     * <em>JSON</em>
     * <p>
     * <blockquote><pre>
     * { "Type" : AWS::Timestream::Table", "Properties":{ "DatabaseName":"TestDatabase", "TableName":"TestTable", "MagneticStoreWriteProperties":{ "EnableMagneticStoreWrites":true, "MagneticStoreRejectedDataLocation":{ "S3Configuration":{ "BucketName":"testbucket", "EncryptionOption":"SSE_KMS", "KmsKeyId":"1234abcd-12ab-34cd-56ef-1234567890ab", "ObjectKeyPrefix":"prefix" } } } }
     * }
     * </pre></blockquote>
     * <p>
     * <em>YAML</em>
     * <p>
     * <blockquote><pre>
     * Type: AWS::Timestream::Table
     * DependsOn: TestDatabase
     * Properties: TableName: "TestTable" DatabaseName: "TestDatabase" MagneticStoreWriteProperties: EnableMagneticStoreWrites: true MagneticStoreRejectedDataLocation: S3Configuration: BucketName: "testbucket" EncryptionOption: "SSE_KMS" KmsKeyId: "1234abcd-12ab-34cd-56ef-1234567890ab" ObjectKeyPrefix: "prefix"
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMagneticStoreWriteProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.timestream.CfnTable.MagneticStoreWritePropertiesProperty value) {
        software.amazon.jsii.Kernel.set(this, "magneticStoreWriteProperties", value);
    }

    /**
     * Contains properties to set on the table when enabling magnetic store writes.
     * <p>
     * This object has the following attributes:
     * <p>
     * <ul>
     * <li><em>EnableMagneticStoreWrites</em> : A <code>boolean</code> flag to enable magnetic store writes.</li>
     * <li><em>MagneticStoreRejectedDataLocation</em> : The location to write error reports for records rejected, asynchronously, during magnetic store writes. Only <code>S3Configuration</code> objects are allowed. The <code>S3Configuration</code> object has the following attributes:</li>
     * <li><em>BucketName</em> : The name of the S3 bucket.</li>
     * <li><em>EncryptionOption</em> : The encryption option for the S3 location. Valid values are S3 server-side encryption with an S3 managed key ( <code>SSE_S3</code> ) or AWS managed key ( <code>SSE_KMS</code> ).</li>
     * <li><em>KmsKeyId</em> : The AWS KMS key ID to use when encrypting with an AWS managed key.</li>
     * <li><em>ObjectKeyPrefix</em> : The prefix to use option for the objects stored in S3.</li>
     * </ul>
     * <p>
     * Both <code>BucketName</code> and <code>EncryptionOption</code> are <em>required</em> when <code>S3Configuration</code> is specified. If you specify <code>SSE_KMS</code> as your <code>EncryptionOption</code> then <code>KmsKeyId</code> is <em>required</em> .
     * <p>
     * <code>EnableMagneticStoreWrites</code> attribute is <em>required</em> when <code>MagneticStoreWriteProperties</code> is specified. <code>MagneticStoreRejectedDataLocation</code> attribute is <em>required</em> when <code>EnableMagneticStoreWrites</code> is set to <code>true</code> .
     * <p>
     * See the following examples:
     * <p>
     * <em>JSON</em>
     * <p>
     * <blockquote><pre>
     * { "Type" : AWS::Timestream::Table", "Properties":{ "DatabaseName":"TestDatabase", "TableName":"TestTable", "MagneticStoreWriteProperties":{ "EnableMagneticStoreWrites":true, "MagneticStoreRejectedDataLocation":{ "S3Configuration":{ "BucketName":"testbucket", "EncryptionOption":"SSE_KMS", "KmsKeyId":"1234abcd-12ab-34cd-56ef-1234567890ab", "ObjectKeyPrefix":"prefix" } } } }
     * }
     * </pre></blockquote>
     * <p>
     * <em>YAML</em>
     * <p>
     * <blockquote><pre>
     * Type: AWS::Timestream::Table
     * DependsOn: TestDatabase
     * Properties: TableName: "TestTable" DatabaseName: "TestDatabase" MagneticStoreWriteProperties: EnableMagneticStoreWrites: true MagneticStoreRejectedDataLocation: S3Configuration: BucketName: "testbucket" EncryptionOption: "SSE_KMS" KmsKeyId: "1234abcd-12ab-34cd-56ef-1234567890ab" ObjectKeyPrefix: "prefix"
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMagneticStoreWriteProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "magneticStoreWriteProperties", value);
    }

    /**
     * The retention duration for the memory store and magnetic store. This object has the following attributes:.
     * <p>
     * <ul>
     * <li><em>MemoryStoreRetentionPeriodInHours</em> : Retention duration for memory store, in hours.</li>
     * <li><em>MagneticStoreRetentionPeriodInDays</em> : Retention duration for magnetic store, in days.</li>
     * </ul>
     * <p>
     * Both attributes are of type <code>string</code> . Both attributes are <em>required</em> when <code>RetentionProperties</code> is specified.
     * <p>
     * See the following examples:
     * <p>
     * <em>JSON</em>
     * <p>
     * <code>{ "Type" : AWS::Timestream::Table", "Properties" : { "DatabaseName" : "TestDatabase", "TableName" : "TestTable", "RetentionProperties" : { "MemoryStoreRetentionPeriodInHours": "24", "MagneticStoreRetentionPeriodInDays": "7" } } }</code>
     * <p>
     * <em>YAML</em>
     * <p>
     * <blockquote><pre>
     * Type: AWS::Timestream::Table
     * DependsOn: TestDatabase
     * Properties: TableName: "TestTable" DatabaseName: "TestDatabase" RetentionProperties: MemoryStoreRetentionPeriodInHours: "24" MagneticStoreRetentionPeriodInDays: "7"
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRetentionProperties() {
        return software.amazon.jsii.Kernel.get(this, "retentionProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The retention duration for the memory store and magnetic store. This object has the following attributes:.
     * <p>
     * <ul>
     * <li><em>MemoryStoreRetentionPeriodInHours</em> : Retention duration for memory store, in hours.</li>
     * <li><em>MagneticStoreRetentionPeriodInDays</em> : Retention duration for magnetic store, in days.</li>
     * </ul>
     * <p>
     * Both attributes are of type <code>string</code> . Both attributes are <em>required</em> when <code>RetentionProperties</code> is specified.
     * <p>
     * See the following examples:
     * <p>
     * <em>JSON</em>
     * <p>
     * <code>{ "Type" : AWS::Timestream::Table", "Properties" : { "DatabaseName" : "TestDatabase", "TableName" : "TestTable", "RetentionProperties" : { "MemoryStoreRetentionPeriodInHours": "24", "MagneticStoreRetentionPeriodInDays": "7" } } }</code>
     * <p>
     * <em>YAML</em>
     * <p>
     * <blockquote><pre>
     * Type: AWS::Timestream::Table
     * DependsOn: TestDatabase
     * Properties: TableName: "TestTable" DatabaseName: "TestDatabase" RetentionProperties: MemoryStoreRetentionPeriodInHours: "24" MagneticStoreRetentionPeriodInDays: "7"
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetentionProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.timestream.CfnTable.RetentionPropertiesProperty value) {
        software.amazon.jsii.Kernel.set(this, "retentionProperties", value);
    }

    /**
     * The retention duration for the memory store and magnetic store. This object has the following attributes:.
     * <p>
     * <ul>
     * <li><em>MemoryStoreRetentionPeriodInHours</em> : Retention duration for memory store, in hours.</li>
     * <li><em>MagneticStoreRetentionPeriodInDays</em> : Retention duration for magnetic store, in days.</li>
     * </ul>
     * <p>
     * Both attributes are of type <code>string</code> . Both attributes are <em>required</em> when <code>RetentionProperties</code> is specified.
     * <p>
     * See the following examples:
     * <p>
     * <em>JSON</em>
     * <p>
     * <code>{ "Type" : AWS::Timestream::Table", "Properties" : { "DatabaseName" : "TestDatabase", "TableName" : "TestTable", "RetentionProperties" : { "MemoryStoreRetentionPeriodInHours": "24", "MagneticStoreRetentionPeriodInDays": "7" } } }</code>
     * <p>
     * <em>YAML</em>
     * <p>
     * <blockquote><pre>
     * Type: AWS::Timestream::Table
     * DependsOn: TestDatabase
     * Properties: TableName: "TestTable" DatabaseName: "TestDatabase" RetentionProperties: MemoryStoreRetentionPeriodInHours: "24" MagneticStoreRetentionPeriodInDays: "7"
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetentionProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "retentionProperties", value);
    }

    /**
     * The name of the Timestream table.
     * <p>
     * <em>Length Constraints</em> : Minimum length of 3 bytes. Maximum length of 256 bytes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
        return software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Timestream table.
     * <p>
     * <em>Length Constraints</em> : Minimum length of 3 bytes. Maximum length of 256 bytes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTableName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tableName", value);
    }
    /**
     * The location to write error reports for records rejected, asynchronously, during magnetic store writes.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.timestream.*;
     * MagneticStoreRejectedDataLocationProperty magneticStoreRejectedDataLocationProperty = MagneticStoreRejectedDataLocationProperty.builder()
     *         .s3Configuration(S3ConfigurationProperty.builder()
     *                 .bucketName("bucketName")
     *                 .encryptionOption("encryptionOption")
     *                 // the properties below are optional
     *                 .kmsKeyId("kmsKeyId")
     *                 .objectKeyPrefix("objectKeyPrefix")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_timestream.CfnTable.MagneticStoreRejectedDataLocationProperty")
    @software.amazon.jsii.Jsii.Proxy(MagneticStoreRejectedDataLocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MagneticStoreRejectedDataLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration of an S3 location to write error reports for records rejected, asynchronously, during magnetic store writes.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Configuration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MagneticStoreRejectedDataLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MagneticStoreRejectedDataLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MagneticStoreRejectedDataLocationProperty> {
            java.lang.Object s3Configuration;

            /**
             * Sets the value of {@link MagneticStoreRejectedDataLocationProperty#getS3Configuration}
             * @param s3Configuration Configuration of an S3 location to write error reports for records rejected, asynchronously, during magnetic store writes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.services.timestream.CfnTable.S3ConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link MagneticStoreRejectedDataLocationProperty#getS3Configuration}
             * @param s3Configuration Configuration of an S3 location to write error reports for records rejected, asynchronously, during magnetic store writes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.core.IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MagneticStoreRejectedDataLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MagneticStoreRejectedDataLocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MagneticStoreRejectedDataLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MagneticStoreRejectedDataLocationProperty {
            private final java.lang.Object s3Configuration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Configuration = software.amazon.jsii.Kernel.get(this, "s3Configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Configuration = builder.s3Configuration;
            }

            @Override
            public final java.lang.Object getS3Configuration() {
                return this.s3Configuration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3Configuration() != null) {
                    data.set("s3Configuration", om.valueToTree(this.getS3Configuration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_timestream.CfnTable.MagneticStoreRejectedDataLocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MagneticStoreRejectedDataLocationProperty.Jsii$Proxy that = (MagneticStoreRejectedDataLocationProperty.Jsii$Proxy) o;

                return this.s3Configuration != null ? this.s3Configuration.equals(that.s3Configuration) : that.s3Configuration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3Configuration != null ? this.s3Configuration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The set of properties on a table for configuring magnetic store writes.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.timestream.*;
     * MagneticStoreWritePropertiesProperty magneticStoreWritePropertiesProperty = MagneticStoreWritePropertiesProperty.builder()
     *         .enableMagneticStoreWrites(false)
     *         // the properties below are optional
     *         .magneticStoreRejectedDataLocation(MagneticStoreRejectedDataLocationProperty.builder()
     *                 .s3Configuration(S3ConfigurationProperty.builder()
     *                         .bucketName("bucketName")
     *                         .encryptionOption("encryptionOption")
     *                         // the properties below are optional
     *                         .kmsKeyId("kmsKeyId")
     *                         .objectKeyPrefix("objectKeyPrefix")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_timestream.CfnTable.MagneticStoreWritePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(MagneticStoreWritePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MagneticStoreWritePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A flag to enable magnetic store writes.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnableMagneticStoreWrites();

        /**
         * The location to write error reports for records rejected asynchronously during magnetic store writes.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMagneticStoreRejectedDataLocation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MagneticStoreWritePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MagneticStoreWritePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MagneticStoreWritePropertiesProperty> {
            java.lang.Object enableMagneticStoreWrites;
            java.lang.Object magneticStoreRejectedDataLocation;

            /**
             * Sets the value of {@link MagneticStoreWritePropertiesProperty#getEnableMagneticStoreWrites}
             * @param enableMagneticStoreWrites A flag to enable magnetic store writes. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableMagneticStoreWrites(java.lang.Boolean enableMagneticStoreWrites) {
                this.enableMagneticStoreWrites = enableMagneticStoreWrites;
                return this;
            }

            /**
             * Sets the value of {@link MagneticStoreWritePropertiesProperty#getEnableMagneticStoreWrites}
             * @param enableMagneticStoreWrites A flag to enable magnetic store writes. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableMagneticStoreWrites(software.amazon.awscdk.core.IResolvable enableMagneticStoreWrites) {
                this.enableMagneticStoreWrites = enableMagneticStoreWrites;
                return this;
            }

            /**
             * Sets the value of {@link MagneticStoreWritePropertiesProperty#getMagneticStoreRejectedDataLocation}
             * @param magneticStoreRejectedDataLocation The location to write error reports for records rejected asynchronously during magnetic store writes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder magneticStoreRejectedDataLocation(software.amazon.awscdk.services.timestream.CfnTable.MagneticStoreRejectedDataLocationProperty magneticStoreRejectedDataLocation) {
                this.magneticStoreRejectedDataLocation = magneticStoreRejectedDataLocation;
                return this;
            }

            /**
             * Sets the value of {@link MagneticStoreWritePropertiesProperty#getMagneticStoreRejectedDataLocation}
             * @param magneticStoreRejectedDataLocation The location to write error reports for records rejected asynchronously during magnetic store writes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder magneticStoreRejectedDataLocation(software.amazon.awscdk.core.IResolvable magneticStoreRejectedDataLocation) {
                this.magneticStoreRejectedDataLocation = magneticStoreRejectedDataLocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MagneticStoreWritePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MagneticStoreWritePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MagneticStoreWritePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MagneticStoreWritePropertiesProperty {
            private final java.lang.Object enableMagneticStoreWrites;
            private final java.lang.Object magneticStoreRejectedDataLocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableMagneticStoreWrites = software.amazon.jsii.Kernel.get(this, "enableMagneticStoreWrites", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.magneticStoreRejectedDataLocation = software.amazon.jsii.Kernel.get(this, "magneticStoreRejectedDataLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableMagneticStoreWrites = java.util.Objects.requireNonNull(builder.enableMagneticStoreWrites, "enableMagneticStoreWrites is required");
                this.magneticStoreRejectedDataLocation = builder.magneticStoreRejectedDataLocation;
            }

            @Override
            public final java.lang.Object getEnableMagneticStoreWrites() {
                return this.enableMagneticStoreWrites;
            }

            @Override
            public final java.lang.Object getMagneticStoreRejectedDataLocation() {
                return this.magneticStoreRejectedDataLocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enableMagneticStoreWrites", om.valueToTree(this.getEnableMagneticStoreWrites()));
                if (this.getMagneticStoreRejectedDataLocation() != null) {
                    data.set("magneticStoreRejectedDataLocation", om.valueToTree(this.getMagneticStoreRejectedDataLocation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_timestream.CfnTable.MagneticStoreWritePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MagneticStoreWritePropertiesProperty.Jsii$Proxy that = (MagneticStoreWritePropertiesProperty.Jsii$Proxy) o;

                if (!enableMagneticStoreWrites.equals(that.enableMagneticStoreWrites)) return false;
                return this.magneticStoreRejectedDataLocation != null ? this.magneticStoreRejectedDataLocation.equals(that.magneticStoreRejectedDataLocation) : that.magneticStoreRejectedDataLocation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableMagneticStoreWrites.hashCode();
                result = 31 * result + (this.magneticStoreRejectedDataLocation != null ? this.magneticStoreRejectedDataLocation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Retention properties contain the duration for which your time-series data must be stored in the magnetic store and the memory store.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.timestream.*;
     * RetentionPropertiesProperty retentionPropertiesProperty = RetentionPropertiesProperty.builder()
     *         .magneticStoreRetentionPeriodInDays("magneticStoreRetentionPeriodInDays")
     *         .memoryStoreRetentionPeriodInHours("memoryStoreRetentionPeriodInHours")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_timestream.CfnTable.RetentionPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(RetentionPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetentionPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The duration for which data must be stored in the magnetic store.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMagneticStoreRetentionPeriodInDays() {
            return null;
        }

        /**
         * The duration for which data must be stored in the memory store.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMemoryStoreRetentionPeriodInHours() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RetentionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetentionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetentionPropertiesProperty> {
            java.lang.String magneticStoreRetentionPeriodInDays;
            java.lang.String memoryStoreRetentionPeriodInHours;

            /**
             * Sets the value of {@link RetentionPropertiesProperty#getMagneticStoreRetentionPeriodInDays}
             * @param magneticStoreRetentionPeriodInDays The duration for which data must be stored in the magnetic store.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder magneticStoreRetentionPeriodInDays(java.lang.String magneticStoreRetentionPeriodInDays) {
                this.magneticStoreRetentionPeriodInDays = magneticStoreRetentionPeriodInDays;
                return this;
            }

            /**
             * Sets the value of {@link RetentionPropertiesProperty#getMemoryStoreRetentionPeriodInHours}
             * @param memoryStoreRetentionPeriodInHours The duration for which data must be stored in the memory store.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryStoreRetentionPeriodInHours(java.lang.String memoryStoreRetentionPeriodInHours) {
                this.memoryStoreRetentionPeriodInHours = memoryStoreRetentionPeriodInHours;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetentionPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetentionPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetentionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetentionPropertiesProperty {
            private final java.lang.String magneticStoreRetentionPeriodInDays;
            private final java.lang.String memoryStoreRetentionPeriodInHours;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.magneticStoreRetentionPeriodInDays = software.amazon.jsii.Kernel.get(this, "magneticStoreRetentionPeriodInDays", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.memoryStoreRetentionPeriodInHours = software.amazon.jsii.Kernel.get(this, "memoryStoreRetentionPeriodInHours", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.magneticStoreRetentionPeriodInDays = builder.magneticStoreRetentionPeriodInDays;
                this.memoryStoreRetentionPeriodInHours = builder.memoryStoreRetentionPeriodInHours;
            }

            @Override
            public final java.lang.String getMagneticStoreRetentionPeriodInDays() {
                return this.magneticStoreRetentionPeriodInDays;
            }

            @Override
            public final java.lang.String getMemoryStoreRetentionPeriodInHours() {
                return this.memoryStoreRetentionPeriodInHours;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMagneticStoreRetentionPeriodInDays() != null) {
                    data.set("magneticStoreRetentionPeriodInDays", om.valueToTree(this.getMagneticStoreRetentionPeriodInDays()));
                }
                if (this.getMemoryStoreRetentionPeriodInHours() != null) {
                    data.set("memoryStoreRetentionPeriodInHours", om.valueToTree(this.getMemoryStoreRetentionPeriodInHours()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_timestream.CfnTable.RetentionPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetentionPropertiesProperty.Jsii$Proxy that = (RetentionPropertiesProperty.Jsii$Proxy) o;

                if (this.magneticStoreRetentionPeriodInDays != null ? !this.magneticStoreRetentionPeriodInDays.equals(that.magneticStoreRetentionPeriodInDays) : that.magneticStoreRetentionPeriodInDays != null) return false;
                return this.memoryStoreRetentionPeriodInHours != null ? this.memoryStoreRetentionPeriodInHours.equals(that.memoryStoreRetentionPeriodInHours) : that.memoryStoreRetentionPeriodInHours == null;
            }

            @Override
            public final int hashCode() {
                int result = this.magneticStoreRetentionPeriodInDays != null ? this.magneticStoreRetentionPeriodInDays.hashCode() : 0;
                result = 31 * result + (this.memoryStoreRetentionPeriodInHours != null ? this.memoryStoreRetentionPeriodInHours.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration that specifies an S3 location.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.timestream.*;
     * S3ConfigurationProperty s3ConfigurationProperty = S3ConfigurationProperty.builder()
     *         .bucketName("bucketName")
     *         .encryptionOption("encryptionOption")
     *         // the properties below are optional
     *         .kmsKeyId("kmsKeyId")
     *         .objectKeyPrefix("objectKeyPrefix")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_timestream.CfnTable.S3ConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3ConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3ConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The bucket name of the customer S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * The encryption option for the customer S3 location.
         * <p>
         * Options are S3 server-side encryption with an S3 managed key or AWS managed key.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEncryptionOption();

        /**
         * The AWS KMS key ID for the customer S3 location when encrypting with an AWS managed key.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * The object key preview for the customer S3 location.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getObjectKeyPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3ConfigurationProperty> {
            java.lang.String bucketName;
            java.lang.String encryptionOption;
            java.lang.String kmsKeyId;
            java.lang.String objectKeyPrefix;

            /**
             * Sets the value of {@link S3ConfigurationProperty#getBucketName}
             * @param bucketName The bucket name of the customer S3 bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3ConfigurationProperty#getEncryptionOption}
             * @param encryptionOption The encryption option for the customer S3 location. This parameter is required.
             *                         Options are S3 server-side encryption with an S3 managed key or AWS managed key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionOption(java.lang.String encryptionOption) {
                this.encryptionOption = encryptionOption;
                return this;
            }

            /**
             * Sets the value of {@link S3ConfigurationProperty#getKmsKeyId}
             * @param kmsKeyId The AWS KMS key ID for the customer S3 location when encrypting with an AWS managed key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link S3ConfigurationProperty#getObjectKeyPrefix}
             * @param objectKeyPrefix The object key preview for the customer S3 location.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectKeyPrefix(java.lang.String objectKeyPrefix) {
                this.objectKeyPrefix = objectKeyPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3ConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3ConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3ConfigurationProperty {
            private final java.lang.String bucketName;
            private final java.lang.String encryptionOption;
            private final java.lang.String kmsKeyId;
            private final java.lang.String objectKeyPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.encryptionOption = software.amazon.jsii.Kernel.get(this, "encryptionOption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.objectKeyPrefix = software.amazon.jsii.Kernel.get(this, "objectKeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.encryptionOption = java.util.Objects.requireNonNull(builder.encryptionOption, "encryptionOption is required");
                this.kmsKeyId = builder.kmsKeyId;
                this.objectKeyPrefix = builder.objectKeyPrefix;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getEncryptionOption() {
                return this.encryptionOption;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public final java.lang.String getObjectKeyPrefix() {
                return this.objectKeyPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                data.set("encryptionOption", om.valueToTree(this.getEncryptionOption()));
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }
                if (this.getObjectKeyPrefix() != null) {
                    data.set("objectKeyPrefix", om.valueToTree(this.getObjectKeyPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_timestream.CfnTable.S3ConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3ConfigurationProperty.Jsii$Proxy that = (S3ConfigurationProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                if (!encryptionOption.equals(that.encryptionOption)) return false;
                if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
                return this.objectKeyPrefix != null ? this.objectKeyPrefix.equals(that.objectKeyPrefix) : that.objectKeyPrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.encryptionOption.hashCode());
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                result = 31 * result + (this.objectKeyPrefix != null ? this.objectKeyPrefix.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.timestream.CfnTable}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.timestream.CfnTable> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.timestream.CfnTableProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.timestream.CfnTableProps.Builder();
        }

        /**
         * The name of the Timestream database that contains this table.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 3 bytes. Maximum length of 256 bytes.
         * <p>
         * @return {@code this}
         * @param databaseName The name of the Timestream database that contains this table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(final java.lang.String databaseName) {
            this.props.databaseName(databaseName);
            return this;
        }

        /**
         * Contains properties to set on the table when enabling magnetic store writes.
         * <p>
         * This object has the following attributes:
         * <p>
         * <ul>
         * <li><em>EnableMagneticStoreWrites</em> : A <code>boolean</code> flag to enable magnetic store writes.</li>
         * <li><em>MagneticStoreRejectedDataLocation</em> : The location to write error reports for records rejected, asynchronously, during magnetic store writes. Only <code>S3Configuration</code> objects are allowed. The <code>S3Configuration</code> object has the following attributes:</li>
         * <li><em>BucketName</em> : The name of the S3 bucket.</li>
         * <li><em>EncryptionOption</em> : The encryption option for the S3 location. Valid values are S3 server-side encryption with an S3 managed key ( <code>SSE_S3</code> ) or AWS managed key ( <code>SSE_KMS</code> ).</li>
         * <li><em>KmsKeyId</em> : The AWS KMS key ID to use when encrypting with an AWS managed key.</li>
         * <li><em>ObjectKeyPrefix</em> : The prefix to use option for the objects stored in S3.</li>
         * </ul>
         * <p>
         * Both <code>BucketName</code> and <code>EncryptionOption</code> are <em>required</em> when <code>S3Configuration</code> is specified. If you specify <code>SSE_KMS</code> as your <code>EncryptionOption</code> then <code>KmsKeyId</code> is <em>required</em> .
         * <p>
         * <code>EnableMagneticStoreWrites</code> attribute is <em>required</em> when <code>MagneticStoreWriteProperties</code> is specified. <code>MagneticStoreRejectedDataLocation</code> attribute is <em>required</em> when <code>EnableMagneticStoreWrites</code> is set to <code>true</code> .
         * <p>
         * See the following examples:
         * <p>
         * <em>JSON</em>
         * <p>
         * <blockquote><pre>
         * { "Type" : AWS::Timestream::Table", "Properties":{ "DatabaseName":"TestDatabase", "TableName":"TestTable", "MagneticStoreWriteProperties":{ "EnableMagneticStoreWrites":true, "MagneticStoreRejectedDataLocation":{ "S3Configuration":{ "BucketName":"testbucket", "EncryptionOption":"SSE_KMS", "KmsKeyId":"1234abcd-12ab-34cd-56ef-1234567890ab", "ObjectKeyPrefix":"prefix" } } } }
         * }
         * </pre></blockquote>
         * <p>
         * <em>YAML</em>
         * <p>
         * <blockquote><pre>
         * Type: AWS::Timestream::Table
         * DependsOn: TestDatabase
         * Properties: TableName: "TestTable" DatabaseName: "TestDatabase" MagneticStoreWriteProperties: EnableMagneticStoreWrites: true MagneticStoreRejectedDataLocation: S3Configuration: BucketName: "testbucket" EncryptionOption: "SSE_KMS" KmsKeyId: "1234abcd-12ab-34cd-56ef-1234567890ab" ObjectKeyPrefix: "prefix"
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param magneticStoreWriteProperties Contains properties to set on the table when enabling magnetic store writes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder magneticStoreWriteProperties(final software.amazon.awscdk.services.timestream.CfnTable.MagneticStoreWritePropertiesProperty magneticStoreWriteProperties) {
            this.props.magneticStoreWriteProperties(magneticStoreWriteProperties);
            return this;
        }
        /**
         * Contains properties to set on the table when enabling magnetic store writes.
         * <p>
         * This object has the following attributes:
         * <p>
         * <ul>
         * <li><em>EnableMagneticStoreWrites</em> : A <code>boolean</code> flag to enable magnetic store writes.</li>
         * <li><em>MagneticStoreRejectedDataLocation</em> : The location to write error reports for records rejected, asynchronously, during magnetic store writes. Only <code>S3Configuration</code> objects are allowed. The <code>S3Configuration</code> object has the following attributes:</li>
         * <li><em>BucketName</em> : The name of the S3 bucket.</li>
         * <li><em>EncryptionOption</em> : The encryption option for the S3 location. Valid values are S3 server-side encryption with an S3 managed key ( <code>SSE_S3</code> ) or AWS managed key ( <code>SSE_KMS</code> ).</li>
         * <li><em>KmsKeyId</em> : The AWS KMS key ID to use when encrypting with an AWS managed key.</li>
         * <li><em>ObjectKeyPrefix</em> : The prefix to use option for the objects stored in S3.</li>
         * </ul>
         * <p>
         * Both <code>BucketName</code> and <code>EncryptionOption</code> are <em>required</em> when <code>S3Configuration</code> is specified. If you specify <code>SSE_KMS</code> as your <code>EncryptionOption</code> then <code>KmsKeyId</code> is <em>required</em> .
         * <p>
         * <code>EnableMagneticStoreWrites</code> attribute is <em>required</em> when <code>MagneticStoreWriteProperties</code> is specified. <code>MagneticStoreRejectedDataLocation</code> attribute is <em>required</em> when <code>EnableMagneticStoreWrites</code> is set to <code>true</code> .
         * <p>
         * See the following examples:
         * <p>
         * <em>JSON</em>
         * <p>
         * <blockquote><pre>
         * { "Type" : AWS::Timestream::Table", "Properties":{ "DatabaseName":"TestDatabase", "TableName":"TestTable", "MagneticStoreWriteProperties":{ "EnableMagneticStoreWrites":true, "MagneticStoreRejectedDataLocation":{ "S3Configuration":{ "BucketName":"testbucket", "EncryptionOption":"SSE_KMS", "KmsKeyId":"1234abcd-12ab-34cd-56ef-1234567890ab", "ObjectKeyPrefix":"prefix" } } } }
         * }
         * </pre></blockquote>
         * <p>
         * <em>YAML</em>
         * <p>
         * <blockquote><pre>
         * Type: AWS::Timestream::Table
         * DependsOn: TestDatabase
         * Properties: TableName: "TestTable" DatabaseName: "TestDatabase" MagneticStoreWriteProperties: EnableMagneticStoreWrites: true MagneticStoreRejectedDataLocation: S3Configuration: BucketName: "testbucket" EncryptionOption: "SSE_KMS" KmsKeyId: "1234abcd-12ab-34cd-56ef-1234567890ab" ObjectKeyPrefix: "prefix"
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param magneticStoreWriteProperties Contains properties to set on the table when enabling magnetic store writes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder magneticStoreWriteProperties(final software.amazon.awscdk.core.IResolvable magneticStoreWriteProperties) {
            this.props.magneticStoreWriteProperties(magneticStoreWriteProperties);
            return this;
        }

        /**
         * The retention duration for the memory store and magnetic store. This object has the following attributes:.
         * <p>
         * <ul>
         * <li><em>MemoryStoreRetentionPeriodInHours</em> : Retention duration for memory store, in hours.</li>
         * <li><em>MagneticStoreRetentionPeriodInDays</em> : Retention duration for magnetic store, in days.</li>
         * </ul>
         * <p>
         * Both attributes are of type <code>string</code> . Both attributes are <em>required</em> when <code>RetentionProperties</code> is specified.
         * <p>
         * See the following examples:
         * <p>
         * <em>JSON</em>
         * <p>
         * <code>{ "Type" : AWS::Timestream::Table", "Properties" : { "DatabaseName" : "TestDatabase", "TableName" : "TestTable", "RetentionProperties" : { "MemoryStoreRetentionPeriodInHours": "24", "MagneticStoreRetentionPeriodInDays": "7" } } }</code>
         * <p>
         * <em>YAML</em>
         * <p>
         * <blockquote><pre>
         * Type: AWS::Timestream::Table
         * DependsOn: TestDatabase
         * Properties: TableName: "TestTable" DatabaseName: "TestDatabase" RetentionProperties: MemoryStoreRetentionPeriodInHours: "24" MagneticStoreRetentionPeriodInDays: "7"
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param retentionProperties The retention duration for the memory store and magnetic store. This object has the following attributes:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionProperties(final software.amazon.awscdk.services.timestream.CfnTable.RetentionPropertiesProperty retentionProperties) {
            this.props.retentionProperties(retentionProperties);
            return this;
        }
        /**
         * The retention duration for the memory store and magnetic store. This object has the following attributes:.
         * <p>
         * <ul>
         * <li><em>MemoryStoreRetentionPeriodInHours</em> : Retention duration for memory store, in hours.</li>
         * <li><em>MagneticStoreRetentionPeriodInDays</em> : Retention duration for magnetic store, in days.</li>
         * </ul>
         * <p>
         * Both attributes are of type <code>string</code> . Both attributes are <em>required</em> when <code>RetentionProperties</code> is specified.
         * <p>
         * See the following examples:
         * <p>
         * <em>JSON</em>
         * <p>
         * <code>{ "Type" : AWS::Timestream::Table", "Properties" : { "DatabaseName" : "TestDatabase", "TableName" : "TestTable", "RetentionProperties" : { "MemoryStoreRetentionPeriodInHours": "24", "MagneticStoreRetentionPeriodInDays": "7" } } }</code>
         * <p>
         * <em>YAML</em>
         * <p>
         * <blockquote><pre>
         * Type: AWS::Timestream::Table
         * DependsOn: TestDatabase
         * Properties: TableName: "TestTable" DatabaseName: "TestDatabase" RetentionProperties: MemoryStoreRetentionPeriodInHours: "24" MagneticStoreRetentionPeriodInDays: "7"
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param retentionProperties The retention duration for the memory store and magnetic store. This object has the following attributes:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionProperties(final software.amazon.awscdk.core.IResolvable retentionProperties) {
            this.props.retentionProperties(retentionProperties);
            return this;
        }

        /**
         * The name of the Timestream table.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 3 bytes. Maximum length of 256 bytes.
         * <p>
         * @return {@code this}
         * @param tableName The name of the Timestream table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(final java.lang.String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        /**
         * The tags to add to the table.
         * <p>
         * @return {@code this}
         * @param tags The tags to add to the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.timestream.CfnTable}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.timestream.CfnTable build() {
            return new software.amazon.awscdk.services.timestream.CfnTable(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
