/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.cxapi;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.cloudassembly.schema.ArtifactManifest;
import software.amazon.awscdk.cloudassembly.schema.MissingContext;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.cxapi.AssemblyBuildOptions;
import software.amazon.awscdk.cxapi.CloudAssembly;
import software.amazon.awscdk.cxapi.CloudAssemblyBuilderProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk.cx_api.CloudAssemblyBuilder")
public class CloudAssemblyBuilder
extends JsiiObject {
    protected CloudAssemblyBuilder(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudAssemblyBuilder(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CloudAssemblyBuilder(@Nullable String outdir, @Nullable CloudAssemblyBuilderProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{outdir, props});
    }

    public CloudAssemblyBuilder(@Nullable String outdir) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{outdir});
    }

    public CloudAssemblyBuilder() {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[0]);
    }

    public void addArtifact(@NotNull String id, @NotNull ArtifactManifest manifest) {
        Kernel.call((Object)((Object)this), (String)"addArtifact", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(manifest, "manifest is required")});
    }

    public void addMissing(@NotNull MissingContext missing) {
        Kernel.call((Object)((Object)this), (String)"addMissing", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(missing, "missing is required")});
    }

    @NotNull
    public CloudAssembly buildAssembly(@Nullable AssemblyBuildOptions options) {
        return (CloudAssembly)((Object)Kernel.call((Object)((Object)this), (String)"buildAssembly", (NativeType)NativeType.forClass(CloudAssembly.class), (Object[])new Object[]{options}));
    }

    @NotNull
    public CloudAssembly buildAssembly() {
        return (CloudAssembly)((Object)Kernel.call((Object)((Object)this), (String)"buildAssembly", (NativeType)NativeType.forClass(CloudAssembly.class), (Object[])new Object[0]));
    }

    @NotNull
    public CloudAssemblyBuilder createNestedAssembly(@NotNull String artifactId, @NotNull String displayName) {
        return (CloudAssemblyBuilder)((Object)Kernel.call((Object)((Object)this), (String)"createNestedAssembly", (NativeType)NativeType.forClass(CloudAssemblyBuilder.class), (Object[])new Object[]{Objects.requireNonNull(artifactId, "artifactId is required"), Objects.requireNonNull(displayName, "displayName is required")}));
    }

    @NotNull
    public String getAssetOutdir() {
        return (String)Kernel.get((Object)((Object)this), (String)"assetOutdir", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getOutdir() {
        return (String)Kernel.get((Object)((Object)this), (String)"outdir", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CloudAssemblyBuilder> {
        private final String outdir;
        private CloudAssemblyBuilderProps.Builder props;

        public static Builder create(String outdir) {
            return new Builder(outdir);
        }

        public static Builder create() {
            return new Builder(null);
        }

        private Builder(String outdir) {
            this.outdir = outdir;
        }

        public Builder assetOutdir(String assetOutdir) {
            this.props().assetOutdir(assetOutdir);
            return this;
        }

        public Builder parentBuilder(CloudAssemblyBuilder parentBuilder) {
            this.props().parentBuilder(parentBuilder);
            return this;
        }

        public CloudAssemblyBuilder build() {
            return new CloudAssemblyBuilder(this.outdir, this.props != null ? this.props.build() : null);
        }

        private CloudAssemblyBuilderProps.Builder props() {
            if (this.props == null) {
                this.props = new CloudAssemblyBuilderProps.Builder();
            }
            return this.props;
        }
    }
}

