/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codebuild;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.codebuild.CfnProject;
import software.amazon.awscdk.services.codebuild.CfnProjectProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.CfnProject")
public class CfnProject
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnProject.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnProject(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnProject(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnProject(@NotNull Construct scope, @NotNull String id, @NotNull CfnProjectProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public Object getArtifacts() {
        return Kernel.get((Object)this, (String)"artifacts", (NativeType)NativeType.forClass(Object.class));
    }

    public void setArtifacts(@NotNull ArtifactsProperty value) {
        Kernel.set((Object)this, (String)"artifacts", (Object)Objects.requireNonNull(value, "artifacts is required"));
    }

    public void setArtifacts(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"artifacts", (Object)Objects.requireNonNull(value, "artifacts is required"));
    }

    @NotNull
    public Object getEnvironment() {
        return Kernel.get((Object)this, (String)"environment", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEnvironment(@NotNull EnvironmentProperty value) {
        Kernel.set((Object)this, (String)"environment", (Object)Objects.requireNonNull(value, "environment is required"));
    }

    public void setEnvironment(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"environment", (Object)Objects.requireNonNull(value, "environment is required"));
    }

    @NotNull
    public String getServiceRole() {
        return (String)Kernel.get((Object)this, (String)"serviceRole", (NativeType)NativeType.forClass(String.class));
    }

    public void setServiceRole(@NotNull String value) {
        Kernel.set((Object)this, (String)"serviceRole", (Object)Objects.requireNonNull(value, "serviceRole is required"));
    }

    @NotNull
    public Object getSource() {
        return Kernel.get((Object)this, (String)"source", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSource(@NotNull SourceProperty value) {
        Kernel.set((Object)this, (String)"source", (Object)Objects.requireNonNull(value, "source is required"));
    }

    public void setSource(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"source", (Object)Objects.requireNonNull(value, "source is required"));
    }

    @Nullable
    public Object getBadgeEnabled() {
        return Kernel.get((Object)this, (String)"badgeEnabled", (NativeType)NativeType.forClass(Object.class));
    }

    public void setBadgeEnabled(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"badgeEnabled", (Object)value);
    }

    public void setBadgeEnabled(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"badgeEnabled", (Object)value);
    }

    @Nullable
    public Object getBuildBatchConfig() {
        return Kernel.get((Object)this, (String)"buildBatchConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setBuildBatchConfig(@Nullable ProjectBuildBatchConfigProperty value) {
        Kernel.set((Object)this, (String)"buildBatchConfig", (Object)value);
    }

    public void setBuildBatchConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"buildBatchConfig", (Object)value);
    }

    @Nullable
    public Object getCache() {
        return Kernel.get((Object)this, (String)"cache", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCache(@Nullable ProjectCacheProperty value) {
        Kernel.set((Object)this, (String)"cache", (Object)value);
    }

    public void setCache(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"cache", (Object)value);
    }

    @Nullable
    public Number getConcurrentBuildLimit() {
        return (Number)Kernel.get((Object)this, (String)"concurrentBuildLimit", (NativeType)NativeType.forClass(Number.class));
    }

    public void setConcurrentBuildLimit(@Nullable Number value) {
        Kernel.set((Object)this, (String)"concurrentBuildLimit", (Object)value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public String getEncryptionKey() {
        return (String)Kernel.get((Object)this, (String)"encryptionKey", (NativeType)NativeType.forClass(String.class));
    }

    public void setEncryptionKey(@Nullable String value) {
        Kernel.set((Object)this, (String)"encryptionKey", (Object)value);
    }

    @Nullable
    public Object getFileSystemLocations() {
        return Kernel.get((Object)this, (String)"fileSystemLocations", (NativeType)NativeType.forClass(Object.class));
    }

    public void setFileSystemLocations(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"fileSystemLocations", (Object)value);
    }

    public void setFileSystemLocations(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof ProjectFileSystemLocationProperty || __val_ac66f0 instanceof IResolvable || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.services.codebuild.CfnProject.ProjectFileSystemLocationProperty, software.amazon.awscdk.core.IResolvable; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"fileSystemLocations", value);
    }

    @Nullable
    public Object getLogsConfig() {
        return Kernel.get((Object)this, (String)"logsConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLogsConfig(@Nullable LogsConfigProperty value) {
        Kernel.set((Object)this, (String)"logsConfig", (Object)value);
    }

    public void setLogsConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"logsConfig", (Object)value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)this, (String)"name", (Object)value);
    }

    @Nullable
    public Number getQueuedTimeoutInMinutes() {
        return (Number)Kernel.get((Object)this, (String)"queuedTimeoutInMinutes", (NativeType)NativeType.forClass(Number.class));
    }

    public void setQueuedTimeoutInMinutes(@Nullable Number value) {
        Kernel.set((Object)this, (String)"queuedTimeoutInMinutes", (Object)value);
    }

    @Nullable
    public String getResourceAccessRole() {
        return (String)Kernel.get((Object)this, (String)"resourceAccessRole", (NativeType)NativeType.forClass(String.class));
    }

    public void setResourceAccessRole(@Nullable String value) {
        Kernel.set((Object)this, (String)"resourceAccessRole", (Object)value);
    }

    @Nullable
    public Object getSecondaryArtifacts() {
        return Kernel.get((Object)this, (String)"secondaryArtifacts", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSecondaryArtifacts(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"secondaryArtifacts", (Object)value);
    }

    public void setSecondaryArtifacts(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof ArtifactsProperty || __val_ac66f0 instanceof IResolvable || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.services.codebuild.CfnProject.ArtifactsProperty, software.amazon.awscdk.core.IResolvable; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"secondaryArtifacts", value);
    }

    @Nullable
    public Object getSecondarySources() {
        return Kernel.get((Object)this, (String)"secondarySources", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSecondarySources(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"secondarySources", (Object)value);
    }

    public void setSecondarySources(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof SourceProperty || __val_ac66f0 instanceof IResolvable || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.services.codebuild.CfnProject.SourceProperty, software.amazon.awscdk.core.IResolvable; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"secondarySources", value);
    }

    @Nullable
    public Object getSecondarySourceVersions() {
        return Kernel.get((Object)this, (String)"secondarySourceVersions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSecondarySourceVersions(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"secondarySourceVersions", (Object)value);
    }

    public void setSecondarySourceVersions(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof ProjectSourceVersionProperty || __val_ac66f0 instanceof IResolvable || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.services.codebuild.CfnProject.ProjectSourceVersionProperty, software.amazon.awscdk.core.IResolvable; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"secondarySourceVersions", value);
    }

    @Nullable
    public String getSourceVersion() {
        return (String)Kernel.get((Object)this, (String)"sourceVersion", (NativeType)NativeType.forClass(String.class));
    }

    public void setSourceVersion(@Nullable String value) {
        Kernel.set((Object)this, (String)"sourceVersion", (Object)value);
    }

    @Nullable
    public Number getTimeoutInMinutes() {
        return (Number)Kernel.get((Object)this, (String)"timeoutInMinutes", (NativeType)NativeType.forClass(Number.class));
    }

    public void setTimeoutInMinutes(@Nullable Number value) {
        Kernel.set((Object)this, (String)"timeoutInMinutes", (Object)value);
    }

    @Nullable
    public Object getTriggers() {
        return Kernel.get((Object)this, (String)"triggers", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTriggers(@Nullable ProjectTriggersProperty value) {
        Kernel.set((Object)this, (String)"triggers", (Object)value);
    }

    public void setTriggers(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"triggers", (Object)value);
    }

    @Nullable
    public String getVisibility() {
        return (String)Kernel.get((Object)this, (String)"visibility", (NativeType)NativeType.forClass(String.class));
    }

    public void setVisibility(@Nullable String value) {
        Kernel.set((Object)this, (String)"visibility", (Object)value);
    }

    @Nullable
    public Object getVpcConfig() {
        return Kernel.get((Object)this, (String)"vpcConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setVpcConfig(@Nullable VpcConfigProperty value) {
        Kernel.set((Object)this, (String)"vpcConfig", (Object)value);
    }

    public void setVpcConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"vpcConfig", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnProject> {
        private final Construct scope;
        private final String id;
        private final CfnProjectProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnProjectProps.Builder();
        }

        public Builder artifacts(ArtifactsProperty artifacts) {
            this.props.artifacts(artifacts);
            return this;
        }

        public Builder artifacts(IResolvable artifacts) {
            this.props.artifacts(artifacts);
            return this;
        }

        public Builder environment(EnvironmentProperty environment) {
            this.props.environment(environment);
            return this;
        }

        public Builder environment(IResolvable environment) {
            this.props.environment(environment);
            return this;
        }

        public Builder serviceRole(String serviceRole) {
            this.props.serviceRole(serviceRole);
            return this;
        }

        public Builder source(SourceProperty source) {
            this.props.source(source);
            return this;
        }

        public Builder source(IResolvable source) {
            this.props.source(source);
            return this;
        }

        public Builder badgeEnabled(Boolean badgeEnabled) {
            this.props.badgeEnabled(badgeEnabled);
            return this;
        }

        public Builder badgeEnabled(IResolvable badgeEnabled) {
            this.props.badgeEnabled(badgeEnabled);
            return this;
        }

        public Builder buildBatchConfig(ProjectBuildBatchConfigProperty buildBatchConfig) {
            this.props.buildBatchConfig(buildBatchConfig);
            return this;
        }

        public Builder buildBatchConfig(IResolvable buildBatchConfig) {
            this.props.buildBatchConfig(buildBatchConfig);
            return this;
        }

        public Builder cache(ProjectCacheProperty cache) {
            this.props.cache(cache);
            return this;
        }

        public Builder cache(IResolvable cache) {
            this.props.cache(cache);
            return this;
        }

        public Builder concurrentBuildLimit(Number concurrentBuildLimit) {
            this.props.concurrentBuildLimit(concurrentBuildLimit);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder encryptionKey(String encryptionKey) {
            this.props.encryptionKey(encryptionKey);
            return this;
        }

        public Builder fileSystemLocations(IResolvable fileSystemLocations) {
            this.props.fileSystemLocations(fileSystemLocations);
            return this;
        }

        public Builder fileSystemLocations(List<? extends Object> fileSystemLocations) {
            this.props.fileSystemLocations(fileSystemLocations);
            return this;
        }

        public Builder logsConfig(LogsConfigProperty logsConfig) {
            this.props.logsConfig(logsConfig);
            return this;
        }

        public Builder logsConfig(IResolvable logsConfig) {
            this.props.logsConfig(logsConfig);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder queuedTimeoutInMinutes(Number queuedTimeoutInMinutes) {
            this.props.queuedTimeoutInMinutes(queuedTimeoutInMinutes);
            return this;
        }

        public Builder resourceAccessRole(String resourceAccessRole) {
            this.props.resourceAccessRole(resourceAccessRole);
            return this;
        }

        public Builder secondaryArtifacts(IResolvable secondaryArtifacts) {
            this.props.secondaryArtifacts(secondaryArtifacts);
            return this;
        }

        public Builder secondaryArtifacts(List<? extends Object> secondaryArtifacts) {
            this.props.secondaryArtifacts(secondaryArtifacts);
            return this;
        }

        public Builder secondarySources(IResolvable secondarySources) {
            this.props.secondarySources(secondarySources);
            return this;
        }

        public Builder secondarySources(List<? extends Object> secondarySources) {
            this.props.secondarySources(secondarySources);
            return this;
        }

        public Builder secondarySourceVersions(IResolvable secondarySourceVersions) {
            this.props.secondarySourceVersions(secondarySourceVersions);
            return this;
        }

        public Builder secondarySourceVersions(List<? extends Object> secondarySourceVersions) {
            this.props.secondarySourceVersions(secondarySourceVersions);
            return this;
        }

        public Builder sourceVersion(String sourceVersion) {
            this.props.sourceVersion(sourceVersion);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder timeoutInMinutes(Number timeoutInMinutes) {
            this.props.timeoutInMinutes(timeoutInMinutes);
            return this;
        }

        public Builder triggers(ProjectTriggersProperty triggers) {
            this.props.triggers(triggers);
            return this;
        }

        public Builder triggers(IResolvable triggers) {
            this.props.triggers(triggers);
            return this;
        }

        public Builder visibility(String visibility) {
            this.props.visibility(visibility);
            return this;
        }

        public Builder vpcConfig(VpcConfigProperty vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        public Builder vpcConfig(IResolvable vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        public CfnProject build() {
            return new CfnProject(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.CfnProject.WebhookFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WebhookFilterProperty
    extends JsiiSerializable {
        @NotNull
        public String getPattern();

        @NotNull
        public String getType();

        @Nullable
        default public Object getExcludeMatchedPattern() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WebhookFilterProperty> {
            String pattern;
            String type;
            Object excludeMatchedPattern;

            public Builder pattern(String pattern) {
                this.pattern = pattern;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder excludeMatchedPattern(Boolean excludeMatchedPattern) {
                this.excludeMatchedPattern = excludeMatchedPattern;
                return this;
            }

            public Builder excludeMatchedPattern(IResolvable excludeMatchedPattern) {
                this.excludeMatchedPattern = excludeMatchedPattern;
                return this;
            }

            public WebhookFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.CfnProject.VpcConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VpcConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getSecurityGroupIds() {
            return null;
        }

        @Nullable
        default public List<String> getSubnets() {
            return null;
        }

        @Nullable
        default public String getVpcId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VpcConfigProperty> {
            List<String> securityGroupIds;
            List<String> subnets;
            String vpcId;

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnets(List<String> subnets) {
                this.subnets = subnets;
                return this;
            }

            public Builder vpcId(String vpcId) {
                this.vpcId = vpcId;
                return this;
            }

            public VpcConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.CfnProject.SourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SourceProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public Object getAuth() {
            return null;
        }

        @Nullable
        default public String getBuildSpec() {
            return null;
        }

        @Nullable
        default public Object getBuildStatusConfig() {
            return null;
        }

        @Nullable
        default public Number getGitCloneDepth() {
            return null;
        }

        @Nullable
        default public Object getGitSubmodulesConfig() {
            return null;
        }

        @Nullable
        default public Object getInsecureSsl() {
            return null;
        }

        @Nullable
        default public String getLocation() {
            return null;
        }

        @Nullable
        default public Object getReportBuildStatus() {
            return null;
        }

        @Nullable
        default public String getSourceIdentifier() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SourceProperty> {
            String type;
            Object auth;
            String buildSpec;
            Object buildStatusConfig;
            Number gitCloneDepth;
            Object gitSubmodulesConfig;
            Object insecureSsl;
            String location;
            Object reportBuildStatus;
            String sourceIdentifier;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder auth(SourceAuthProperty auth) {
                this.auth = auth;
                return this;
            }

            public Builder auth(IResolvable auth) {
                this.auth = auth;
                return this;
            }

            public Builder buildSpec(String buildSpec) {
                this.buildSpec = buildSpec;
                return this;
            }

            public Builder buildStatusConfig(BuildStatusConfigProperty buildStatusConfig) {
                this.buildStatusConfig = buildStatusConfig;
                return this;
            }

            public Builder buildStatusConfig(IResolvable buildStatusConfig) {
                this.buildStatusConfig = buildStatusConfig;
                return this;
            }

            public Builder gitCloneDepth(Number gitCloneDepth) {
                this.gitCloneDepth = gitCloneDepth;
                return this;
            }

            public Builder gitSubmodulesConfig(GitSubmodulesConfigProperty gitSubmodulesConfig) {
                this.gitSubmodulesConfig = gitSubmodulesConfig;
                return this;
            }

            public Builder gitSubmodulesConfig(IResolvable gitSubmodulesConfig) {
                this.gitSubmodulesConfig = gitSubmodulesConfig;
                return this;
            }

            public Builder insecureSsl(Boolean insecureSsl) {
                this.insecureSsl = insecureSsl;
                return this;
            }

            public Builder insecureSsl(IResolvable insecureSsl) {
                this.insecureSsl = insecureSsl;
                return this;
            }

            public Builder location(String location) {
                this.location = location;
                return this;
            }

            public Builder reportBuildStatus(Boolean reportBuildStatus) {
                this.reportBuildStatus = reportBuildStatus;
                return this;
            }

            public Builder reportBuildStatus(IResolvable reportBuildStatus) {
                this.reportBuildStatus = reportBuildStatus;
                return this;
            }

            public Builder sourceIdentifier(String sourceIdentifier) {
                this.sourceIdentifier = sourceIdentifier;
                return this;
            }

            public SourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.CfnProject.SourceAuthProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SourceAuthProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public String getResource() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SourceAuthProperty> {
            String type;
            String resource;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder resource(String resource) {
                this.resource = resource;
                return this;
            }

            public SourceAuthProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.CfnProject.S3LogsConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LogsConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getStatus();

        @Nullable
        default public Object getEncryptionDisabled() {
            return null;
        }

        @Nullable
        default public String getLocation() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3LogsConfigProperty> {
            String status;
            Object encryptionDisabled;
            String location;

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public Builder encryptionDisabled(Boolean encryptionDisabled) {
                this.encryptionDisabled = encryptionDisabled;
                return this;
            }

            public Builder encryptionDisabled(IResolvable encryptionDisabled) {
                this.encryptionDisabled = encryptionDisabled;
                return this;
            }

            public Builder location(String location) {
                this.location = location;
                return this;
            }

            public S3LogsConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.CfnProject.RegistryCredentialProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RegistryCredentialProperty
    extends JsiiSerializable {
        @NotNull
        public String getCredential();

        @NotNull
        public String getCredentialProvider();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RegistryCredentialProperty> {
            String credential;
            String credentialProvider;

            public Builder credential(String credential) {
                this.credential = credential;
                return this;
            }

            public Builder credentialProvider(String credentialProvider) {
                this.credentialProvider = credentialProvider;
                return this;
            }

            public RegistryCredentialProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.CfnProject.ProjectTriggersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProjectTriggersProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBuildType() {
            return null;
        }

        @Nullable
        default public Object getFilterGroups() {
            return null;
        }

        @Nullable
        default public Object getWebhook() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProjectTriggersProperty> {
            String buildType;
            Object filterGroups;
            Object webhook;

            public Builder buildType(String buildType) {
                this.buildType = buildType;
                return this;
            }

            public Builder filterGroups(IResolvable filterGroups) {
                this.filterGroups = filterGroups;
                return this;
            }

            public Builder filterGroups(List<? extends Object> filterGroups) {
                this.filterGroups = filterGroups;
                return this;
            }

            public Builder webhook(Boolean webhook) {
                this.webhook = webhook;
                return this;
            }

            public Builder webhook(IResolvable webhook) {
                this.webhook = webhook;
                return this;
            }

            public ProjectTriggersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.CfnProject.ProjectSourceVersionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProjectSourceVersionProperty
    extends JsiiSerializable {
        @NotNull
        public String getSourceIdentifier();

        @Nullable
        default public String getSourceVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProjectSourceVersionProperty> {
            String sourceIdentifier;
            String sourceVersion;

            public Builder sourceIdentifier(String sourceIdentifier) {
                this.sourceIdentifier = sourceIdentifier;
                return this;
            }

            public Builder sourceVersion(String sourceVersion) {
                this.sourceVersion = sourceVersion;
                return this;
            }

            public ProjectSourceVersionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.CfnProject.ProjectFileSystemLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProjectFileSystemLocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getIdentifier();

        @NotNull
        public String getLocation();

        @NotNull
        public String getMountPoint();

        @NotNull
        public String getType();

        @Nullable
        default public String getMountOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProjectFileSystemLocationProperty> {
            String identifier;
            String location;
            String mountPoint;
            String type;
            String mountOptions;

            public Builder identifier(String identifier) {
                this.identifier = identifier;
                return this;
            }

            public Builder location(String location) {
                this.location = location;
                return this;
            }

            public Builder mountPoint(String mountPoint) {
                this.mountPoint = mountPoint;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder mountOptions(String mountOptions) {
                this.mountOptions = mountOptions;
                return this;
            }

            public ProjectFileSystemLocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.CfnProject.ProjectCacheProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProjectCacheProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public String getLocation() {
            return null;
        }

        @Nullable
        default public List<String> getModes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProjectCacheProperty> {
            String type;
            String location;
            List<String> modes;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder location(String location) {
                this.location = location;
                return this;
            }

            public Builder modes(List<String> modes) {
                this.modes = modes;
                return this;
            }

            public ProjectCacheProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.CfnProject.ProjectBuildBatchConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProjectBuildBatchConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBatchReportMode() {
            return null;
        }

        @Nullable
        default public Object getCombineArtifacts() {
            return null;
        }

        @Nullable
        default public Object getRestrictions() {
            return null;
        }

        @Nullable
        default public String getServiceRole() {
            return null;
        }

        @Nullable
        default public Number getTimeoutInMins() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProjectBuildBatchConfigProperty> {
            String batchReportMode;
            Object combineArtifacts;
            Object restrictions;
            String serviceRole;
            Number timeoutInMins;

            public Builder batchReportMode(String batchReportMode) {
                this.batchReportMode = batchReportMode;
                return this;
            }

            public Builder combineArtifacts(Boolean combineArtifacts) {
                this.combineArtifacts = combineArtifacts;
                return this;
            }

            public Builder combineArtifacts(IResolvable combineArtifacts) {
                this.combineArtifacts = combineArtifacts;
                return this;
            }

            public Builder restrictions(BatchRestrictionsProperty restrictions) {
                this.restrictions = restrictions;
                return this;
            }

            public Builder restrictions(IResolvable restrictions) {
                this.restrictions = restrictions;
                return this;
            }

            public Builder serviceRole(String serviceRole) {
                this.serviceRole = serviceRole;
                return this;
            }

            public Builder timeoutInMins(Number timeoutInMins) {
                this.timeoutInMins = timeoutInMins;
                return this;
            }

            public ProjectBuildBatchConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.CfnProject.LogsConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LogsConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCloudWatchLogs() {
            return null;
        }

        @Nullable
        default public Object getS3Logs() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LogsConfigProperty> {
            Object cloudWatchLogs;
            Object s3Logs;

            public Builder cloudWatchLogs(CloudWatchLogsConfigProperty cloudWatchLogs) {
                this.cloudWatchLogs = cloudWatchLogs;
                return this;
            }

            public Builder cloudWatchLogs(IResolvable cloudWatchLogs) {
                this.cloudWatchLogs = cloudWatchLogs;
                return this;
            }

            public Builder s3Logs(S3LogsConfigProperty s3Logs) {
                this.s3Logs = s3Logs;
                return this;
            }

            public Builder s3Logs(IResolvable s3Logs) {
                this.s3Logs = s3Logs;
                return this;
            }

            public LogsConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.CfnProject.GitSubmodulesConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GitSubmodulesConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getFetchSubmodules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GitSubmodulesConfigProperty> {
            Object fetchSubmodules;

            public Builder fetchSubmodules(Boolean fetchSubmodules) {
                this.fetchSubmodules = fetchSubmodules;
                return this;
            }

            public Builder fetchSubmodules(IResolvable fetchSubmodules) {
                this.fetchSubmodules = fetchSubmodules;
                return this;
            }

            public GitSubmodulesConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.CfnProject.EnvironmentVariableProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EnvironmentVariableProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getValue();

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EnvironmentVariableProperty> {
            String name;
            String value;
            String type;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public EnvironmentVariableProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.CfnProject.EnvironmentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EnvironmentProperty
    extends JsiiSerializable {
        @NotNull
        public String getComputeType();

        @NotNull
        public String getImage();

        @NotNull
        public String getType();

        @Nullable
        default public String getCertificate() {
            return null;
        }

        @Nullable
        default public Object getEnvironmentVariables() {
            return null;
        }

        @Nullable
        default public String getImagePullCredentialsType() {
            return null;
        }

        @Nullable
        default public Object getPrivilegedMode() {
            return null;
        }

        @Nullable
        default public Object getRegistryCredential() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EnvironmentProperty> {
            String computeType;
            String image;
            String type;
            String certificate;
            Object environmentVariables;
            String imagePullCredentialsType;
            Object privilegedMode;
            Object registryCredential;

            public Builder computeType(String computeType) {
                this.computeType = computeType;
                return this;
            }

            public Builder image(String image) {
                this.image = image;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder certificate(String certificate) {
                this.certificate = certificate;
                return this;
            }

            public Builder environmentVariables(IResolvable environmentVariables) {
                this.environmentVariables = environmentVariables;
                return this;
            }

            public Builder environmentVariables(List<? extends Object> environmentVariables) {
                this.environmentVariables = environmentVariables;
                return this;
            }

            public Builder imagePullCredentialsType(String imagePullCredentialsType) {
                this.imagePullCredentialsType = imagePullCredentialsType;
                return this;
            }

            public Builder privilegedMode(Boolean privilegedMode) {
                this.privilegedMode = privilegedMode;
                return this;
            }

            public Builder privilegedMode(IResolvable privilegedMode) {
                this.privilegedMode = privilegedMode;
                return this;
            }

            public Builder registryCredential(RegistryCredentialProperty registryCredential) {
                this.registryCredential = registryCredential;
                return this;
            }

            public Builder registryCredential(IResolvable registryCredential) {
                this.registryCredential = registryCredential;
                return this;
            }

            public EnvironmentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.CfnProject.CloudWatchLogsConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudWatchLogsConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getStatus();

        @Nullable
        default public String getGroupName() {
            return null;
        }

        @Nullable
        default public String getStreamName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CloudWatchLogsConfigProperty> {
            String status;
            String groupName;
            String streamName;

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public Builder groupName(String groupName) {
                this.groupName = groupName;
                return this;
            }

            public Builder streamName(String streamName) {
                this.streamName = streamName;
                return this;
            }

            public CloudWatchLogsConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.CfnProject.BuildStatusConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BuildStatusConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getContext() {
            return null;
        }

        @Nullable
        default public String getTargetUrl() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BuildStatusConfigProperty> {
            String context;
            String targetUrl;

            public Builder context(String context) {
                this.context = context;
                return this;
            }

            public Builder targetUrl(String targetUrl) {
                this.targetUrl = targetUrl;
                return this;
            }

            public BuildStatusConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.CfnProject.BatchRestrictionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BatchRestrictionsProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getComputeTypesAllowed() {
            return null;
        }

        @Nullable
        default public Number getMaximumBuildsAllowed() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BatchRestrictionsProperty> {
            List<String> computeTypesAllowed;
            Number maximumBuildsAllowed;

            public Builder computeTypesAllowed(List<String> computeTypesAllowed) {
                this.computeTypesAllowed = computeTypesAllowed;
                return this;
            }

            public Builder maximumBuildsAllowed(Number maximumBuildsAllowed) {
                this.maximumBuildsAllowed = maximumBuildsAllowed;
                return this;
            }

            public BatchRestrictionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_codebuild.CfnProject.ArtifactsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ArtifactsProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public String getArtifactIdentifier() {
            return null;
        }

        @Nullable
        default public Object getEncryptionDisabled() {
            return null;
        }

        @Nullable
        default public String getLocation() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public String getNamespaceType() {
            return null;
        }

        @Nullable
        default public Object getOverrideArtifactName() {
            return null;
        }

        @Nullable
        default public String getPackaging() {
            return null;
        }

        @Nullable
        default public String getPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ArtifactsProperty> {
            String type;
            String artifactIdentifier;
            Object encryptionDisabled;
            String location;
            String name;
            String namespaceType;
            Object overrideArtifactName;
            String packaging;
            String path;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder artifactIdentifier(String artifactIdentifier) {
                this.artifactIdentifier = artifactIdentifier;
                return this;
            }

            public Builder encryptionDisabled(Boolean encryptionDisabled) {
                this.encryptionDisabled = encryptionDisabled;
                return this;
            }

            public Builder encryptionDisabled(IResolvable encryptionDisabled) {
                this.encryptionDisabled = encryptionDisabled;
                return this;
            }

            public Builder location(String location) {
                this.location = location;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder namespaceType(String namespaceType) {
                this.namespaceType = namespaceType;
                return this;
            }

            public Builder overrideArtifactName(Boolean overrideArtifactName) {
                this.overrideArtifactName = overrideArtifactName;
                return this;
            }

            public Builder overrideArtifactName(IResolvable overrideArtifactName) {
                this.overrideArtifactName = overrideArtifactName;
                return this;
            }

            public Builder packaging(String packaging) {
                this.packaging = packaging;
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public ArtifactsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

