/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.databrew;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.databrew.CfnJob;
import software.amazon.awscdk.services.databrew.CfnJobProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk.aws_databrew.CfnJob")
public class CfnJob
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnJob.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnJob(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnJob(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnJob(@NotNull Construct scope, @NotNull String id, @NotNull CfnJobProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @NotNull
    public String getRoleArn() {
        return (String)Kernel.get((Object)this, (String)"roleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setRoleArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"roleArn", (Object)Objects.requireNonNull(value, "roleArn is required"));
    }

    @NotNull
    public String getType() {
        return (String)Kernel.get((Object)this, (String)"type", (NativeType)NativeType.forClass(String.class));
    }

    public void setType(@NotNull String value) {
        Kernel.set((Object)this, (String)"type", (Object)Objects.requireNonNull(value, "type is required"));
    }

    @Nullable
    public Object getDatabaseOutputs() {
        return Kernel.get((Object)this, (String)"databaseOutputs", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDatabaseOutputs(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"databaseOutputs", (Object)value);
    }

    public void setDatabaseOutputs(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof DatabaseOutputProperty || __val_ac66f0 instanceof IResolvable || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.services.databrew.CfnJob.DatabaseOutputProperty, software.amazon.awscdk.core.IResolvable; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"databaseOutputs", value);
    }

    @Nullable
    public Object getDataCatalogOutputs() {
        return Kernel.get((Object)this, (String)"dataCatalogOutputs", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDataCatalogOutputs(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"dataCatalogOutputs", (Object)value);
    }

    public void setDataCatalogOutputs(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof DataCatalogOutputProperty || __val_ac66f0 instanceof IResolvable || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.services.databrew.CfnJob.DataCatalogOutputProperty, software.amazon.awscdk.core.IResolvable; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"dataCatalogOutputs", value);
    }

    @Nullable
    public String getDatasetName() {
        return (String)Kernel.get((Object)this, (String)"datasetName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDatasetName(@Nullable String value) {
        Kernel.set((Object)this, (String)"datasetName", (Object)value);
    }

    @Nullable
    public String getEncryptionKeyArn() {
        return (String)Kernel.get((Object)this, (String)"encryptionKeyArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setEncryptionKeyArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"encryptionKeyArn", (Object)value);
    }

    @Nullable
    public String getEncryptionMode() {
        return (String)Kernel.get((Object)this, (String)"encryptionMode", (NativeType)NativeType.forClass(String.class));
    }

    public void setEncryptionMode(@Nullable String value) {
        Kernel.set((Object)this, (String)"encryptionMode", (Object)value);
    }

    @Nullable
    public Object getJobSample() {
        return Kernel.get((Object)this, (String)"jobSample", (NativeType)NativeType.forClass(Object.class));
    }

    public void setJobSample(@Nullable JobSampleProperty value) {
        Kernel.set((Object)this, (String)"jobSample", (Object)value);
    }

    public void setJobSample(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"jobSample", (Object)value);
    }

    @Nullable
    public String getLogSubscription() {
        return (String)Kernel.get((Object)this, (String)"logSubscription", (NativeType)NativeType.forClass(String.class));
    }

    public void setLogSubscription(@Nullable String value) {
        Kernel.set((Object)this, (String)"logSubscription", (Object)value);
    }

    @Nullable
    public Number getMaxCapacity() {
        return (Number)Kernel.get((Object)this, (String)"maxCapacity", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMaxCapacity(@Nullable Number value) {
        Kernel.set((Object)this, (String)"maxCapacity", (Object)value);
    }

    @Nullable
    public Number getMaxRetries() {
        return (Number)Kernel.get((Object)this, (String)"maxRetries", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMaxRetries(@Nullable Number value) {
        Kernel.set((Object)this, (String)"maxRetries", (Object)value);
    }

    @Nullable
    public Object getOutputLocation() {
        return Kernel.get((Object)this, (String)"outputLocation", (NativeType)NativeType.forClass(Object.class));
    }

    public void setOutputLocation(@Nullable OutputLocationProperty value) {
        Kernel.set((Object)this, (String)"outputLocation", (Object)value);
    }

    public void setOutputLocation(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"outputLocation", (Object)value);
    }

    @Nullable
    public Object getOutputs() {
        return Kernel.get((Object)this, (String)"outputs", (NativeType)NativeType.forClass(Object.class));
    }

    public void setOutputs(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"outputs", (Object)value);
    }

    public void setOutputs(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof OutputProperty || __val_ac66f0 instanceof IResolvable || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.services.databrew.CfnJob.OutputProperty, software.amazon.awscdk.core.IResolvable; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"outputs", value);
    }

    @Nullable
    public Object getProfileConfiguration() {
        return Kernel.get((Object)this, (String)"profileConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setProfileConfiguration(@Nullable ProfileConfigurationProperty value) {
        Kernel.set((Object)this, (String)"profileConfiguration", (Object)value);
    }

    public void setProfileConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"profileConfiguration", (Object)value);
    }

    @Nullable
    public String getProjectName() {
        return (String)Kernel.get((Object)this, (String)"projectName", (NativeType)NativeType.forClass(String.class));
    }

    public void setProjectName(@Nullable String value) {
        Kernel.set((Object)this, (String)"projectName", (Object)value);
    }

    @Nullable
    public Object getRecipe() {
        return Kernel.get((Object)this, (String)"recipe", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRecipe(@Nullable RecipeProperty value) {
        Kernel.set((Object)this, (String)"recipe", (Object)value);
    }

    public void setRecipe(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"recipe", (Object)value);
    }

    @Nullable
    public Number getTimeout() {
        return (Number)Kernel.get((Object)this, (String)"timeout", (NativeType)NativeType.forClass(Number.class));
    }

    public void setTimeout(@Nullable Number value) {
        Kernel.set((Object)this, (String)"timeout", (Object)value);
    }

    @Nullable
    public Object getValidationConfigurations() {
        return Kernel.get((Object)this, (String)"validationConfigurations", (NativeType)NativeType.forClass(Object.class));
    }

    public void setValidationConfigurations(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"validationConfigurations", (Object)value);
    }

    public void setValidationConfigurations(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof ValidationConfigurationProperty || __val_ac66f0 instanceof IResolvable || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.services.databrew.CfnJob.ValidationConfigurationProperty, software.amazon.awscdk.core.IResolvable; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"validationConfigurations", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnJob> {
        private final Construct scope;
        private final String id;
        private final CfnJobProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnJobProps.Builder();
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder roleArn(String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        public Builder type(String type) {
            this.props.type(type);
            return this;
        }

        public Builder databaseOutputs(IResolvable databaseOutputs) {
            this.props.databaseOutputs(databaseOutputs);
            return this;
        }

        public Builder databaseOutputs(List<? extends Object> databaseOutputs) {
            this.props.databaseOutputs(databaseOutputs);
            return this;
        }

        public Builder dataCatalogOutputs(IResolvable dataCatalogOutputs) {
            this.props.dataCatalogOutputs(dataCatalogOutputs);
            return this;
        }

        public Builder dataCatalogOutputs(List<? extends Object> dataCatalogOutputs) {
            this.props.dataCatalogOutputs(dataCatalogOutputs);
            return this;
        }

        public Builder datasetName(String datasetName) {
            this.props.datasetName(datasetName);
            return this;
        }

        public Builder encryptionKeyArn(String encryptionKeyArn) {
            this.props.encryptionKeyArn(encryptionKeyArn);
            return this;
        }

        public Builder encryptionMode(String encryptionMode) {
            this.props.encryptionMode(encryptionMode);
            return this;
        }

        public Builder jobSample(JobSampleProperty jobSample) {
            this.props.jobSample(jobSample);
            return this;
        }

        public Builder jobSample(IResolvable jobSample) {
            this.props.jobSample(jobSample);
            return this;
        }

        public Builder logSubscription(String logSubscription) {
            this.props.logSubscription(logSubscription);
            return this;
        }

        public Builder maxCapacity(Number maxCapacity) {
            this.props.maxCapacity(maxCapacity);
            return this;
        }

        public Builder maxRetries(Number maxRetries) {
            this.props.maxRetries(maxRetries);
            return this;
        }

        public Builder outputLocation(OutputLocationProperty outputLocation) {
            this.props.outputLocation(outputLocation);
            return this;
        }

        public Builder outputLocation(IResolvable outputLocation) {
            this.props.outputLocation(outputLocation);
            return this;
        }

        public Builder outputs(IResolvable outputs) {
            this.props.outputs(outputs);
            return this;
        }

        public Builder outputs(List<? extends Object> outputs) {
            this.props.outputs(outputs);
            return this;
        }

        public Builder profileConfiguration(ProfileConfigurationProperty profileConfiguration) {
            this.props.profileConfiguration(profileConfiguration);
            return this;
        }

        public Builder profileConfiguration(IResolvable profileConfiguration) {
            this.props.profileConfiguration(profileConfiguration);
            return this;
        }

        public Builder projectName(String projectName) {
            this.props.projectName(projectName);
            return this;
        }

        public Builder recipe(RecipeProperty recipe) {
            this.props.recipe(recipe);
            return this;
        }

        public Builder recipe(IResolvable recipe) {
            this.props.recipe(recipe);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder timeout(Number timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public Builder validationConfigurations(IResolvable validationConfigurations) {
            this.props.validationConfigurations(validationConfigurations);
            return this;
        }

        public Builder validationConfigurations(List<? extends Object> validationConfigurations) {
            this.props.validationConfigurations(validationConfigurations);
            return this;
        }

        public CfnJob build() {
            return new CfnJob(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_databrew.CfnJob.ValidationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ValidationConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getRulesetArn();

        @Nullable
        default public String getValidationMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ValidationConfigurationProperty> {
            String rulesetArn;
            String validationMode;

            public Builder rulesetArn(String rulesetArn) {
                this.rulesetArn = rulesetArn;
                return this;
            }

            public Builder validationMode(String validationMode) {
                this.validationMode = validationMode;
                return this;
            }

            public ValidationConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_databrew.CfnJob.StatisticsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StatisticsConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getIncludedStatistics() {
            return null;
        }

        @Nullable
        default public Object getOverrides() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StatisticsConfigurationProperty> {
            List<String> includedStatistics;
            Object overrides;

            public Builder includedStatistics(List<String> includedStatistics) {
                this.includedStatistics = includedStatistics;
                return this;
            }

            public Builder overrides(IResolvable overrides) {
                this.overrides = overrides;
                return this;
            }

            public Builder overrides(List<? extends Object> overrides) {
                this.overrides = overrides;
                return this;
            }

            public StatisticsConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_databrew.CfnJob.StatisticOverrideProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StatisticOverrideProperty
    extends JsiiSerializable {
        @NotNull
        public Object getParameters();

        @NotNull
        public String getStatistic();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StatisticOverrideProperty> {
            Object parameters;
            String statistic;

            public Builder parameters(IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            public Builder parameters(Map<String, String> parameters) {
                this.parameters = parameters;
                return this;
            }

            public Builder statistic(String statistic) {
                this.statistic = statistic;
                return this;
            }

            public StatisticOverrideProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_databrew.CfnJob.S3TableOutputOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3TableOutputOptionsProperty
    extends JsiiSerializable {
        @NotNull
        public Object getLocation();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3TableOutputOptionsProperty> {
            Object location;

            public Builder location(S3LocationProperty location) {
                this.location = location;
                return this;
            }

            public Builder location(IResolvable location) {
                this.location = location;
                return this;
            }

            public S3TableOutputOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_databrew.CfnJob.S3LocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @Nullable
        default public String getBucketOwner() {
            return null;
        }

        @Nullable
        default public String getKey() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3LocationProperty> {
            String bucket;
            String bucketOwner;
            String key;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder bucketOwner(String bucketOwner) {
                this.bucketOwner = bucketOwner;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public S3LocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_databrew.CfnJob.RecipeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RecipeProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @Nullable
        default public String getVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RecipeProperty> {
            String name;
            String version;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public RecipeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_databrew.CfnJob.ProfileConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProfileConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getColumnStatisticsConfigurations() {
            return null;
        }

        @Nullable
        default public Object getDatasetStatisticsConfiguration() {
            return null;
        }

        @Nullable
        default public Object getEntityDetectorConfiguration() {
            return null;
        }

        @Nullable
        default public Object getProfileColumns() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProfileConfigurationProperty> {
            Object columnStatisticsConfigurations;
            Object datasetStatisticsConfiguration;
            Object entityDetectorConfiguration;
            Object profileColumns;

            public Builder columnStatisticsConfigurations(IResolvable columnStatisticsConfigurations) {
                this.columnStatisticsConfigurations = columnStatisticsConfigurations;
                return this;
            }

            public Builder columnStatisticsConfigurations(List<? extends Object> columnStatisticsConfigurations) {
                this.columnStatisticsConfigurations = columnStatisticsConfigurations;
                return this;
            }

            public Builder datasetStatisticsConfiguration(StatisticsConfigurationProperty datasetStatisticsConfiguration) {
                this.datasetStatisticsConfiguration = datasetStatisticsConfiguration;
                return this;
            }

            public Builder datasetStatisticsConfiguration(IResolvable datasetStatisticsConfiguration) {
                this.datasetStatisticsConfiguration = datasetStatisticsConfiguration;
                return this;
            }

            public Builder entityDetectorConfiguration(EntityDetectorConfigurationProperty entityDetectorConfiguration) {
                this.entityDetectorConfiguration = entityDetectorConfiguration;
                return this;
            }

            public Builder entityDetectorConfiguration(IResolvable entityDetectorConfiguration) {
                this.entityDetectorConfiguration = entityDetectorConfiguration;
                return this;
            }

            public Builder profileColumns(IResolvable profileColumns) {
                this.profileColumns = profileColumns;
                return this;
            }

            public Builder profileColumns(List<? extends Object> profileColumns) {
                this.profileColumns = profileColumns;
                return this;
            }

            public ProfileConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_databrew.CfnJob.OutputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OutputProperty
    extends JsiiSerializable {
        @NotNull
        public Object getLocation();

        @Nullable
        default public String getCompressionFormat() {
            return null;
        }

        @Nullable
        default public String getFormat() {
            return null;
        }

        @Nullable
        default public Object getFormatOptions() {
            return null;
        }

        @Nullable
        default public Number getMaxOutputFiles() {
            return null;
        }

        @Nullable
        default public Object getOverwrite() {
            return null;
        }

        @Nullable
        default public List<String> getPartitionColumns() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OutputProperty> {
            Object location;
            String compressionFormat;
            String format;
            Object formatOptions;
            Number maxOutputFiles;
            Object overwrite;
            List<String> partitionColumns;

            public Builder location(S3LocationProperty location) {
                this.location = location;
                return this;
            }

            public Builder location(IResolvable location) {
                this.location = location;
                return this;
            }

            public Builder compressionFormat(String compressionFormat) {
                this.compressionFormat = compressionFormat;
                return this;
            }

            public Builder format(String format) {
                this.format = format;
                return this;
            }

            public Builder formatOptions(OutputFormatOptionsProperty formatOptions) {
                this.formatOptions = formatOptions;
                return this;
            }

            public Builder formatOptions(IResolvable formatOptions) {
                this.formatOptions = formatOptions;
                return this;
            }

            public Builder maxOutputFiles(Number maxOutputFiles) {
                this.maxOutputFiles = maxOutputFiles;
                return this;
            }

            public Builder overwrite(Boolean overwrite) {
                this.overwrite = overwrite;
                return this;
            }

            public Builder overwrite(IResolvable overwrite) {
                this.overwrite = overwrite;
                return this;
            }

            public Builder partitionColumns(List<String> partitionColumns) {
                this.partitionColumns = partitionColumns;
                return this;
            }

            public OutputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_databrew.CfnJob.OutputLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OutputLocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @Nullable
        default public String getBucketOwner() {
            return null;
        }

        @Nullable
        default public String getKey() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OutputLocationProperty> {
            String bucket;
            String bucketOwner;
            String key;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder bucketOwner(String bucketOwner) {
                this.bucketOwner = bucketOwner;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public OutputLocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_databrew.CfnJob.OutputFormatOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OutputFormatOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCsv() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OutputFormatOptionsProperty> {
            Object csv;

            public Builder csv(CsvOutputOptionsProperty csv) {
                this.csv = csv;
                return this;
            }

            public Builder csv(IResolvable csv) {
                this.csv = csv;
                return this;
            }

            public OutputFormatOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_databrew.CfnJob.JobSampleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface JobSampleProperty
    extends JsiiSerializable {
        @Nullable
        default public String getMode() {
            return null;
        }

        @Nullable
        default public Number getSize() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<JobSampleProperty> {
            String mode;
            Number size;

            public Builder mode(String mode) {
                this.mode = mode;
                return this;
            }

            public Builder size(Number size) {
                this.size = size;
                return this;
            }

            public JobSampleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_databrew.CfnJob.EntityDetectorConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EntityDetectorConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getEntityTypes();

        @Nullable
        default public Object getAllowedStatistics() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EntityDetectorConfigurationProperty> {
            List<String> entityTypes;
            Object allowedStatistics;

            public Builder entityTypes(List<String> entityTypes) {
                this.entityTypes = entityTypes;
                return this;
            }

            public Builder allowedStatistics(AllowedStatisticsProperty allowedStatistics) {
                this.allowedStatistics = allowedStatistics;
                return this;
            }

            public Builder allowedStatistics(IResolvable allowedStatistics) {
                this.allowedStatistics = allowedStatistics;
                return this;
            }

            public EntityDetectorConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_databrew.CfnJob.DatabaseTableOutputOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DatabaseTableOutputOptionsProperty
    extends JsiiSerializable {
        @NotNull
        public String getTableName();

        @Nullable
        default public Object getTempDirectory() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DatabaseTableOutputOptionsProperty> {
            String tableName;
            Object tempDirectory;

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public Builder tempDirectory(S3LocationProperty tempDirectory) {
                this.tempDirectory = tempDirectory;
                return this;
            }

            public Builder tempDirectory(IResolvable tempDirectory) {
                this.tempDirectory = tempDirectory;
                return this;
            }

            public DatabaseTableOutputOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_databrew.CfnJob.DatabaseOutputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DatabaseOutputProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDatabaseOptions();

        @NotNull
        public String getGlueConnectionName();

        @Nullable
        default public String getDatabaseOutputMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DatabaseOutputProperty> {
            Object databaseOptions;
            String glueConnectionName;
            String databaseOutputMode;

            public Builder databaseOptions(DatabaseTableOutputOptionsProperty databaseOptions) {
                this.databaseOptions = databaseOptions;
                return this;
            }

            public Builder databaseOptions(IResolvable databaseOptions) {
                this.databaseOptions = databaseOptions;
                return this;
            }

            public Builder glueConnectionName(String glueConnectionName) {
                this.glueConnectionName = glueConnectionName;
                return this;
            }

            public Builder databaseOutputMode(String databaseOutputMode) {
                this.databaseOutputMode = databaseOutputMode;
                return this;
            }

            public DatabaseOutputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_databrew.CfnJob.DataCatalogOutputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataCatalogOutputProperty
    extends JsiiSerializable {
        @NotNull
        public String getDatabaseName();

        @NotNull
        public String getTableName();

        @Nullable
        default public String getCatalogId() {
            return null;
        }

        @Nullable
        default public Object getDatabaseOptions() {
            return null;
        }

        @Nullable
        default public Object getOverwrite() {
            return null;
        }

        @Nullable
        default public Object getS3Options() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataCatalogOutputProperty> {
            String databaseName;
            String tableName;
            String catalogId;
            Object databaseOptions;
            Object overwrite;
            Object s3Options;

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public Builder catalogId(String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            public Builder databaseOptions(DatabaseTableOutputOptionsProperty databaseOptions) {
                this.databaseOptions = databaseOptions;
                return this;
            }

            public Builder databaseOptions(IResolvable databaseOptions) {
                this.databaseOptions = databaseOptions;
                return this;
            }

            public Builder overwrite(Boolean overwrite) {
                this.overwrite = overwrite;
                return this;
            }

            public Builder overwrite(IResolvable overwrite) {
                this.overwrite = overwrite;
                return this;
            }

            public Builder s3Options(S3TableOutputOptionsProperty s3Options) {
                this.s3Options = s3Options;
                return this;
            }

            public Builder s3Options(IResolvable s3Options) {
                this.s3Options = s3Options;
                return this;
            }

            public DataCatalogOutputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_databrew.CfnJob.CsvOutputOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CsvOutputOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDelimiter() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CsvOutputOptionsProperty> {
            String delimiter;

            public Builder delimiter(String delimiter) {
                this.delimiter = delimiter;
                return this;
            }

            public CsvOutputOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_databrew.CfnJob.ColumnStatisticsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ColumnStatisticsConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getStatistics();

        @Nullable
        default public Object getSelectors() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ColumnStatisticsConfigurationProperty> {
            Object statistics;
            Object selectors;

            public Builder statistics(StatisticsConfigurationProperty statistics) {
                this.statistics = statistics;
                return this;
            }

            public Builder statistics(IResolvable statistics) {
                this.statistics = statistics;
                return this;
            }

            public Builder selectors(IResolvable selectors) {
                this.selectors = selectors;
                return this;
            }

            public Builder selectors(List<? extends Object> selectors) {
                this.selectors = selectors;
                return this;
            }

            public ColumnStatisticsConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_databrew.CfnJob.ColumnSelectorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ColumnSelectorProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public String getRegex() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ColumnSelectorProperty> {
            String name;
            String regex;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder regex(String regex) {
                this.regex = regex;
                return this;
            }

            public ColumnSelectorProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_databrew.CfnJob.AllowedStatisticsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AllowedStatisticsProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getStatistics();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AllowedStatisticsProperty> {
            List<String> statistics;

            public Builder statistics(List<String> statistics) {
                this.statistics = statistics;
                return this;
            }

            public AllowedStatisticsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

