/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.glue;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.events.OnEventOptions;
import software.amazon.awscdk.services.events.Rule;
import software.amazon.awscdk.services.glue.ContinuousLoggingProps;
import software.amazon.awscdk.services.glue.IConnection;
import software.amazon.awscdk.services.glue.IJob;
import software.amazon.awscdk.services.glue.ISecurityConfiguration;
import software.amazon.awscdk.services.glue.JobAttributes;
import software.amazon.awscdk.services.glue.JobExecutable;
import software.amazon.awscdk.services.glue.JobProps;
import software.amazon.awscdk.services.glue.JobState;
import software.amazon.awscdk.services.glue.MetricType;
import software.amazon.awscdk.services.glue.SparkUILoggingLocation;
import software.amazon.awscdk.services.glue.SparkUIProps;
import software.amazon.awscdk.services.glue.WorkerType;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk.aws_glue.Job")
public class Job
extends Resource
implements IJob {
    protected Job(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Job(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Job(@NotNull Construct scope, @NotNull String id, @NotNull JobProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IJob fromJobAttributes(@NotNull Construct scope, @NotNull String id, @NotNull JobAttributes attrs) {
        return (IJob)JsiiObject.jsiiStaticCall(Job.class, (String)"fromJobAttributes", (NativeType)NativeType.forClass(IJob.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName, @NotNull MetricType type, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), Objects.requireNonNull(type, "type is required"), props});
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName, @NotNull MetricType type) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), Objects.requireNonNull(type, "type is required")});
    }

    @Override
    @NotNull
    public Metric metricFailure(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricFailure", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricFailure() {
        return (Metric)Kernel.call((Object)this, (String)"metricFailure", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricSuccess(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricSuccess", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricSuccess() {
        return (Metric)Kernel.call((Object)this, (String)"metricSuccess", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricTimeout(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricTimeout", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricTimeout() {
        return (Metric)Kernel.call((Object)this, (String)"metricTimeout", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Rule onEvent(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onEvent", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onEvent(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onEvent", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onFailure(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onFailure", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onFailure(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onFailure", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onStateChange(@NotNull String id, @NotNull JobState jobState, @Nullable OnEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onStateChange", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(jobState, "jobState is required"), options});
    }

    @Override
    @NotNull
    public Rule onStateChange(@NotNull String id, @NotNull JobState jobState) {
        return (Rule)Kernel.call((Object)this, (String)"onStateChange", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(jobState, "jobState is required")});
    }

    @Override
    @NotNull
    public Rule onSuccess(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onSuccess", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onSuccess(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onSuccess", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onTimeout(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onTimeout", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onTimeout(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onTimeout", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public IPrincipal getGrantPrincipal() {
        return (IPrincipal)Kernel.get((Object)this, (String)"grantPrincipal", (NativeType)NativeType.forClass(IPrincipal.class));
    }

    @Override
    @NotNull
    public String getJobArn() {
        return (String)Kernel.get((Object)this, (String)"jobArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getJobName() {
        return (String)Kernel.get((Object)this, (String)"jobName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IRole getRole() {
        return (IRole)Kernel.get((Object)this, (String)"role", (NativeType)NativeType.forClass(IRole.class));
    }

    @Nullable
    public SparkUILoggingLocation getSparkUILoggingLocation() {
        return (SparkUILoggingLocation)Kernel.get((Object)this, (String)"sparkUILoggingLocation", (NativeType)NativeType.forClass(SparkUILoggingLocation.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Job> {
        private final Construct scope;
        private final String id;
        private final JobProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new JobProps.Builder();
        }

        public Builder executable(JobExecutable executable) {
            this.props.executable(executable);
            return this;
        }

        public Builder connections(List<? extends IConnection> connections) {
            this.props.connections(connections);
            return this;
        }

        public Builder continuousLogging(ContinuousLoggingProps continuousLogging) {
            this.props.continuousLogging(continuousLogging);
            return this;
        }

        public Builder defaultArguments(Map<String, String> defaultArguments) {
            this.props.defaultArguments(defaultArguments);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder enableProfilingMetrics(Boolean enableProfilingMetrics) {
            this.props.enableProfilingMetrics(enableProfilingMetrics);
            return this;
        }

        public Builder jobName(String jobName) {
            this.props.jobName(jobName);
            return this;
        }

        public Builder maxCapacity(Number maxCapacity) {
            this.props.maxCapacity(maxCapacity);
            return this;
        }

        public Builder maxConcurrentRuns(Number maxConcurrentRuns) {
            this.props.maxConcurrentRuns(maxConcurrentRuns);
            return this;
        }

        public Builder maxRetries(Number maxRetries) {
            this.props.maxRetries(maxRetries);
            return this;
        }

        public Builder notifyDelayAfter(Duration notifyDelayAfter) {
            this.props.notifyDelayAfter(notifyDelayAfter);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder securityConfiguration(ISecurityConfiguration securityConfiguration) {
            this.props.securityConfiguration(securityConfiguration);
            return this;
        }

        public Builder sparkUi(SparkUIProps sparkUi) {
            this.props.sparkUi(sparkUi);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public Builder workerCount(Number workerCount) {
            this.props.workerCount(workerCount);
            return this;
        }

        public Builder workerType(WorkerType workerType) {
            this.props.workerType(workerType);
            return this;
        }

        public Job build() {
            return new Job(this.scope, this.id, this.props.build());
        }
    }
}

