/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.imagebuilder;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.imagebuilder.CfnInfrastructureConfiguration;
import software.amazon.awscdk.services.imagebuilder.CfnInfrastructureConfigurationProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk.aws_imagebuilder.CfnInfrastructureConfiguration")
public class CfnInfrastructureConfiguration
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnInfrastructureConfiguration.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnInfrastructureConfiguration(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInfrastructureConfiguration(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnInfrastructureConfiguration(@NotNull Construct scope, @NotNull String id, @NotNull CfnInfrastructureConfigurationProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrName() {
        return (String)Kernel.get((Object)this, (String)"attrName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getInstanceProfileName() {
        return (String)Kernel.get((Object)this, (String)"instanceProfileName", (NativeType)NativeType.forClass(String.class));
    }

    public void setInstanceProfileName(@NotNull String value) {
        Kernel.set((Object)this, (String)"instanceProfileName", (Object)Objects.requireNonNull(value, "instanceProfileName is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Object getInstanceMetadataOptions() {
        return Kernel.get((Object)this, (String)"instanceMetadataOptions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setInstanceMetadataOptions(@Nullable InstanceMetadataOptionsProperty value) {
        Kernel.set((Object)this, (String)"instanceMetadataOptions", (Object)value);
    }

    public void setInstanceMetadataOptions(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"instanceMetadataOptions", (Object)value);
    }

    @Nullable
    public List<String> getInstanceTypes() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"instanceTypes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setInstanceTypes(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"instanceTypes", value);
    }

    @Nullable
    public String getKeyPair() {
        return (String)Kernel.get((Object)this, (String)"keyPair", (NativeType)NativeType.forClass(String.class));
    }

    public void setKeyPair(@Nullable String value) {
        Kernel.set((Object)this, (String)"keyPair", (Object)value);
    }

    @Nullable
    public Object getLogging() {
        return Kernel.get((Object)this, (String)"logging", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLogging(@Nullable LoggingProperty value) {
        Kernel.set((Object)this, (String)"logging", (Object)value);
    }

    public void setLogging(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"logging", (Object)value);
    }

    @Nullable
    public Object getResourceTags() {
        return Kernel.get((Object)this, (String)"resourceTags", (NativeType)NativeType.forClass(Object.class));
    }

    public void setResourceTags(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"resourceTags", (Object)value);
    }

    public void setResourceTags(@Nullable Map<String, String> value) {
        Kernel.set((Object)this, (String)"resourceTags", value);
    }

    @Nullable
    public List<String> getSecurityGroupIds() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"securityGroupIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSecurityGroupIds(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"securityGroupIds", value);
    }

    @Nullable
    public String getSnsTopicArn() {
        return (String)Kernel.get((Object)this, (String)"snsTopicArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setSnsTopicArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"snsTopicArn", (Object)value);
    }

    @Nullable
    public String getSubnetId() {
        return (String)Kernel.get((Object)this, (String)"subnetId", (NativeType)NativeType.forClass(String.class));
    }

    public void setSubnetId(@Nullable String value) {
        Kernel.set((Object)this, (String)"subnetId", (Object)value);
    }

    @Nullable
    public Object getTerminateInstanceOnFailure() {
        return Kernel.get((Object)this, (String)"terminateInstanceOnFailure", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTerminateInstanceOnFailure(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"terminateInstanceOnFailure", (Object)value);
    }

    public void setTerminateInstanceOnFailure(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"terminateInstanceOnFailure", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnInfrastructureConfiguration> {
        private final Construct scope;
        private final String id;
        private final CfnInfrastructureConfigurationProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnInfrastructureConfigurationProps.Builder();
        }

        public Builder instanceProfileName(String instanceProfileName) {
            this.props.instanceProfileName(instanceProfileName);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder instanceMetadataOptions(InstanceMetadataOptionsProperty instanceMetadataOptions) {
            this.props.instanceMetadataOptions(instanceMetadataOptions);
            return this;
        }

        public Builder instanceMetadataOptions(IResolvable instanceMetadataOptions) {
            this.props.instanceMetadataOptions(instanceMetadataOptions);
            return this;
        }

        public Builder instanceTypes(List<String> instanceTypes) {
            this.props.instanceTypes(instanceTypes);
            return this;
        }

        public Builder keyPair(String keyPair) {
            this.props.keyPair(keyPair);
            return this;
        }

        public Builder logging(LoggingProperty logging) {
            this.props.logging(logging);
            return this;
        }

        public Builder logging(IResolvable logging) {
            this.props.logging(logging);
            return this;
        }

        public Builder resourceTags(IResolvable resourceTags) {
            this.props.resourceTags(resourceTags);
            return this;
        }

        public Builder resourceTags(Map<String, String> resourceTags) {
            this.props.resourceTags(resourceTags);
            return this;
        }

        public Builder securityGroupIds(List<String> securityGroupIds) {
            this.props.securityGroupIds(securityGroupIds);
            return this;
        }

        public Builder snsTopicArn(String snsTopicArn) {
            this.props.snsTopicArn(snsTopicArn);
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.props.subnetId(subnetId);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder terminateInstanceOnFailure(Boolean terminateInstanceOnFailure) {
            this.props.terminateInstanceOnFailure(terminateInstanceOnFailure);
            return this;
        }

        public Builder terminateInstanceOnFailure(IResolvable terminateInstanceOnFailure) {
            this.props.terminateInstanceOnFailure(terminateInstanceOnFailure);
            return this;
        }

        public CfnInfrastructureConfiguration build() {
            return new CfnInfrastructureConfiguration(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_imagebuilder.CfnInfrastructureConfiguration.S3LogsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LogsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getS3BucketName() {
            return null;
        }

        @Nullable
        default public String getS3KeyPrefix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3LogsProperty> {
            String s3BucketName;
            String s3KeyPrefix;

            public Builder s3BucketName(String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            public Builder s3KeyPrefix(String s3KeyPrefix) {
                this.s3KeyPrefix = s3KeyPrefix;
                return this;
            }

            public S3LogsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_imagebuilder.CfnInfrastructureConfiguration.LoggingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LoggingProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getS3Logs() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LoggingProperty> {
            Object s3Logs;

            public Builder s3Logs(S3LogsProperty s3Logs) {
                this.s3Logs = s3Logs;
                return this;
            }

            public Builder s3Logs(IResolvable s3Logs) {
                this.s3Logs = s3Logs;
                return this;
            }

            public LoggingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_imagebuilder.CfnInfrastructureConfiguration.InstanceMetadataOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceMetadataOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getHttpPutResponseHopLimit() {
            return null;
        }

        @Nullable
        default public String getHttpTokens() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstanceMetadataOptionsProperty> {
            Number httpPutResponseHopLimit;
            String httpTokens;

            public Builder httpPutResponseHopLimit(Number httpPutResponseHopLimit) {
                this.httpPutResponseHopLimit = httpPutResponseHopLimit;
                return this;
            }

            public Builder httpTokens(String httpTokens) {
                this.httpTokens = httpTokens;
                return this;
            }

            public InstanceMetadataOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

