/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.msk;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.msk.BrokerLogging;
import software.amazon.awscdk.services.msk.ClientAuthentication;
import software.amazon.awscdk.services.msk.ClusterConfigurationInfo;
import software.amazon.awscdk.services.msk.ClusterProps;
import software.amazon.awscdk.services.msk.EbsStorageInfo;
import software.amazon.awscdk.services.msk.EncryptionInTransitConfig;
import software.amazon.awscdk.services.msk.KafkaVersion;
import software.amazon.awscdk.services.msk.MonitoringConfiguration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="monocdk.aws_msk.ClusterProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface ClusterProps
extends JsiiSerializable {
    @NotNull
    public String getClusterName();

    @NotNull
    public KafkaVersion getKafkaVersion();

    @NotNull
    public IVpc getVpc();

    @Nullable
    default public ClientAuthentication getClientAuthentication() {
        return null;
    }

    @Nullable
    default public ClusterConfigurationInfo getConfigurationInfo() {
        return null;
    }

    @Nullable
    default public EbsStorageInfo getEbsStorageInfo() {
        return null;
    }

    @Nullable
    default public EncryptionInTransitConfig getEncryptionInTransit() {
        return null;
    }

    @Nullable
    default public InstanceType getInstanceType() {
        return null;
    }

    @Nullable
    default public BrokerLogging getLogging() {
        return null;
    }

    @Nullable
    default public MonitoringConfiguration getMonitoring() {
        return null;
    }

    @Nullable
    default public Number getNumberOfBrokerNodes() {
        return null;
    }

    @Nullable
    default public RemovalPolicy getRemovalPolicy() {
        return null;
    }

    @Nullable
    default public List<ISecurityGroup> getSecurityGroups() {
        return null;
    }

    @Nullable
    default public SubnetSelection getVpcSubnets() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ClusterProps> {
        String clusterName;
        KafkaVersion kafkaVersion;
        IVpc vpc;
        ClientAuthentication clientAuthentication;
        ClusterConfigurationInfo configurationInfo;
        EbsStorageInfo ebsStorageInfo;
        EncryptionInTransitConfig encryptionInTransit;
        InstanceType instanceType;
        BrokerLogging logging;
        MonitoringConfiguration monitoring;
        Number numberOfBrokerNodes;
        RemovalPolicy removalPolicy;
        List<ISecurityGroup> securityGroups;
        SubnetSelection vpcSubnets;

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder kafkaVersion(KafkaVersion kafkaVersion) {
            this.kafkaVersion = kafkaVersion;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder clientAuthentication(ClientAuthentication clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        public Builder configurationInfo(ClusterConfigurationInfo configurationInfo) {
            this.configurationInfo = configurationInfo;
            return this;
        }

        public Builder ebsStorageInfo(EbsStorageInfo ebsStorageInfo) {
            this.ebsStorageInfo = ebsStorageInfo;
            return this;
        }

        public Builder encryptionInTransit(EncryptionInTransitConfig encryptionInTransit) {
            this.encryptionInTransit = encryptionInTransit;
            return this;
        }

        public Builder instanceType(InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder logging(BrokerLogging logging) {
            this.logging = logging;
            return this;
        }

        public Builder monitoring(MonitoringConfiguration monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public Builder numberOfBrokerNodes(Number numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public ClusterProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

