/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.rds;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.SecretValue;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.rds.CredentialsBaseOptions;
import software.amazon.awscdk.services.rds.CredentialsFromUsernameOptions;
import software.amazon.awscdk.services.secretsmanager.ISecret;
import software.amazon.awscdk.services.secretsmanager.ReplicaRegion;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk.aws_rds.Credentials")
public abstract class Credentials
extends JsiiObject {
    protected Credentials(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Credentials(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    protected Credentials() {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[0]);
    }

    @NotNull
    public static Credentials fromGeneratedSecret(@NotNull String username, @Nullable CredentialsBaseOptions options) {
        return (Credentials)((Object)JsiiObject.jsiiStaticCall(Credentials.class, (String)"fromGeneratedSecret", (NativeType)NativeType.forClass(Credentials.class), (Object[])new Object[]{Objects.requireNonNull(username, "username is required"), options}));
    }

    @NotNull
    public static Credentials fromGeneratedSecret(@NotNull String username) {
        return (Credentials)((Object)JsiiObject.jsiiStaticCall(Credentials.class, (String)"fromGeneratedSecret", (NativeType)NativeType.forClass(Credentials.class), (Object[])new Object[]{Objects.requireNonNull(username, "username is required")}));
    }

    @NotNull
    public static Credentials fromPassword(@NotNull String username, @NotNull SecretValue password) {
        return (Credentials)((Object)JsiiObject.jsiiStaticCall(Credentials.class, (String)"fromPassword", (NativeType)NativeType.forClass(Credentials.class), (Object[])new Object[]{Objects.requireNonNull(username, "username is required"), Objects.requireNonNull(password, "password is required")}));
    }

    @NotNull
    public static Credentials fromSecret(@NotNull ISecret secret, @Nullable String username) {
        return (Credentials)((Object)JsiiObject.jsiiStaticCall(Credentials.class, (String)"fromSecret", (NativeType)NativeType.forClass(Credentials.class), (Object[])new Object[]{Objects.requireNonNull(secret, "secret is required"), username}));
    }

    @NotNull
    public static Credentials fromSecret(@NotNull ISecret secret) {
        return (Credentials)((Object)JsiiObject.jsiiStaticCall(Credentials.class, (String)"fromSecret", (NativeType)NativeType.forClass(Credentials.class), (Object[])new Object[]{Objects.requireNonNull(secret, "secret is required")}));
    }

    @NotNull
    public static Credentials fromUsername(@NotNull String username, @Nullable CredentialsFromUsernameOptions options) {
        return (Credentials)((Object)JsiiObject.jsiiStaticCall(Credentials.class, (String)"fromUsername", (NativeType)NativeType.forClass(Credentials.class), (Object[])new Object[]{Objects.requireNonNull(username, "username is required"), options}));
    }

    @NotNull
    public static Credentials fromUsername(@NotNull String username) {
        return (Credentials)((Object)JsiiObject.jsiiStaticCall(Credentials.class, (String)"fromUsername", (NativeType)NativeType.forClass(Credentials.class), (Object[])new Object[]{Objects.requireNonNull(username, "username is required")}));
    }

    @NotNull
    public abstract String getUsername();

    @Nullable
    public abstract IKey getEncryptionKey();

    @Nullable
    public abstract String getExcludeCharacters();

    @Nullable
    public abstract SecretValue getPassword();

    @Nullable
    public abstract List<ReplicaRegion> getReplicaRegions();

    @Nullable
    public abstract ISecret getSecret();

    @Nullable
    public abstract String getSecretName();

    @Nullable
    public abstract Boolean getUsernameAsString();
}

