/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sagemaker;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.sagemaker.CfnUserProfile;
import software.amazon.awscdk.services.sagemaker.CfnUserProfileProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk.aws_sagemaker.CfnUserProfile")
public class CfnUserProfile
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnUserProfile.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnUserProfile(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnUserProfile(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnUserProfile(@NotNull Construct scope, @NotNull String id, @NotNull CfnUserProfileProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrUserProfileArn() {
        return (String)Kernel.get((Object)this, (String)"attrUserProfileArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getDomainId() {
        return (String)Kernel.get((Object)this, (String)"domainId", (NativeType)NativeType.forClass(String.class));
    }

    public void setDomainId(@NotNull String value) {
        Kernel.set((Object)this, (String)"domainId", (Object)Objects.requireNonNull(value, "domainId is required"));
    }

    @NotNull
    public String getUserProfileName() {
        return (String)Kernel.get((Object)this, (String)"userProfileName", (NativeType)NativeType.forClass(String.class));
    }

    public void setUserProfileName(@NotNull String value) {
        Kernel.set((Object)this, (String)"userProfileName", (Object)Objects.requireNonNull(value, "userProfileName is required"));
    }

    @Nullable
    public String getSingleSignOnUserIdentifier() {
        return (String)Kernel.get((Object)this, (String)"singleSignOnUserIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setSingleSignOnUserIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"singleSignOnUserIdentifier", (Object)value);
    }

    @Nullable
    public String getSingleSignOnUserValue() {
        return (String)Kernel.get((Object)this, (String)"singleSignOnUserValue", (NativeType)NativeType.forClass(String.class));
    }

    public void setSingleSignOnUserValue(@Nullable String value) {
        Kernel.set((Object)this, (String)"singleSignOnUserValue", (Object)value);
    }

    @Nullable
    public Object getUserSettings() {
        return Kernel.get((Object)this, (String)"userSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setUserSettings(@Nullable UserSettingsProperty value) {
        Kernel.set((Object)this, (String)"userSettings", (Object)value);
    }

    public void setUserSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"userSettings", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnUserProfile> {
        private final Construct scope;
        private final String id;
        private final CfnUserProfileProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnUserProfileProps.Builder();
        }

        public Builder domainId(String domainId) {
            this.props.domainId(domainId);
            return this;
        }

        public Builder userProfileName(String userProfileName) {
            this.props.userProfileName(userProfileName);
            return this;
        }

        public Builder singleSignOnUserIdentifier(String singleSignOnUserIdentifier) {
            this.props.singleSignOnUserIdentifier(singleSignOnUserIdentifier);
            return this;
        }

        public Builder singleSignOnUserValue(String singleSignOnUserValue) {
            this.props.singleSignOnUserValue(singleSignOnUserValue);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder userSettings(UserSettingsProperty userSettings) {
            this.props.userSettings(userSettings);
            return this;
        }

        public Builder userSettings(IResolvable userSettings) {
            this.props.userSettings(userSettings);
            return this;
        }

        public CfnUserProfile build() {
            return new CfnUserProfile(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_sagemaker.CfnUserProfile.UserSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface UserSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getExecutionRole() {
            return null;
        }

        @Nullable
        default public Object getJupyterServerAppSettings() {
            return null;
        }

        @Nullable
        default public Object getKernelGatewayAppSettings() {
            return null;
        }

        @Nullable
        default public Object getRStudioServerProAppSettings() {
            return null;
        }

        @Nullable
        default public List<String> getSecurityGroups() {
            return null;
        }

        @Nullable
        default public Object getSharingSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<UserSettingsProperty> {
            String executionRole;
            Object jupyterServerAppSettings;
            Object kernelGatewayAppSettings;
            Object rStudioServerProAppSettings;
            List<String> securityGroups;
            Object sharingSettings;

            public Builder executionRole(String executionRole) {
                this.executionRole = executionRole;
                return this;
            }

            public Builder jupyterServerAppSettings(JupyterServerAppSettingsProperty jupyterServerAppSettings) {
                this.jupyterServerAppSettings = jupyterServerAppSettings;
                return this;
            }

            public Builder jupyterServerAppSettings(IResolvable jupyterServerAppSettings) {
                this.jupyterServerAppSettings = jupyterServerAppSettings;
                return this;
            }

            public Builder kernelGatewayAppSettings(KernelGatewayAppSettingsProperty kernelGatewayAppSettings) {
                this.kernelGatewayAppSettings = kernelGatewayAppSettings;
                return this;
            }

            public Builder kernelGatewayAppSettings(IResolvable kernelGatewayAppSettings) {
                this.kernelGatewayAppSettings = kernelGatewayAppSettings;
                return this;
            }

            public Builder rStudioServerProAppSettings(RStudioServerProAppSettingsProperty rStudioServerProAppSettings) {
                this.rStudioServerProAppSettings = rStudioServerProAppSettings;
                return this;
            }

            public Builder rStudioServerProAppSettings(IResolvable rStudioServerProAppSettings) {
                this.rStudioServerProAppSettings = rStudioServerProAppSettings;
                return this;
            }

            public Builder securityGroups(List<String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            public Builder sharingSettings(SharingSettingsProperty sharingSettings) {
                this.sharingSettings = sharingSettings;
                return this;
            }

            public Builder sharingSettings(IResolvable sharingSettings) {
                this.sharingSettings = sharingSettings;
                return this;
            }

            public UserSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_sagemaker.CfnUserProfile.SharingSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SharingSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getNotebookOutputOption() {
            return null;
        }

        @Nullable
        default public String getS3KmsKeyId() {
            return null;
        }

        @Nullable
        default public String getS3OutputPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SharingSettingsProperty> {
            String notebookOutputOption;
            String s3KmsKeyId;
            String s3OutputPath;

            public Builder notebookOutputOption(String notebookOutputOption) {
                this.notebookOutputOption = notebookOutputOption;
                return this;
            }

            public Builder s3KmsKeyId(String s3KmsKeyId) {
                this.s3KmsKeyId = s3KmsKeyId;
                return this;
            }

            public Builder s3OutputPath(String s3OutputPath) {
                this.s3OutputPath = s3OutputPath;
                return this;
            }

            public SharingSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_sagemaker.CfnUserProfile.ResourceSpecProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ResourceSpecProperty
    extends JsiiSerializable {
        @Nullable
        default public String getInstanceType() {
            return null;
        }

        @Nullable
        default public String getSageMakerImageArn() {
            return null;
        }

        @Nullable
        default public String getSageMakerImageVersionArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ResourceSpecProperty> {
            String instanceType;
            String sageMakerImageArn;
            String sageMakerImageVersionArn;

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder sageMakerImageArn(String sageMakerImageArn) {
                this.sageMakerImageArn = sageMakerImageArn;
                return this;
            }

            public Builder sageMakerImageVersionArn(String sageMakerImageVersionArn) {
                this.sageMakerImageVersionArn = sageMakerImageVersionArn;
                return this;
            }

            public ResourceSpecProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_sagemaker.CfnUserProfile.RStudioServerProAppSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RStudioServerProAppSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAccessStatus() {
            return null;
        }

        @Nullable
        default public String getUserGroup() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RStudioServerProAppSettingsProperty> {
            String accessStatus;
            String userGroup;

            public Builder accessStatus(String accessStatus) {
                this.accessStatus = accessStatus;
                return this;
            }

            public Builder userGroup(String userGroup) {
                this.userGroup = userGroup;
                return this;
            }

            public RStudioServerProAppSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_sagemaker.CfnUserProfile.KernelGatewayAppSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KernelGatewayAppSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCustomImages() {
            return null;
        }

        @Nullable
        default public Object getDefaultResourceSpec() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KernelGatewayAppSettingsProperty> {
            Object customImages;
            Object defaultResourceSpec;

            public Builder customImages(IResolvable customImages) {
                this.customImages = customImages;
                return this;
            }

            public Builder customImages(List<? extends Object> customImages) {
                this.customImages = customImages;
                return this;
            }

            public Builder defaultResourceSpec(ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public Builder defaultResourceSpec(IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public KernelGatewayAppSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_sagemaker.CfnUserProfile.JupyterServerAppSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface JupyterServerAppSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDefaultResourceSpec() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<JupyterServerAppSettingsProperty> {
            Object defaultResourceSpec;

            public Builder defaultResourceSpec(ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public Builder defaultResourceSpec(IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public JupyterServerAppSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_sagemaker.CfnUserProfile.CustomImageProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomImageProperty
    extends JsiiSerializable {
        @NotNull
        public String getAppImageConfigName();

        @NotNull
        public String getImageName();

        @Nullable
        default public Number getImageVersionNumber() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomImageProperty> {
            String appImageConfigName;
            String imageName;
            Number imageVersionNumber;

            public Builder appImageConfigName(String appImageConfigName) {
                this.appImageConfigName = appImageConfigName;
                return this;
            }

            public Builder imageName(String imageName) {
                this.imageName = imageName;
                return this;
            }

            public Builder imageVersionNumber(Number imageVersionNumber) {
                this.imageVersionNumber = imageVersionNumber;
                return this;
            }

            public CustomImageProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

