/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.servicecatalog;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.iam.IGroup;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.IUser;
import software.amazon.awscdk.services.servicecatalog.CloudFormationRuleConstraintOptions;
import software.amazon.awscdk.services.servicecatalog.CommonConstraintOptions;
import software.amazon.awscdk.services.servicecatalog.IPortfolio;
import software.amazon.awscdk.services.servicecatalog.IProduct;
import software.amazon.awscdk.services.servicecatalog.MessageLanguage;
import software.amazon.awscdk.services.servicecatalog.PortfolioProps;
import software.amazon.awscdk.services.servicecatalog.PortfolioShareOptions;
import software.amazon.awscdk.services.servicecatalog.StackSetsConstraintOptions;
import software.amazon.awscdk.services.servicecatalog.TagOptions;
import software.amazon.awscdk.services.servicecatalog.TagUpdateConstraintOptions;
import software.amazon.awscdk.services.sns.ITopic;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk.aws_servicecatalog.Portfolio")
public class Portfolio
extends Resource
implements IPortfolio {
    protected Portfolio(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Portfolio(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Portfolio(@NotNull Construct scope, @NotNull String id, @NotNull PortfolioProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IPortfolio fromPortfolioArn(@NotNull Construct scope, @NotNull String id, @NotNull String portfolioArn) {
        return (IPortfolio)JsiiObject.jsiiStaticCall(Portfolio.class, (String)"fromPortfolioArn", (NativeType)NativeType.forClass(IPortfolio.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(portfolioArn, "portfolioArn is required")});
    }

    @Override
    public void addProduct(@NotNull IProduct product) {
        Kernel.call((Object)this, (String)"addProduct", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(product, "product is required")});
    }

    @Override
    public void associateTagOptions(@NotNull TagOptions tagOptions) {
        Kernel.call((Object)this, (String)"associateTagOptions", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(tagOptions, "tagOptions is required")});
    }

    @Override
    public void constrainCloudFormationParameters(@NotNull IProduct product, @NotNull CloudFormationRuleConstraintOptions options) {
        Kernel.call((Object)this, (String)"constrainCloudFormationParameters", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(product, "product is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    public void constrainTagUpdates(@NotNull IProduct product, @Nullable TagUpdateConstraintOptions options) {
        Kernel.call((Object)this, (String)"constrainTagUpdates", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(product, "product is required"), options});
    }

    @Override
    public void constrainTagUpdates(@NotNull IProduct product) {
        Kernel.call((Object)this, (String)"constrainTagUpdates", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(product, "product is required")});
    }

    @Override
    public void deployWithStackSets(@NotNull IProduct product, @NotNull StackSetsConstraintOptions options) {
        Kernel.call((Object)this, (String)"deployWithStackSets", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(product, "product is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    protected String generateUniqueHash(@NotNull String value) {
        return (String)Kernel.call((Object)this, (String)"generateUniqueHash", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(value, "value is required")});
    }

    @Override
    public void giveAccessToGroup(@NotNull IGroup group) {
        Kernel.call((Object)this, (String)"giveAccessToGroup", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(group, "group is required")});
    }

    @Override
    public void giveAccessToRole(@NotNull IRole role) {
        Kernel.call((Object)this, (String)"giveAccessToRole", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(role, "role is required")});
    }

    @Override
    public void giveAccessToUser(@NotNull IUser user) {
        Kernel.call((Object)this, (String)"giveAccessToUser", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(user, "user is required")});
    }

    @Override
    public void notifyOnStackEvents(@NotNull IProduct product, @NotNull ITopic topic, @Nullable CommonConstraintOptions options) {
        Kernel.call((Object)this, (String)"notifyOnStackEvents", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(product, "product is required"), Objects.requireNonNull(topic, "topic is required"), options});
    }

    @Override
    public void notifyOnStackEvents(@NotNull IProduct product, @NotNull ITopic topic) {
        Kernel.call((Object)this, (String)"notifyOnStackEvents", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(product, "product is required"), Objects.requireNonNull(topic, "topic is required")});
    }

    @Override
    public void setLaunchRole(@NotNull IProduct product, @NotNull IRole launchRole, @Nullable CommonConstraintOptions options) {
        Kernel.call((Object)this, (String)"setLaunchRole", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(product, "product is required"), Objects.requireNonNull(launchRole, "launchRole is required"), options});
    }

    @Override
    public void setLaunchRole(@NotNull IProduct product, @NotNull IRole launchRole) {
        Kernel.call((Object)this, (String)"setLaunchRole", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(product, "product is required"), Objects.requireNonNull(launchRole, "launchRole is required")});
    }

    @Override
    public void setLocalLaunchRole(@NotNull IProduct product, @NotNull IRole launchRole, @Nullable CommonConstraintOptions options) {
        Kernel.call((Object)this, (String)"setLocalLaunchRole", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(product, "product is required"), Objects.requireNonNull(launchRole, "launchRole is required"), options});
    }

    @Override
    public void setLocalLaunchRole(@NotNull IProduct product, @NotNull IRole launchRole) {
        Kernel.call((Object)this, (String)"setLocalLaunchRole", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(product, "product is required"), Objects.requireNonNull(launchRole, "launchRole is required")});
    }

    @Override
    @NotNull
    public IRole setLocalLaunchRoleName(@NotNull IProduct product, @NotNull String launchRoleName, @Nullable CommonConstraintOptions options) {
        return (IRole)Kernel.call((Object)this, (String)"setLocalLaunchRoleName", (NativeType)NativeType.forClass(IRole.class), (Object[])new Object[]{Objects.requireNonNull(product, "product is required"), Objects.requireNonNull(launchRoleName, "launchRoleName is required"), options});
    }

    @Override
    @NotNull
    public IRole setLocalLaunchRoleName(@NotNull IProduct product, @NotNull String launchRoleName) {
        return (IRole)Kernel.call((Object)this, (String)"setLocalLaunchRoleName", (NativeType)NativeType.forClass(IRole.class), (Object[])new Object[]{Objects.requireNonNull(product, "product is required"), Objects.requireNonNull(launchRoleName, "launchRoleName is required")});
    }

    @Override
    public void shareWithAccount(@NotNull String accountId, @Nullable PortfolioShareOptions options) {
        Kernel.call((Object)this, (String)"shareWithAccount", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(accountId, "accountId is required"), options});
    }

    @Override
    public void shareWithAccount(@NotNull String accountId) {
        Kernel.call((Object)this, (String)"shareWithAccount", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(accountId, "accountId is required")});
    }

    @Override
    @NotNull
    public String getPortfolioArn() {
        return (String)Kernel.get((Object)this, (String)"portfolioArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getPortfolioId() {
        return (String)Kernel.get((Object)this, (String)"portfolioId", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Portfolio> {
        private final Construct scope;
        private final String id;
        private final PortfolioProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new PortfolioProps.Builder();
        }

        public Builder displayName(String displayName) {
            this.props.displayName(displayName);
            return this;
        }

        public Builder providerName(String providerName) {
            this.props.providerName(providerName);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder messageLanguage(MessageLanguage messageLanguage) {
            this.props.messageLanguage(messageLanguage);
            return this;
        }

        public Builder tagOptions(TagOptions tagOptions) {
            this.props.tagOptions(tagOptions);
            return this;
        }

        public Portfolio build() {
            return new Portfolio(this.scope, this.id, this.props.build());
        }
    }
}

