/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apprunner;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.apprunner.Cpu;
import software.amazon.awscdk.services.apprunner.IService;
import software.amazon.awscdk.services.apprunner.IVpcConnector;
import software.amazon.awscdk.services.apprunner.Memory;
import software.amazon.awscdk.services.apprunner.ServiceAttributes;
import software.amazon.awscdk.services.apprunner.ServiceProps;
import software.amazon.awscdk.services.apprunner.Source;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk.aws_apprunner.Service")
public class Service
extends Resource {
    protected Service(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Service(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Service(@NotNull Construct scope, @NotNull String id, @NotNull ServiceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IService fromServiceAttributes(@NotNull Construct scope, @NotNull String id, @NotNull ServiceAttributes attrs) {
        return (IService)JsiiObject.jsiiStaticCall(Service.class, (String)"fromServiceAttributes", (NativeType)NativeType.forClass(IService.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static IService fromServiceName(@NotNull Construct scope, @NotNull String id, @NotNull String serviceName) {
        return (IService)JsiiObject.jsiiStaticCall(Service.class, (String)"fromServiceName", (NativeType)NativeType.forClass(IService.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(serviceName, "serviceName is required")});
    }

    @NotNull
    public String getServiceArn() {
        return (String)Kernel.get((Object)this, (String)"serviceArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getServiceId() {
        return (String)Kernel.get((Object)this, (String)"serviceId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getServiceName() {
        return (String)Kernel.get((Object)this, (String)"serviceName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getServiceStatus() {
        return (String)Kernel.get((Object)this, (String)"serviceStatus", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getServiceUrl() {
        return (String)Kernel.get((Object)this, (String)"serviceUrl", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Service> {
        private final Construct scope;
        private final String id;
        private final ServiceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ServiceProps.Builder();
        }

        public Builder source(Source source) {
            this.props.source(source);
            return this;
        }

        public Builder accessRole(IRole accessRole) {
            this.props.accessRole(accessRole);
            return this;
        }

        public Builder cpu(Cpu cpu) {
            this.props.cpu(cpu);
            return this;
        }

        public Builder instanceRole(IRole instanceRole) {
            this.props.instanceRole(instanceRole);
            return this;
        }

        public Builder memory(Memory memory) {
            this.props.memory(memory);
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.props.serviceName(serviceName);
            return this;
        }

        public Builder vpcConnector(IVpcConnector vpcConnector) {
            this.props.vpcConnector(vpcConnector);
            return this;
        }

        public Service build() {
            return new Service(this.scope, this.id, this.props.build());
        }
    }
}

