/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.appsync;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.services.appsync.AddFieldOptions;
import software.amazon.awscdk.services.appsync.Directive;
import software.amazon.awscdk.services.appsync.IField;
import software.amazon.awscdk.services.appsync.IGraphqlApi;
import software.amazon.awscdk.services.appsync.IIntermediateType;
import software.amazon.awscdk.services.appsync.InterfaceType;
import software.amazon.awscdk.services.appsync.ObjectTypeOptions;
import software.amazon.awscdk.services.appsync.ResolvableFieldOptions;
import software.amazon.awscdk.services.appsync.Resolver;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk.aws_appsync.ObjectType")
public class ObjectType
extends InterfaceType
implements IIntermediateType {
    protected ObjectType(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ObjectType(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ObjectType(@NotNull String name, @NotNull ObjectTypeOptions props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(name, "name is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void addField(@NotNull AddFieldOptions options) {
        Kernel.call((Object)this, (String)"addField", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    protected Resolver generateResolver(@NotNull IGraphqlApi api, @NotNull String fieldName, @Nullable ResolvableFieldOptions options) {
        return (Resolver)Kernel.call((Object)this, (String)"generateResolver", (NativeType)NativeType.forClass(Resolver.class), (Object[])new Object[]{Objects.requireNonNull(api, "api is required"), Objects.requireNonNull(fieldName, "fieldName is required"), options});
    }

    @NotNull
    protected Resolver generateResolver(@NotNull IGraphqlApi api, @NotNull String fieldName) {
        return (Resolver)Kernel.call((Object)this, (String)"generateResolver", (NativeType)NativeType.forClass(Resolver.class), (Object[])new Object[]{Objects.requireNonNull(api, "api is required"), Objects.requireNonNull(fieldName, "fieldName is required")});
    }

    @Override
    @NotNull
    public String toString() {
        return (String)Kernel.call((Object)this, (String)"toString", (NativeType)NativeType.forClass(String.class), (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public List<InterfaceType> getInterfaceTypes() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"interfaceTypes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(InterfaceType.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Override
    @Nullable
    public List<Resolver> getResolvers() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"resolvers", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Resolver.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Override
    public void setResolvers(@Nullable List<Resolver> value) {
        Kernel.set((Object)this, (String)"resolvers", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ObjectType> {
        private final String name;
        private final ObjectTypeOptions.Builder props;

        public static Builder create(String name) {
            return new Builder(name);
        }

        private Builder(String name) {
            this.name = name;
            this.props = new ObjectTypeOptions.Builder();
        }

        public Builder definition(Map<String, ? extends IField> definition) {
            this.props.definition(definition);
            return this;
        }

        public Builder directives(List<? extends Directive> directives) {
            this.props.directives(directives);
            return this;
        }

        public Builder interfaceTypes(List<? extends InterfaceType> interfaceTypes) {
            this.props.interfaceTypes(interfaceTypes);
            return this;
        }

        public ObjectType build() {
            return new ObjectType(this.name, this.props.build());
        }
    }
}

