/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.applicationautoscaling.EnableScalingProps;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ecs.AssociateCloudMapServiceOptions;
import software.amazon.awscdk.services.ecs.BaseServiceProps;
import software.amazon.awscdk.services.ecs.CfnService;
import software.amazon.awscdk.services.ecs.CloudMapOptions;
import software.amazon.awscdk.services.ecs.EcsTarget;
import software.amazon.awscdk.services.ecs.IBaseService;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.IEcsLoadBalancerTarget;
import software.amazon.awscdk.services.ecs.LoadBalancerTargetOptions;
import software.amazon.awscdk.services.ecs.ScalableTaskCount;
import software.amazon.awscdk.services.ecs.TaskDefinition;
import software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps;
import software.amazon.awscdk.services.servicediscovery.IService;
import software.amazon.awscdk.services.servicediscovery.Service;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk.aws_ecs.BaseService")
public abstract class BaseService
extends Resource
implements IBaseService,
IApplicationLoadBalancerTarget,
INetworkLoadBalancerTarget,
ILoadBalancerTarget {
    protected BaseService(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BaseService(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    protected BaseService(@NotNull Construct scope, @NotNull String id, @NotNull BaseServiceProps props, @NotNull Object additionalProps, @NotNull TaskDefinition taskDefinition) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required"), additionalProps, Objects.requireNonNull(taskDefinition, "taskDefinition is required")});
    }

    @NotNull
    public static IBaseService fromServiceArnWithCluster(@NotNull Construct scope, @NotNull String id, @NotNull String serviceArn) {
        return (IBaseService)JsiiObject.jsiiStaticCall(BaseService.class, (String)"fromServiceArnWithCluster", (NativeType)NativeType.forClass(IBaseService.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(serviceArn, "serviceArn is required")});
    }

    public void associateCloudMapService(@NotNull AssociateCloudMapServiceOptions options) {
        Kernel.call((Object)this, (String)"associateCloudMapService", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    public LoadBalancerTargetProps attachToApplicationTargetGroup(@NotNull IApplicationTargetGroup targetGroup) {
        return (LoadBalancerTargetProps)Kernel.call((Object)this, (String)"attachToApplicationTargetGroup", (NativeType)NativeType.forClass(LoadBalancerTargetProps.class), (Object[])new Object[]{Objects.requireNonNull(targetGroup, "targetGroup is required")});
    }

    @Override
    public void attachToClassicLB(@NotNull LoadBalancer loadBalancer) {
        Kernel.call((Object)this, (String)"attachToClassicLB", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(loadBalancer, "loadBalancer is required")});
    }

    @Override
    @NotNull
    public LoadBalancerTargetProps attachToNetworkTargetGroup(@NotNull INetworkTargetGroup targetGroup) {
        return (LoadBalancerTargetProps)Kernel.call((Object)this, (String)"attachToNetworkTargetGroup", (NativeType)NativeType.forClass(LoadBalancerTargetProps.class), (Object[])new Object[]{Objects.requireNonNull(targetGroup, "targetGroup is required")});
    }

    @NotNull
    public ScalableTaskCount autoScaleTaskCount(@NotNull EnableScalingProps props) {
        return (ScalableTaskCount)Kernel.call((Object)this, (String)"autoScaleTaskCount", (NativeType)NativeType.forClass(ScalableTaskCount.class), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @Deprecated
    protected void configureAwsVpcNetworking(@NotNull IVpc vpc, @Nullable Boolean assignPublicIp, @Nullable SubnetSelection vpcSubnets, @Nullable ISecurityGroup securityGroup) {
        Kernel.call((Object)this, (String)"configureAwsVpcNetworking", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp, vpcSubnets, securityGroup});
    }

    @Deprecated
    protected void configureAwsVpcNetworking(@NotNull IVpc vpc, @Nullable Boolean assignPublicIp, @Nullable SubnetSelection vpcSubnets) {
        Kernel.call((Object)this, (String)"configureAwsVpcNetworking", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp, vpcSubnets});
    }

    @Deprecated
    protected void configureAwsVpcNetworking(@NotNull IVpc vpc, @Nullable Boolean assignPublicIp) {
        Kernel.call((Object)this, (String)"configureAwsVpcNetworking", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp});
    }

    @Deprecated
    protected void configureAwsVpcNetworking(@NotNull IVpc vpc) {
        Kernel.call((Object)this, (String)"configureAwsVpcNetworking", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(vpc, "vpc is required")});
    }

    protected void configureAwsVpcNetworkingWithSecurityGroups(@NotNull IVpc vpc, @Nullable Boolean assignPublicIp, @Nullable SubnetSelection vpcSubnets, @Nullable List<ISecurityGroup> securityGroups) {
        Kernel.call((Object)this, (String)"configureAwsVpcNetworkingWithSecurityGroups", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp, vpcSubnets, securityGroups});
    }

    protected void configureAwsVpcNetworkingWithSecurityGroups(@NotNull IVpc vpc, @Nullable Boolean assignPublicIp, @Nullable SubnetSelection vpcSubnets) {
        Kernel.call((Object)this, (String)"configureAwsVpcNetworkingWithSecurityGroups", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp, vpcSubnets});
    }

    protected void configureAwsVpcNetworkingWithSecurityGroups(@NotNull IVpc vpc, @Nullable Boolean assignPublicIp) {
        Kernel.call((Object)this, (String)"configureAwsVpcNetworkingWithSecurityGroups", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp});
    }

    protected void configureAwsVpcNetworkingWithSecurityGroups(@NotNull IVpc vpc) {
        Kernel.call((Object)this, (String)"configureAwsVpcNetworkingWithSecurityGroups", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(vpc, "vpc is required")});
    }

    @NotNull
    public Service enableCloudMap(@NotNull CloudMapOptions options) {
        return (Service)Kernel.call((Object)this, (String)"enableCloudMap", (NativeType)NativeType.forClass(Service.class), (Object[])new Object[]{Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public IEcsLoadBalancerTarget loadBalancerTarget(@NotNull LoadBalancerTargetOptions options) {
        return (IEcsLoadBalancerTarget)Kernel.call((Object)this, (String)"loadBalancerTarget", (NativeType)NativeType.forClass(IEcsLoadBalancerTarget.class), (Object[])new Object[]{Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public Metric metric(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @NotNull
    public Metric metric(@NotNull String metricName) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @NotNull
    public Metric metricCpuUtilization(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricCpuUtilization", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public Metric metricCpuUtilization() {
        return (Metric)Kernel.call((Object)this, (String)"metricCpuUtilization", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public Metric metricMemoryUtilization(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricMemoryUtilization", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public Metric metricMemoryUtilization() {
        return (Metric)Kernel.call((Object)this, (String)"metricMemoryUtilization", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    public void registerLoadBalancerTargets(EcsTarget ... targets) {
        Kernel.call((Object)this, (String)"registerLoadBalancerTargets", (NativeType)NativeType.VOID, (Object[])Arrays.stream(targets).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public ICluster getCluster() {
        return (ICluster)Kernel.get((Object)this, (String)"cluster", (NativeType)NativeType.forClass(ICluster.class));
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @Override
    @NotNull
    public String getServiceArn() {
        return (String)Kernel.get((Object)this, (String)"serviceArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getServiceName() {
        return (String)Kernel.get((Object)this, (String)"serviceName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public TaskDefinition getTaskDefinition() {
        return (TaskDefinition)Kernel.get((Object)this, (String)"taskDefinition", (NativeType)NativeType.forClass(TaskDefinition.class));
    }

    @Nullable
    public IService getCloudMapService() {
        return (IService)Kernel.get((Object)this, (String)"cloudMapService", (NativeType)NativeType.forClass(IService.class));
    }

    @NotNull
    protected List<CfnService.LoadBalancerProperty> getLoadBalancers() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"loadBalancers", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnService.LoadBalancerProperty.class))));
    }

    protected void setLoadBalancers(@NotNull List<CfnService.LoadBalancerProperty> value) {
        Kernel.set((Object)this, (String)"loadBalancers", Objects.requireNonNull(value, "loadBalancers is required"));
    }

    @NotNull
    protected List<CfnService.ServiceRegistryProperty> getServiceRegistries() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"serviceRegistries", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnService.ServiceRegistryProperty.class))));
    }

    protected void setServiceRegistries(@NotNull List<CfnService.ServiceRegistryProperty> value) {
        Kernel.set((Object)this, (String)"serviceRegistries", Objects.requireNonNull(value, "serviceRegistries is required"));
    }

    @Nullable
    protected Service getCloudmapService() {
        return (Service)Kernel.get((Object)this, (String)"cloudmapService", (NativeType)NativeType.forClass(Service.class));
    }

    protected void setCloudmapService(@Nullable Service value) {
        Kernel.set((Object)this, (String)"cloudmapService", (Object)value);
    }

    @Nullable
    protected CfnService.NetworkConfigurationProperty getNetworkConfiguration() {
        return (CfnService.NetworkConfigurationProperty)Kernel.get((Object)this, (String)"networkConfiguration", (NativeType)NativeType.forClass(CfnService.NetworkConfigurationProperty.class));
    }

    protected void setNetworkConfiguration(@Nullable CfnService.NetworkConfigurationProperty value) {
        Kernel.set((Object)this, (String)"networkConfiguration", (Object)value);
    }
}

