/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.autoscaling.AutoScalingGroup;
import software.amazon.awscdk.services.autoscaling.IAutoScalingGroup;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ecs.AddAutoScalingGroupCapacityOptions;
import software.amazon.awscdk.services.ecs.AddCapacityOptions;
import software.amazon.awscdk.services.ecs.AsgCapacityProvider;
import software.amazon.awscdk.services.ecs.CloudMapNamespaceOptions;
import software.amazon.awscdk.services.ecs.ClusterAttributes;
import software.amazon.awscdk.services.ecs.ClusterProps;
import software.amazon.awscdk.services.ecs.ExecuteCommandConfiguration;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.servicediscovery.INamespace;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk.aws_ecs.Cluster")
public class Cluster
extends Resource
implements ICluster {
    protected Cluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Cluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Cluster(@NotNull Construct scope, @NotNull String id, @Nullable ClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Cluster(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static ICluster fromClusterArn(@NotNull Construct scope, @NotNull String id, @NotNull String clusterArn) {
        return (ICluster)JsiiObject.jsiiStaticCall(Cluster.class, (String)"fromClusterArn", (NativeType)NativeType.forClass(ICluster.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(clusterArn, "clusterArn is required")});
    }

    @NotNull
    public static ICluster fromClusterAttributes(@NotNull Construct scope, @NotNull String id, @NotNull ClusterAttributes attrs) {
        return (ICluster)JsiiObject.jsiiStaticCall(Cluster.class, (String)"fromClusterAttributes", (NativeType)NativeType.forClass(ICluster.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    public void addAsgCapacityProvider(@NotNull AsgCapacityProvider provider, @Nullable AddAutoScalingGroupCapacityOptions options) {
        Kernel.call((Object)this, (String)"addAsgCapacityProvider", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(provider, "provider is required"), options});
    }

    public void addAsgCapacityProvider(@NotNull AsgCapacityProvider provider) {
        Kernel.call((Object)this, (String)"addAsgCapacityProvider", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(provider, "provider is required")});
    }

    @Deprecated
    public void addAutoScalingGroup(@NotNull AutoScalingGroup autoScalingGroup, @Nullable AddAutoScalingGroupCapacityOptions options) {
        Kernel.call((Object)this, (String)"addAutoScalingGroup", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(autoScalingGroup, "autoScalingGroup is required"), options});
    }

    @Deprecated
    public void addAutoScalingGroup(@NotNull AutoScalingGroup autoScalingGroup) {
        Kernel.call((Object)this, (String)"addAutoScalingGroup", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(autoScalingGroup, "autoScalingGroup is required")});
    }

    @NotNull
    public AutoScalingGroup addCapacity(@NotNull String id, @NotNull AddCapacityOptions options) {
        return (AutoScalingGroup)Kernel.call((Object)this, (String)"addCapacity", (NativeType)NativeType.forClass(AutoScalingGroup.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Deprecated
    public void addCapacityProvider(@NotNull String provider) {
        Kernel.call((Object)this, (String)"addCapacityProvider", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(provider, "provider is required")});
    }

    @NotNull
    public INamespace addDefaultCloudMapNamespace(@NotNull CloudMapNamespaceOptions options) {
        return (INamespace)Kernel.call((Object)this, (String)"addDefaultCloudMapNamespace", (NativeType)NativeType.forClass(INamespace.class), (Object[])new Object[]{Objects.requireNonNull(options, "options is required")});
    }

    public void enableFargateCapacityProviders() {
        Kernel.call((Object)this, (String)"enableFargateCapacityProviders", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    @NotNull
    public Metric metric(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @NotNull
    public Metric metric(@NotNull String metricName) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @NotNull
    public Metric metricCpuReservation(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricCpuReservation", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public Metric metricCpuReservation() {
        return (Metric)Kernel.call((Object)this, (String)"metricCpuReservation", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public Metric metricCpuUtilization(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricCpuUtilization", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public Metric metricCpuUtilization() {
        return (Metric)Kernel.call((Object)this, (String)"metricCpuUtilization", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public Metric metricMemoryReservation(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricMemoryReservation", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public Metric metricMemoryReservation() {
        return (Metric)Kernel.call((Object)this, (String)"metricMemoryReservation", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public Metric metricMemoryUtilization(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricMemoryUtilization", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public Metric metricMemoryUtilization() {
        return (Metric)Kernel.call((Object)this, (String)"metricMemoryUtilization", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getClusterArn() {
        return (String)Kernel.get((Object)this, (String)"clusterArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getClusterName() {
        return (String)Kernel.get((Object)this, (String)"clusterName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @Override
    @NotNull
    public Boolean getHasEc2Capacity() {
        return (Boolean)Kernel.get((Object)this, (String)"hasEc2Capacity", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @NotNull
    public IVpc getVpc() {
        return (IVpc)Kernel.get((Object)this, (String)"vpc", (NativeType)NativeType.forClass(IVpc.class));
    }

    @Override
    @Nullable
    public IAutoScalingGroup getAutoscalingGroup() {
        return (IAutoScalingGroup)Kernel.get((Object)this, (String)"autoscalingGroup", (NativeType)NativeType.forClass(IAutoScalingGroup.class));
    }

    @Override
    @Nullable
    public INamespace getDefaultCloudMapNamespace() {
        return (INamespace)Kernel.get((Object)this, (String)"defaultCloudMapNamespace", (NativeType)NativeType.forClass(INamespace.class));
    }

    @Override
    @Nullable
    public ExecuteCommandConfiguration getExecuteCommandConfiguration() {
        return (ExecuteCommandConfiguration)Kernel.get((Object)this, (String)"executeCommandConfiguration", (NativeType)NativeType.forClass(ExecuteCommandConfiguration.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Cluster> {
        private final Construct scope;
        private final String id;
        private ClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder capacity(AddCapacityOptions capacity) {
            this.props().capacity(capacity);
            return this;
        }

        @Deprecated
        public Builder capacityProviders(List<String> capacityProviders) {
            this.props().capacityProviders(capacityProviders);
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.props().clusterName(clusterName);
            return this;
        }

        public Builder containerInsights(Boolean containerInsights) {
            this.props().containerInsights(containerInsights);
            return this;
        }

        public Builder defaultCloudMapNamespace(CloudMapNamespaceOptions defaultCloudMapNamespace) {
            this.props().defaultCloudMapNamespace(defaultCloudMapNamespace);
            return this;
        }

        public Builder enableFargateCapacityProviders(Boolean enableFargateCapacityProviders) {
            this.props().enableFargateCapacityProviders(enableFargateCapacityProviders);
            return this;
        }

        public Builder executeCommandConfiguration(ExecuteCommandConfiguration executeCommandConfiguration) {
            this.props().executeCommandConfiguration(executeCommandConfiguration);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props().vpc(vpc);
            return this;
        }

        public Cluster build() {
            return new Cluster(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private ClusterProps.Builder props() {
            if (this.props == null) {
                this.props = new ClusterProps.Builder();
            }
            return this.props;
        }
    }
}

