/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.grafana;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.grafana.CfnWorkspace;
import software.amazon.awscdk.services.grafana.CfnWorkspaceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk.aws_grafana.CfnWorkspace")
public class CfnWorkspace
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnWorkspace.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnWorkspace(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnWorkspace(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnWorkspace(@NotNull Construct scope, @NotNull String id, @NotNull CfnWorkspaceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrCreationTimestamp() {
        return (String)Kernel.get((Object)this, (String)"attrCreationTimestamp", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrEndpoint() {
        return (String)Kernel.get((Object)this, (String)"attrEndpoint", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrGrafanaVersion() {
        return (String)Kernel.get((Object)this, (String)"attrGrafanaVersion", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrModificationTimestamp() {
        return (String)Kernel.get((Object)this, (String)"attrModificationTimestamp", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrSamlConfigurationStatus() {
        return (String)Kernel.get((Object)this, (String)"attrSamlConfigurationStatus", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrSsoClientId() {
        return (String)Kernel.get((Object)this, (String)"attrSsoClientId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrStatus() {
        return (String)Kernel.get((Object)this, (String)"attrStatus", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getAccountAccessType() {
        return (String)Kernel.get((Object)this, (String)"accountAccessType", (NativeType)NativeType.forClass(String.class));
    }

    public void setAccountAccessType(@NotNull String value) {
        Kernel.set((Object)this, (String)"accountAccessType", (Object)Objects.requireNonNull(value, "accountAccessType is required"));
    }

    @NotNull
    public List<String> getAuthenticationProviders() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"authenticationProviders", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    public void setAuthenticationProviders(@NotNull List<String> value) {
        Kernel.set((Object)this, (String)"authenticationProviders", Objects.requireNonNull(value, "authenticationProviders is required"));
    }

    @NotNull
    public String getPermissionType() {
        return (String)Kernel.get((Object)this, (String)"permissionType", (NativeType)NativeType.forClass(String.class));
    }

    public void setPermissionType(@NotNull String value) {
        Kernel.set((Object)this, (String)"permissionType", (Object)Objects.requireNonNull(value, "permissionType is required"));
    }

    @Nullable
    public String getClientToken() {
        return (String)Kernel.get((Object)this, (String)"clientToken", (NativeType)NativeType.forClass(String.class));
    }

    public void setClientToken(@Nullable String value) {
        Kernel.set((Object)this, (String)"clientToken", (Object)value);
    }

    @Nullable
    public List<String> getDataSources() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"dataSources", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setDataSources(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"dataSources", value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public String getGrafanaVersion() {
        return (String)Kernel.get((Object)this, (String)"grafanaVersion", (NativeType)NativeType.forClass(String.class));
    }

    public void setGrafanaVersion(@Nullable String value) {
        Kernel.set((Object)this, (String)"grafanaVersion", (Object)value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)this, (String)"name", (Object)value);
    }

    @Nullable
    public Object getNetworkAccessControl() {
        return Kernel.get((Object)this, (String)"networkAccessControl", (NativeType)NativeType.forClass(Object.class));
    }

    public void setNetworkAccessControl(@Nullable NetworkAccessControlProperty value) {
        Kernel.set((Object)this, (String)"networkAccessControl", (Object)value);
    }

    public void setNetworkAccessControl(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"networkAccessControl", (Object)value);
    }

    @Nullable
    public List<String> getNotificationDestinations() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"notificationDestinations", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setNotificationDestinations(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"notificationDestinations", value);
    }

    @Nullable
    public List<String> getOrganizationalUnits() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"organizationalUnits", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setOrganizationalUnits(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"organizationalUnits", value);
    }

    @Nullable
    public String getOrganizationRoleName() {
        return (String)Kernel.get((Object)this, (String)"organizationRoleName", (NativeType)NativeType.forClass(String.class));
    }

    public void setOrganizationRoleName(@Nullable String value) {
        Kernel.set((Object)this, (String)"organizationRoleName", (Object)value);
    }

    @Nullable
    public String getRoleArn() {
        return (String)Kernel.get((Object)this, (String)"roleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setRoleArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"roleArn", (Object)value);
    }

    @Nullable
    public Object getSamlConfiguration() {
        return Kernel.get((Object)this, (String)"samlConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSamlConfiguration(@Nullable SamlConfigurationProperty value) {
        Kernel.set((Object)this, (String)"samlConfiguration", (Object)value);
    }

    public void setSamlConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"samlConfiguration", (Object)value);
    }

    @Nullable
    public String getStackSetName() {
        return (String)Kernel.get((Object)this, (String)"stackSetName", (NativeType)NativeType.forClass(String.class));
    }

    public void setStackSetName(@Nullable String value) {
        Kernel.set((Object)this, (String)"stackSetName", (Object)value);
    }

    @Nullable
    public Object getVpcConfiguration() {
        return Kernel.get((Object)this, (String)"vpcConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setVpcConfiguration(@Nullable VpcConfigurationProperty value) {
        Kernel.set((Object)this, (String)"vpcConfiguration", (Object)value);
    }

    public void setVpcConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"vpcConfiguration", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnWorkspace> {
        private final Construct scope;
        private final String id;
        private final CfnWorkspaceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnWorkspaceProps.Builder();
        }

        public Builder accountAccessType(String accountAccessType) {
            this.props.accountAccessType(accountAccessType);
            return this;
        }

        public Builder authenticationProviders(List<String> authenticationProviders) {
            this.props.authenticationProviders(authenticationProviders);
            return this;
        }

        public Builder permissionType(String permissionType) {
            this.props.permissionType(permissionType);
            return this;
        }

        public Builder clientToken(String clientToken) {
            this.props.clientToken(clientToken);
            return this;
        }

        public Builder dataSources(List<String> dataSources) {
            this.props.dataSources(dataSources);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder grafanaVersion(String grafanaVersion) {
            this.props.grafanaVersion(grafanaVersion);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder networkAccessControl(NetworkAccessControlProperty networkAccessControl) {
            this.props.networkAccessControl(networkAccessControl);
            return this;
        }

        public Builder networkAccessControl(IResolvable networkAccessControl) {
            this.props.networkAccessControl(networkAccessControl);
            return this;
        }

        public Builder notificationDestinations(List<String> notificationDestinations) {
            this.props.notificationDestinations(notificationDestinations);
            return this;
        }

        public Builder organizationalUnits(List<String> organizationalUnits) {
            this.props.organizationalUnits(organizationalUnits);
            return this;
        }

        public Builder organizationRoleName(String organizationRoleName) {
            this.props.organizationRoleName(organizationRoleName);
            return this;
        }

        public Builder roleArn(String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        public Builder samlConfiguration(SamlConfigurationProperty samlConfiguration) {
            this.props.samlConfiguration(samlConfiguration);
            return this;
        }

        public Builder samlConfiguration(IResolvable samlConfiguration) {
            this.props.samlConfiguration(samlConfiguration);
            return this;
        }

        public Builder stackSetName(String stackSetName) {
            this.props.stackSetName(stackSetName);
            return this;
        }

        public Builder vpcConfiguration(VpcConfigurationProperty vpcConfiguration) {
            this.props.vpcConfiguration(vpcConfiguration);
            return this;
        }

        public Builder vpcConfiguration(IResolvable vpcConfiguration) {
            this.props.vpcConfiguration(vpcConfiguration);
            return this;
        }

        public CfnWorkspace build() {
            return new CfnWorkspace(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_grafana.CfnWorkspace.VpcConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VpcConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSecurityGroupIds();

        @NotNull
        public List<String> getSubnetIds();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VpcConfigurationProperty> {
            List<String> securityGroupIds;
            List<String> subnetIds;

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnetIds(List<String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            public VpcConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_grafana.CfnWorkspace.SamlConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SamlConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getIdpMetadata();

        @Nullable
        default public List<String> getAllowedOrganizations() {
            return null;
        }

        @Nullable
        default public Object getAssertionAttributes() {
            return null;
        }

        @Nullable
        default public Number getLoginValidityDuration() {
            return null;
        }

        @Nullable
        default public Object getRoleValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SamlConfigurationProperty> {
            Object idpMetadata;
            List<String> allowedOrganizations;
            Object assertionAttributes;
            Number loginValidityDuration;
            Object roleValues;

            public Builder idpMetadata(IdpMetadataProperty idpMetadata) {
                this.idpMetadata = idpMetadata;
                return this;
            }

            public Builder idpMetadata(IResolvable idpMetadata) {
                this.idpMetadata = idpMetadata;
                return this;
            }

            public Builder allowedOrganizations(List<String> allowedOrganizations) {
                this.allowedOrganizations = allowedOrganizations;
                return this;
            }

            public Builder assertionAttributes(AssertionAttributesProperty assertionAttributes) {
                this.assertionAttributes = assertionAttributes;
                return this;
            }

            public Builder assertionAttributes(IResolvable assertionAttributes) {
                this.assertionAttributes = assertionAttributes;
                return this;
            }

            public Builder loginValidityDuration(Number loginValidityDuration) {
                this.loginValidityDuration = loginValidityDuration;
                return this;
            }

            public Builder roleValues(RoleValuesProperty roleValues) {
                this.roleValues = roleValues;
                return this;
            }

            public Builder roleValues(IResolvable roleValues) {
                this.roleValues = roleValues;
                return this;
            }

            public SamlConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_grafana.CfnWorkspace.RoleValuesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RoleValuesProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getAdmin() {
            return null;
        }

        @Nullable
        default public List<String> getEditor() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RoleValuesProperty> {
            List<String> admin;
            List<String> editor;

            public Builder admin(List<String> admin) {
                this.admin = admin;
                return this;
            }

            public Builder editor(List<String> editor) {
                this.editor = editor;
                return this;
            }

            public RoleValuesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_grafana.CfnWorkspace.NetworkAccessControlProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkAccessControlProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getPrefixListIds() {
            return null;
        }

        @Nullable
        default public List<String> getVpceIds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NetworkAccessControlProperty> {
            List<String> prefixListIds;
            List<String> vpceIds;

            public Builder prefixListIds(List<String> prefixListIds) {
                this.prefixListIds = prefixListIds;
                return this;
            }

            public Builder vpceIds(List<String> vpceIds) {
                this.vpceIds = vpceIds;
                return this;
            }

            public NetworkAccessControlProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_grafana.CfnWorkspace.IdpMetadataProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IdpMetadataProperty
    extends JsiiSerializable {
        @Nullable
        default public String getUrl() {
            return null;
        }

        @Nullable
        default public String getXml() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IdpMetadataProperty> {
            String url;
            String xml;

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public Builder xml(String xml) {
                this.xml = xml;
                return this;
            }

            public IdpMetadataProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_grafana.CfnWorkspace.AssertionAttributesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AssertionAttributesProperty
    extends JsiiSerializable {
        @Nullable
        default public String getEmail() {
            return null;
        }

        @Nullable
        default public String getGroups() {
            return null;
        }

        @Nullable
        default public String getLogin() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public String getOrg() {
            return null;
        }

        @Nullable
        default public String getRole() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AssertionAttributesProperty> {
            String email;
            String groups;
            String login;
            String name;
            String org;
            String role;

            public Builder email(String email) {
                this.email = email;
                return this;
            }

            public Builder groups(String groups) {
                this.groups = groups;
                return this;
            }

            public Builder login(String login) {
                this.login = login;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder org(String org) {
                this.org = org;
                return this;
            }

            public Builder role(String role) {
                this.role = role;
                return this;
            }

            public AssertionAttributesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

