/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.pinpoint;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.pinpoint.CfnCampaign;
import software.amazon.awscdk.services.pinpoint.CfnCampaignProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign")
public class CfnCampaign
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnCampaign.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnCampaign(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCampaign(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnCampaign(@NotNull Construct scope, @NotNull String id, @NotNull CfnCampaignProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrCampaignId() {
        return (String)Kernel.get((Object)this, (String)"attrCampaignId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getApplicationId() {
        return (String)Kernel.get((Object)this, (String)"applicationId", (NativeType)NativeType.forClass(String.class));
    }

    public void setApplicationId(@NotNull String value) {
        Kernel.set((Object)this, (String)"applicationId", (Object)Objects.requireNonNull(value, "applicationId is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @NotNull
    public Object getSchedule() {
        return Kernel.get((Object)this, (String)"schedule", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSchedule(@NotNull ScheduleProperty value) {
        Kernel.set((Object)this, (String)"schedule", (Object)Objects.requireNonNull(value, "schedule is required"));
    }

    public void setSchedule(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"schedule", (Object)Objects.requireNonNull(value, "schedule is required"));
    }

    @NotNull
    public String getSegmentId() {
        return (String)Kernel.get((Object)this, (String)"segmentId", (NativeType)NativeType.forClass(String.class));
    }

    public void setSegmentId(@NotNull String value) {
        Kernel.set((Object)this, (String)"segmentId", (Object)Objects.requireNonNull(value, "segmentId is required"));
    }

    @Nullable
    public Object getAdditionalTreatments() {
        return Kernel.get((Object)this, (String)"additionalTreatments", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAdditionalTreatments(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"additionalTreatments", (Object)value);
    }

    public void setAdditionalTreatments(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof WriteTreatmentResourceProperty || __val_ac66f0 instanceof IResolvable || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.services.pinpoint.CfnCampaign.WriteTreatmentResourceProperty, software.amazon.awscdk.core.IResolvable; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"additionalTreatments", value);
    }

    @Nullable
    public Object getCampaignHook() {
        return Kernel.get((Object)this, (String)"campaignHook", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCampaignHook(@Nullable CampaignHookProperty value) {
        Kernel.set((Object)this, (String)"campaignHook", (Object)value);
    }

    public void setCampaignHook(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"campaignHook", (Object)value);
    }

    @Nullable
    public Object getCustomDeliveryConfiguration() {
        return Kernel.get((Object)this, (String)"customDeliveryConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCustomDeliveryConfiguration(@Nullable CustomDeliveryConfigurationProperty value) {
        Kernel.set((Object)this, (String)"customDeliveryConfiguration", (Object)value);
    }

    public void setCustomDeliveryConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"customDeliveryConfiguration", (Object)value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Number getHoldoutPercent() {
        return (Number)Kernel.get((Object)this, (String)"holdoutPercent", (NativeType)NativeType.forClass(Number.class));
    }

    public void setHoldoutPercent(@Nullable Number value) {
        Kernel.set((Object)this, (String)"holdoutPercent", (Object)value);
    }

    @Nullable
    public Object getIsPaused() {
        return Kernel.get((Object)this, (String)"isPaused", (NativeType)NativeType.forClass(Object.class));
    }

    public void setIsPaused(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"isPaused", (Object)value);
    }

    public void setIsPaused(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"isPaused", (Object)value);
    }

    @Nullable
    public Object getLimits() {
        return Kernel.get((Object)this, (String)"limits", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLimits(@Nullable LimitsProperty value) {
        Kernel.set((Object)this, (String)"limits", (Object)value);
    }

    public void setLimits(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"limits", (Object)value);
    }

    @Nullable
    public Object getMessageConfiguration() {
        return Kernel.get((Object)this, (String)"messageConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setMessageConfiguration(@Nullable MessageConfigurationProperty value) {
        Kernel.set((Object)this, (String)"messageConfiguration", (Object)value);
    }

    public void setMessageConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"messageConfiguration", (Object)value);
    }

    @Nullable
    public Number getPriority() {
        return (Number)Kernel.get((Object)this, (String)"priority", (NativeType)NativeType.forClass(Number.class));
    }

    public void setPriority(@Nullable Number value) {
        Kernel.set((Object)this, (String)"priority", (Object)value);
    }

    @Nullable
    public Number getSegmentVersion() {
        return (Number)Kernel.get((Object)this, (String)"segmentVersion", (NativeType)NativeType.forClass(Number.class));
    }

    public void setSegmentVersion(@Nullable Number value) {
        Kernel.set((Object)this, (String)"segmentVersion", (Object)value);
    }

    @Nullable
    public Object getTemplateConfiguration() {
        return Kernel.get((Object)this, (String)"templateConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTemplateConfiguration(@Nullable TemplateConfigurationProperty value) {
        Kernel.set((Object)this, (String)"templateConfiguration", (Object)value);
    }

    public void setTemplateConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"templateConfiguration", (Object)value);
    }

    @Nullable
    public String getTreatmentDescription() {
        return (String)Kernel.get((Object)this, (String)"treatmentDescription", (NativeType)NativeType.forClass(String.class));
    }

    public void setTreatmentDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"treatmentDescription", (Object)value);
    }

    @Nullable
    public String getTreatmentName() {
        return (String)Kernel.get((Object)this, (String)"treatmentName", (NativeType)NativeType.forClass(String.class));
    }

    public void setTreatmentName(@Nullable String value) {
        Kernel.set((Object)this, (String)"treatmentName", (Object)value);
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.WriteTreatmentResourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WriteTreatmentResourceProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCustomDeliveryConfiguration() {
            return null;
        }

        @Nullable
        default public Object getMessageConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSchedule() {
            return null;
        }

        @Nullable
        default public Number getSizePercent() {
            return null;
        }

        @Nullable
        default public Object getTemplateConfiguration() {
            return null;
        }

        @Nullable
        default public String getTreatmentDescription() {
            return null;
        }

        @Nullable
        default public String getTreatmentName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WriteTreatmentResourceProperty> {
            Object customDeliveryConfiguration;
            Object messageConfiguration;
            Object schedule;
            Number sizePercent;
            Object templateConfiguration;
            String treatmentDescription;
            String treatmentName;

            public Builder customDeliveryConfiguration(CustomDeliveryConfigurationProperty customDeliveryConfiguration) {
                this.customDeliveryConfiguration = customDeliveryConfiguration;
                return this;
            }

            public Builder customDeliveryConfiguration(IResolvable customDeliveryConfiguration) {
                this.customDeliveryConfiguration = customDeliveryConfiguration;
                return this;
            }

            public Builder messageConfiguration(MessageConfigurationProperty messageConfiguration) {
                this.messageConfiguration = messageConfiguration;
                return this;
            }

            public Builder messageConfiguration(IResolvable messageConfiguration) {
                this.messageConfiguration = messageConfiguration;
                return this;
            }

            public Builder schedule(ScheduleProperty schedule) {
                this.schedule = schedule;
                return this;
            }

            public Builder schedule(IResolvable schedule) {
                this.schedule = schedule;
                return this;
            }

            public Builder sizePercent(Number sizePercent) {
                this.sizePercent = sizePercent;
                return this;
            }

            public Builder templateConfiguration(TemplateConfigurationProperty templateConfiguration) {
                this.templateConfiguration = templateConfiguration;
                return this;
            }

            public Builder templateConfiguration(IResolvable templateConfiguration) {
                this.templateConfiguration = templateConfiguration;
                return this;
            }

            public Builder treatmentDescription(String treatmentDescription) {
                this.treatmentDescription = treatmentDescription;
                return this;
            }

            public Builder treatmentName(String treatmentName) {
                this.treatmentName = treatmentName;
                return this;
            }

            public WriteTreatmentResourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnCampaign> {
        private final Construct scope;
        private final String id;
        private final CfnCampaignProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnCampaignProps.Builder();
        }

        public Builder applicationId(String applicationId) {
            this.props.applicationId(applicationId);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder schedule(ScheduleProperty schedule) {
            this.props.schedule(schedule);
            return this;
        }

        public Builder schedule(IResolvable schedule) {
            this.props.schedule(schedule);
            return this;
        }

        public Builder segmentId(String segmentId) {
            this.props.segmentId(segmentId);
            return this;
        }

        public Builder additionalTreatments(IResolvable additionalTreatments) {
            this.props.additionalTreatments(additionalTreatments);
            return this;
        }

        public Builder additionalTreatments(List<? extends Object> additionalTreatments) {
            this.props.additionalTreatments(additionalTreatments);
            return this;
        }

        public Builder campaignHook(CampaignHookProperty campaignHook) {
            this.props.campaignHook(campaignHook);
            return this;
        }

        public Builder campaignHook(IResolvable campaignHook) {
            this.props.campaignHook(campaignHook);
            return this;
        }

        public Builder customDeliveryConfiguration(CustomDeliveryConfigurationProperty customDeliveryConfiguration) {
            this.props.customDeliveryConfiguration(customDeliveryConfiguration);
            return this;
        }

        public Builder customDeliveryConfiguration(IResolvable customDeliveryConfiguration) {
            this.props.customDeliveryConfiguration(customDeliveryConfiguration);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder holdoutPercent(Number holdoutPercent) {
            this.props.holdoutPercent(holdoutPercent);
            return this;
        }

        public Builder isPaused(Boolean isPaused) {
            this.props.isPaused(isPaused);
            return this;
        }

        public Builder isPaused(IResolvable isPaused) {
            this.props.isPaused(isPaused);
            return this;
        }

        public Builder limits(LimitsProperty limits) {
            this.props.limits(limits);
            return this;
        }

        public Builder limits(IResolvable limits) {
            this.props.limits(limits);
            return this;
        }

        public Builder messageConfiguration(MessageConfigurationProperty messageConfiguration) {
            this.props.messageConfiguration(messageConfiguration);
            return this;
        }

        public Builder messageConfiguration(IResolvable messageConfiguration) {
            this.props.messageConfiguration(messageConfiguration);
            return this;
        }

        public Builder priority(Number priority) {
            this.props.priority(priority);
            return this;
        }

        public Builder segmentVersion(Number segmentVersion) {
            this.props.segmentVersion(segmentVersion);
            return this;
        }

        public Builder tags(Object tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder templateConfiguration(TemplateConfigurationProperty templateConfiguration) {
            this.props.templateConfiguration(templateConfiguration);
            return this;
        }

        public Builder templateConfiguration(IResolvable templateConfiguration) {
            this.props.templateConfiguration(templateConfiguration);
            return this;
        }

        public Builder treatmentDescription(String treatmentDescription) {
            this.props.treatmentDescription(treatmentDescription);
            return this;
        }

        public Builder treatmentName(String treatmentName) {
            this.props.treatmentName(treatmentName);
            return this;
        }

        public CfnCampaign build() {
            return new CfnCampaign(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.TemplateProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TemplateProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public String getVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TemplateProperty> {
            String name;
            String version;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public TemplateProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.TemplateConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TemplateConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEmailTemplate() {
            return null;
        }

        @Nullable
        default public Object getPushTemplate() {
            return null;
        }

        @Nullable
        default public Object getSmsTemplate() {
            return null;
        }

        @Nullable
        default public Object getVoiceTemplate() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TemplateConfigurationProperty> {
            Object emailTemplate;
            Object pushTemplate;
            Object smsTemplate;
            Object voiceTemplate;

            public Builder emailTemplate(TemplateProperty emailTemplate) {
                this.emailTemplate = emailTemplate;
                return this;
            }

            public Builder emailTemplate(IResolvable emailTemplate) {
                this.emailTemplate = emailTemplate;
                return this;
            }

            public Builder pushTemplate(TemplateProperty pushTemplate) {
                this.pushTemplate = pushTemplate;
                return this;
            }

            public Builder pushTemplate(IResolvable pushTemplate) {
                this.pushTemplate = pushTemplate;
                return this;
            }

            public Builder smsTemplate(TemplateProperty smsTemplate) {
                this.smsTemplate = smsTemplate;
                return this;
            }

            public Builder smsTemplate(IResolvable smsTemplate) {
                this.smsTemplate = smsTemplate;
                return this;
            }

            public Builder voiceTemplate(TemplateProperty voiceTemplate) {
                this.voiceTemplate = voiceTemplate;
                return this;
            }

            public Builder voiceTemplate(IResolvable voiceTemplate) {
                this.voiceTemplate = voiceTemplate;
                return this;
            }

            public TemplateConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.SetDimensionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SetDimensionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDimensionType() {
            return null;
        }

        @Nullable
        default public List<String> getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SetDimensionProperty> {
            String dimensionType;
            List<String> values;

            public Builder dimensionType(String dimensionType) {
                this.dimensionType = dimensionType;
                return this;
            }

            public Builder values(List<String> values) {
                this.values = values;
                return this;
            }

            public SetDimensionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.ScheduleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScheduleProperty
    extends JsiiSerializable {
        @Nullable
        default public String getEndTime() {
            return null;
        }

        @Nullable
        default public Object getEventFilter() {
            return null;
        }

        @Nullable
        default public String getFrequency() {
            return null;
        }

        @Nullable
        default public Object getIsLocalTime() {
            return null;
        }

        @Nullable
        default public Object getQuietTime() {
            return null;
        }

        @Nullable
        default public String getStartTime() {
            return null;
        }

        @Nullable
        default public String getTimeZone() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScheduleProperty> {
            String endTime;
            Object eventFilter;
            String frequency;
            Object isLocalTime;
            Object quietTime;
            String startTime;
            String timeZone;

            public Builder endTime(String endTime) {
                this.endTime = endTime;
                return this;
            }

            public Builder eventFilter(CampaignEventFilterProperty eventFilter) {
                this.eventFilter = eventFilter;
                return this;
            }

            public Builder eventFilter(IResolvable eventFilter) {
                this.eventFilter = eventFilter;
                return this;
            }

            public Builder frequency(String frequency) {
                this.frequency = frequency;
                return this;
            }

            public Builder isLocalTime(Boolean isLocalTime) {
                this.isLocalTime = isLocalTime;
                return this;
            }

            public Builder isLocalTime(IResolvable isLocalTime) {
                this.isLocalTime = isLocalTime;
                return this;
            }

            public Builder quietTime(QuietTimeProperty quietTime) {
                this.quietTime = quietTime;
                return this;
            }

            public Builder quietTime(IResolvable quietTime) {
                this.quietTime = quietTime;
                return this;
            }

            public Builder startTime(String startTime) {
                this.startTime = startTime;
                return this;
            }

            public Builder timeZone(String timeZone) {
                this.timeZone = timeZone;
                return this;
            }

            public ScheduleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.QuietTimeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface QuietTimeProperty
    extends JsiiSerializable {
        @NotNull
        public String getEnd();

        @NotNull
        public String getStart();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<QuietTimeProperty> {
            String end;
            String start;

            public Builder end(String end) {
                this.end = end;
                return this;
            }

            public Builder start(String start) {
                this.start = start;
                return this;
            }

            public QuietTimeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.OverrideButtonConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OverrideButtonConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getButtonAction() {
            return null;
        }

        @Nullable
        default public String getLink() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OverrideButtonConfigurationProperty> {
            String buttonAction;
            String link;

            public Builder buttonAction(String buttonAction) {
                this.buttonAction = buttonAction;
                return this;
            }

            public Builder link(String link) {
                this.link = link;
                return this;
            }

            public OverrideButtonConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.MetricDimensionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetricDimensionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getComparisonOperator() {
            return null;
        }

        @Nullable
        default public Number getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetricDimensionProperty> {
            String comparisonOperator;
            Number value;

            public Builder comparisonOperator(String comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            public Builder value(Number value) {
                this.value = value;
                return this;
            }

            public MetricDimensionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.MessageProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MessageProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAction() {
            return null;
        }

        @Nullable
        default public String getBody() {
            return null;
        }

        @Nullable
        default public String getImageIconUrl() {
            return null;
        }

        @Nullable
        default public String getImageSmallIconUrl() {
            return null;
        }

        @Nullable
        default public String getImageUrl() {
            return null;
        }

        @Nullable
        default public String getJsonBody() {
            return null;
        }

        @Nullable
        default public String getMediaUrl() {
            return null;
        }

        @Nullable
        default public String getRawContent() {
            return null;
        }

        @Nullable
        default public Object getSilentPush() {
            return null;
        }

        @Nullable
        default public Number getTimeToLive() {
            return null;
        }

        @Nullable
        default public String getTitle() {
            return null;
        }

        @Nullable
        default public String getUrl() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MessageProperty> {
            String action;
            String body;
            String imageIconUrl;
            String imageSmallIconUrl;
            String imageUrl;
            String jsonBody;
            String mediaUrl;
            String rawContent;
            Object silentPush;
            Number timeToLive;
            String title;
            String url;

            public Builder action(String action) {
                this.action = action;
                return this;
            }

            public Builder body(String body) {
                this.body = body;
                return this;
            }

            public Builder imageIconUrl(String imageIconUrl) {
                this.imageIconUrl = imageIconUrl;
                return this;
            }

            public Builder imageSmallIconUrl(String imageSmallIconUrl) {
                this.imageSmallIconUrl = imageSmallIconUrl;
                return this;
            }

            public Builder imageUrl(String imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            public Builder jsonBody(String jsonBody) {
                this.jsonBody = jsonBody;
                return this;
            }

            public Builder mediaUrl(String mediaUrl) {
                this.mediaUrl = mediaUrl;
                return this;
            }

            public Builder rawContent(String rawContent) {
                this.rawContent = rawContent;
                return this;
            }

            public Builder silentPush(Boolean silentPush) {
                this.silentPush = silentPush;
                return this;
            }

            public Builder silentPush(IResolvable silentPush) {
                this.silentPush = silentPush;
                return this;
            }

            public Builder timeToLive(Number timeToLive) {
                this.timeToLive = timeToLive;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public MessageProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.MessageConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MessageConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAdmMessage() {
            return null;
        }

        @Nullable
        default public Object getApnsMessage() {
            return null;
        }

        @Nullable
        default public Object getBaiduMessage() {
            return null;
        }

        @Nullable
        default public Object getCustomMessage() {
            return null;
        }

        @Nullable
        default public Object getDefaultMessage() {
            return null;
        }

        @Nullable
        default public Object getEmailMessage() {
            return null;
        }

        @Nullable
        default public Object getGcmMessage() {
            return null;
        }

        @Nullable
        default public Object getInAppMessage() {
            return null;
        }

        @Nullable
        default public Object getSmsMessage() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MessageConfigurationProperty> {
            Object admMessage;
            Object apnsMessage;
            Object baiduMessage;
            Object customMessage;
            Object defaultMessage;
            Object emailMessage;
            Object gcmMessage;
            Object inAppMessage;
            Object smsMessage;

            public Builder admMessage(MessageProperty admMessage) {
                this.admMessage = admMessage;
                return this;
            }

            public Builder admMessage(IResolvable admMessage) {
                this.admMessage = admMessage;
                return this;
            }

            public Builder apnsMessage(MessageProperty apnsMessage) {
                this.apnsMessage = apnsMessage;
                return this;
            }

            public Builder apnsMessage(IResolvable apnsMessage) {
                this.apnsMessage = apnsMessage;
                return this;
            }

            public Builder baiduMessage(MessageProperty baiduMessage) {
                this.baiduMessage = baiduMessage;
                return this;
            }

            public Builder baiduMessage(IResolvable baiduMessage) {
                this.baiduMessage = baiduMessage;
                return this;
            }

            public Builder customMessage(CampaignCustomMessageProperty customMessage) {
                this.customMessage = customMessage;
                return this;
            }

            public Builder customMessage(IResolvable customMessage) {
                this.customMessage = customMessage;
                return this;
            }

            public Builder defaultMessage(MessageProperty defaultMessage) {
                this.defaultMessage = defaultMessage;
                return this;
            }

            public Builder defaultMessage(IResolvable defaultMessage) {
                this.defaultMessage = defaultMessage;
                return this;
            }

            public Builder emailMessage(CampaignEmailMessageProperty emailMessage) {
                this.emailMessage = emailMessage;
                return this;
            }

            public Builder emailMessage(IResolvable emailMessage) {
                this.emailMessage = emailMessage;
                return this;
            }

            public Builder gcmMessage(MessageProperty gcmMessage) {
                this.gcmMessage = gcmMessage;
                return this;
            }

            public Builder gcmMessage(IResolvable gcmMessage) {
                this.gcmMessage = gcmMessage;
                return this;
            }

            public Builder inAppMessage(CampaignInAppMessageProperty inAppMessage) {
                this.inAppMessage = inAppMessage;
                return this;
            }

            public Builder inAppMessage(IResolvable inAppMessage) {
                this.inAppMessage = inAppMessage;
                return this;
            }

            public Builder smsMessage(CampaignSmsMessageProperty smsMessage) {
                this.smsMessage = smsMessage;
                return this;
            }

            public Builder smsMessage(IResolvable smsMessage) {
                this.smsMessage = smsMessage;
                return this;
            }

            public MessageConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.LimitsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LimitsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getDaily() {
            return null;
        }

        @Nullable
        default public Number getMaximumDuration() {
            return null;
        }

        @Nullable
        default public Number getMessagesPerSecond() {
            return null;
        }

        @Nullable
        default public Number getSession() {
            return null;
        }

        @Nullable
        default public Number getTotal() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LimitsProperty> {
            Number daily;
            Number maximumDuration;
            Number messagesPerSecond;
            Number session;
            Number total;

            public Builder daily(Number daily) {
                this.daily = daily;
                return this;
            }

            public Builder maximumDuration(Number maximumDuration) {
                this.maximumDuration = maximumDuration;
                return this;
            }

            public Builder messagesPerSecond(Number messagesPerSecond) {
                this.messagesPerSecond = messagesPerSecond;
                return this;
            }

            public Builder session(Number session) {
                this.session = session;
                return this;
            }

            public Builder total(Number total) {
                this.total = total;
                return this;
            }

            public LimitsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.InAppMessageHeaderConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InAppMessageHeaderConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAlignment() {
            return null;
        }

        @Nullable
        default public String getHeader() {
            return null;
        }

        @Nullable
        default public String getTextColor() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InAppMessageHeaderConfigProperty> {
            String alignment;
            String header;
            String textColor;

            public Builder alignment(String alignment) {
                this.alignment = alignment;
                return this;
            }

            public Builder header(String header) {
                this.header = header;
                return this;
            }

            public Builder textColor(String textColor) {
                this.textColor = textColor;
                return this;
            }

            public InAppMessageHeaderConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.InAppMessageContentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InAppMessageContentProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBackgroundColor() {
            return null;
        }

        @Nullable
        default public Object getBodyConfig() {
            return null;
        }

        @Nullable
        default public Object getHeaderConfig() {
            return null;
        }

        @Nullable
        default public String getImageUrl() {
            return null;
        }

        @Nullable
        default public Object getPrimaryBtn() {
            return null;
        }

        @Nullable
        default public Object getSecondaryBtn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InAppMessageContentProperty> {
            String backgroundColor;
            Object bodyConfig;
            Object headerConfig;
            String imageUrl;
            Object primaryBtn;
            Object secondaryBtn;

            public Builder backgroundColor(String backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            public Builder bodyConfig(InAppMessageBodyConfigProperty bodyConfig) {
                this.bodyConfig = bodyConfig;
                return this;
            }

            public Builder bodyConfig(IResolvable bodyConfig) {
                this.bodyConfig = bodyConfig;
                return this;
            }

            public Builder headerConfig(InAppMessageHeaderConfigProperty headerConfig) {
                this.headerConfig = headerConfig;
                return this;
            }

            public Builder headerConfig(IResolvable headerConfig) {
                this.headerConfig = headerConfig;
                return this;
            }

            public Builder imageUrl(String imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            public Builder primaryBtn(InAppMessageButtonProperty primaryBtn) {
                this.primaryBtn = primaryBtn;
                return this;
            }

            public Builder primaryBtn(IResolvable primaryBtn) {
                this.primaryBtn = primaryBtn;
                return this;
            }

            public Builder secondaryBtn(InAppMessageButtonProperty secondaryBtn) {
                this.secondaryBtn = secondaryBtn;
                return this;
            }

            public Builder secondaryBtn(IResolvable secondaryBtn) {
                this.secondaryBtn = secondaryBtn;
                return this;
            }

            public InAppMessageContentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.InAppMessageButtonProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InAppMessageButtonProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAndroid() {
            return null;
        }

        @Nullable
        default public Object getDefaultConfig() {
            return null;
        }

        @Nullable
        default public Object getIos() {
            return null;
        }

        @Nullable
        default public Object getWeb() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InAppMessageButtonProperty> {
            Object android;
            Object defaultConfig;
            Object ios;
            Object web;

            public Builder android(OverrideButtonConfigurationProperty android) {
                this.android = android;
                return this;
            }

            public Builder android(IResolvable android) {
                this.android = android;
                return this;
            }

            public Builder defaultConfig(DefaultButtonConfigurationProperty defaultConfig) {
                this.defaultConfig = defaultConfig;
                return this;
            }

            public Builder defaultConfig(IResolvable defaultConfig) {
                this.defaultConfig = defaultConfig;
                return this;
            }

            public Builder ios(OverrideButtonConfigurationProperty ios) {
                this.ios = ios;
                return this;
            }

            public Builder ios(IResolvable ios) {
                this.ios = ios;
                return this;
            }

            public Builder web(OverrideButtonConfigurationProperty web) {
                this.web = web;
                return this;
            }

            public Builder web(IResolvable web) {
                this.web = web;
                return this;
            }

            public InAppMessageButtonProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.InAppMessageBodyConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InAppMessageBodyConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAlignment() {
            return null;
        }

        @Nullable
        default public String getBody() {
            return null;
        }

        @Nullable
        default public String getTextColor() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InAppMessageBodyConfigProperty> {
            String alignment;
            String body;
            String textColor;

            public Builder alignment(String alignment) {
                this.alignment = alignment;
                return this;
            }

            public Builder body(String body) {
                this.body = body;
                return this;
            }

            public Builder textColor(String textColor) {
                this.textColor = textColor;
                return this;
            }

            public InAppMessageBodyConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.EventDimensionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EventDimensionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAttributes() {
            return null;
        }

        @Nullable
        default public Object getEventType() {
            return null;
        }

        @Nullable
        default public Object getMetrics() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EventDimensionsProperty> {
            Object attributes;
            Object eventType;
            Object metrics;

            public Builder attributes(Object attributes) {
                this.attributes = attributes;
                return this;
            }

            public Builder eventType(SetDimensionProperty eventType) {
                this.eventType = eventType;
                return this;
            }

            public Builder eventType(IResolvable eventType) {
                this.eventType = eventType;
                return this;
            }

            public Builder metrics(Object metrics) {
                this.metrics = metrics;
                return this;
            }

            public EventDimensionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.DefaultButtonConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DefaultButtonConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBackgroundColor() {
            return null;
        }

        @Nullable
        default public Number getBorderRadius() {
            return null;
        }

        @Nullable
        default public String getButtonAction() {
            return null;
        }

        @Nullable
        default public String getLink() {
            return null;
        }

        @Nullable
        default public String getText() {
            return null;
        }

        @Nullable
        default public String getTextColor() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DefaultButtonConfigurationProperty> {
            String backgroundColor;
            Number borderRadius;
            String buttonAction;
            String link;
            String text;
            String textColor;

            public Builder backgroundColor(String backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            public Builder borderRadius(Number borderRadius) {
                this.borderRadius = borderRadius;
                return this;
            }

            public Builder buttonAction(String buttonAction) {
                this.buttonAction = buttonAction;
                return this;
            }

            public Builder link(String link) {
                this.link = link;
                return this;
            }

            public Builder text(String text) {
                this.text = text;
                return this;
            }

            public Builder textColor(String textColor) {
                this.textColor = textColor;
                return this;
            }

            public DefaultButtonConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.CustomDeliveryConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomDeliveryConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDeliveryUri() {
            return null;
        }

        @Nullable
        default public List<String> getEndpointTypes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomDeliveryConfigurationProperty> {
            String deliveryUri;
            List<String> endpointTypes;

            public Builder deliveryUri(String deliveryUri) {
                this.deliveryUri = deliveryUri;
                return this;
            }

            public Builder endpointTypes(List<String> endpointTypes) {
                this.endpointTypes = endpointTypes;
                return this;
            }

            public CustomDeliveryConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.CampaignSmsMessageProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CampaignSmsMessageProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBody() {
            return null;
        }

        @Nullable
        default public String getEntityId() {
            return null;
        }

        @Nullable
        default public String getMessageType() {
            return null;
        }

        @Nullable
        default public String getOriginationNumber() {
            return null;
        }

        @Nullable
        default public String getSenderId() {
            return null;
        }

        @Nullable
        default public String getTemplateId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CampaignSmsMessageProperty> {
            String body;
            String entityId;
            String messageType;
            String originationNumber;
            String senderId;
            String templateId;

            public Builder body(String body) {
                this.body = body;
                return this;
            }

            public Builder entityId(String entityId) {
                this.entityId = entityId;
                return this;
            }

            public Builder messageType(String messageType) {
                this.messageType = messageType;
                return this;
            }

            public Builder originationNumber(String originationNumber) {
                this.originationNumber = originationNumber;
                return this;
            }

            public Builder senderId(String senderId) {
                this.senderId = senderId;
                return this;
            }

            public Builder templateId(String templateId) {
                this.templateId = templateId;
                return this;
            }

            public CampaignSmsMessageProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.CampaignInAppMessageProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CampaignInAppMessageProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getContent() {
            return null;
        }

        @Nullable
        default public Object getCustomConfig() {
            return null;
        }

        @Nullable
        default public String getLayout() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CampaignInAppMessageProperty> {
            Object content;
            Object customConfig;
            String layout;

            public Builder content(IResolvable content) {
                this.content = content;
                return this;
            }

            public Builder content(List<? extends Object> content) {
                this.content = content;
                return this;
            }

            public Builder customConfig(Object customConfig) {
                this.customConfig = customConfig;
                return this;
            }

            public Builder layout(String layout) {
                this.layout = layout;
                return this;
            }

            public CampaignInAppMessageProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.CampaignHookProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CampaignHookProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLambdaFunctionName() {
            return null;
        }

        @Nullable
        default public String getMode() {
            return null;
        }

        @Nullable
        default public String getWebUrl() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CampaignHookProperty> {
            String lambdaFunctionName;
            String mode;
            String webUrl;

            public Builder lambdaFunctionName(String lambdaFunctionName) {
                this.lambdaFunctionName = lambdaFunctionName;
                return this;
            }

            public Builder mode(String mode) {
                this.mode = mode;
                return this;
            }

            public Builder webUrl(String webUrl) {
                this.webUrl = webUrl;
                return this;
            }

            public CampaignHookProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.CampaignEventFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CampaignEventFilterProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDimensions() {
            return null;
        }

        @Nullable
        default public String getFilterType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CampaignEventFilterProperty> {
            Object dimensions;
            String filterType;

            public Builder dimensions(EventDimensionsProperty dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            public Builder dimensions(IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            public Builder filterType(String filterType) {
                this.filterType = filterType;
                return this;
            }

            public CampaignEventFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.CampaignEmailMessageProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CampaignEmailMessageProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBody() {
            return null;
        }

        @Nullable
        default public String getFromAddress() {
            return null;
        }

        @Nullable
        default public String getHtmlBody() {
            return null;
        }

        @Nullable
        default public String getTitle() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CampaignEmailMessageProperty> {
            String body;
            String fromAddress;
            String htmlBody;
            String title;

            public Builder body(String body) {
                this.body = body;
                return this;
            }

            public Builder fromAddress(String fromAddress) {
                this.fromAddress = fromAddress;
                return this;
            }

            public Builder htmlBody(String htmlBody) {
                this.htmlBody = htmlBody;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public CampaignEmailMessageProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.CampaignCustomMessageProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CampaignCustomMessageProperty
    extends JsiiSerializable {
        @Nullable
        default public String getData() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CampaignCustomMessageProperty> {
            String data;

            public Builder data(String data) {
                this.data = data;
                return this;
            }

            public CampaignCustomMessageProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_pinpoint.CfnCampaign.AttributeDimensionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AttributeDimensionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAttributeType() {
            return null;
        }

        @Nullable
        default public List<String> getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AttributeDimensionProperty> {
            String attributeType;
            List<String> values;

            public Builder attributeType(String attributeType) {
                this.attributeType = attributeType;
                return this;
            }

            public Builder values(List<String> values) {
                this.values = values;
                return this;
            }

            public AttributeDimensionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

