/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sagemaker;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.sagemaker.CfnModel;
import software.amazon.awscdk.services.sagemaker.CfnModelProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk.aws_sagemaker.CfnModel")
public class CfnModel
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnModel.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnModel(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnModel(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnModel(@NotNull Construct scope, @NotNull String id, @NotNull CfnModelProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrModelName() {
        return (String)Kernel.get((Object)this, (String)"attrModelName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getExecutionRoleArn() {
        return (String)Kernel.get((Object)this, (String)"executionRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setExecutionRoleArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"executionRoleArn", (Object)Objects.requireNonNull(value, "executionRoleArn is required"));
    }

    @Nullable
    public Object getContainers() {
        return Kernel.get((Object)this, (String)"containers", (NativeType)NativeType.forClass(Object.class));
    }

    public void setContainers(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"containers", (Object)value);
    }

    public void setContainers(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof ContainerDefinitionProperty || __val_ac66f0 instanceof IResolvable || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.services.sagemaker.CfnModel.ContainerDefinitionProperty, software.amazon.awscdk.core.IResolvable; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"containers", value);
    }

    @Nullable
    public Object getEnableNetworkIsolation() {
        return Kernel.get((Object)this, (String)"enableNetworkIsolation", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEnableNetworkIsolation(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"enableNetworkIsolation", (Object)value);
    }

    public void setEnableNetworkIsolation(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"enableNetworkIsolation", (Object)value);
    }

    @Nullable
    public Object getInferenceExecutionConfig() {
        return Kernel.get((Object)this, (String)"inferenceExecutionConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setInferenceExecutionConfig(@Nullable InferenceExecutionConfigProperty value) {
        Kernel.set((Object)this, (String)"inferenceExecutionConfig", (Object)value);
    }

    public void setInferenceExecutionConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"inferenceExecutionConfig", (Object)value);
    }

    @Nullable
    public String getModelName() {
        return (String)Kernel.get((Object)this, (String)"modelName", (NativeType)NativeType.forClass(String.class));
    }

    public void setModelName(@Nullable String value) {
        Kernel.set((Object)this, (String)"modelName", (Object)value);
    }

    @Nullable
    public Object getPrimaryContainer() {
        return Kernel.get((Object)this, (String)"primaryContainer", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPrimaryContainer(@Nullable ContainerDefinitionProperty value) {
        Kernel.set((Object)this, (String)"primaryContainer", (Object)value);
    }

    public void setPrimaryContainer(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"primaryContainer", (Object)value);
    }

    @Nullable
    public Object getVpcConfig() {
        return Kernel.get((Object)this, (String)"vpcConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setVpcConfig(@Nullable VpcConfigProperty value) {
        Kernel.set((Object)this, (String)"vpcConfig", (Object)value);
    }

    public void setVpcConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"vpcConfig", (Object)value);
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_sagemaker.CfnModel.ContainerDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ContainerDefinitionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getContainerHostname() {
            return null;
        }

        @Nullable
        default public Object getEnvironment() {
            return null;
        }

        @Nullable
        default public String getImage() {
            return null;
        }

        @Nullable
        default public Object getImageConfig() {
            return null;
        }

        @Nullable
        default public String getInferenceSpecificationName() {
            return null;
        }

        @Nullable
        default public String getMode() {
            return null;
        }

        @Nullable
        default public String getModelDataUrl() {
            return null;
        }

        @Nullable
        default public String getModelPackageName() {
            return null;
        }

        @Nullable
        default public Object getMultiModelConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ContainerDefinitionProperty> {
            String containerHostname;
            Object environment;
            String image;
            Object imageConfig;
            String inferenceSpecificationName;
            String mode;
            String modelDataUrl;
            String modelPackageName;
            Object multiModelConfig;

            public Builder containerHostname(String containerHostname) {
                this.containerHostname = containerHostname;
                return this;
            }

            public Builder environment(Object environment) {
                this.environment = environment;
                return this;
            }

            public Builder image(String image) {
                this.image = image;
                return this;
            }

            public Builder imageConfig(ImageConfigProperty imageConfig) {
                this.imageConfig = imageConfig;
                return this;
            }

            public Builder imageConfig(IResolvable imageConfig) {
                this.imageConfig = imageConfig;
                return this;
            }

            public Builder inferenceSpecificationName(String inferenceSpecificationName) {
                this.inferenceSpecificationName = inferenceSpecificationName;
                return this;
            }

            public Builder mode(String mode) {
                this.mode = mode;
                return this;
            }

            public Builder modelDataUrl(String modelDataUrl) {
                this.modelDataUrl = modelDataUrl;
                return this;
            }

            public Builder modelPackageName(String modelPackageName) {
                this.modelPackageName = modelPackageName;
                return this;
            }

            public Builder multiModelConfig(MultiModelConfigProperty multiModelConfig) {
                this.multiModelConfig = multiModelConfig;
                return this;
            }

            public Builder multiModelConfig(IResolvable multiModelConfig) {
                this.multiModelConfig = multiModelConfig;
                return this;
            }

            public ContainerDefinitionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnModel> {
        private final Construct scope;
        private final String id;
        private final CfnModelProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnModelProps.Builder();
        }

        public Builder executionRoleArn(String executionRoleArn) {
            this.props.executionRoleArn(executionRoleArn);
            return this;
        }

        public Builder containers(IResolvable containers) {
            this.props.containers(containers);
            return this;
        }

        public Builder containers(List<? extends Object> containers) {
            this.props.containers(containers);
            return this;
        }

        public Builder enableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.props.enableNetworkIsolation(enableNetworkIsolation);
            return this;
        }

        public Builder enableNetworkIsolation(IResolvable enableNetworkIsolation) {
            this.props.enableNetworkIsolation(enableNetworkIsolation);
            return this;
        }

        public Builder inferenceExecutionConfig(InferenceExecutionConfigProperty inferenceExecutionConfig) {
            this.props.inferenceExecutionConfig(inferenceExecutionConfig);
            return this;
        }

        public Builder inferenceExecutionConfig(IResolvable inferenceExecutionConfig) {
            this.props.inferenceExecutionConfig(inferenceExecutionConfig);
            return this;
        }

        public Builder modelName(String modelName) {
            this.props.modelName(modelName);
            return this;
        }

        public Builder primaryContainer(ContainerDefinitionProperty primaryContainer) {
            this.props.primaryContainer(primaryContainer);
            return this;
        }

        public Builder primaryContainer(IResolvable primaryContainer) {
            this.props.primaryContainer(primaryContainer);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder vpcConfig(VpcConfigProperty vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        public Builder vpcConfig(IResolvable vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        public CfnModel build() {
            return new CfnModel(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_sagemaker.CfnModel.VpcConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VpcConfigProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSecurityGroupIds();

        @NotNull
        public List<String> getSubnets();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VpcConfigProperty> {
            List<String> securityGroupIds;
            List<String> subnets;

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnets(List<String> subnets) {
                this.subnets = subnets;
                return this;
            }

            public VpcConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_sagemaker.CfnModel.RepositoryAuthConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RepositoryAuthConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getRepositoryCredentialsProviderArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RepositoryAuthConfigProperty> {
            String repositoryCredentialsProviderArn;

            public Builder repositoryCredentialsProviderArn(String repositoryCredentialsProviderArn) {
                this.repositoryCredentialsProviderArn = repositoryCredentialsProviderArn;
                return this;
            }

            public RepositoryAuthConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_sagemaker.CfnModel.MultiModelConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MultiModelConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getModelCacheSetting() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MultiModelConfigProperty> {
            String modelCacheSetting;

            public Builder modelCacheSetting(String modelCacheSetting) {
                this.modelCacheSetting = modelCacheSetting;
                return this;
            }

            public MultiModelConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_sagemaker.CfnModel.InferenceExecutionConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InferenceExecutionConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getMode();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InferenceExecutionConfigProperty> {
            String mode;

            public Builder mode(String mode) {
                this.mode = mode;
                return this;
            }

            public InferenceExecutionConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_sagemaker.CfnModel.ImageConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ImageConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getRepositoryAccessMode();

        @Nullable
        default public Object getRepositoryAuthConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ImageConfigProperty> {
            String repositoryAccessMode;
            Object repositoryAuthConfig;

            public Builder repositoryAccessMode(String repositoryAccessMode) {
                this.repositoryAccessMode = repositoryAccessMode;
                return this;
            }

            public Builder repositoryAuthConfig(RepositoryAuthConfigProperty repositoryAuthConfig) {
                this.repositoryAuthConfig = repositoryAuthConfig;
                return this;
            }

            public Builder repositoryAuthConfig(IResolvable repositoryAuthConfig) {
                this.repositoryAuthConfig = repositoryAuthConfig;
                return this;
            }

            public ImageConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

