/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.xray;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.xray.CfnGroup;
import software.amazon.awscdk.services.xray.CfnGroupProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk.aws_xray.CfnGroup")
public class CfnGroup
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnGroup.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnGroup(@NotNull Construct scope, @NotNull String id, @NotNull CfnGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrGroupArn() {
        return (String)Kernel.get((Object)this, (String)"attrGroupArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getGroupName() {
        return (String)Kernel.get((Object)this, (String)"groupName", (NativeType)NativeType.forClass(String.class));
    }

    public void setGroupName(@NotNull String value) {
        Kernel.set((Object)this, (String)"groupName", (Object)Objects.requireNonNull(value, "groupName is required"));
    }

    @Nullable
    public String getFilterExpression() {
        return (String)Kernel.get((Object)this, (String)"filterExpression", (NativeType)NativeType.forClass(String.class));
    }

    public void setFilterExpression(@Nullable String value) {
        Kernel.set((Object)this, (String)"filterExpression", (Object)value);
    }

    @Nullable
    public Object getInsightsConfiguration() {
        return Kernel.get((Object)this, (String)"insightsConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setInsightsConfiguration(@Nullable InsightsConfigurationProperty value) {
        Kernel.set((Object)this, (String)"insightsConfiguration", (Object)value);
    }

    public void setInsightsConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"insightsConfiguration", (Object)value);
    }

    @Nullable
    public List<Object> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Object.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<Object> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnGroup> {
        private final Construct scope;
        private final String id;
        private final CfnGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnGroupProps.Builder();
        }

        public Builder groupName(String groupName) {
            this.props.groupName(groupName);
            return this;
        }

        public Builder filterExpression(String filterExpression) {
            this.props.filterExpression(filterExpression);
            return this;
        }

        public Builder insightsConfiguration(InsightsConfigurationProperty insightsConfiguration) {
            this.props.insightsConfiguration(insightsConfiguration);
            return this;
        }

        public Builder insightsConfiguration(IResolvable insightsConfiguration) {
            this.props.insightsConfiguration(insightsConfiguration);
            return this;
        }

        public Builder tags(List<? extends Object> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnGroup build() {
            return new CfnGroup(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_xray.CfnGroup.InsightsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InsightsConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getInsightsEnabled() {
            return null;
        }

        @Nullable
        default public Object getNotificationsEnabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InsightsConfigurationProperty> {
            Object insightsEnabled;
            Object notificationsEnabled;

            public Builder insightsEnabled(Boolean insightsEnabled) {
                this.insightsEnabled = insightsEnabled;
                return this;
            }

            public Builder insightsEnabled(IResolvable insightsEnabled) {
                this.insightsEnabled = insightsEnabled;
                return this;
            }

            public Builder notificationsEnabled(Boolean notificationsEnabled) {
                this.notificationsEnabled = notificationsEnabled;
                return this;
            }

            public Builder notificationsEnabled(IResolvable notificationsEnabled) {
                this.notificationsEnabled = notificationsEnabled;
                return this;
            }

            public InsightsConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

