package software.amazon.awscdk.services.msk;

/**
 * (experimental) Configuration properties for client authentication.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Cluster cluster = Cluster.Builder.create(this, "cluster")
 *         .clusterName("myCluster")
 *         .kafkaVersion(KafkaVersion.V2_8_1)
 *         .vpc(vpc)
 *         .encryptionInTransit(EncryptionInTransitConfig.builder()
 *                 .clientBroker(ClientBrokerEncryption.TLS)
 *                 .build())
 *         .clientAuthentication(ClientAuthentication.sasl(SaslAuthProps.builder()
 *                 .scram(true)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:43.554Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.msk.$Module.class, fqn = "@aws-cdk/aws-msk.ClientAuthentication")
public class ClientAuthentication extends software.amazon.jsii.JsiiObject {

    protected ClientAuthentication(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ClientAuthentication(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) SASL authentication.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.msk.ClientAuthentication sasl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.msk.SaslAuthProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.msk.ClientAuthentication.class, "sasl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.msk.ClientAuthentication.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) TLS authentication.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.msk.ClientAuthentication tls(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.msk.TlsAuthProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.msk.ClientAuthentication.class, "tls", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.msk.ClientAuthentication.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) - properties for SASL authentication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.msk.SaslAuthProps getSaslProps() {
        return software.amazon.jsii.Kernel.get(this, "saslProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.msk.SaslAuthProps.class));
    }

    /**
     * (experimental) - properties for TLS authentication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.msk.TlsAuthProps getTlsProps() {
        return software.amazon.jsii.Kernel.get(this, "tlsProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.msk.TlsAuthProps.class));
    }
}
