/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.rds;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.rds.;
import software.amazon.awscdk.services.rds.Credentials;
import software.amazon.awscdk.services.rds.IClusterEngine;
import software.amazon.awscdk.services.rds.IParameterGroup;
import software.amazon.awscdk.services.rds.ISubnetGroup;
import software.amazon.awscdk.services.rds.ServerlessClusterProps;
import software.amazon.awscdk.services.rds.ServerlessScalingOptions;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-rds.ServerlessClusterProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface ServerlessClusterProps
extends JsiiSerializable {
    @NotNull
    public IClusterEngine getEngine();

    @NotNull
    public IVpc getVpc();

    @Nullable
    default public Duration getBackupRetention() {
        return null;
    }

    @Nullable
    default public String getClusterIdentifier() {
        return null;
    }

    @Nullable
    default public Credentials getCredentials() {
        return null;
    }

    @Nullable
    default public String getDefaultDatabaseName() {
        return null;
    }

    @Nullable
    default public Boolean getDeletionProtection() {
        return null;
    }

    @Nullable
    default public Boolean getEnableDataApi() {
        return null;
    }

    @Nullable
    default public IParameterGroup getParameterGroup() {
        return null;
    }

    @Nullable
    default public RemovalPolicy getRemovalPolicy() {
        return null;
    }

    @Nullable
    default public ServerlessScalingOptions getScaling() {
        return null;
    }

    @Nullable
    default public List<ISecurityGroup> getSecurityGroups() {
        return null;
    }

    @Nullable
    default public IKey getStorageEncryptionKey() {
        return null;
    }

    @Nullable
    default public ISubnetGroup getSubnetGroup() {
        return null;
    }

    @Nullable
    default public SubnetSelection getVpcSubnets() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ServerlessClusterProps> {
        private IClusterEngine engine;
        private IVpc vpc;
        private Duration backupRetention;
        private String clusterIdentifier;
        private Credentials credentials;
        private String defaultDatabaseName;
        private Boolean deletionProtection;
        private Boolean enableDataApi;
        private IParameterGroup parameterGroup;
        private RemovalPolicy removalPolicy;
        private ServerlessScalingOptions scaling;
        private List<ISecurityGroup> securityGroups;
        private IKey storageEncryptionKey;
        private ISubnetGroup subnetGroup;
        private SubnetSelection vpcSubnets;

        public Builder engine(IClusterEngine engine) {
            this.engine = engine;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder backupRetention(Duration backupRetention) {
            this.backupRetention = backupRetention;
            return this;
        }

        public Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public Builder defaultDatabaseName(String defaultDatabaseName) {
            this.defaultDatabaseName = defaultDatabaseName;
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public Builder enableDataApi(Boolean enableDataApi) {
            this.enableDataApi = enableDataApi;
            return this;
        }

        public Builder parameterGroup(IParameterGroup parameterGroup) {
            this.parameterGroup = parameterGroup;
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        public Builder scaling(ServerlessScalingOptions scaling) {
            this.scaling = scaling;
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder storageEncryptionKey(IKey storageEncryptionKey) {
            this.storageEncryptionKey = storageEncryptionKey;
            return this;
        }

        public Builder subnetGroup(ISubnetGroup subnetGroup) {
            this.subnetGroup = subnetGroup;
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public ServerlessClusterProps build() {
            return new Jsii.Proxy(this.engine, this.vpc, this.backupRetention, this.clusterIdentifier, this.credentials, this.defaultDatabaseName, this.deletionProtection, this.enableDataApi, this.parameterGroup, this.removalPolicy, this.scaling, this.securityGroups, this.storageEncryptionKey, this.subnetGroup, this.vpcSubnets);
        }
    }
}

