/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.rds;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.logs.RetentionDays;
import software.amazon.awscdk.services.rds.;
import software.amazon.awscdk.services.rds.BackupProps;
import software.amazon.awscdk.services.rds.DatabaseClusterFromSnapshotProps;
import software.amazon.awscdk.services.rds.IClusterEngine;
import software.amazon.awscdk.services.rds.IParameterGroup;
import software.amazon.awscdk.services.rds.ISubnetGroup;
import software.amazon.awscdk.services.rds.InstanceProps;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-rds.DatabaseClusterFromSnapshotProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface DatabaseClusterFromSnapshotProps
extends JsiiSerializable {
    @NotNull
    public IClusterEngine getEngine();

    @NotNull
    public InstanceProps getInstanceProps();

    @NotNull
    public String getSnapshotIdentifier();

    @Nullable
    default public BackupProps getBackup() {
        return null;
    }

    @Nullable
    default public List<String> getCloudwatchLogsExports() {
        return null;
    }

    @Nullable
    default public RetentionDays getCloudwatchLogsRetention() {
        return null;
    }

    @Nullable
    default public IRole getCloudwatchLogsRetentionRole() {
        return null;
    }

    @Nullable
    default public String getClusterIdentifier() {
        return null;
    }

    @Nullable
    default public String getDefaultDatabaseName() {
        return null;
    }

    @Nullable
    default public Boolean getDeletionProtection() {
        return null;
    }

    @Nullable
    default public Boolean getIamAuthentication() {
        return null;
    }

    @Nullable
    default public String getInstanceIdentifierBase() {
        return null;
    }

    @Nullable
    default public Number getInstances() {
        return null;
    }

    @Nullable
    default public Duration getMonitoringInterval() {
        return null;
    }

    @Nullable
    default public IRole getMonitoringRole() {
        return null;
    }

    @Nullable
    default public IParameterGroup getParameterGroup() {
        return null;
    }

    @Nullable
    default public Number getPort() {
        return null;
    }

    @Nullable
    default public String getPreferredMaintenanceWindow() {
        return null;
    }

    @Nullable
    default public RemovalPolicy getRemovalPolicy() {
        return null;
    }

    @Nullable
    default public List<IBucket> getS3ExportBuckets() {
        return null;
    }

    @Nullable
    default public IRole getS3ExportRole() {
        return null;
    }

    @Nullable
    default public List<IBucket> getS3ImportBuckets() {
        return null;
    }

    @Nullable
    default public IRole getS3ImportRole() {
        return null;
    }

    @Nullable
    default public ISubnetGroup getSubnetGroup() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<DatabaseClusterFromSnapshotProps> {
        private IClusterEngine engine;
        private InstanceProps instanceProps;
        private String snapshotIdentifier;
        private BackupProps backup;
        private List<String> cloudwatchLogsExports;
        private RetentionDays cloudwatchLogsRetention;
        private IRole cloudwatchLogsRetentionRole;
        private String clusterIdentifier;
        private String defaultDatabaseName;
        private Boolean deletionProtection;
        private Boolean iamAuthentication;
        private String instanceIdentifierBase;
        private Number instances;
        private Duration monitoringInterval;
        private IRole monitoringRole;
        private IParameterGroup parameterGroup;
        private Number port;
        private String preferredMaintenanceWindow;
        private RemovalPolicy removalPolicy;
        private List<IBucket> s3ExportBuckets;
        private IRole s3ExportRole;
        private List<IBucket> s3ImportBuckets;
        private IRole s3ImportRole;
        private ISubnetGroup subnetGroup;

        public Builder engine(IClusterEngine engine) {
            this.engine = engine;
            return this;
        }

        public Builder instanceProps(InstanceProps instanceProps) {
            this.instanceProps = instanceProps;
            return this;
        }

        public Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public Builder backup(BackupProps backup) {
            this.backup = backup;
            return this;
        }

        public Builder cloudwatchLogsExports(List<String> cloudwatchLogsExports) {
            this.cloudwatchLogsExports = cloudwatchLogsExports;
            return this;
        }

        public Builder cloudwatchLogsRetention(RetentionDays cloudwatchLogsRetention) {
            this.cloudwatchLogsRetention = cloudwatchLogsRetention;
            return this;
        }

        public Builder cloudwatchLogsRetentionRole(IRole cloudwatchLogsRetentionRole) {
            this.cloudwatchLogsRetentionRole = cloudwatchLogsRetentionRole;
            return this;
        }

        public Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public Builder defaultDatabaseName(String defaultDatabaseName) {
            this.defaultDatabaseName = defaultDatabaseName;
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public Builder iamAuthentication(Boolean iamAuthentication) {
            this.iamAuthentication = iamAuthentication;
            return this;
        }

        public Builder instanceIdentifierBase(String instanceIdentifierBase) {
            this.instanceIdentifierBase = instanceIdentifierBase;
            return this;
        }

        public Builder instances(Number instances) {
            this.instances = instances;
            return this;
        }

        public Builder monitoringInterval(Duration monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public Builder monitoringRole(IRole monitoringRole) {
            this.monitoringRole = monitoringRole;
            return this;
        }

        public Builder parameterGroup(IParameterGroup parameterGroup) {
            this.parameterGroup = parameterGroup;
            return this;
        }

        public Builder port(Number port) {
            this.port = port;
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        public Builder s3ExportBuckets(List<? extends IBucket> s3ExportBuckets) {
            this.s3ExportBuckets = s3ExportBuckets;
            return this;
        }

        public Builder s3ExportRole(IRole s3ExportRole) {
            this.s3ExportRole = s3ExportRole;
            return this;
        }

        public Builder s3ImportBuckets(List<? extends IBucket> s3ImportBuckets) {
            this.s3ImportBuckets = s3ImportBuckets;
            return this;
        }

        public Builder s3ImportRole(IRole s3ImportRole) {
            this.s3ImportRole = s3ImportRole;
            return this;
        }

        public Builder subnetGroup(ISubnetGroup subnetGroup) {
            this.subnetGroup = subnetGroup;
            return this;
        }

        public DatabaseClusterFromSnapshotProps build() {
            return new Jsii.Proxy(this.engine, this.instanceProps, this.snapshotIdentifier, this.backup, this.cloudwatchLogsExports, this.cloudwatchLogsRetention, this.cloudwatchLogsRetentionRole, this.clusterIdentifier, this.defaultDatabaseName, this.deletionProtection, this.iamAuthentication, this.instanceIdentifierBase, this.instances, this.monitoringInterval, this.monitoringRole, this.parameterGroup, this.port, this.preferredMaintenanceWindow, this.removalPolicy, this.s3ExportBuckets, this.s3ExportRole, this.s3ImportBuckets, this.s3ImportRole, this.subnetGroup);
        }
    }
}

