package software.amazon.awscdk.services.rds;

/**
 * Aurora capacity units (ACUs).
 * <p>
 * Each ACU is a combination of processing and memory capacity.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * ServerlessCluster cluster = ServerlessCluster.Builder.create(this, "AnotherCluster")
 *         .engine(DatabaseClusterEngine.AURORA_POSTGRESQL)
 *         .parameterGroup(ParameterGroup.fromParameterGroupName(this, "ParameterGroup", "default.aurora-postgresql10"))
 *         .vpc(vpc)
 *         .scaling(ServerlessScalingOptions.builder()
 *                 .autoPause(Duration.minutes(10)) // default is to pause after 5 minutes of idle time
 *                 .minCapacity(AuroraCapacityUnit.ACU_8) // default is 2 Aurora capacity units (ACUs)
 *                 .maxCapacity(AuroraCapacityUnit.ACU_32)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.architecture">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.architecture</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:48.626Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.rds.$Module.class, fqn = "@aws-cdk/aws-rds.AuroraCapacityUnit")
public enum AuroraCapacityUnit {
    /**
     * 1 Aurora Capacity Unit.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACU_1,
    /**
     * 2 Aurora Capacity Units.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACU_2,
    /**
     * 4 Aurora Capacity Units.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACU_4,
    /**
     * 8 Aurora Capacity Units.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACU_8,
    /**
     * 16 Aurora Capacity Units.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACU_16,
    /**
     * 32 Aurora Capacity Units.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACU_32,
    /**
     * 64 Aurora Capacity Units.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACU_64,
    /**
     * 128 Aurora Capacity Units.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACU_128,
    /**
     * 192 Aurora Capacity Units.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACU_192,
    /**
     * 256 Aurora Capacity Units.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACU_256,
    /**
     * 384 Aurora Capacity Units.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACU_384,
}
