package software.amazon.awscdk.services.rds;

/**
 * The type returned from the {@link IInstanceEngine.bind} method.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * OptionGroup optionGroup;
 * InstanceEngineConfig instanceEngineConfig = InstanceEngineConfig.builder()
 *         .features(InstanceEngineFeatures.builder()
 *                 .s3Export("s3Export")
 *                 .s3Import("s3Import")
 *                 .build())
 *         .optionGroup(optionGroup)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:48.869Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.rds.$Module.class, fqn = "@aws-cdk/aws-rds.InstanceEngineConfig")
@software.amazon.jsii.Jsii.Proxy(InstanceEngineConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InstanceEngineConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Features supported by the database engine.
     * <p>
     * Default: - no features
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html">https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.InstanceEngineFeatures getFeatures() {
        return null;
    }

    /**
     * Option group of the database.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.IOptionGroup getOptionGroup() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link InstanceEngineConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InstanceEngineConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InstanceEngineConfig> {
        software.amazon.awscdk.services.rds.InstanceEngineFeatures features;
        software.amazon.awscdk.services.rds.IOptionGroup optionGroup;

        /**
         * Sets the value of {@link InstanceEngineConfig#getFeatures}
         * @param features Features supported by the database engine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder features(software.amazon.awscdk.services.rds.InstanceEngineFeatures features) {
            this.features = features;
            return this;
        }

        /**
         * Sets the value of {@link InstanceEngineConfig#getOptionGroup}
         * @param optionGroup Option group of the database.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionGroup(software.amazon.awscdk.services.rds.IOptionGroup optionGroup) {
            this.optionGroup = optionGroup;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InstanceEngineConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InstanceEngineConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InstanceEngineConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceEngineConfig {
        private final software.amazon.awscdk.services.rds.InstanceEngineFeatures features;
        private final software.amazon.awscdk.services.rds.IOptionGroup optionGroup;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.features = software.amazon.jsii.Kernel.get(this, "features", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.InstanceEngineFeatures.class));
            this.optionGroup = software.amazon.jsii.Kernel.get(this, "optionGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IOptionGroup.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.features = builder.features;
            this.optionGroup = builder.optionGroup;
        }

        @Override
        public final software.amazon.awscdk.services.rds.InstanceEngineFeatures getFeatures() {
            return this.features;
        }

        @Override
        public final software.amazon.awscdk.services.rds.IOptionGroup getOptionGroup() {
            return this.optionGroup;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getFeatures() != null) {
                data.set("features", om.valueToTree(this.getFeatures()));
            }
            if (this.getOptionGroup() != null) {
                data.set("optionGroup", om.valueToTree(this.getOptionGroup()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-rds.InstanceEngineConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InstanceEngineConfig.Jsii$Proxy that = (InstanceEngineConfig.Jsii$Proxy) o;

            if (this.features != null ? !this.features.equals(that.features) : that.features != null) return false;
            return this.optionGroup != null ? this.optionGroup.equals(that.optionGroup) : that.optionGroup == null;
        }

        @Override
        public final int hashCode() {
            int result = this.features != null ? this.features.hashCode() : 0;
            result = 31 * result + (this.optionGroup != null ? this.optionGroup.hashCode() : 0);
            return result;
        }
    }
}
