package software.amazon.awscdk.services.rds;

/**
 * The versions for the MariaDB instance engines (those returned by {@link DatabaseInstanceEngine.mariaDb}).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * MariaDbEngineVersion mariaDbEngineVersion = MariaDbEngineVersion.VER_10_0;
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:48.889Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.rds.$Module.class, fqn = "@aws-cdk/aws-rds.MariaDbEngineVersion")
public class MariaDbEngineVersion extends software.amazon.jsii.JsiiObject {

    protected MariaDbEngineVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MariaDbEngineVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        VER_10_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_0_17 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_0_17", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_0_24 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_0_24", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_0_28 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_0_28", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_0_31 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_0_31", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_0_32 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_0_32", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_0_34 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_0_34", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_0_35 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_0_35", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_1_14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_1_14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_1_19 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_1_19", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_1_23 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_1_23", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_1_26 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_1_26", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_1_31 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_1_31", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_1_34 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_1_34", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_2_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_2_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_2_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_2_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_2_15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_2_15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_2_21 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_2_21", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_2_32 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_2_32", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_2_37 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_2_37", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_2_39 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_2_39", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_2_40 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_2_40", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_2_41 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_2_41", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_3_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_3_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_3_20 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_3_20", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_3_23 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_3_23", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_3_28 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_3_28", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_3_31 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_3_31", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_3_32 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_3_32", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_3_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_3_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_4_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_4_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_4_18 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_4_18", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_4_21 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_4_21", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_4_22 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_4_22", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_4_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_4_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_5_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_5_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_5_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_5_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_5_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_5_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
        VER_10_5_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "VER_10_5_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class));
    }

    /**
     * Create a new MariaDbEngineVersion with an arbitrary version.
     * <p>
     * @param mariaDbFullVersion the full version string, for example "10.5.28". This parameter is required.
     * @param mariaDbMajorVersion the major version of the engine, for example "10.5". This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.MariaDbEngineVersion of(final @org.jetbrains.annotations.NotNull java.lang.String mariaDbFullVersion, final @org.jetbrains.annotations.NotNull java.lang.String mariaDbMajorVersion) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MariaDbEngineVersion.class), new Object[] { java.util.Objects.requireNonNull(mariaDbFullVersion, "mariaDbFullVersion is required"), java.util.Objects.requireNonNull(mariaDbMajorVersion, "mariaDbMajorVersion is required") });
    }

    /**
     * (deprecated) Version "10.0" (only a major version, without a specific minor version).
     * <p>
     * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_0;

    /**
     * (deprecated) Version "10.0.17".
     * <p>
     * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_0_17;

    /**
     * (deprecated) Version "10.0.24".
     * <p>
     * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_0_24;

    /**
     * (deprecated) Version "10.0.28".
     * <p>
     * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_0_28;

    /**
     * (deprecated) Version "10.0.31".
     * <p>
     * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_0_31;

    /**
     * (deprecated) Version "10.0.32".
     * <p>
     * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_0_32;

    /**
     * (deprecated) Version "10.0.34".
     * <p>
     * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_0_34;

    /**
     * (deprecated) Version "10.0.35".
     * <p>
     * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_0_35;

    /**
     * (deprecated) Version "10.1" (only a major version, without a specific minor version).
     * <p>
     * @deprecated MariaDB 10.1 will reach end of life on May 18, 2021
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_1;

    /**
     * (deprecated) Version "10.1.14".
     * <p>
     * @deprecated MariaDB 10.1 will reach end of life on May 18, 2021
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_1_14;

    /**
     * (deprecated) Version "10.1.19".
     * <p>
     * @deprecated MariaDB 10.1 will reach end of life on May 18, 2021
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_1_19;

    /**
     * (deprecated) Version "10.1.23".
     * <p>
     * @deprecated MariaDB 10.1 will reach end of life on May 18, 2021
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_1_23;

    /**
     * (deprecated) Version "10.1.26".
     * <p>
     * @deprecated MariaDB 10.1 will reach end of life on May 18, 2021
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_1_26;

    /**
     * (deprecated) Version "10.1.31".
     * <p>
     * @deprecated MariaDB 10.1 will reach end of life on May 18, 2021
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_1_31;

    /**
     * (deprecated) Version "10.1.34".
     * <p>
     * @deprecated MariaDB 10.1 will reach end of life on May 18, 2021
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_1_34;

    /**
     * Version "10.2" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_2;

    /**
     * Version "10.2.11".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_2_11;

    /**
     * Version "10.2.12".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_2_12;

    /**
     * Version "10.2.15".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_2_15;

    /**
     * Version "10.2.21".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_2_21;

    /**
     * Version "10.2.32".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_2_32;

    /**
     * Version "10.2.37".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_2_37;

    /**
     * Version "10.2.39".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_2_39;

    /**
     * Version "10.2.40".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_2_40;

    /**
     * Version "10.2.41".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_2_41;

    /**
     * Version "10.3" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_3;

    /**
     * Version "10.3.13".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_3_13;

    /**
     * Version "10.3.20".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_3_20;

    /**
     * Version "10.3.23".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_3_23;

    /**
     * Version "10.3.28".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_3_28;

    /**
     * Version "10.3.31".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_3_31;

    /**
     * Version "10.3.32".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_3_32;

    /**
     * Version "10.3.8".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_3_8;

    /**
     * Version "10.4" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_4;

    /**
     * Version "10.4.13".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_4_13;

    /**
     * Version "10.4.18".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_4_18;

    /**
     * Version "10.4.21".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_4_21;

    /**
     * Version "10.4.22".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_4_22;

    /**
     * Version "10.4.8".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_4_8;

    /**
     * Version "10.5" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_5;

    /**
     * Version "10.5.12".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_5_12;

    /**
     * Version "10.5.13".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_5_13;

    /**
     * Version "10.5.8".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_5_8;

    /**
     * Version "10.5.9".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MariaDbEngineVersion VER_10_5_9;

    /**
     * The full version string, for example, "10.5.28".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMariaDbFullVersion() {
        return software.amazon.jsii.Kernel.get(this, "mariaDbFullVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The major version of the engine, for example, "10.5".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMariaDbMajorVersion() {
        return software.amazon.jsii.Kernel.get(this, "mariaDbMajorVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
