package software.amazon.awscdk.services.rds;

/**
 * Proxy target: Instance or Cluster.
 * <p>
 * A target group is a collection of databases that the proxy can connect to.
 * Currently, you can specify only one RDS DB instance or Aurora DB cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .engine(DatabaseClusterEngine.AURORA)
 *         .instanceProps(InstanceProps.builder().vpc(vpc).build())
 *         .build();
 * DatabaseProxy proxy = DatabaseProxy.Builder.create(this, "Proxy")
 *         .proxyTarget(ProxyTarget.fromCluster(cluster))
 *         .secrets(List.of(cluster.getSecret()))
 *         .vpc(vpc)
 *         .build();
 * Role role = Role.Builder.create(this, "DBProxyRole").assumedBy(new AccountPrincipal(this.account)).build();
 * proxy.grantConnect(role, "admin");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:48.913Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.rds.$Module.class, fqn = "@aws-cdk/aws-rds.ProxyTarget")
public class ProxyTarget extends software.amazon.jsii.JsiiObject {

    protected ProxyTarget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ProxyTarget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * From cluster.
     * <p>
     * @param cluster RDS database cluster. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.ProxyTarget fromCluster(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IDatabaseCluster cluster) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.ProxyTarget.class, "fromCluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.ProxyTarget.class), new Object[] { java.util.Objects.requireNonNull(cluster, "cluster is required") });
    }

    /**
     * From instance.
     * <p>
     * @param instance RDS database instance. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.ProxyTarget fromInstance(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IDatabaseInstance instance) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.ProxyTarget.class, "fromInstance", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.ProxyTarget.class), new Object[] { java.util.Objects.requireNonNull(instance, "instance is required") });
    }

    /**
     * Bind this target to the specified database proxy.
     * <p>
     * @param proxy This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.ProxyTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.DatabaseProxy proxy) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.ProxyTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(proxy, "proxy is required") });
    }
}
