package software.amazon.awscdk.services.rds;

/**
 * Options for creating Credentials from a username.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-11T13:46:51.509Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.rds.$Module.class, fqn = "@aws-cdk/aws-rds.CredentialsFromUsernameOptions")
@software.amazon.jsii.Jsii.Proxy(CredentialsFromUsernameOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CredentialsFromUsernameOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.rds.CredentialsBaseOptions {

    /**
     * Password.
     * <p>
     * Do not put passwords in your CDK code directly.
     * <p>
     * Default: - a Secrets Manager generated password
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.SecretValue getPassword() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CredentialsFromUsernameOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CredentialsFromUsernameOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CredentialsFromUsernameOptions> {
        private software.amazon.awscdk.core.SecretValue password;
        private software.amazon.awscdk.services.kms.IKey encryptionKey;
        private java.lang.String excludeCharacters;

        /**
         * Sets the value of {@link CredentialsFromUsernameOptions#getPassword}
         * @param password Password.
         *                 Do not put passwords in your CDK code directly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder password(software.amazon.awscdk.core.SecretValue password) {
            this.password = password;
            return this;
        }

        /**
         * Sets the value of {@link CredentialsFromUsernameOptions#getEncryptionKey}
         * @param encryptionKey KMS encryption key to encrypt the generated secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link CredentialsFromUsernameOptions#getExcludeCharacters}
         * @param excludeCharacters The characters to exclude from the generated password.
         *                          Has no effect if {&#64;link password} has been provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeCharacters(java.lang.String excludeCharacters) {
            this.excludeCharacters = excludeCharacters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CredentialsFromUsernameOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CredentialsFromUsernameOptions build() {
            return new Jsii$Proxy(password, encryptionKey, excludeCharacters);
        }
    }

    /**
     * An implementation for {@link CredentialsFromUsernameOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CredentialsFromUsernameOptions {
        private final software.amazon.awscdk.core.SecretValue password;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.lang.String excludeCharacters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.SecretValue.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.excludeCharacters = software.amazon.jsii.Kernel.get(this, "excludeCharacters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.core.SecretValue password, final software.amazon.awscdk.services.kms.IKey encryptionKey, final java.lang.String excludeCharacters) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.password = password;
            this.encryptionKey = encryptionKey;
            this.excludeCharacters = excludeCharacters;
        }

        @Override
        public final software.amazon.awscdk.core.SecretValue getPassword() {
            return this.password;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.lang.String getExcludeCharacters() {
            return this.excludeCharacters;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPassword() != null) {
                data.set("password", om.valueToTree(this.getPassword()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getExcludeCharacters() != null) {
                data.set("excludeCharacters", om.valueToTree(this.getExcludeCharacters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-rds.CredentialsFromUsernameOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CredentialsFromUsernameOptions.Jsii$Proxy that = (CredentialsFromUsernameOptions.Jsii$Proxy) o;

            if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            return this.excludeCharacters != null ? this.excludeCharacters.equals(that.excludeCharacters) : that.excludeCharacters == null;
        }

        @Override
        public final int hashCode() {
            int result = this.password != null ? this.password.hashCode() : 0;
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.excludeCharacters != null ? this.excludeCharacters.hashCode() : 0);
            return result;
        }
    }
}
