package software.amazon.awscdk.services.rds;

/**
 * Options used in the {@link SnapshotCredentials.fromGeneratedPassword} method.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-11T13:46:51.610Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.rds.$Module.class, fqn = "@aws-cdk/aws-rds.SnapshotCredentialsFromGeneratedPasswordOptions")
@software.amazon.jsii.Jsii.Proxy(SnapshotCredentialsFromGeneratedPasswordOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SnapshotCredentialsFromGeneratedPasswordOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * KMS encryption key to encrypt the generated secret.
     * <p>
     * Default: - default master key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * The characters to exclude from the generated password.
     * <p>
     * Default: - the DatabaseSecret default exclude character set (" %+~`#$&*()|[]{}:;<>?!'/
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExcludeCharacters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SnapshotCredentialsFromGeneratedPasswordOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SnapshotCredentialsFromGeneratedPasswordOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SnapshotCredentialsFromGeneratedPasswordOptions> {
        private software.amazon.awscdk.services.kms.IKey encryptionKey;
        private java.lang.String excludeCharacters;

        /**
         * Sets the value of {@link SnapshotCredentialsFromGeneratedPasswordOptions#getEncryptionKey}
         * @param encryptionKey KMS encryption key to encrypt the generated secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link SnapshotCredentialsFromGeneratedPasswordOptions#getExcludeCharacters}
         * @param excludeCharacters The characters to exclude from the generated password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeCharacters(java.lang.String excludeCharacters) {
            this.excludeCharacters = excludeCharacters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SnapshotCredentialsFromGeneratedPasswordOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SnapshotCredentialsFromGeneratedPasswordOptions build() {
            return new Jsii$Proxy(encryptionKey, excludeCharacters);
        }
    }

    /**
     * An implementation for {@link SnapshotCredentialsFromGeneratedPasswordOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnapshotCredentialsFromGeneratedPasswordOptions {
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.lang.String excludeCharacters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.excludeCharacters = software.amazon.jsii.Kernel.get(this, "excludeCharacters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.kms.IKey encryptionKey, final java.lang.String excludeCharacters) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.encryptionKey = encryptionKey;
            this.excludeCharacters = excludeCharacters;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.lang.String getExcludeCharacters() {
            return this.excludeCharacters;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getExcludeCharacters() != null) {
                data.set("excludeCharacters", om.valueToTree(this.getExcludeCharacters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-rds.SnapshotCredentialsFromGeneratedPasswordOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SnapshotCredentialsFromGeneratedPasswordOptions.Jsii$Proxy that = (SnapshotCredentialsFromGeneratedPasswordOptions.Jsii$Proxy) o;

            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            return this.excludeCharacters != null ? this.excludeCharacters.equals(that.excludeCharacters) : that.excludeCharacters == null;
        }

        @Override
        public final int hashCode() {
            int result = this.encryptionKey != null ? this.encryptionKey.hashCode() : 0;
            result = 31 * result + (this.excludeCharacters != null ? this.excludeCharacters.hashCode() : 0);
            return result;
        }
    }
}
