package software.amazon.awscdk.services.redshift.alpha;

/**
 * (experimental) A full specification of a Redshift table that can be used to import it fluently into the CDK application.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * String databaseName = "databaseName";
 * String username = "myuser";
 * String tableName = "mytable";
 * IUser user = User.fromUserAttributes(this, "User", UserAttributes.builder()
 *         .username(username)
 *         .password(SecretValue.unsafePlainText("NOT_FOR_PRODUCTION"))
 *         .cluster(cluster)
 *         .databaseName(databaseName)
 *         .build());
 * ITable table = Table.fromTableAttributes(this, "Table", TableAttributes.builder()
 *         .tableName(tableName)
 *         .tableColumns(List.of(Column.builder().name("col1").dataType("varchar(4)").build(), Column.builder().name("col2").dataType("float").build()))
 *         .cluster(cluster)
 *         .databaseName("databaseName")
 *         .build());
 * table.grant(user, TableAction.INSERT);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:34.422Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.redshift.alpha.$Module.class, fqn = "@aws-cdk/aws-redshift-alpha.TableAttributes")
@software.amazon.jsii.Jsii.Proxy(TableAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface TableAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The cluster where the table is located.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.redshift.alpha.ICluster getCluster();

    /**
     * (experimental) The name of the database where the table is located.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

    /**
     * (experimental) The columns of the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.redshift.alpha.Column> getTableColumns();

    /**
     * (experimental) Name of the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getTableName();

    /**
     * @return a {@link Builder} of {@link TableAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TableAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<TableAttributes> {
        software.amazon.awscdk.services.redshift.alpha.ICluster cluster;
        java.lang.String databaseName;
        java.util.List<software.amazon.awscdk.services.redshift.alpha.Column> tableColumns;
        java.lang.String tableName;

        /**
         * Sets the value of {@link TableAttributes#getCluster}
         * @param cluster The cluster where the table is located. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cluster(software.amazon.awscdk.services.redshift.alpha.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link TableAttributes#getDatabaseName}
         * @param databaseName The name of the database where the table is located. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder databaseName(java.lang.String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        /**
         * Sets the value of {@link TableAttributes#getTableColumns}
         * @param tableColumns The columns of the table. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder tableColumns(java.util.List<? extends software.amazon.awscdk.services.redshift.alpha.Column> tableColumns) {
            this.tableColumns = (java.util.List<software.amazon.awscdk.services.redshift.alpha.Column>)tableColumns;
            return this;
        }

        /**
         * Sets the value of {@link TableAttributes#getTableName}
         * @param tableName Name of the table. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TableAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public TableAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TableAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableAttributes {
        private final software.amazon.awscdk.services.redshift.alpha.ICluster cluster;
        private final java.lang.String databaseName;
        private final java.util.List<software.amazon.awscdk.services.redshift.alpha.Column> tableColumns;
        private final java.lang.String tableName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.redshift.alpha.ICluster.class));
            this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tableColumns = software.amazon.jsii.Kernel.get(this, "tableColumns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.redshift.alpha.Column.class)));
            this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cluster = java.util.Objects.requireNonNull(builder.cluster, "cluster is required");
            this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
            this.tableColumns = (java.util.List<software.amazon.awscdk.services.redshift.alpha.Column>)java.util.Objects.requireNonNull(builder.tableColumns, "tableColumns is required");
            this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
        }

        @Override
        public final software.amazon.awscdk.services.redshift.alpha.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final java.lang.String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.redshift.alpha.Column> getTableColumns() {
            return this.tableColumns;
        }

        @Override
        public final java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cluster", om.valueToTree(this.getCluster()));
            data.set("databaseName", om.valueToTree(this.getDatabaseName()));
            data.set("tableColumns", om.valueToTree(this.getTableColumns()));
            data.set("tableName", om.valueToTree(this.getTableName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-redshift-alpha.TableAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TableAttributes.Jsii$Proxy that = (TableAttributes.Jsii$Proxy) o;

            if (!cluster.equals(that.cluster)) return false;
            if (!databaseName.equals(that.databaseName)) return false;
            if (!tableColumns.equals(that.tableColumns)) return false;
            return this.tableName.equals(that.tableName);
        }

        @Override
        public final int hashCode() {
            int result = this.cluster.hashCode();
            result = 31 * result + (this.databaseName.hashCode());
            result = 31 * result + (this.tableColumns.hashCode());
            result = 31 * result + (this.tableName.hashCode());
            return result;
        }
    }
}
