package software.amazon.awscdk.services.redshift.alpha;

/**
 * (experimental) The compression encoding of a column.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.redshift.alpha.ColumnEncoding;
 * Table.Builder.create(this, "Table")
 *         .tableColumns(List.of(Column.builder().name("col1").dataType("varchar(4)").encoding(ColumnEncoding.TEXT32K).build(), Column.builder().name("col2").dataType("float").encoding(ColumnEncoding.DELTA32K).build()))
 *         .cluster(cluster)
 *         .databaseName("databaseName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/redshift/latest/dg/c_Compression_encodings.html">https://docs.aws.amazon.com/redshift/latest/dg/c_Compression_encodings.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-12T19:34:12.011Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.redshift.alpha.$Module.class, fqn = "@aws-cdk/aws-redshift-alpha.ColumnEncoding")
public enum ColumnEncoding {
    /**
     * (experimental) Amazon Redshift assigns an optimal encoding based on the column data.
     * <p>
     * This is the default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    AUTO,
    /**
     * (experimental) The column is not compressed.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/redshift/latest/dg/c_Raw_encoding.html">https://docs.aws.amazon.com/redshift/latest/dg/c_Raw_encoding.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    RAW,
    /**
     * (experimental) The column is compressed using the AZ64 algorithm.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/redshift/latest/dg/az64-encoding.html">https://docs.aws.amazon.com/redshift/latest/dg/az64-encoding.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    AZ64,
    /**
     * (experimental) The column is compressed using a separate dictionary for each block column value on disk.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/redshift/latest/dg/c_Byte_dictionary_encoding.html">https://docs.aws.amazon.com/redshift/latest/dg/c_Byte_dictionary_encoding.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    BYTEDICT,
    /**
     * (experimental) The column is compressed based on the difference between values in the column.
     * <p>
     * This records differences as 1-byte values.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/redshift/latest/dg/c_Delta_encoding.html">https://docs.aws.amazon.com/redshift/latest/dg/c_Delta_encoding.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DELTA,
    /**
     * (experimental) The column is compressed based on the difference between values in the column.
     * <p>
     * This records differences as 2-byte values.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/redshift/latest/dg/c_Delta_encoding.html">https://docs.aws.amazon.com/redshift/latest/dg/c_Delta_encoding.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DELTA32K,
    /**
     * (experimental) The column is compressed using the LZO algorithm.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/redshift/latest/dg/lzo-encoding.html">https://docs.aws.amazon.com/redshift/latest/dg/lzo-encoding.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    LZO,
    /**
     * (experimental) The column is compressed to a smaller storage size than the original data type.
     * <p>
     * The compressed storage size is 1 byte.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/redshift/latest/dg/c_MostlyN_encoding.html">https://docs.aws.amazon.com/redshift/latest/dg/c_MostlyN_encoding.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MOSTLY8,
    /**
     * (experimental) The column is compressed to a smaller storage size than the original data type.
     * <p>
     * The compressed storage size is 2 bytes.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/redshift/latest/dg/c_MostlyN_encoding.html">https://docs.aws.amazon.com/redshift/latest/dg/c_MostlyN_encoding.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MOSTLY16,
    /**
     * (experimental) The column is compressed to a smaller storage size than the original data type.
     * <p>
     * The compressed storage size is 4 bytes.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/redshift/latest/dg/c_MostlyN_encoding.html">https://docs.aws.amazon.com/redshift/latest/dg/c_MostlyN_encoding.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    MOSTLY32,
    /**
     * (experimental) The column is compressed by recording the number of occurrences of each value in the column.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/redshift/latest/dg/c_Runlength_encoding.html">https://docs.aws.amazon.com/redshift/latest/dg/c_Runlength_encoding.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    RUNLENGTH,
    /**
     * (experimental) The column is compressed by recording the first 245 unique words and then using a 1-byte index to represent each word.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/redshift/latest/dg/c_Text255_encoding.html">https://docs.aws.amazon.com/redshift/latest/dg/c_Text255_encoding.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TEXT255,
    /**
     * (experimental) The column is compressed by recording the first 32K unique words and then using a 2-byte index to represent each word.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/redshift/latest/dg/c_Text255_encoding.html">https://docs.aws.amazon.com/redshift/latest/dg/c_Text255_encoding.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TEXT32K,
    /**
     * (experimental) The column is compressed using the ZSTD algorithm.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/redshift/latest/dg/zstd-encoding.html">https://docs.aws.amazon.com/redshift/latest/dg/zstd-encoding.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ZSTD,
}
