package software.amazon.awscdk.services.redshift.alpha;

/**
 * (experimental) Logging bucket and S3 prefix combination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.s3.*;
 * Vpc vpc = new Vpc(this, "Vpc");
 * IBucket bucket = Bucket.fromBucketName(this, "bucket", "logging-bucket");
 * Cluster cluster = Cluster.Builder.create(this, "Redshift")
 *         .masterUser(Login.builder()
 *                 .masterUsername("admin")
 *                 .build())
 *         .vpc(vpc)
 *         .loggingProperties(LoggingProperties.builder()
 *                 .loggingBucket(bucket)
 *                 .loggingKeyPrefix("prefix")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-12T19:34:12.027Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.redshift.alpha.$Module.class, fqn = "@aws-cdk/aws-redshift-alpha.LoggingProperties")
@software.amazon.jsii.Jsii.Proxy(LoggingProperties.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface LoggingProperties extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Bucket to send logs to.
     * <p>
     * Logging information includes queries and connection attempts, for the specified Amazon Redshift cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getLoggingBucket();

    /**
     * (experimental) Prefix used for logging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getLoggingKeyPrefix();

    /**
     * @return a {@link Builder} of {@link LoggingProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LoggingProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<LoggingProperties> {
        software.amazon.awscdk.services.s3.IBucket loggingBucket;
        java.lang.String loggingKeyPrefix;

        /**
         * Sets the value of {@link LoggingProperties#getLoggingBucket}
         * @param loggingBucket Bucket to send logs to. This parameter is required.
         *                      Logging information includes queries and connection attempts, for the specified Amazon Redshift cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder loggingBucket(software.amazon.awscdk.services.s3.IBucket loggingBucket) {
            this.loggingBucket = loggingBucket;
            return this;
        }

        /**
         * Sets the value of {@link LoggingProperties#getLoggingKeyPrefix}
         * @param loggingKeyPrefix Prefix used for logging. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder loggingKeyPrefix(java.lang.String loggingKeyPrefix) {
            this.loggingKeyPrefix = loggingKeyPrefix;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LoggingProperties}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public LoggingProperties build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LoggingProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingProperties {
        private final software.amazon.awscdk.services.s3.IBucket loggingBucket;
        private final java.lang.String loggingKeyPrefix;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.loggingBucket = software.amazon.jsii.Kernel.get(this, "loggingBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.loggingKeyPrefix = software.amazon.jsii.Kernel.get(this, "loggingKeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.loggingBucket = java.util.Objects.requireNonNull(builder.loggingBucket, "loggingBucket is required");
            this.loggingKeyPrefix = java.util.Objects.requireNonNull(builder.loggingKeyPrefix, "loggingKeyPrefix is required");
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getLoggingBucket() {
            return this.loggingBucket;
        }

        @Override
        public final java.lang.String getLoggingKeyPrefix() {
            return this.loggingKeyPrefix;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("loggingBucket", om.valueToTree(this.getLoggingBucket()));
            data.set("loggingKeyPrefix", om.valueToTree(this.getLoggingKeyPrefix()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-redshift-alpha.LoggingProperties"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LoggingProperties.Jsii$Proxy that = (LoggingProperties.Jsii$Proxy) o;

            if (!loggingBucket.equals(that.loggingBucket)) return false;
            return this.loggingKeyPrefix.equals(that.loggingKeyPrefix);
        }

        @Override
        public final int hashCode() {
            int result = this.loggingBucket.hashCode();
            result = 31 * result + (this.loggingKeyPrefix.hashCode());
            return result;
        }
    }
}
