package software.amazon.awscdk.services.redshift.alpha;

/**
 * (experimental) An action that a Redshift user can be granted privilege to perform on a table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * String databaseName = "databaseName";
 * String username = "myuser";
 * String tableName = "mytable";
 * User user = User.Builder.create(this, "User")
 *         .username(username)
 *         .cluster(cluster)
 *         .databaseName(databaseName)
 *         .build();
 * Table table = Table.Builder.create(this, "Table")
 *         .tableColumns(List.of(Column.builder().name("col1").dataType("varchar(4)").build(), Column.builder().name("col2").dataType("float").build()))
 *         .cluster(cluster)
 *         .databaseName(databaseName)
 *         .build();
 * table.grant(user, TableAction.INSERT);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-12T19:34:12.029Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.redshift.alpha.$Module.class, fqn = "@aws-cdk/aws-redshift-alpha.TableAction")
public enum TableAction {
    /**
     * (experimental) Grants privilege to select data from a table or view using a SELECT statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SELECT,
    /**
     * (experimental) Grants privilege to load data into a table using an INSERT statement or a COPY statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    INSERT,
    /**
     * (experimental) Grants privilege to update a table column using an UPDATE statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    UPDATE,
    /**
     * (experimental) Grants privilege to delete a data row from a table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DELETE,
    /**
     * (experimental) Grants privilege to drop a table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DROP,
    /**
     * (experimental) Grants privilege to create a foreign key constraint.
     * <p>
     * You need to grant this privilege on both the referenced table and the referencing table; otherwise, the user can't create the constraint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    REFERENCES,
    /**
     * (experimental) Grants all available privileges at once to the specified user or user group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ALL,
}
