/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.redshift.alpha;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.redshift.alpha.;
import software.amazon.awscdk.services.redshift.alpha.ClusterAttributes;
import software.amazon.awscdk.services.redshift.alpha.ClusterProps;
import software.amazon.awscdk.services.redshift.alpha.ClusterType;
import software.amazon.awscdk.services.redshift.alpha.Endpoint;
import software.amazon.awscdk.services.redshift.alpha.ICluster;
import software.amazon.awscdk.services.redshift.alpha.IClusterParameterGroup;
import software.amazon.awscdk.services.redshift.alpha.IClusterSubnetGroup;
import software.amazon.awscdk.services.redshift.alpha.LoggingProperties;
import software.amazon.awscdk.services.redshift.alpha.Login;
import software.amazon.awscdk.services.redshift.alpha.NodeType;
import software.amazon.awscdk.services.redshift.alpha.RotationMultiUserOptions;
import software.amazon.awscdk.services.secretsmanager.ISecret;
import software.amazon.awscdk.services.secretsmanager.SecretAttachmentTargetProps;
import software.amazon.awscdk.services.secretsmanager.SecretRotation;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-redshift-alpha.Cluster")
public class Cluster
extends Resource
implements ICluster {
    protected Cluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Cluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Cluster(@NotNull Construct scope, @NotNull String id, @NotNull ClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static ICluster fromClusterAttributes(@NotNull Construct scope, @NotNull String id, @NotNull ClusterAttributes attrs) {
        return (ICluster)JsiiObject.jsiiStaticCall(Cluster.class, (String)"fromClusterAttributes", (NativeType)NativeType.forClass(ICluster.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    public void addDefaultIamRole(@NotNull IRole defaultIamRole) {
        Kernel.call((Object)this, (String)"addDefaultIamRole", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(defaultIamRole, "defaultIamRole is required")});
    }

    public void addIamRole(@NotNull IRole role) {
        Kernel.call((Object)this, (String)"addIamRole", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(role, "role is required")});
    }

    @NotNull
    public SecretRotation addRotationMultiUser(@NotNull String id, @NotNull RotationMultiUserOptions options) {
        return (SecretRotation)Kernel.call((Object)this, (String)"addRotationMultiUser", (NativeType)NativeType.forClass(SecretRotation.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public SecretRotation addRotationSingleUser(@Nullable Duration automaticallyAfter) {
        return (SecretRotation)Kernel.call((Object)this, (String)"addRotationSingleUser", (NativeType)NativeType.forClass(SecretRotation.class), (Object[])new Object[]{automaticallyAfter});
    }

    @NotNull
    public SecretRotation addRotationSingleUser() {
        return (SecretRotation)Kernel.call((Object)this, (String)"addRotationSingleUser", (NativeType)NativeType.forClass(SecretRotation.class), (Object[])new Object[0]);
    }

    public void addToParameterGroup(@NotNull String name, @NotNull String value) {
        Kernel.call((Object)this, (String)"addToParameterGroup", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(name, "name is required"), Objects.requireNonNull(value, "value is required")});
    }

    @NotNull
    public SecretAttachmentTargetProps asSecretAttachmentTarget() {
        return (SecretAttachmentTargetProps)Kernel.call((Object)this, (String)"asSecretAttachmentTarget", (NativeType)NativeType.forClass(SecretAttachmentTargetProps.class), (Object[])new Object[0]);
    }

    public void enableRebootForParameterChanges() {
        Kernel.call((Object)this, (String)"enableRebootForParameterChanges", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Endpoint getClusterEndpoint() {
        return (Endpoint)((Object)Kernel.get((Object)this, (String)"clusterEndpoint", (NativeType)NativeType.forClass(Endpoint.class)));
    }

    @Override
    @NotNull
    public String getClusterName() {
        return (String)Kernel.get((Object)this, (String)"clusterName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @Nullable
    public ISecret getSecret() {
        return (ISecret)Kernel.get((Object)this, (String)"secret", (NativeType)NativeType.forClass(ISecret.class));
    }

    @Nullable
    protected IClusterParameterGroup getParameterGroup() {
        return (IClusterParameterGroup)Kernel.get((Object)this, (String)"parameterGroup", (NativeType)NativeType.forClass(IClusterParameterGroup.class));
    }

    protected void setParameterGroup(@Nullable IClusterParameterGroup value) {
        Kernel.set((Object)this, (String)"parameterGroup", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Cluster> {
        private final Construct scope;
        private final String id;
        private final ClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ClusterProps.Builder();
        }

        public Builder masterUser(Login masterUser) {
            this.props.masterUser(masterUser);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder classicResizing(Boolean classicResizing) {
            this.props.classicResizing(classicResizing);
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.props.clusterName(clusterName);
            return this;
        }

        public Builder clusterType(ClusterType clusterType) {
            this.props.clusterType(clusterType);
            return this;
        }

        public Builder defaultDatabaseName(String defaultDatabaseName) {
            this.props.defaultDatabaseName(defaultDatabaseName);
            return this;
        }

        public Builder defaultRole(IRole defaultRole) {
            this.props.defaultRole(defaultRole);
            return this;
        }

        public Builder elasticIp(String elasticIp) {
            this.props.elasticIp(elasticIp);
            return this;
        }

        public Builder encrypted(Boolean encrypted) {
            this.props.encrypted(encrypted);
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.props.encryptionKey(encryptionKey);
            return this;
        }

        public Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.props.enhancedVpcRouting(enhancedVpcRouting);
            return this;
        }

        public Builder loggingProperties(LoggingProperties loggingProperties) {
            this.props.loggingProperties(loggingProperties);
            return this;
        }

        public Builder multiAz(Boolean multiAz) {
            this.props.multiAz(multiAz);
            return this;
        }

        public Builder nodeType(NodeType nodeType) {
            this.props.nodeType(nodeType);
            return this;
        }

        public Builder numberOfNodes(Number numberOfNodes) {
            this.props.numberOfNodes(numberOfNodes);
            return this;
        }

        public Builder parameterGroup(IClusterParameterGroup parameterGroup) {
            this.props.parameterGroup(parameterGroup);
            return this;
        }

        public Builder port(Number port) {
            this.props.port(port);
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        public Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.props.publiclyAccessible(publiclyAccessible);
            return this;
        }

        public Builder rebootForParameterChanges(Boolean rebootForParameterChanges) {
            this.props.rebootForParameterChanges(rebootForParameterChanges);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder roles(List<? extends IRole> roles) {
            this.props.roles(roles);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder subnetGroup(IClusterSubnetGroup subnetGroup) {
            this.props.subnetGroup(subnetGroup);
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public Cluster build() {
            return new Cluster(this.scope, this.id, this.props.build());
        }
    }
}

