package software.amazon.awscdk.services.redshift.alpha;

/**
 * (experimental) Properties for a new database cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.*;
 * Vpc vpc;
 * Cluster cluster = Cluster.Builder.create(this, "Cluster")
 *         .masterUser(Login.builder()
 *                 .masterUsername("admin")
 *                 .masterPassword(SecretValue.unsafePlainText("tooshort"))
 *                 .build())
 *         .vpc(vpc)
 *         .build();
 * cluster.addToParameterGroup("enable_user_activity_logging", "true");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-22T22:43:00.341Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.redshift.alpha.$Module.class, fqn = "@aws-cdk/aws-redshift-alpha.ClusterProps")
@software.amazon.jsii.Jsii.Proxy(ClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Username and password for the administrative user.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.redshift.alpha.Login getMasterUser();

    /**
     * (experimental) The VPC to place the cluster in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * (experimental) If this flag is set, the cluster resizing type will be set to classic.
     * <p>
     * When resizing a cluster, classic resizing will always provision a new cluster and transfer the data there.
     * <p>
     * Classic resize takes more time to complete, but it can be useful in cases where the change in node count or
     * the node type to migrate to doesn't fall within the bounds for elastic resize.
     * <p>
     * Default: - Elastic resize type
     * <p>
     * @see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/managing-cluster-operations.html#elastic-resize">https://docs.aws.amazon.com/redshift/latest/mgmt/managing-cluster-operations.html#elastic-resize</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getClassicResizing() {
        return null;
    }

    /**
     * (experimental) An optional identifier for the cluster.
     * <p>
     * Default: - A name is automatically generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterName() {
        return null;
    }

    /**
     * (experimental) Settings for the individual instances that are launched.
     * <p>
     * Default: `ClusterType.MULTI_NODE`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.redshift.alpha.ClusterType getClusterType() {
        return null;
    }

    /**
     * (experimental) Name of a database which is automatically created inside the cluster.
     * <p>
     * Default: - default_db
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultDatabaseName() {
        return null;
    }

    /**
     * (experimental) A single AWS Identity and Access Management (IAM) role to be used as the default role for the cluster.
     * <p>
     * The default role must be included in the roles list.
     * <p>
     * Default: - No default role is specified for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getDefaultRole() {
        return null;
    }

    /**
     * (experimental) The Elastic IP (EIP) address for the cluster.
     * <p>
     * Default: - No Elastic IP
     * <p>
     * @see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/managing-clusters-vpc.html">https://docs.aws.amazon.com/redshift/latest/mgmt/managing-clusters-vpc.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getElasticIp() {
        return null;
    }

    /**
     * (experimental) Whether to enable encryption of data at rest in the cluster.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEncrypted() {
        return null;
    }

    /**
     * (experimental) The KMS key to use for encryption of data at rest.
     * <p>
     * Default: - AWS-managed key, if encryption at rest is enabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * (experimental) If this flag is set, Amazon Redshift forces all COPY and UNLOAD traffic between your cluster and your data repositories through your virtual private cloud (VPC).
     * <p>
     * Default: - false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnhancedVpcRouting() {
        return null;
    }

    /**
     * (experimental) Bucket details for log files to be sent to, including prefix.
     * <p>
     * Default: - No logging bucket is used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.redshift.alpha.LoggingProperties getLoggingProperties() {
        return null;
    }

    /**
     * (experimental) Indicating whether Amazon Redshift should deploy the cluster in two Availability Zones.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMultiAz() {
        return null;
    }

    /**
     * (experimental) The node type to be provisioned for the cluster.
     * <p>
     * Default: `NodeType.DC2_LARGE`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.redshift.alpha.NodeType getNodeType() {
        return null;
    }

    /**
     * (experimental) Number of compute nodes in the cluster. Only specify this property for multi-node clusters.
     * <p>
     * Value must be at least 2 and no more than 100.
     * <p>
     * Default: - 2 if `clusterType` is ClusterType.MULTI_NODE, undefined otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfNodes() {
        return null;
    }

    /**
     * (experimental) Additional parameters to pass to the database engine https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html.
     * <p>
     * Default: - No parameter group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.redshift.alpha.IClusterParameterGroup getParameterGroup() {
        return null;
    }

    /**
     * (experimental) What port to listen on.
     * <p>
     * Default: - The default for the engine is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * (experimental) A preferred maintenance window day/time range. Should be specified as a range ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC).
     * <p>
     * Example: 'Sun:23:45-Mon:00:15'
     * <p>
     * Default: - 30-minute window selected at random from an 8-hour block of time for
     * each AWS Region, occurring on a random day of the week.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return null;
    }

    /**
     * (experimental) Whether to make cluster publicly accessible.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPubliclyAccessible() {
        return null;
    }

    /**
     * (experimental) If this flag is set, the cluster will be rebooted when changes to the cluster's parameter group that require a restart to apply.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRebootForParameterChanges() {
        return null;
    }

    /**
     * (experimental) The removal policy to apply when the cluster and its instances are removed from the stack or replaced during an update.
     * <p>
     * Default: RemovalPolicy.RETAIN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * (experimental) A list of AWS Identity and Access Management (IAM) role that can be used by the cluster to access other AWS services.
     * <p>
     * The maximum number of roles to attach to a cluster is subject to a quota.
     * <p>
     * Default: - No role is attached to the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.IRole> getRoles() {
        return null;
    }

    /**
     * (experimental) Security group.
     * <p>
     * Default: - a new security group is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * (experimental) A cluster subnet group to use with this cluster.
     * <p>
     * Default: - a new subnet group will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.redshift.alpha.IClusterSubnetGroup getSubnetGroup() {
        return null;
    }

    /**
     * (experimental) Where to place the instances within the VPC.
     * <p>
     * Default: - private subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ClusterProps> {
        software.amazon.awscdk.services.redshift.alpha.Login masterUser;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        java.lang.Boolean classicResizing;
        java.lang.String clusterName;
        software.amazon.awscdk.services.redshift.alpha.ClusterType clusterType;
        java.lang.String defaultDatabaseName;
        software.amazon.awscdk.services.iam.IRole defaultRole;
        java.lang.String elasticIp;
        java.lang.Boolean encrypted;
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        java.lang.Boolean enhancedVpcRouting;
        software.amazon.awscdk.services.redshift.alpha.LoggingProperties loggingProperties;
        java.lang.Boolean multiAz;
        software.amazon.awscdk.services.redshift.alpha.NodeType nodeType;
        java.lang.Number numberOfNodes;
        software.amazon.awscdk.services.redshift.alpha.IClusterParameterGroup parameterGroup;
        java.lang.Number port;
        java.lang.String preferredMaintenanceWindow;
        java.lang.Boolean publiclyAccessible;
        java.lang.Boolean rebootForParameterChanges;
        software.amazon.awscdk.RemovalPolicy removalPolicy;
        java.util.List<software.amazon.awscdk.services.iam.IRole> roles;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        software.amazon.awscdk.services.redshift.alpha.IClusterSubnetGroup subnetGroup;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link ClusterProps#getMasterUser}
         * @param masterUser Username and password for the administrative user. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder masterUser(software.amazon.awscdk.services.redshift.alpha.Login masterUser) {
            this.masterUser = masterUser;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getVpc}
         * @param vpc The VPC to place the cluster in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getClassicResizing}
         * @param classicResizing If this flag is set, the cluster resizing type will be set to classic.
         *                        When resizing a cluster, classic resizing will always provision a new cluster and transfer the data there.
         *                        <p>
         *                        Classic resize takes more time to complete, but it can be useful in cases where the change in node count or
         *                        the node type to migrate to doesn't fall within the bounds for elastic resize.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder classicResizing(java.lang.Boolean classicResizing) {
            this.classicResizing = classicResizing;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getClusterName}
         * @param clusterName An optional identifier for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getClusterType}
         * @param clusterType Settings for the individual instances that are launched.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterType(software.amazon.awscdk.services.redshift.alpha.ClusterType clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getDefaultDatabaseName}
         * @param defaultDatabaseName Name of a database which is automatically created inside the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaultDatabaseName(java.lang.String defaultDatabaseName) {
            this.defaultDatabaseName = defaultDatabaseName;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getDefaultRole}
         * @param defaultRole A single AWS Identity and Access Management (IAM) role to be used as the default role for the cluster.
         *                    The default role must be included in the roles list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaultRole(software.amazon.awscdk.services.iam.IRole defaultRole) {
            this.defaultRole = defaultRole;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getElasticIp}
         * @param elasticIp The Elastic IP (EIP) address for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder elasticIp(java.lang.String elasticIp) {
            this.elasticIp = elasticIp;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getEncrypted}
         * @param encrypted Whether to enable encryption of data at rest in the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encrypted(java.lang.Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getEncryptionKey}
         * @param encryptionKey The KMS key to use for encryption of data at rest.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getEnhancedVpcRouting}
         * @param enhancedVpcRouting If this flag is set, Amazon Redshift forces all COPY and UNLOAD traffic between your cluster and your data repositories through your virtual private cloud (VPC).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enhancedVpcRouting(java.lang.Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getLoggingProperties}
         * @param loggingProperties Bucket details for log files to be sent to, including prefix.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder loggingProperties(software.amazon.awscdk.services.redshift.alpha.LoggingProperties loggingProperties) {
            this.loggingProperties = loggingProperties;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getMultiAz}
         * @param multiAz Indicating whether Amazon Redshift should deploy the cluster in two Availability Zones.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder multiAz(java.lang.Boolean multiAz) {
            this.multiAz = multiAz;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getNodeType}
         * @param nodeType The node type to be provisioned for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder nodeType(software.amazon.awscdk.services.redshift.alpha.NodeType nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getNumberOfNodes}
         * @param numberOfNodes Number of compute nodes in the cluster. Only specify this property for multi-node clusters.
         *                      Value must be at least 2 and no more than 100.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder numberOfNodes(java.lang.Number numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getParameterGroup}
         * @param parameterGroup Additional parameters to pass to the database engine https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameterGroup(software.amazon.awscdk.services.redshift.alpha.IClusterParameterGroup parameterGroup) {
            this.parameterGroup = parameterGroup;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getPort}
         * @param port What port to listen on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getPreferredMaintenanceWindow}
         * @param preferredMaintenanceWindow A preferred maintenance window day/time range. Should be specified as a range ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC).
         *                                   Example: 'Sun:23:45-Mon:00:15'
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder preferredMaintenanceWindow(java.lang.String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getPubliclyAccessible}
         * @param publiclyAccessible Whether to make cluster publicly accessible.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder publiclyAccessible(java.lang.Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getRebootForParameterChanges}
         * @param rebootForParameterChanges If this flag is set, the cluster will be rebooted when changes to the cluster's parameter group that require a restart to apply.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder rebootForParameterChanges(java.lang.Boolean rebootForParameterChanges) {
            this.rebootForParameterChanges = rebootForParameterChanges;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getRemovalPolicy}
         * @param removalPolicy The removal policy to apply when the cluster and its instances are removed from the stack or replaced during an update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getRoles}
         * @param roles A list of AWS Identity and Access Management (IAM) role that can be used by the cluster to access other AWS services.
         *              The maximum number of roles to attach to a cluster is subject to a quota.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder roles(java.util.List<? extends software.amazon.awscdk.services.iam.IRole> roles) {
            this.roles = (java.util.List<software.amazon.awscdk.services.iam.IRole>)roles;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getSecurityGroups}
         * @param securityGroups Security group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getSubnetGroup}
         * @param subnetGroup A cluster subnet group to use with this cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnetGroup(software.amazon.awscdk.services.redshift.alpha.IClusterSubnetGroup subnetGroup) {
            this.subnetGroup = subnetGroup;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getVpcSubnets}
         * @param vpcSubnets Where to place the instances within the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterProps {
        private final software.amazon.awscdk.services.redshift.alpha.Login masterUser;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.Boolean classicResizing;
        private final java.lang.String clusterName;
        private final software.amazon.awscdk.services.redshift.alpha.ClusterType clusterType;
        private final java.lang.String defaultDatabaseName;
        private final software.amazon.awscdk.services.iam.IRole defaultRole;
        private final java.lang.String elasticIp;
        private final java.lang.Boolean encrypted;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.lang.Boolean enhancedVpcRouting;
        private final software.amazon.awscdk.services.redshift.alpha.LoggingProperties loggingProperties;
        private final java.lang.Boolean multiAz;
        private final software.amazon.awscdk.services.redshift.alpha.NodeType nodeType;
        private final java.lang.Number numberOfNodes;
        private final software.amazon.awscdk.services.redshift.alpha.IClusterParameterGroup parameterGroup;
        private final java.lang.Number port;
        private final java.lang.String preferredMaintenanceWindow;
        private final java.lang.Boolean publiclyAccessible;
        private final java.lang.Boolean rebootForParameterChanges;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;
        private final java.util.List<software.amazon.awscdk.services.iam.IRole> roles;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.services.redshift.alpha.IClusterSubnetGroup subnetGroup;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.masterUser = software.amazon.jsii.Kernel.get(this, "masterUser", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.redshift.alpha.Login.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.classicResizing = software.amazon.jsii.Kernel.get(this, "classicResizing", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterType = software.amazon.jsii.Kernel.get(this, "clusterType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.redshift.alpha.ClusterType.class));
            this.defaultDatabaseName = software.amazon.jsii.Kernel.get(this, "defaultDatabaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultRole = software.amazon.jsii.Kernel.get(this, "defaultRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.elasticIp = software.amazon.jsii.Kernel.get(this, "elasticIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encrypted = software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.enhancedVpcRouting = software.amazon.jsii.Kernel.get(this, "enhancedVpcRouting", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.loggingProperties = software.amazon.jsii.Kernel.get(this, "loggingProperties", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.redshift.alpha.LoggingProperties.class));
            this.multiAz = software.amazon.jsii.Kernel.get(this, "multiAz", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.nodeType = software.amazon.jsii.Kernel.get(this, "nodeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.redshift.alpha.NodeType.class));
            this.numberOfNodes = software.amazon.jsii.Kernel.get(this, "numberOfNodes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.parameterGroup = software.amazon.jsii.Kernel.get(this, "parameterGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.redshift.alpha.IClusterParameterGroup.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.preferredMaintenanceWindow = software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publiclyAccessible = software.amazon.jsii.Kernel.get(this, "publiclyAccessible", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.rebootForParameterChanges = software.amazon.jsii.Kernel.get(this, "rebootForParameterChanges", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.roles = software.amazon.jsii.Kernel.get(this, "roles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class)));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.subnetGroup = software.amazon.jsii.Kernel.get(this, "subnetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.redshift.alpha.IClusterSubnetGroup.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.masterUser = java.util.Objects.requireNonNull(builder.masterUser, "masterUser is required");
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
            this.classicResizing = builder.classicResizing;
            this.clusterName = builder.clusterName;
            this.clusterType = builder.clusterType;
            this.defaultDatabaseName = builder.defaultDatabaseName;
            this.defaultRole = builder.defaultRole;
            this.elasticIp = builder.elasticIp;
            this.encrypted = builder.encrypted;
            this.encryptionKey = builder.encryptionKey;
            this.enhancedVpcRouting = builder.enhancedVpcRouting;
            this.loggingProperties = builder.loggingProperties;
            this.multiAz = builder.multiAz;
            this.nodeType = builder.nodeType;
            this.numberOfNodes = builder.numberOfNodes;
            this.parameterGroup = builder.parameterGroup;
            this.port = builder.port;
            this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
            this.publiclyAccessible = builder.publiclyAccessible;
            this.rebootForParameterChanges = builder.rebootForParameterChanges;
            this.removalPolicy = builder.removalPolicy;
            this.roles = (java.util.List<software.amazon.awscdk.services.iam.IRole>)builder.roles;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.subnetGroup = builder.subnetGroup;
            this.vpcSubnets = builder.vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.services.redshift.alpha.Login getMasterUser() {
            return this.masterUser;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final java.lang.Boolean getClassicResizing() {
            return this.classicResizing;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final software.amazon.awscdk.services.redshift.alpha.ClusterType getClusterType() {
            return this.clusterType;
        }

        @Override
        public final java.lang.String getDefaultDatabaseName() {
            return this.defaultDatabaseName;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getDefaultRole() {
            return this.defaultRole;
        }

        @Override
        public final java.lang.String getElasticIp() {
            return this.elasticIp;
        }

        @Override
        public final java.lang.Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.lang.Boolean getEnhancedVpcRouting() {
            return this.enhancedVpcRouting;
        }

        @Override
        public final software.amazon.awscdk.services.redshift.alpha.LoggingProperties getLoggingProperties() {
            return this.loggingProperties;
        }

        @Override
        public final java.lang.Boolean getMultiAz() {
            return this.multiAz;
        }

        @Override
        public final software.amazon.awscdk.services.redshift.alpha.NodeType getNodeType() {
            return this.nodeType;
        }

        @Override
        public final java.lang.Number getNumberOfNodes() {
            return this.numberOfNodes;
        }

        @Override
        public final software.amazon.awscdk.services.redshift.alpha.IClusterParameterGroup getParameterGroup() {
            return this.parameterGroup;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final java.lang.Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final java.lang.Boolean getRebootForParameterChanges() {
            return this.rebootForParameterChanges;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.IRole> getRoles() {
            return this.roles;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.services.redshift.alpha.IClusterSubnetGroup getSubnetGroup() {
            return this.subnetGroup;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("masterUser", om.valueToTree(this.getMasterUser()));
            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getClassicResizing() != null) {
                data.set("classicResizing", om.valueToTree(this.getClassicResizing()));
            }
            if (this.getClusterName() != null) {
                data.set("clusterName", om.valueToTree(this.getClusterName()));
            }
            if (this.getClusterType() != null) {
                data.set("clusterType", om.valueToTree(this.getClusterType()));
            }
            if (this.getDefaultDatabaseName() != null) {
                data.set("defaultDatabaseName", om.valueToTree(this.getDefaultDatabaseName()));
            }
            if (this.getDefaultRole() != null) {
                data.set("defaultRole", om.valueToTree(this.getDefaultRole()));
            }
            if (this.getElasticIp() != null) {
                data.set("elasticIp", om.valueToTree(this.getElasticIp()));
            }
            if (this.getEncrypted() != null) {
                data.set("encrypted", om.valueToTree(this.getEncrypted()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getEnhancedVpcRouting() != null) {
                data.set("enhancedVpcRouting", om.valueToTree(this.getEnhancedVpcRouting()));
            }
            if (this.getLoggingProperties() != null) {
                data.set("loggingProperties", om.valueToTree(this.getLoggingProperties()));
            }
            if (this.getMultiAz() != null) {
                data.set("multiAz", om.valueToTree(this.getMultiAz()));
            }
            if (this.getNodeType() != null) {
                data.set("nodeType", om.valueToTree(this.getNodeType()));
            }
            if (this.getNumberOfNodes() != null) {
                data.set("numberOfNodes", om.valueToTree(this.getNumberOfNodes()));
            }
            if (this.getParameterGroup() != null) {
                data.set("parameterGroup", om.valueToTree(this.getParameterGroup()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getPreferredMaintenanceWindow() != null) {
                data.set("preferredMaintenanceWindow", om.valueToTree(this.getPreferredMaintenanceWindow()));
            }
            if (this.getPubliclyAccessible() != null) {
                data.set("publiclyAccessible", om.valueToTree(this.getPubliclyAccessible()));
            }
            if (this.getRebootForParameterChanges() != null) {
                data.set("rebootForParameterChanges", om.valueToTree(this.getRebootForParameterChanges()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getRoles() != null) {
                data.set("roles", om.valueToTree(this.getRoles()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSubnetGroup() != null) {
                data.set("subnetGroup", om.valueToTree(this.getSubnetGroup()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-redshift-alpha.ClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ClusterProps.Jsii$Proxy that = (ClusterProps.Jsii$Proxy) o;

            if (!masterUser.equals(that.masterUser)) return false;
            if (!vpc.equals(that.vpc)) return false;
            if (this.classicResizing != null ? !this.classicResizing.equals(that.classicResizing) : that.classicResizing != null) return false;
            if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) return false;
            if (this.clusterType != null ? !this.clusterType.equals(that.clusterType) : that.clusterType != null) return false;
            if (this.defaultDatabaseName != null ? !this.defaultDatabaseName.equals(that.defaultDatabaseName) : that.defaultDatabaseName != null) return false;
            if (this.defaultRole != null ? !this.defaultRole.equals(that.defaultRole) : that.defaultRole != null) return false;
            if (this.elasticIp != null ? !this.elasticIp.equals(that.elasticIp) : that.elasticIp != null) return false;
            if (this.encrypted != null ? !this.encrypted.equals(that.encrypted) : that.encrypted != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.enhancedVpcRouting != null ? !this.enhancedVpcRouting.equals(that.enhancedVpcRouting) : that.enhancedVpcRouting != null) return false;
            if (this.loggingProperties != null ? !this.loggingProperties.equals(that.loggingProperties) : that.loggingProperties != null) return false;
            if (this.multiAz != null ? !this.multiAz.equals(that.multiAz) : that.multiAz != null) return false;
            if (this.nodeType != null ? !this.nodeType.equals(that.nodeType) : that.nodeType != null) return false;
            if (this.numberOfNodes != null ? !this.numberOfNodes.equals(that.numberOfNodes) : that.numberOfNodes != null) return false;
            if (this.parameterGroup != null ? !this.parameterGroup.equals(that.parameterGroup) : that.parameterGroup != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.preferredMaintenanceWindow != null ? !this.preferredMaintenanceWindow.equals(that.preferredMaintenanceWindow) : that.preferredMaintenanceWindow != null) return false;
            if (this.publiclyAccessible != null ? !this.publiclyAccessible.equals(that.publiclyAccessible) : that.publiclyAccessible != null) return false;
            if (this.rebootForParameterChanges != null ? !this.rebootForParameterChanges.equals(that.rebootForParameterChanges) : that.rebootForParameterChanges != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.roles != null ? !this.roles.equals(that.roles) : that.roles != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.subnetGroup != null ? !this.subnetGroup.equals(that.subnetGroup) : that.subnetGroup != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.masterUser.hashCode();
            result = 31 * result + (this.vpc.hashCode());
            result = 31 * result + (this.classicResizing != null ? this.classicResizing.hashCode() : 0);
            result = 31 * result + (this.clusterName != null ? this.clusterName.hashCode() : 0);
            result = 31 * result + (this.clusterType != null ? this.clusterType.hashCode() : 0);
            result = 31 * result + (this.defaultDatabaseName != null ? this.defaultDatabaseName.hashCode() : 0);
            result = 31 * result + (this.defaultRole != null ? this.defaultRole.hashCode() : 0);
            result = 31 * result + (this.elasticIp != null ? this.elasticIp.hashCode() : 0);
            result = 31 * result + (this.encrypted != null ? this.encrypted.hashCode() : 0);
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.enhancedVpcRouting != null ? this.enhancedVpcRouting.hashCode() : 0);
            result = 31 * result + (this.loggingProperties != null ? this.loggingProperties.hashCode() : 0);
            result = 31 * result + (this.multiAz != null ? this.multiAz.hashCode() : 0);
            result = 31 * result + (this.nodeType != null ? this.nodeType.hashCode() : 0);
            result = 31 * result + (this.numberOfNodes != null ? this.numberOfNodes.hashCode() : 0);
            result = 31 * result + (this.parameterGroup != null ? this.parameterGroup.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.preferredMaintenanceWindow != null ? this.preferredMaintenanceWindow.hashCode() : 0);
            result = 31 * result + (this.publiclyAccessible != null ? this.publiclyAccessible.hashCode() : 0);
            result = 31 * result + (this.rebootForParameterChanges != null ? this.rebootForParameterChanges.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.roles != null ? this.roles.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.subnetGroup != null ? this.subnetGroup.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
