package software.amazon.awscdk.services.redshift;

/**
 * (experimental) Properties for configuring a Redshift user.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * User user = User.Builder.create(this, "User")
 *         .cluster(cluster)
 *         .databaseName("databaseName")
 *         .build();
 * cluster.addRotationMultiUser("MultiUserRotation", RotationMultiUserOptions.builder()
 *         .secret(user.getSecret())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:43.671Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.redshift.$Module.class, fqn = "@aws-cdk/aws-redshift.UserProps")
@software.amazon.jsii.Jsii.Proxy(UserProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface UserProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.redshift.DatabaseOptions {

    /**
     * (experimental) KMS key to encrypt the generated secret.
     * <p>
     * Default: - the default AWS managed key is used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * (experimental) The policy to apply when this resource is removed from the application.
     * <p>
     * Default: cdk.RemovalPolicy.Destroy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * (experimental) The name of the user.
     * <p>
     * For valid values, see: https://docs.aws.amazon.com/redshift/latest/dg/r_names.html
     * <p>
     * Default: - a name is generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getUsername() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<UserProps> {
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        java.lang.String username;
        software.amazon.awscdk.services.redshift.ICluster cluster;
        java.lang.String databaseName;
        software.amazon.awscdk.services.secretsmanager.ISecret adminUser;

        /**
         * Sets the value of {@link UserProps#getEncryptionKey}
         * @param encryptionKey KMS key to encrypt the generated secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link UserProps#getRemovalPolicy}
         * @param removalPolicy The policy to apply when this resource is removed from the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link UserProps#getUsername}
         * @param username The name of the user.
         *                 For valid values, see: https://docs.aws.amazon.com/redshift/latest/dg/r_names.html
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder username(java.lang.String username) {
            this.username = username;
            return this;
        }

        /**
         * Sets the value of {@link UserProps#getCluster}
         * @param cluster The cluster containing the database. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cluster(software.amazon.awscdk.services.redshift.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link UserProps#getDatabaseName}
         * @param databaseName The name of the database. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder databaseName(java.lang.String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        /**
         * Sets the value of {@link UserProps#getAdminUser}
         * @param adminUser The secret containing credentials to a Redshift user with administrator privileges.
         *                  Secret JSON schema: <code>{ username: string; password: string }</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder adminUser(software.amazon.awscdk.services.secretsmanager.ISecret adminUser) {
            this.adminUser = adminUser;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public UserProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserProps {
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final java.lang.String username;
        private final software.amazon.awscdk.services.redshift.ICluster cluster;
        private final java.lang.String databaseName;
        private final software.amazon.awscdk.services.secretsmanager.ISecret adminUser;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.RemovalPolicy.class));
            this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.redshift.ICluster.class));
            this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.adminUser = software.amazon.jsii.Kernel.get(this, "adminUser", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.encryptionKey = builder.encryptionKey;
            this.removalPolicy = builder.removalPolicy;
            this.username = builder.username;
            this.cluster = java.util.Objects.requireNonNull(builder.cluster, "cluster is required");
            this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
            this.adminUser = builder.adminUser;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final java.lang.String getUsername() {
            return this.username;
        }

        @Override
        public final software.amazon.awscdk.services.redshift.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final java.lang.String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.ISecret getAdminUser() {
            return this.adminUser;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getUsername() != null) {
                data.set("username", om.valueToTree(this.getUsername()));
            }
            data.set("cluster", om.valueToTree(this.getCluster()));
            data.set("databaseName", om.valueToTree(this.getDatabaseName()));
            if (this.getAdminUser() != null) {
                data.set("adminUser", om.valueToTree(this.getAdminUser()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-redshift.UserProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserProps.Jsii$Proxy that = (UserProps.Jsii$Proxy) o;

            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.username != null ? !this.username.equals(that.username) : that.username != null) return false;
            if (!cluster.equals(that.cluster)) return false;
            if (!databaseName.equals(that.databaseName)) return false;
            return this.adminUser != null ? this.adminUser.equals(that.adminUser) : that.adminUser == null;
        }

        @Override
        public final int hashCode() {
            int result = this.encryptionKey != null ? this.encryptionKey.hashCode() : 0;
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
            result = 31 * result + (this.cluster.hashCode());
            result = 31 * result + (this.databaseName.hashCode());
            result = 31 * result + (this.adminUser != null ? this.adminUser.hashCode() : 0);
            return result;
        }
    }
}
