/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.redshift;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.core.SecretValue;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.redshift.;
import software.amazon.awscdk.services.redshift.DatabaseOptions;
import software.amazon.awscdk.services.redshift.ICluster;
import software.amazon.awscdk.services.redshift.ITable;
import software.amazon.awscdk.services.redshift.IUser;
import software.amazon.awscdk.services.redshift.TableAction;
import software.amazon.awscdk.services.redshift.UserAttributes;
import software.amazon.awscdk.services.redshift.UserProps;
import software.amazon.awscdk.services.secretsmanager.ISecret;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-redshift.User")
public class User
extends Construct
implements IUser {
    protected User(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected User(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public User(@NotNull software.constructs.Construct scope, @NotNull String id, @NotNull UserProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IUser fromUserAttributes(@NotNull software.constructs.Construct scope, @NotNull String id, @NotNull UserAttributes attrs) {
        return (IUser)JsiiObject.jsiiStaticCall(User.class, (String)"fromUserAttributes", (NativeType)NativeType.forClass(IUser.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    public void addTablePrivileges(@NotNull ITable table, TableAction ... actions) {
        Kernel.call((Object)this, (String)"addTablePrivileges", (NativeType)NativeType.VOID, (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(table, "table is required")}), Arrays.stream(actions)).toArray(Object[]::new));
    }

    public void applyRemovalPolicy(@NotNull RemovalPolicy policy) {
        Kernel.call((Object)this, (String)"applyRemovalPolicy", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(policy, "policy is required")});
    }

    @Override
    @NotNull
    public ICluster getCluster() {
        return (ICluster)Kernel.get((Object)this, (String)"cluster", (NativeType)NativeType.forClass(ICluster.class));
    }

    @Override
    @NotNull
    public String getDatabaseName() {
        return (String)Kernel.get((Object)this, (String)"databaseName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public SecretValue getPassword() {
        return (SecretValue)Kernel.get((Object)this, (String)"password", (NativeType)NativeType.forClass(SecretValue.class));
    }

    @NotNull
    public ISecret getSecret() {
        return (ISecret)Kernel.get((Object)this, (String)"secret", (NativeType)NativeType.forClass(ISecret.class));
    }

    @Override
    @NotNull
    public String getUsername() {
        return (String)Kernel.get((Object)this, (String)"username", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected DatabaseOptions getDatabaseProps() {
        return (DatabaseOptions)Kernel.get((Object)this, (String)"databaseProps", (NativeType)NativeType.forClass(DatabaseOptions.class));
    }

    protected void setDatabaseProps(@NotNull DatabaseOptions value) {
        Kernel.set((Object)this, (String)"databaseProps", (Object)Objects.requireNonNull(value, "databaseProps is required"));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<User> {
        private final software.constructs.Construct scope;
        private final String id;
        private final UserProps.Builder props;

        public static Builder create(software.constructs.Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(software.constructs.Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new UserProps.Builder();
        }

        public Builder cluster(ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        public Builder databaseName(String databaseName) {
            this.props.databaseName(databaseName);
            return this;
        }

        public Builder adminUser(ISecret adminUser) {
            this.props.adminUser(adminUser);
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.props.encryptionKey(encryptionKey);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder username(String username) {
            this.props.username(username);
            return this;
        }

        public User build() {
            return new User(this.scope, this.id, this.props.build());
        }
    }
}

