package software.amazon.awscdk.services.robomaker;

/**
 * Properties for defining a `AWS::RoboMaker::RobotApplicationVersion`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplicationversion.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:02:45.881Z")
public interface CfnRobotApplicationVersionProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::RoboMaker::RobotApplicationVersion.Application`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplicationversion.html#cfn-robomaker-robotapplicationversion-application
     */
    java.lang.String getApplication();
    /**
     * `AWS::RoboMaker::RobotApplicationVersion.CurrentRevisionId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplicationversion.html#cfn-robomaker-robotapplicationversion-currentrevisionid
     */
    java.lang.String getCurrentRevisionId();

    /**
     * @return a {@link Builder} of {@link CfnRobotApplicationVersionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnRobotApplicationVersionProps}
     */
    final class Builder {
        private java.lang.String _application;
        @javax.annotation.Nullable
        private java.lang.String _currentRevisionId;

        /**
         * Sets the value of Application
         * @param value `AWS::RoboMaker::RobotApplicationVersion.Application`.
         * @return {@code this}
         */
        public Builder withApplication(final java.lang.String value) {
            this._application = java.util.Objects.requireNonNull(value, "application is required");
            return this;
        }
        /**
         * Sets the value of CurrentRevisionId
         * @param value `AWS::RoboMaker::RobotApplicationVersion.CurrentRevisionId`.
         * @return {@code this}
         */
        public Builder withCurrentRevisionId(@javax.annotation.Nullable final java.lang.String value) {
            this._currentRevisionId = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRobotApplicationVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CfnRobotApplicationVersionProps build() {
            return new CfnRobotApplicationVersionProps() {
                private final java.lang.String $application = java.util.Objects.requireNonNull(_application, "application is required");
                @javax.annotation.Nullable
                private final java.lang.String $currentRevisionId = _currentRevisionId;

                @Override
                public java.lang.String getApplication() {
                    return this.$application;
                }

                @Override
                public java.lang.String getCurrentRevisionId() {
                    return this.$currentRevisionId;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("application", om.valueToTree(this.getApplication()));
                    obj.set("currentRevisionId", om.valueToTree(this.getCurrentRevisionId()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.robomaker.CfnRobotApplicationVersionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * `AWS::RoboMaker::RobotApplicationVersion.Application`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplicationversion.html#cfn-robomaker-robotapplicationversion-application
         */
        @Override
        public java.lang.String getApplication() {
            return this.jsiiGet("application", java.lang.String.class);
        }

        /**
         * `AWS::RoboMaker::RobotApplicationVersion.CurrentRevisionId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplicationversion.html#cfn-robomaker-robotapplicationversion-currentrevisionid
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getCurrentRevisionId() {
            return this.jsiiGet("currentRevisionId", java.lang.String.class);
        }
    }
}
