package software.amazon.awscdk.services.robomaker;

/**
 * A CloudFormation `AWS::RoboMaker::SimulationApplication`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-10-01T14:37:56.955Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.robomaker.$Module.class, fqn = "@aws-cdk/aws-robomaker.CfnSimulationApplication")
public class CfnSimulationApplication extends software.amazon.awscdk.core.CfnResource {

    protected CfnSimulationApplication(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSimulationApplication(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.robomaker.CfnSimulationApplication.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::RoboMaker::SimulationApplication`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnSimulationApplication(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.robomaker.CfnSimulationApplicationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrArn() {
        return this.jsiiGet("attrArn", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrCurrentRevisionId() {
        return this.jsiiGet("attrCurrentRevisionId", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.RenderingEngine`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-renderingengine
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getRenderingEngine() {
        return this.jsiiGet("renderingEngine", java.lang.Object.class);
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.RenderingEngine`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-renderingengine
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRenderingEngine(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("renderingEngine", java.util.Objects.requireNonNull(value, "renderingEngine is required"));
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.RenderingEngine`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-renderingengine
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRenderingEngine(final software.amazon.awscdk.services.robomaker.CfnSimulationApplication.RenderingEngineProperty value) {
        this.jsiiSet("renderingEngine", java.util.Objects.requireNonNull(value, "renderingEngine is required"));
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.RobotSoftwareSuite`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-robotsoftwaresuite
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getRobotSoftwareSuite() {
        return this.jsiiGet("robotSoftwareSuite", java.lang.Object.class);
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.RobotSoftwareSuite`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-robotsoftwaresuite
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRobotSoftwareSuite(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("robotSoftwareSuite", java.util.Objects.requireNonNull(value, "robotSoftwareSuite is required"));
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.RobotSoftwareSuite`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-robotsoftwaresuite
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRobotSoftwareSuite(final software.amazon.awscdk.services.robomaker.CfnSimulationApplication.RobotSoftwareSuiteProperty value) {
        this.jsiiSet("robotSoftwareSuite", java.util.Objects.requireNonNull(value, "robotSoftwareSuite is required"));
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.SimulationSoftwareSuite`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-simulationsoftwaresuite
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getSimulationSoftwareSuite() {
        return this.jsiiGet("simulationSoftwareSuite", java.lang.Object.class);
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.SimulationSoftwareSuite`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-simulationsoftwaresuite
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSimulationSoftwareSuite(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("simulationSoftwareSuite", java.util.Objects.requireNonNull(value, "simulationSoftwareSuite is required"));
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.SimulationSoftwareSuite`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-simulationsoftwaresuite
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSimulationSoftwareSuite(final software.amazon.awscdk.services.robomaker.CfnSimulationApplication.SimulationSoftwareSuiteProperty value) {
        this.jsiiSet("simulationSoftwareSuite", java.util.Objects.requireNonNull(value, "simulationSoftwareSuite is required"));
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.Sources`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-sources
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getSources() {
        return this.jsiiGet("sources", java.lang.Object.class);
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.Sources`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-sources
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSources(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("sources", java.util.Objects.requireNonNull(value, "sources is required"));
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.Sources`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-sources
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSources(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("sources", java.util.Objects.requireNonNull(value, "sources is required"));
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.CurrentRevisionId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-currentrevisionid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getCurrentRevisionId() {
        return this.jsiiGet("currentRevisionId", java.lang.String.class);
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.CurrentRevisionId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-currentrevisionid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCurrentRevisionId(final java.lang.String value) {
        this.jsiiSet("currentRevisionId", value);
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.Name`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getName() {
        return this.jsiiGet("name", java.lang.String.class);
    }

    /**
     * `AWS::RoboMaker::SimulationApplication.Name`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setName(final java.lang.String value) {
        this.jsiiSet("name", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-renderingengine.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface RenderingEngineProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSimulationApplication.RenderingEngineProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-renderingengine.html#cfn-robomaker-simulationapplication-renderingengine-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getName();

        /**
         * `CfnSimulationApplication.RenderingEngineProperty.Version`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-renderingengine.html#cfn-robomaker-simulationapplication-renderingengine-version
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getVersion();

        /**
         * @return a {@link Builder} of {@link RenderingEngineProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RenderingEngineProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String name;
            private java.lang.String version;

            /**
             * Sets the value of Name
             * @param name `CfnSimulationApplication.RenderingEngineProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of Version
             * @param version `CfnSimulationApplication.RenderingEngineProperty.Version`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RenderingEngineProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public RenderingEngineProperty build() {
                return new Jsii$Proxy(name, version);
            }
        }

        /**
         * An implementation for {@link RenderingEngineProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RenderingEngineProperty {
            private final java.lang.String name;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.version = this.jsiiGet("version", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String name, java.lang.String version) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(name, "name is required");
                this.version = java.util.Objects.requireNonNull(version, "version is required");
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public java.lang.String getVersion() {
                return this.version;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("name", om.valueToTree(this.getName()));
                obj.set("version", om.valueToTree(this.getVersion()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RenderingEngineProperty.Jsii$Proxy that = (RenderingEngineProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.version.equals(that.version);
            }

            @Override
            public int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.version.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-robotsoftwaresuite.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface RobotSoftwareSuiteProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSimulationApplication.RobotSoftwareSuiteProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-robotsoftwaresuite.html#cfn-robomaker-simulationapplication-robotsoftwaresuite-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getName();

        /**
         * `CfnSimulationApplication.RobotSoftwareSuiteProperty.Version`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-robotsoftwaresuite.html#cfn-robomaker-simulationapplication-robotsoftwaresuite-version
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getVersion();

        /**
         * @return a {@link Builder} of {@link RobotSoftwareSuiteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RobotSoftwareSuiteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String name;
            private java.lang.String version;

            /**
             * Sets the value of Name
             * @param name `CfnSimulationApplication.RobotSoftwareSuiteProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of Version
             * @param version `CfnSimulationApplication.RobotSoftwareSuiteProperty.Version`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RobotSoftwareSuiteProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public RobotSoftwareSuiteProperty build() {
                return new Jsii$Proxy(name, version);
            }
        }

        /**
         * An implementation for {@link RobotSoftwareSuiteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RobotSoftwareSuiteProperty {
            private final java.lang.String name;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.version = this.jsiiGet("version", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String name, java.lang.String version) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(name, "name is required");
                this.version = java.util.Objects.requireNonNull(version, "version is required");
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public java.lang.String getVersion() {
                return this.version;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("name", om.valueToTree(this.getName()));
                obj.set("version", om.valueToTree(this.getVersion()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RobotSoftwareSuiteProperty.Jsii$Proxy that = (RobotSoftwareSuiteProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.version.equals(that.version);
            }

            @Override
            public int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.version.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-simulationsoftwaresuite.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface SimulationSoftwareSuiteProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSimulationApplication.SimulationSoftwareSuiteProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-simulationsoftwaresuite.html#cfn-robomaker-simulationapplication-simulationsoftwaresuite-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getName();

        /**
         * `CfnSimulationApplication.SimulationSoftwareSuiteProperty.Version`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-simulationsoftwaresuite.html#cfn-robomaker-simulationapplication-simulationsoftwaresuite-version
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getVersion();

        /**
         * @return a {@link Builder} of {@link SimulationSoftwareSuiteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SimulationSoftwareSuiteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String name;
            private java.lang.String version;

            /**
             * Sets the value of Name
             * @param name `CfnSimulationApplication.SimulationSoftwareSuiteProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of Version
             * @param version `CfnSimulationApplication.SimulationSoftwareSuiteProperty.Version`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SimulationSoftwareSuiteProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public SimulationSoftwareSuiteProperty build() {
                return new Jsii$Proxy(name, version);
            }
        }

        /**
         * An implementation for {@link SimulationSoftwareSuiteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SimulationSoftwareSuiteProperty {
            private final java.lang.String name;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.version = this.jsiiGet("version", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String name, java.lang.String version) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(name, "name is required");
                this.version = java.util.Objects.requireNonNull(version, "version is required");
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public java.lang.String getVersion() {
                return this.version;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("name", om.valueToTree(this.getName()));
                obj.set("version", om.valueToTree(this.getVersion()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SimulationSoftwareSuiteProperty.Jsii$Proxy that = (SimulationSoftwareSuiteProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.version.equals(that.version);
            }

            @Override
            public int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.version.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-sourceconfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface SourceConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSimulationApplication.SourceConfigProperty.Architecture`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-sourceconfig.html#cfn-robomaker-simulationapplication-sourceconfig-architecture
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getArchitecture();

        /**
         * `CfnSimulationApplication.SourceConfigProperty.S3Bucket`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-sourceconfig.html#cfn-robomaker-simulationapplication-sourceconfig-s3bucket
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getS3Bucket();

        /**
         * `CfnSimulationApplication.SourceConfigProperty.S3Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-sourceconfig.html#cfn-robomaker-simulationapplication-sourceconfig-s3key
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getS3Key();

        /**
         * @return a {@link Builder} of {@link SourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String architecture;
            private java.lang.String s3Bucket;
            private java.lang.String s3Key;

            /**
             * Sets the value of Architecture
             * @param architecture `CfnSimulationApplication.SourceConfigProperty.Architecture`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder architecture(java.lang.String architecture) {
                this.architecture = architecture;
                return this;
            }

            /**
             * Sets the value of S3Bucket
             * @param s3Bucket `CfnSimulationApplication.SourceConfigProperty.S3Bucket`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder s3Bucket(java.lang.String s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            /**
             * Sets the value of S3Key
             * @param s3Key `CfnSimulationApplication.SourceConfigProperty.S3Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder s3Key(java.lang.String s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public SourceConfigProperty build() {
                return new Jsii$Proxy(architecture, s3Bucket, s3Key);
            }
        }

        /**
         * An implementation for {@link SourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceConfigProperty {
            private final java.lang.String architecture;
            private final java.lang.String s3Bucket;
            private final java.lang.String s3Key;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.architecture = this.jsiiGet("architecture", java.lang.String.class);
                this.s3Bucket = this.jsiiGet("s3Bucket", java.lang.String.class);
                this.s3Key = this.jsiiGet("s3Key", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String architecture, java.lang.String s3Bucket, java.lang.String s3Key) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.architecture = java.util.Objects.requireNonNull(architecture, "architecture is required");
                this.s3Bucket = java.util.Objects.requireNonNull(s3Bucket, "s3Bucket is required");
                this.s3Key = java.util.Objects.requireNonNull(s3Key, "s3Key is required");
            }

            @Override
            public java.lang.String getArchitecture() {
                return this.architecture;
            }

            @Override
            public java.lang.String getS3Bucket() {
                return this.s3Bucket;
            }

            @Override
            public java.lang.String getS3Key() {
                return this.s3Key;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("architecture", om.valueToTree(this.getArchitecture()));
                obj.set("s3Bucket", om.valueToTree(this.getS3Bucket()));
                obj.set("s3Key", om.valueToTree(this.getS3Key()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceConfigProperty.Jsii$Proxy that = (SourceConfigProperty.Jsii$Proxy) o;

                if (!architecture.equals(that.architecture)) return false;
                if (!s3Bucket.equals(that.s3Bucket)) return false;
                return this.s3Key.equals(that.s3Key);
            }

            @Override
            public int hashCode() {
                int result = this.architecture.hashCode();
                result = 31 * result + (this.s3Bucket.hashCode());
                result = 31 * result + (this.s3Key.hashCode());
                return result;
            }
        }
    }
}
