package software.amazon.awscdk.services.robomaker;

/**
 * Properties for defining a `AWS::RoboMaker::SimulationApplication`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-10-01T14:37:56.957Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnSimulationApplicationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::RoboMaker::SimulationApplication.RenderingEngine`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-renderingengine
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getRenderingEngine();

    /**
     * `AWS::RoboMaker::SimulationApplication.RobotSoftwareSuite`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-robotsoftwaresuite
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getRobotSoftwareSuite();

    /**
     * `AWS::RoboMaker::SimulationApplication.SimulationSoftwareSuite`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-simulationsoftwaresuite
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getSimulationSoftwareSuite();

    /**
     * `AWS::RoboMaker::SimulationApplication.Sources`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-sources
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getSources();

    /**
     * `AWS::RoboMaker::SimulationApplication.CurrentRevisionId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-currentrevisionid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getCurrentRevisionId();

    /**
     * `AWS::RoboMaker::SimulationApplication.Name`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getName();

    /**
     * `AWS::RoboMaker::SimulationApplication.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getTags();

    /**
     * @return a {@link Builder} of {@link CfnSimulationApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSimulationApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.Object renderingEngine;
        private java.lang.Object robotSoftwareSuite;
        private java.lang.Object simulationSoftwareSuite;
        private java.lang.Object sources;
        private java.lang.String currentRevisionId;
        private java.lang.String name;
        private java.lang.Object tags;

        /**
         * Sets the value of RenderingEngine
         * @param renderingEngine `AWS::RoboMaker::SimulationApplication.RenderingEngine`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder renderingEngine(software.amazon.awscdk.core.IResolvable renderingEngine) {
            this.renderingEngine = renderingEngine;
            return this;
        }

        /**
         * Sets the value of RenderingEngine
         * @param renderingEngine `AWS::RoboMaker::SimulationApplication.RenderingEngine`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder renderingEngine(software.amazon.awscdk.services.robomaker.CfnSimulationApplication.RenderingEngineProperty renderingEngine) {
            this.renderingEngine = renderingEngine;
            return this;
        }

        /**
         * Sets the value of RobotSoftwareSuite
         * @param robotSoftwareSuite `AWS::RoboMaker::SimulationApplication.RobotSoftwareSuite`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder robotSoftwareSuite(software.amazon.awscdk.core.IResolvable robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite;
            return this;
        }

        /**
         * Sets the value of RobotSoftwareSuite
         * @param robotSoftwareSuite `AWS::RoboMaker::SimulationApplication.RobotSoftwareSuite`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder robotSoftwareSuite(software.amazon.awscdk.services.robomaker.CfnSimulationApplication.RobotSoftwareSuiteProperty robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite;
            return this;
        }

        /**
         * Sets the value of SimulationSoftwareSuite
         * @param simulationSoftwareSuite `AWS::RoboMaker::SimulationApplication.SimulationSoftwareSuite`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder simulationSoftwareSuite(software.amazon.awscdk.core.IResolvable simulationSoftwareSuite) {
            this.simulationSoftwareSuite = simulationSoftwareSuite;
            return this;
        }

        /**
         * Sets the value of SimulationSoftwareSuite
         * @param simulationSoftwareSuite `AWS::RoboMaker::SimulationApplication.SimulationSoftwareSuite`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder simulationSoftwareSuite(software.amazon.awscdk.services.robomaker.CfnSimulationApplication.SimulationSoftwareSuiteProperty simulationSoftwareSuite) {
            this.simulationSoftwareSuite = simulationSoftwareSuite;
            return this;
        }

        /**
         * Sets the value of Sources
         * @param sources `AWS::RoboMaker::SimulationApplication.Sources`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sources(software.amazon.awscdk.core.IResolvable sources) {
            this.sources = sources;
            return this;
        }

        /**
         * Sets the value of Sources
         * @param sources `AWS::RoboMaker::SimulationApplication.Sources`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sources(java.util.List<java.lang.Object> sources) {
            this.sources = sources;
            return this;
        }

        /**
         * Sets the value of CurrentRevisionId
         * @param currentRevisionId `AWS::RoboMaker::SimulationApplication.CurrentRevisionId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder currentRevisionId(java.lang.String currentRevisionId) {
            this.currentRevisionId = currentRevisionId;
            return this;
        }

        /**
         * Sets the value of Name
         * @param name `AWS::RoboMaker::SimulationApplication.Name`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of Tags
         * @param tags `AWS::RoboMaker::SimulationApplication.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSimulationApplicationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnSimulationApplicationProps build() {
            return new Jsii$Proxy(renderingEngine, robotSoftwareSuite, simulationSoftwareSuite, sources, currentRevisionId, name, tags);
        }
    }

    /**
     * An implementation for {@link CfnSimulationApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSimulationApplicationProps {
        private final java.lang.Object renderingEngine;
        private final java.lang.Object robotSoftwareSuite;
        private final java.lang.Object simulationSoftwareSuite;
        private final java.lang.Object sources;
        private final java.lang.String currentRevisionId;
        private final java.lang.String name;
        private final java.lang.Object tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.renderingEngine = this.jsiiGet("renderingEngine", java.lang.Object.class);
            this.robotSoftwareSuite = this.jsiiGet("robotSoftwareSuite", java.lang.Object.class);
            this.simulationSoftwareSuite = this.jsiiGet("simulationSoftwareSuite", java.lang.Object.class);
            this.sources = this.jsiiGet("sources", java.lang.Object.class);
            this.currentRevisionId = this.jsiiGet("currentRevisionId", java.lang.String.class);
            this.name = this.jsiiGet("name", java.lang.String.class);
            this.tags = this.jsiiGet("tags", java.lang.Object.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Object renderingEngine, java.lang.Object robotSoftwareSuite, java.lang.Object simulationSoftwareSuite, java.lang.Object sources, java.lang.String currentRevisionId, java.lang.String name, java.lang.Object tags) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.renderingEngine = java.util.Objects.requireNonNull(renderingEngine, "renderingEngine is required");
            this.robotSoftwareSuite = java.util.Objects.requireNonNull(robotSoftwareSuite, "robotSoftwareSuite is required");
            this.simulationSoftwareSuite = java.util.Objects.requireNonNull(simulationSoftwareSuite, "simulationSoftwareSuite is required");
            this.sources = java.util.Objects.requireNonNull(sources, "sources is required");
            this.currentRevisionId = currentRevisionId;
            this.name = name;
            this.tags = tags;
        }

        @Override
        public java.lang.Object getRenderingEngine() {
            return this.renderingEngine;
        }

        @Override
        public java.lang.Object getRobotSoftwareSuite() {
            return this.robotSoftwareSuite;
        }

        @Override
        public java.lang.Object getSimulationSoftwareSuite() {
            return this.simulationSoftwareSuite;
        }

        @Override
        public java.lang.Object getSources() {
            return this.sources;
        }

        @Override
        public java.lang.String getCurrentRevisionId() {
            return this.currentRevisionId;
        }

        @Override
        public java.lang.String getName() {
            return this.name;
        }

        @Override
        public java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("renderingEngine", om.valueToTree(this.getRenderingEngine()));
            obj.set("robotSoftwareSuite", om.valueToTree(this.getRobotSoftwareSuite()));
            obj.set("simulationSoftwareSuite", om.valueToTree(this.getSimulationSoftwareSuite()));
            obj.set("sources", om.valueToTree(this.getSources()));
            if (this.getCurrentRevisionId() != null) {
                obj.set("currentRevisionId", om.valueToTree(this.getCurrentRevisionId()));
            }
            if (this.getName() != null) {
                obj.set("name", om.valueToTree(this.getName()));
            }
            if (this.getTags() != null) {
                obj.set("tags", om.valueToTree(this.getTags()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSimulationApplicationProps.Jsii$Proxy that = (CfnSimulationApplicationProps.Jsii$Proxy) o;

            if (!renderingEngine.equals(that.renderingEngine)) return false;
            if (!robotSoftwareSuite.equals(that.robotSoftwareSuite)) return false;
            if (!simulationSoftwareSuite.equals(that.simulationSoftwareSuite)) return false;
            if (!sources.equals(that.sources)) return false;
            if (this.currentRevisionId != null ? !this.currentRevisionId.equals(that.currentRevisionId) : that.currentRevisionId != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public int hashCode() {
            int result = this.renderingEngine.hashCode();
            result = 31 * result + (this.robotSoftwareSuite.hashCode());
            result = 31 * result + (this.simulationSoftwareSuite.hashCode());
            result = 31 * result + (this.sources.hashCode());
            result = 31 * result + (this.currentRevisionId != null ? this.currentRevisionId.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
